/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *   
 *****************************************************************************/
package org.eclipse.papyrus.interoperability.rpy.geometry.utils;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Position;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyPort;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage;

public class RpyPortOperations extends RpyShapeOperations {

	public static String M_POSITION_FEATURE_NAME = UMLRpyPackage.eINSTANCE.getCGIPortConnector_M_position().getName();


	public static void initializeShape(RpyPort rpyPort, EObject rpyMMObj) {
		initializeTransform(rpyPort, rpyMMObj);
		initializeRectangle(rpyPort, rpyMMObj);
		initializeParent(rpyPort, rpyMMObj);
		initializeParentEdge(rpyPort);
		initializePositionAndSize(rpyPort);
		fixPortOffsets(rpyPort);
	}





	public static void initializeRectangle(RpyShape rpyShape, EObject rpyMMObj) {
		Object polygonObj = GeometryUtils.getFeatureValue(rpyMMObj, M_POSITION_FEATURE_NAME);
		if (polygonObj instanceof List) {
			@SuppressWarnings("unchecked")
			Rectangle rectangle = RectangleOperations.getRectangle((List<String>) polygonObj);
			rpyShape.setRectangle(rectangle);
		}

	}

	private static void fixPortOffsets(RpyPort rpyPort) {
		double xOffset = 0;
		double yOffset = 0;

		// TODO : manage corner ?

		switch (rpyPort.getPosition()) {
		case EAST:

			// top left corner has turned of 90� to right and has become the top right corner
			yOffset = 20;
			break;
		case NORTH:
			xOffset = 20;
			break;
		case SOUTH:
			// top left has become bottom right
			xOffset = -40;
			break;
		case WEST:
			// top left has become bottom left
			yOffset = -40;
			break;
		default:
			break;
		}
		Point offset = PointsOperations.getPoint(xOffset, yOffset);
		// Point offset = PointsOperations.getPoint(0, 0);
		Point absolutePosition = rpyPort.getAbsolutePosition();
		Point relativePosition = rpyPort.getParentRelativePosition();
		rpyPort.setAbsolutePosition(absolutePosition.add(offset));
		rpyPort.setParentRelativePosition(relativePosition.add(offset));

	}


	private static void initializeParentEdge(RpyPort rpyPort) {
		TransformMatrix transform = rpyPort.getTransform();
		if (transform != null) {
			boolean topOrBottom = transform.getB() == 0.0 || Math.abs(transform.getA() / transform.getB()) > 100;
			if (topOrBottom) {
				if (transform.getA() > 0) {
					rpyPort.setPosition(Position.NORTH);
				} else {
					rpyPort.setPosition(Position.SOUTH);
				}
			} else {
				if (transform.getB() > 0) {
					rpyPort.setPosition(Position.EAST);
				} else {
					rpyPort.setPosition(Position.WEST);
				}
			}
		} else {
			rpyPort.setPosition(Position.NORTH);
		}
	}





}
