/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.blackboxes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.ListCompartment;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;

public abstract class AbstractDiagramFixLayoutBlackboxes {
    @Operation(kind=Operation.Kind.HELPER)
    public void fixLayout(Diagram diagram) {
        if (this.isManagedDiagram(diagram)) {
            this.fixShapePosition(diagram);
        }
    }

    protected void fixShapePosition(Diagram diagram) {
        EList children = diagram.getChildren();
        for (Object current : children) {
            if (!(current instanceof Shape)) continue;
            this.fixChildrenShapePosition((View)((Shape)current), Collections.singletonList((View)current));
        }
    }

    protected void fixChildrenShapePosition(View shape, List<View> parents) {
        EList children = shape.getChildren();
        for (Object current : children) {
            ArrayList<View> newParents = new ArrayList<View>(parents);
            newParents.add((View)current);
            if (!(current instanceof ListCompartment) && current instanceof BasicCompartment) {
                this.fixChildrenShapePosition((View)current, newParents);
            }
            if (!(current instanceof Shape) || !(((Shape)current).eContainer() instanceof BasicCompartment)) continue;
            Bounds bounds = (Bounds)((Shape)current).getLayoutConstraint();
            if (bounds != null) {
                int Y_offset;
                int X_offset = this.get_X_Offset((View)current, parents);
                if (X_offset != 0) {
                    bounds.setX(bounds.getX() + X_offset);
                }
                if ((Y_offset = this.get_Y_Offset((View)current, parents)) != 0) {
                    bounds.setY(bounds.getY() + Y_offset);
                }
            }
            this.fixChildrenShapePosition((View)current, newParents);
        }
    }

    private int get_Y_Offset(View viewToLocate, List<View> parents) {
        int offset = 0;
        for (View current : parents) {
            offset += this.get_Y_OffsetFor(current);
        }
        return offset;
    }

    private int get_X_Offset(View viewToLocate, List<View> parents) {
        int offset = 0;
        for (View current : parents) {
            offset += this.get_X_OffsetFor(current);
        }
        return offset;
    }

    protected abstract int get_X_OffsetFor(View var1);

    protected abstract int get_Y_OffsetFor(View var1);

    protected abstract boolean isManagedDiagram(Diagram var1);
}

