/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.uml.tools.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.uml.tools.utils.BehaviorUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;

public class StateMachineUtils {
    public static Region region(State state) {
        EList regions = state.getRegions();
        if (regions.size() > 0) {
            return (Region)regions.get(0);
        }
        return null;
    }

    public static Region region(StateMachine stateMachine) {
        EList regions = stateMachine.getRegions();
        if (regions.size() > 0) {
            return (Region)regions.get(0);
        }
        return null;
    }

    public static EList<State> subStates(State state) {
        Region region = StateMachineUtils.region(state);
        return region != null ? StateMachineUtils.states(region) : new BasicEList();
    }

    public static EList<State> states(StateMachine stateMachine) {
        Region region = StateMachineUtils.region(stateMachine);
        return region != null ? StateMachineUtils.states(region) : new BasicEList();
    }

    public static EList<State> states(Region region) {
        BasicEList states = new BasicEList();
        for (Vertex vertex : region.getSubvertices()) {
            if (!(vertex instanceof State)) continue;
            states.add((Object)((State)vertex));
        }
        return states;
    }

    public static EList<Pseudostate> entryPoints(State state) {
        BasicEList pseudoStates = new BasicEList();
        for (Pseudostate pseudoState : state.getConnectionPoints()) {
            if (pseudoState.getKind() != PseudostateKind.ENTRY_POINT_LITERAL) continue;
            pseudoStates.add((Object)pseudoState);
        }
        return pseudoStates;
    }

    public static EList<Pseudostate> exitPoints(State state) {
        BasicEList pseudoStates = new BasicEList();
        for (Pseudostate pseudoState : state.getConnectionPoints()) {
            if (pseudoState.getKind() != PseudostateKind.EXIT_POINT_LITERAL) continue;
            pseudoStates.add((Object)pseudoState);
        }
        return pseudoStates;
    }

    public static EList<Pseudostate> junctionPoints(Region region) {
        return StateMachineUtils.filteredPseudoStates(region, PseudostateKind.JUNCTION_LITERAL);
    }

    public static EList<Pseudostate> choicePoints(Region region) {
        return StateMachineUtils.filteredPseudoStates(region, PseudostateKind.CHOICE_LITERAL);
    }

    public static EList<Pseudostate> filteredPseudoStates(Region region, PseudostateKind kind) {
        BasicEList pseudoStates = new BasicEList();
        for (Vertex vertex : region.getSubvertices()) {
            Pseudostate pseudoState;
            if (!(vertex instanceof Pseudostate) || (pseudoState = (Pseudostate)vertex).getKind() != kind) continue;
            pseudoStates.add((Object)pseudoState);
        }
        return pseudoStates;
    }

    public static Pseudostate firstPseudoState(Region region, PseudostateKind kind) {
        for (Vertex vertex : region.getSubvertices()) {
            Pseudostate pseudoState;
            if (!(vertex instanceof Pseudostate) || (pseudoState = (Pseudostate)vertex).getKind() != kind) continue;
            return pseudoState;
        }
        return null;
    }

    public static Collection<Transition> indirectIncomings(State state) {
        BasicEList indirectIncoming = new BasicEList();
        for (Pseudostate p : StateMachineUtils.entryPoints(state)) {
            for (Transition t : p.getIncomings()) {
                indirectIncoming.add((Object)t);
            }
        }
        return indirectIncoming;
    }

    public static Collection<Transition> indirectOutgoings(State state) {
        BasicEList indirectIncoming = new BasicEList();
        for (Pseudostate p : StateMachineUtils.entryPoints(state)) {
            for (Transition t : p.getIncomings()) {
                indirectIncoming.add((Object)t);
            }
        }
        return indirectIncoming;
    }

    public static Collection<Transition> allIncomings(State state) {
        BasicEList allIncoming = new BasicEList();
        for (Transition t : state.getIncomings()) {
            allIncoming.add((Object)t);
        }
        allIncoming.addAll(StateMachineUtils.indirectIncomings(state));
        return allIncoming;
    }

    public static Collection<Transition> allOutgoings(State state) {
        BasicEList allIncoming = new BasicEList();
        for (Transition t : state.getIncomings()) {
            allIncoming.add((Object)t);
        }
        allIncoming.addAll(StateMachineUtils.indirectOutgoings(state));
        return allIncoming;
    }

    public static void moveContents(Region targetRegion, State source) {
        Region sourceRegion = StateMachineUtils.region(source);
        BasicEList vertices = new BasicEList((Collection)sourceRegion.getSubvertices());
        for (Vertex v : vertices) {
            targetRegion.getSubvertices().add((Object)v);
        }
        BasicEList transitions = new BasicEList((Collection)sourceRegion.getTransitions());
        for (Transition t : transitions) {
            targetRegion.getTransitions().add((Object)t);
        }
    }

    public static Pseudostate initialState(Region region) {
        return StateMachineUtils.firstPseudoState(region, PseudostateKind.INITIAL_LITERAL);
    }

    public static Pseudostate deepHistory(Region region) {
        return StateMachineUtils.firstPseudoState(region, PseudostateKind.DEEP_HISTORY_LITERAL);
    }

    public static State createState(Region region, String name) {
        return (State)region.createSubvertex(name, UMLPackage.eINSTANCE.getState());
    }

    public static Pseudostate createPseudostate(Region region, String name) {
        return (Pseudostate)region.createSubvertex(name, UMLPackage.eINSTANCE.getPseudostate());
    }

    public static State findInitialState(Region r) {
        Pseudostate pseudoDefault = StateMachineUtils.firstPseudoState(r, PseudostateKind.INITIAL_LITERAL);
        if (pseudoDefault != null) {
            return (State)((Transition)pseudoDefault.getOutgoings().get(0)).getTarget();
        }
        return null;
    }

    public static String getInitialEffect(Region r) {
        Pseudostate pseudoDefault = StateMachineUtils.firstPseudoState(r, PseudostateKind.INITIAL_LITERAL);
        if (pseudoDefault != null) {
            Transition t = (Transition)pseudoDefault.getOutgoings().get(0);
            return BehaviorUtils.body(t.getEffect(), null);
        }
        return "//no initial effect is defined";
    }

    public static String getTransitionEffect(Transition t) {
        String body = BehaviorUtils.body(t.getEffect(), null);
        if (body != null) {
            return body;
        }
        return "";
    }

    public static List<State> transitiveSubStates(State parent) {
        ArrayList<State> ret = new ArrayList<State>();
        if (parent.isComposite()) {
            for (Region r : parent.getRegions()) {
                for (State state : StateMachineUtils.states(r)) {
                    ret.add(state);
                    ret.addAll(StateMachineUtils.transitiveSubStates(state));
                }
            }
        }
        return ret;
    }

    public static List<State> transitiveSubStates(Region parent) {
        ArrayList<State> ret = new ArrayList<State>();
        for (State state : StateMachineUtils.states(parent)) {
            if (state instanceof FinalState) continue;
            ret.add(state);
            ret.addAll(StateMachineUtils.transitiveSubStates(state));
        }
        return ret;
    }

    public static String eventName(Event event) {
        String name = "";
        boolean repeat = false;
        char[] cArray = event.getName().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isAlphabetic(c) || Character.isDigit(c)) {
                name = String.valueOf(name) + c;
                repeat = false;
            } else if (!repeat) {
                name = String.valueOf(name) + "_";
                repeat = true;
            }
            ++n2;
        }
        return name;
    }

    public static String eventID(Event event) {
        return String.valueOf(StateMachineUtils.eventName(event).toUpperCase()) + "_ID";
    }

    public static boolean isSavehistory(Region r) {
        for (Vertex v : r.getSubvertices()) {
            if (!(v instanceof Pseudostate) || ((Pseudostate)v).getKind() != PseudostateKind.SHALLOW_HISTORY_LITERAL) continue;
            return true;
        }
        return StateMachineUtils.isSaveDeepHistory(r);
    }

    public static boolean isSaveDeepHistory(Region r) {
        for (Vertex v : r.getSubvertices()) {
            if (!(v instanceof Pseudostate) || ((Pseudostate)v).getKind() != PseudostateKind.DEEP_HISTORY_LITERAL) continue;
            return true;
        }
        if (r.getState() != null) {
            Region nextRegion = r.getState().getContainer();
            return StateMachineUtils.isSaveDeepHistory(nextRegion);
        }
        return false;
    }

    public static boolean isBehaviorExist(Behavior b) {
        return BehaviorUtils.body(b, null) != null;
    }

    public static boolean hasTriggerlessTransition(State s) {
        for (Transition t : s.getOutgoings()) {
            if (!t.getTriggers().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTriggerlessTransition(StateMachine sm) {
        Region r = StateMachineUtils.region(sm);
        if (r != null) {
            for (State state : StateMachineUtils.states(r)) {
                if (!StateMachineUtils.hasTriggerlessTransition(state)) continue;
                return true;
            }
        }
        return false;
    }
}

