/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.xtend;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.transformation.library.xtend.CppUtils;
import org.eclipse.papyrus.designer.transformation.library.xtend.Marshalling;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;

public class AsyncCalls {
    public CharSequence asyncCall(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// TODO: need suitable constant dimensioning");
        _builder.newLine();
        _builder.append("pBuffer = &buffer[500];  // grows backwards");
        _builder.newLine();
        CharSequence _marshall = Marshalling.marshall(operation);
        _builder.append((Object)_marshall);
        _builder.newLineIfNotEmpty();
        _builder.append("int operationID = ID_[operation.name/];");
        _builder.newLine();
        _builder.append("BEncAsnContent (&amp;pBuffer, &amp;operationID);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("pthread_t pt;");
        _builder.newLine();
        _builder.append("pthread_create (&amp;pt, NULL, staticDispatch, (void *) this);");
        _builder.newLine();
        _builder.append("// TODO: add semaphore which assures that subsequent calls to ");
        String _name = operation.getName();
        _builder.append(_name);
        _builder.append(" are not executed before dispatch");
        _builder.newLineIfNotEmpty();
        _builder.append("// has removed the parameters from the pBuffer stack (pBuffer can be corrupted).");
        _builder.newLine();
        return _builder;
    }

    public CharSequence dispatch_(Class clazz) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("int operationID;");
        _builder.newLine();
        _builder.append("BDecAsnContent (&pBuffer, operationID);");
        _builder.newLine();
        _builder.append("switch (operationID) {");
        _builder.newLine();
        EList _ownedOperations = clazz.getOwnedOperations();
        for (Operation operation : _ownedOperations) {
            _builder.append("\t");
            _builder.append("case ID_");
            String _name = operation.getName();
            _builder.append(_name, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("// delegate call to executor");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("rconn->");
            CharSequence _cppCall = CppUtils.cppCall(operation);
            _builder.append((Object)_cppCall, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence dispatchWithThreadPool(Class clazz) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t");
        _builder.append("int operationID;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("BDecAsnContent (&pBuffer, operationID);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("switch (operationID) {");
        _builder.newLine();
        EList _ownedOperations = clazz.getOwnedOperations();
        for (Operation operation : _ownedOperations) {
            boolean _tripleNotEquals;
            _builder.append("\t\t");
            _builder.append("case ID_");
            String _name = operation.getName();
            _builder.append(_name, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            CharSequence _unmarshall = Marshalling.unmarshall(operation);
            _builder.append((Object)_unmarshall, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("// delegate call to executor");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("rconn->");
            CharSequence _cppCall = CppUtils.cppCall(operation);
            _builder.append((Object)_cppCall, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            Type _type = operation.getType();
            boolean bl = _tripleNotEquals = _type != null;
            if (_tripleNotEquals) {
                CharSequence _cppType = CppUtils.cppType(operation.getType());
                _builder.append((Object)_cppType, "\t\t\t");
                _builder.append(" ret = ");
            }
            _builder.append("rconn->");
            CharSequence _cppCall_1 = CppUtils.cppCall(operation);
            _builder.append((Object)_cppCall_1, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            CharSequence _marshallOutInout = Marshalling.marshallOutInout(operation);
            _builder.append((Object)_marshallOutInout, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("resultsReady = 1;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

