/**
 * Copyright (c) 2018 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Shuai Li (CEA LIST) <shuai.li@cea.fr> - initial API and implementation
 *     Ported from C++ code - Bug 568883
 */
package org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine;

import com.google.common.base.Objects;
import java.util.function.Consumer;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.Monitored;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.profile.standard.Destroy;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * TODO - Incomplete, not working
 */
@SuppressWarnings("all")
public class MonitoringTransformation {
  public static final String MONITOR_SOCKET_NAME = "monitorSocket";

  public static final String MONITOR_ADDRESS_NAME = "monitorAddress";

  private SM2ClassesTransformationCore core;

  private org.eclipse.uml2.uml.Class superContext;

  private boolean isMonitored;

  public MonitoringTransformation(final SM2ClassesTransformationCore core) {
    this.core = core;
    this.superContext = core.superContext;
    this.isMonitored = false;
  }

  /**
   * def void appendInclude() {
   * if (isMonitored) {
   * val include = UMLUtil.getStereotypeApplication(superContext, Import)
   * if (include !== null) {
   * val header = include.header
   * if (!header.contains('''#include <netinet/in.h>''')) {
   * core.appendImport('''#include <netinet/in.h>''')
   * }
   * }
   * 
   * if (include !== null) {
   * val body = UMLUtil.getStereotypeApplication(superContext, Include).header
   * if (!body.contains('''#include <unistd.h>''')) {
   * core.appendImport('''#include <unistd.h>''')
   * }
   * if (!body.contains('''#include <sys/socket.h>''')) {
   * core.appendImport('''#include <sys/socket.h>''')
   * }
   * if (!body.contains('''#include <arpa/inet.h>''')) {
   * core.appendImport('''#include <arpa/inet.h>''')
   * }
   * }
   * 
   * }
   * }
   */
  public Property createMonitorAttributes() {
    Property _xifexpression = null;
    if (this.isMonitored) {
      Property _xblockexpression = null;
      {
        this.superContext.createOwnedAttribute(MonitoringTransformation.MONITOR_SOCKET_NAME, this.core.intType);
        _xblockexpression = this.superContext.createOwnedAttribute(MonitoringTransformation.MONITOR_ADDRESS_NAME, this.core.sockAddrInType);
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }

  public OpaqueBehavior createDestructor() {
    OpaqueBehavior _xifexpression = null;
    if (this.isMonitored) {
      OpaqueBehavior _xblockexpression = null;
      {
        final Function1<Operation, Boolean> _function = new Function1<Operation, Boolean>() {
          @Override
          public Boolean apply(final Operation it) {
            return Boolean.valueOf((StereotypeUtil.isApplied(it, "StandardProfile::Destroy") && Objects.equal(it.getName(), MonitoringTransformation.this.superContext.getName())));
          }
        };
        Iterable<Operation> sourceDestructors = IterableExtensions.<Operation>filter(this.superContext.getOwnedOperations(), _function);
        final Function1<Operation, Operation> _function_1 = new Function1<Operation, Operation>() {
          @Override
          public Operation apply(final Operation it) {
            return it;
          }
        };
        Iterable<Operation> targetDestructors = IterableExtensions.<Operation, Operation>map(sourceDestructors, _function_1);
        OpaqueBehavior _xifexpression_1 = null;
        boolean _isEmpty = IterableExtensions.isEmpty(targetDestructors);
        if (_isEmpty) {
          OpaqueBehavior _xblockexpression_1 = null;
          {
            Operation destructor = this.superContext.createOwnedOperation(this.superContext.getName(), null, null);
            StereotypeUtil.apply(destructor, Destroy.class);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("close(");
            _builder.append(MonitoringTransformation.MONITOR_SOCKET_NAME);
            _builder.append(");");
            _xblockexpression_1 = this.core.createOpaqueBehavior(this.superContext, destructor, _builder.toString());
          }
          _xifexpression_1 = _xblockexpression_1;
        } else {
          final Consumer<Operation> _function_2 = new Consumer<Operation>() {
            @Override
            public void accept(final Operation it) {
              Behavior _head = IterableExtensions.<Behavior>head(it.getMethods());
              OpaqueBehavior opaque = ((OpaqueBehavior) _head);
              if ((opaque != null)) {
                String body = opaque.getBodies().get(0);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(body);
                _builder.newLineIfNotEmpty();
                _builder.append("close(");
                _builder.append(MonitoringTransformation.MONITOR_SOCKET_NAME);
                _builder.append(");");
                MonitoringTransformation.this.core.createOpaqueBehavior(MonitoringTransformation.this.superContext, it, _builder.toString());
              } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("close(");
                _builder_1.append(MonitoringTransformation.MONITOR_SOCKET_NAME);
                _builder_1.append(");");
                MonitoringTransformation.this.core.createOpaqueBehavior(MonitoringTransformation.this.superContext, it, _builder_1.toString());
              }
            }
          };
          targetDestructors.forEach(_function_2);
        }
        _xblockexpression = _xifexpression_1;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }

  public OpaqueBehavior createConstructor() {
    OpaqueBehavior _xifexpression = null;
    if (this.isMonitored) {
      OpaqueBehavior _xblockexpression = null;
      {
        final Function1<Operation, Boolean> _function = new Function1<Operation, Boolean>() {
          @Override
          public Boolean apply(final Operation it) {
            return Boolean.valueOf((StereotypeUtil.isApplied(it, "StandardProfile::Create") && Objects.equal(it.getName(), MonitoringTransformation.this.superContext.getName())));
          }
        };
        Iterable<Operation> sourceContructors = IterableExtensions.<Operation>filter(this.superContext.getOwnedOperations(), _function);
        final Function1<Operation, Operation> _function_1 = new Function1<Operation, Operation>() {
          @Override
          public Operation apply(final Operation it) {
            return it;
          }
        };
        Iterable<Operation> targetContructors = IterableExtensions.<Operation, Operation>map(sourceContructors, _function_1);
        OpaqueBehavior _xifexpression_1 = null;
        boolean _isEmpty = IterableExtensions.isEmpty(targetContructors);
        if (_isEmpty) {
          OpaqueBehavior _xblockexpression_1 = null;
          {
            Operation constructor = this.superContext.createOwnedOperation(this.superContext.getName(), null, null);
            StereotypeUtil.apply(constructor, "StandardProfile::Create");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(MonitoringTransformation.MONITOR_SOCKET_NAME);
            _builder.append(" = socket(AF_INET, SOCK_DGRAM, 17);");
            _builder.newLineIfNotEmpty();
            _builder.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
            _builder.append(".sin_addr.s_addr = inet_addr(\"TODO\");");
            _builder.newLineIfNotEmpty();
            _builder.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
            _builder.append(".sin_family = AF_INET;");
            _builder.newLineIfNotEmpty();
            _builder.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
            _builder.append(".sin_port = htons(\"TODO\");");
            _xblockexpression_1 = this.core.createOpaqueBehavior(this.superContext, constructor, _builder.toString());
          }
          _xifexpression_1 = _xblockexpression_1;
        } else {
          final Consumer<Operation> _function_2 = new Consumer<Operation>() {
            @Override
            public void accept(final Operation it) {
              Behavior _head = IterableExtensions.<Behavior>head(it.getMethods());
              OpaqueBehavior opaque = ((OpaqueBehavior) _head);
              if ((opaque != null)) {
                String body = opaque.getBodies().get(0);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(MonitoringTransformation.MONITOR_SOCKET_NAME);
                _builder.append(" = socket(AF_INET, SOCK_DGRAM, 17);");
                _builder.newLineIfNotEmpty();
                _builder.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
                _builder.append(".sin_addr.s_addr = inet_addr(\"TODO\");");
                _builder.newLineIfNotEmpty();
                _builder.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
                _builder.append(".sin_family = AF_INET;");
                _builder.newLineIfNotEmpty();
                _builder.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
                _builder.append(".sin_port = htons(\"TODO\");");
                _builder.newLineIfNotEmpty();
                _builder.append(body);
                MonitoringTransformation.this.core.createOpaqueBehavior(MonitoringTransformation.this.superContext, it, _builder.toString());
              } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(MonitoringTransformation.MONITOR_SOCKET_NAME);
                _builder_1.append(" = socket(AF_INET, SOCK_DGRAM, 17);");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
                _builder_1.append(".sin_addr.s_addr = inet_addr(\"TODO\");");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
                _builder_1.append(".sin_family = AF_INET;");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
                _builder_1.append(".sin_port = htons(\"TODO\");");
                MonitoringTransformation.this.core.createOpaqueBehavior(MonitoringTransformation.this.superContext, it, _builder_1.toString());
              }
            }
          };
          targetContructors.forEach(_function_2);
        }
        _xblockexpression = _xifexpression_1;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }

  public String generateTransitionCode(final Transition t) {
    if (this.isMonitored) {
      boolean monitorThis = true;
      final StateMachine stateMachine = t.containingStateMachine();
      if ((stateMachine != null)) {
        final Monitored monitoredStereotype = UMLUtil.<Monitored>getStereotypeApplication(stateMachine, Monitored.class);
        if ((monitoredStereotype != null)) {
          monitorThis = monitoredStereotype.isGenerateMonitoringCode();
          if (monitorThis) {
            boolean _contains = monitoredStereotype.getGenerateExclude().contains(t);
            boolean _not = (!_contains);
            monitorThis = _not;
            if ((monitorThis && (!monitoredStereotype.getGenerateExclusivelyInclude().isEmpty()))) {
              monitorThis = monitoredStereotype.getGenerateExclusivelyInclude().contains(t);
            }
          }
        }
      }
      if (monitorThis) {
        if (((t.getQualifiedName() != null) && (!t.getQualifiedName().isEmpty()))) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("if (");
          _builder.append(MonitoringTransformation.MONITOR_SOCKET_NAME);
          _builder.append(" != -1) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("sendto(");
          _builder.append(MonitoringTransformation.MONITOR_SOCKET_NAME, "\t");
          _builder.append(", \"TRANSITION|");
          String _qualifiedName = t.getQualifiedName();
          _builder.append(_qualifiedName, "\t");
          _builder.append("\", sizeof(\"TRANSITION|");
          String _qualifiedName_1 = t.getQualifiedName();
          _builder.append(_qualifiedName_1, "\t");
          _builder.append("\"), 0, reinterpret_cast<const sockaddr*>(&");
          _builder.append(MonitoringTransformation.MONITOR_ADDRESS_NAME, "\t");
          _builder.append("), sizeof(");
          _builder.append(MonitoringTransformation.MONITOR_ADDRESS_NAME, "\t");
          _builder.append("));");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
          return _builder.toString();
        }
      }
    }
    return "";
  }
}
