/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.languages.common.base.StdUriConstants;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.common.profile.CommonProfileResource;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.library.CppUriConstants;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.EnumStyle;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Virtual;
import org.eclipse.papyrus.designer.transformation.base.utils.OperationSync;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.IncludeUtils;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.ChangeEventTransformation;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.ConcurrencyGenerator;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.EventTransformation;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.LifeCycleUtil;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.MonitoringTransformation;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.PThreadTypes;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.PseudostateGenerator;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.TransitionGraph;
import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCommon;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.DerivedElement;
import org.eclipse.papyrus.designer.transformation.vsl.ParseVSL;
import org.eclipse.papyrus.designer.uml.tools.utils.BehaviorUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StateMachineUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class SM2ClassesTransformationCore {
    @Extension
    protected CDefinitions cdefs;
    public int MAX_NUMBER_ORTHOGONAL_REGIONS = 1;
    private StateMachine sm;
    public Type boolType;
    public Type threadFuncEnum;
    public Class superContext;
    private List<Transition> transitions = new ArrayList<Transition>();
    private List<OpaqueBehavior> actions = new ArrayList<OpaqueBehavior>();
    public Region topRegion;
    public List<State> states = new ArrayList<State>();
    private List<Vertex> vertexes = new ArrayList<Vertex>();
    public LazyCopier copier;
    private String langID = "C++";
    private Type stateStruct;
    public boolean generateActionLog = false;
    private boolean createDoActivity = true;
    private boolean useThreadCpp11 = true;
    private Type threadCpp11;
    public Type voidType;
    private Enumeration stateIdEnum;
    public Type intType;
    public Type charType;
    private Enumeration eventIdEnum;
    public Type fptr;
    public PThreadTypes ptTypes;
    public Type sockAddrInType;
    public List<TimeEvent> timeEvents = new ArrayList<TimeEvent>();
    public List<ChangeEvent> changeEvents = new ArrayList<ChangeEvent>();
    public List<CallEvent> callEvents = new ArrayList<CallEvent>();
    private List<SignalEvent> signalEvents = new ArrayList<SignalEvent>();
    private List<AnyReceiveEvent> anyEvents = new ArrayList<AnyReceiveEvent>();
    private List<Pseudostate> junctions = new ArrayList<Pseudostate>();
    public ConcurrencyGenerator concurrency;
    public EventTransformation eventTransform;
    public PseudostateGenerator pseudostateGenerator;
    public MonitoringTransformation monitoringTransformation;
    public static String smLibraryUri = "platform:/resource/org.eclipse.papyrus.designer.codegen.statemachine/models/SmLibrary.uml";
    public List<Behavior> doActivityList = new ArrayList<Behavior>();
    public Package smPack;
    private List<Region> regions = new ArrayList<Region>();
    public List<Transition> parallelTransitions = new ArrayList<Transition>();
    public Map<State, List<TimeEvent>> states2TimeEvents = new HashMap<State, List<TimeEvent>>();
    private Type threadStructType;
    public List<Region> orthogonalRegions = new ArrayList<Region>();

    public SM2ClassesTransformationCore(LazyCopier copier, StateMachine sm, Class tmClass) {
        CDefinitions _cDefinitions;
        PThreadTypes _pThreadTypes;
        this.copier = copier;
        this.superContext = tmClass;
        this.sm = sm;
        ResourceSet resourceSet = this.getTargetPacket().eResource().getResourceSet();
        this.boolType = this.getPrimitiveType("bool", resourceSet);
        this.voidType = this.getPrimitiveType("void", resourceSet);
        this.intType = this.getPrimitiveType("int", resourceSet);
        this.charType = this.getPrimitiveType("char", resourceSet);
        this.sockAddrInType = this.getSocketType("sockaddr_in", resourceSet);
        this.ptTypes = _pThreadTypes = new PThreadTypes(this.superContext);
        this.cdefs = _cDefinitions = new CDefinitions(this.superContext);
    }

    public Package setSmPack(Package smPack) {
        this.smPack = smPack;
        return this.smPack;
    }

    public Type getThreadStructType() {
        return this.threadStructType;
    }

    public Type setThreadStructType(Type threadStructType) {
        this.threadStructType = threadStructType;
        return this.threadStructType;
    }

    public Type getSocketType(String name, ResourceSet resourceSet) {
        Package socketLibrary = ElementUtils.loadPackage((URI)CppUriConstants.SOCKET_LIB_URI, (ResourceSet)resourceSet);
        PackageableElement element = socketLibrary.getPackagedElement(name);
        if (element instanceof Type) {
            return (Type)element;
        }
        return null;
    }

    public Package getRoot() {
        return TransformationContext.current.copier.source;
    }

    public Type getPrimitiveType(String name, ResourceSet resourceSet) {
        Package ansiCLibrary = ElementUtils.loadPackage((URI)CppUriConstants.ANSIC_LIB_URI, (ResourceSet)resourceSet);
        PackageableElement element = ansiCLibrary.getPackagedElement(name);
        if (element instanceof Type) {
            return (Type)element;
        }
        return null;
    }

    public Package getTargetPacket() {
        return this.copier.target;
    }

    public Package getExternalPackage(Package parentPack) {
        boolean _tripleEquals;
        Package _nestedPackage = parentPack.getNestedPackage("external");
        boolean bl = _tripleEquals = _nestedPackage == null;
        if (_tripleEquals) {
            Package createdPack = parentPack.createNestedPackage("external");
            StereotypeUtil.apply((Element)createdPack, NoCodeGen.class);
        }
        return parentPack.getNestedPackage("external");
    }

    public void transform() {
        boolean _greaterThan_1;
        boolean _not_1;
        boolean _not;
        boolean _greaterThan;
        MonitoringTransformation _monitoringTransformation;
        PseudostateGenerator _pseudostateGenerator;
        EventTransformation _eventTransformation;
        ConcurrencyGenerator _concurrencyGenerator;
        Package cgProfile;
        Package targetPack = this.getTargetPacket();
        ResourceSet resourceSet = targetPack.eResource().getResourceSet();
        Package stdProfile = ElementUtils.loadPackage((URI)StdUriConstants.UML_STD_PROFILE_URI, (ResourceSet)resourceSet);
        if (stdProfile instanceof Profile) {
            PackageUtil.applyProfile((Package)targetPack, (Profile)((Profile)stdProfile), (boolean)true);
        }
        if ((cgProfile = ElementUtils.loadPackage((URI)CommonProfileResource.PROFILE_PATH_URI, (ResourceSet)resourceSet)) instanceof Profile) {
            PackageUtil.applyProfile((Package)targetPack, (Profile)((Profile)cgProfile), (boolean)true);
        }
        if (this.useThreadCpp11) {
            Package externalPackage = this.getExternalPackage(targetPack);
            this.threadCpp11 = externalPackage.createOwnedType("std::thread", UMLPackage.Literals.DATA_TYPE);
            StereotypeUtil.apply((Element)this.threadCpp11, External.class);
        }
        this.topRegion = (Region)IterableExtensions.head((Iterable)this.sm.getRegions());
        this.concurrency = _concurrencyGenerator = new ConcurrencyGenerator(this);
        this.eventTransform = _eventTransformation = new EventTransformation(this);
        this.pseudostateGenerator = _pseudostateGenerator = new PseudostateGenerator(this);
        this.monitoringTransformation = _monitoringTransformation = new MonitoringTransformation(this);
        Map<Event, List<Transition>> eventMap = this.getAllEvents(this.topRegion);
        BiConsumer<Event, List<Transition>> _function = new BiConsumer<Event, List<Transition>>(){

            @Override
            public void accept(Event e, List<Transition> k) {
                if (e instanceof TimeEvent) {
                    SM2ClassesTransformationCore.this.timeEvents.add((TimeEvent)e);
                } else if (e instanceof CallEvent) {
                    SM2ClassesTransformationCore.this.callEvents.add((CallEvent)e);
                } else if (e instanceof SignalEvent) {
                    SM2ClassesTransformationCore.this.signalEvents.add((SignalEvent)e);
                } else if (e instanceof ChangeEvent) {
                    SM2ClassesTransformationCore.this.changeEvents.add((ChangeEvent)e);
                } else if (e instanceof AnyReceiveEvent) {
                    SM2ClassesTransformationCore.this.anyEvents.add((AnyReceiveEvent)e);
                }
            }
        };
        eventMap.forEach(_function);
        Classifier _createNestedClassifier = this.superContext.createNestedClassifier("EventId_t", UMLPackage.Literals.ENUMERATION);
        this.eventIdEnum = (Enumeration)_createNestedClassifier;
        EnumStyle eventIdEnumStyle = (EnumStyle)StereotypeUtil.applyApp((Element)this.eventIdEnum, EnumStyle.class);
        eventIdEnumStyle.setClassEnum(false);
        Consumer<TimeEvent> _function_1 = new Consumer<TimeEvent>(){

            @Override
            public void accept(TimeEvent it) {
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(StateMachineUtils.eventID((Event)it));
            }
        };
        this.timeEvents.forEach(_function_1);
        Consumer<ChangeEvent> _function_2 = new Consumer<ChangeEvent>(){

            @Override
            public void accept(ChangeEvent it) {
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(StateMachineUtils.eventID((Event)it));
            }
        };
        this.changeEvents.forEach(_function_2);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#define ");
        String _TIME_EVENT_LOWER_BOUND = this.cdefs.TIME_EVENT_LOWER_BOUND();
        _builder.append(_TIME_EVENT_LOWER_BOUND);
        _builder.append(" (0)");
        _builder.newLineIfNotEmpty();
        _builder.append("#define ");
        String _CHANGE_EVENT_LOWER_BOUND = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
        _builder.append(_CHANGE_EVENT_LOWER_BOUND);
        _builder.append(" (");
        int _size = this.timeEvents.size();
        _builder.append((Object)_size);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("#define ");
        String _TE_INDEX = this.cdefs.TE_INDEX();
        _builder.append(_TE_INDEX);
        _builder.append("(id) (id - ");
        String _TIME_EVENT_LOWER_BOUND_1 = this.cdefs.TIME_EVENT_LOWER_BOUND();
        _builder.append(_TIME_EVENT_LOWER_BOUND_1);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("#define ");
        String _CHE_INDEX = this.cdefs.CHE_INDEX();
        _builder.append(_CHE_INDEX);
        _builder.append("(id) (id - ");
        String _CHANGE_EVENT_LOWER_BOUND_1 = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
        _builder.append(_CHANGE_EVENT_LOWER_BOUND_1);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        IncludeUtils.appendIncludeHeader(this.superContext, _builder.toString());
        this.monitoringTransformation.appendInclude();
        Consumer<SignalEvent> _function_3 = new Consumer<SignalEvent>(){

            @Override
            public void accept(SignalEvent it) {
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(StateMachineUtils.eventID((Event)it));
            }
        };
        this.signalEvents.forEach(_function_3);
        Consumer<CallEvent> _function_4 = new Consumer<CallEvent>(){

            @Override
            public void accept(CallEvent it) {
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(StateMachineUtils.eventID((Event)it));
            }
        };
        this.callEvents.forEach(_function_4);
        Consumer<AnyReceiveEvent> _function_5 = new Consumer<AnyReceiveEvent>(){

            @Override
            public void accept(AnyReceiveEvent it) {
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(StateMachineUtils.eventID((Event)it));
            }
        };
        this.anyEvents.forEach(_function_5);
        String _upperCase = "CompletionEvent".toUpperCase();
        String _plus = String.valueOf(_upperCase) + "_ID";
        this.eventIdEnum.createOwnedLiteral(_plus);
        this.getAllActionsTransitionsStates(this.topRegion);
        Functions.Function1<State, Boolean> _function_6 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return it.isOrthogonal();
            }
        };
        Consumer<State> _function_7 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                boolean _greaterThan;
                int _size = it.getRegions().size();
                boolean bl = _greaterThan = _size > SM2ClassesTransformationCore.this.MAX_NUMBER_ORTHOGONAL_REGIONS;
                if (_greaterThan) {
                    SM2ClassesTransformationCore.this.MAX_NUMBER_ORTHOGONAL_REGIONS = it.getRegions().size();
                }
            }
        };
        IterableExtensions.filter(this.states, (Functions.Function1)_function_6).forEach(_function_7);
        Consumer<State> _function_8 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                final ArrayList triggers = new ArrayList();
                Consumer<Transition> _function = new Consumer<Transition>(){

                    @Override
                    public void accept(Transition it_1) {
                        triggers.addAll(it_1.getTriggers());
                    }
                };
                it.getOutgoings().forEach((Consumer)_function);
                Functions.Function1<Trigger, Event> _function_1 = new Functions.Function1<Trigger, Event>(){

                    public Event apply(Trigger it_1) {
                        return it_1.getEvent();
                    }
                };
                List events = ListExtensions.map(triggers, (Functions.Function1)_function_1);
                List timeEvents = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)events, TimeEvent.class));
                SM2ClassesTransformationCore.this.states2TimeEvents.put(it, timeEvents);
            }
        };
        this.states.forEach(_function_8);
        Consumer<Pseudostate> _function_9 = new Consumer<Pseudostate>(){

            @Override
            public void accept(Pseudostate it) {
                PseudostateKind _kind = it.getKind();
                boolean _equals = Objects.equal((Object)_kind, (Object)PseudostateKind.JUNCTION_LITERAL);
                if (_equals) {
                    SM2ClassesTransformationCore.this.junctions.add(it);
                }
            }
        };
        Iterables.filter(this.vertexes, Pseudostate.class).forEach(_function_9);
        Consumer<Pseudostate> _function_10 = new Consumer<Pseudostate>(){

            @Override
            public void accept(Pseudostate it) {
                SM2ClassesTransformationCore.this.superContext.createOwnedAttribute(it.getName(), SM2ClassesTransformationCore.this.intType);
            }
        };
        this.junctions.forEach(_function_10);
        Classifier _createNestedClassifier_1 = this.superContext.createNestedClassifier("StateIDEnum", UMLPackage.Literals.ENUMERATION);
        this.stateIdEnum = (Enumeration)_createNestedClassifier_1;
        EnumStyle stateIdEnumStyle = (EnumStyle)StereotypeUtil.applyApp((Element)this.stateIdEnum, EnumStyle.class);
        stateIdEnumStyle.setClassEnum(false);
        this.monitoringTransformation.createMonitorAttributes();
        this.createStateStruct();
        Property stateArrayAttr = this.superContext.createOwnedAttribute("states", this.stateStruct);
        StereotypeUtil.apply((Element)stateArrayAttr, Array.class);
        Array _stereotypeApplication = (Array)UMLUtil.getStereotypeApplication((Element)stateArrayAttr, Array.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("[");
        int _size_1 = this.states.size();
        _builder_1.append((Object)_size_1);
        _builder_1.append("]");
        _stereotypeApplication.setDefinition(_builder_1.toString());
        this.superContext.createOwnedAttribute("activeStateID", (Type)this.stateIdEnum);
        this.createRegionMethods();
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("startBehavior();");
        final String startCode = _builder_2.toString();
        boolean _supportsLifeCycle = LifeCycleUtil.supportsLifeCycle(this.superContext);
        if (_supportsLifeCycle) {
            LifeCycleUtil.addUnimplemented(this.superContext);
            Operation activateOp = this.superContext.getOperation("activate", null, null);
            BehaviorUtils.appendBody((Operation)activateOp, (String)startCode);
        } else {
            Functions.Function1<Operation, Boolean> _function_11 = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    return StereotypeUtil.isApplied((Element)it, Create.class) && Objects.equal((Object)it.getName(), (Object)SM2ClassesTransformationCore.this.superContext.getName());
                }
            };
            Iterable constructors = IterableExtensions.filter((Iterable)this.superContext.getOwnedOperations(), (Functions.Function1)_function_11);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)constructors);
            if (_isEmpty) {
                Operation ctor = this.superContext.createOwnedOperation(this.superContext.getName(), null, null);
                StereotypeUtil.apply((Element)ctor, Create.class);
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("startBehavior();");
                this.createOpaqueBehavior(this.superContext, ctor, _builder_3.toString());
            } else {
                Consumer<Operation> _function_12 = new Consumer<Operation>(){

                    @Override
                    public void accept(Operation it) {
                        BehaviorUtils.appendBody((Operation)it, (String)startCode);
                    }
                };
                constructors.forEach(_function_12);
            }
        }
        this.monitoringTransformation.createConstructor();
        this.monitoringTransformation.createDestructor();
        Operation startBehavior = this.superContext.createOwnedOperation("startBehavior", null, null);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("systemState");
        _builder_4.append(" = statemachine::SystemStateEnum_t::IDLE;");
        _builder_4.newLineIfNotEmpty();
        for (State s : this.states) {
            boolean _isBehaviorExist_2;
            boolean _isBehaviorExist_1;
            boolean _isBehaviorExist = StateMachineUtils.isBehaviorExist((Behavior)s.getEntry());
            if (_isBehaviorExist) {
                _builder_4.append("states");
                _builder_4.append("[");
                String _upperCase_1 = s.getName().toUpperCase();
                _builder_4.append(_upperCase_1);
                _builder_4.append("_ID].");
                _builder_4.append("entry");
                _builder_4.append(" = &");
                String _name = this.superContext.getName();
                _builder_4.append(_name);
                _builder_4.append("::");
                String _name_1 = s.getName();
                String _plus_1 = String.valueOf(_name_1) + "_";
                String _plus_2 = String.valueOf(_plus_1) + "entry";
                _builder_4.append(_plus_2);
                _builder_4.append(";");
                _builder_4.newLineIfNotEmpty();
            }
            if (_isBehaviorExist_1 = StateMachineUtils.isBehaviorExist((Behavior)s.getExit())) {
                _builder_4.append("states");
                _builder_4.append("[");
                String _upperCase_2 = s.getName().toUpperCase();
                _builder_4.append(_upperCase_2);
                _builder_4.append("_ID].");
                _builder_4.append("exit");
                _builder_4.append(" = &");
                String _name_2 = this.superContext.getName();
                _builder_4.append(_name_2);
                _builder_4.append("::");
                String _name_3 = s.getName();
                String _plus_3 = String.valueOf(_name_3) + "_";
                String _plus_4 = String.valueOf(_plus_3) + "exit";
                _builder_4.append(_plus_4);
                _builder_4.append(";");
                _builder_4.newLineIfNotEmpty();
            }
            if (_isBehaviorExist_2 = StateMachineUtils.isBehaviorExist((Behavior)s.getDoActivity())) {
                _builder_4.append("states");
                _builder_4.append("[");
                String _upperCase_3 = s.getName().toUpperCase();
                _builder_4.append(_upperCase_3);
                _builder_4.append("_ID].");
                _builder_4.append("doActivity");
                _builder_4.append(" = &");
                String _name_4 = this.superContext.getName();
                _builder_4.append(_name_4);
                _builder_4.append("::");
                String _name_5 = s.getName();
                String _plus_5 = String.valueOf(_name_5) + "_";
                String _plus_6 = String.valueOf(_plus_5) + "doActivity";
                _builder_4.append(_plus_6);
                _builder_4.append(";");
                _builder_4.newLineIfNotEmpty();
            }
            _builder_4.append("doActivityTable");
            _builder_4.append("[");
            String _upperCase_4 = s.getName().toUpperCase();
            _builder_4.append(_upperCase_4);
            _builder_4.append("_ID] =  ");
            _builder_4.append("states");
            _builder_4.append("[");
            String _upperCase_5 = s.getName().toUpperCase();
            _builder_4.append(_upperCase_5);
            _builder_4.append("_ID].");
            _builder_4.append("doActivity");
            _builder_4.append(";");
            _builder_4.newLineIfNotEmpty();
        }
        _builder_4.newLine();
        _builder_4.append("// initialize all threads, the threads wait until the associated flag is set");
        _builder_4.newLine();
        _builder_4.append("for(int i = 0; i < (int) ");
        _builder_4.append("STATE_MAX");
        _builder_4.append("; i++) {");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append("if (");
        _builder_4.append("states", "\t");
        _builder_4.append("[i].");
        _builder_4.append("doActivity", "\t");
        _builder_4.append(" != &");
        String _name_6 = this.superContext.getName();
        _builder_4.append(_name_6, "\t");
        _builder_4.append("::doActivity_dft) {");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t\t");
        _builder_4.append("threadStructs", "\t\t");
        _builder_4.append("[i].id = i;");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t\t");
        _builder_4.append("threadStructs", "\t\t");
        _builder_4.append("[i].ptr = this;");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t\t");
        _builder_4.append("threadStructs", "\t\t");
        _builder_4.append("[i].func_type = ");
        _builder_4.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY", "\t\t");
        _builder_4.append(";");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t\t");
        _builder_4.append("mutexes", "\t\t");
        _builder_4.append("[i] = PTHREAD_MUTEX_INITIALIZER;");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t\t");
        _builder_4.append("conds", "\t\t");
        _builder_4.append("[i] = PTHREAD_COND_INITIALIZER;");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t\t");
        _builder_4.append("pthread_create", "\t\t");
        _builder_4.append("(&");
        _builder_4.append("threads", "\t\t");
        _builder_4.append("[i], NULL, &");
        String _name_7 = this.superContext.getName();
        _builder_4.append(_name_7, "\t\t");
        _builder_4.append("::");
        _builder_4.append("thread_func_wrapper", "\t\t");
        _builder_4.append(", &");
        _builder_4.append("threadStructs", "\t\t");
        _builder_4.append("[i]);");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append("}");
        _builder_4.newLine();
        _builder_4.append("}");
        _builder_4.newLine();
        _builder_4.newLine();
        int _size_2 = this.timeEvents.size();
        boolean bl = _greaterThan = _size_2 > 0;
        if (_greaterThan) {
            for (TimeEvent e : this.timeEvents) {
                ValueSpecification _expr = e.getWhen().getExpr();
                long duration = ParseVSL.getMsDurationFromVSL((String)((String)((OpaqueExpression)_expr).getBodies().get(0)));
                _builder_4.newLineIfNotEmpty();
                _builder_4.append("timeEventThreadStructs");
                _builder_4.append("[");
                String _TE_INDEX_1 = this.cdefs.TE_INDEX();
                _builder_4.append(_TE_INDEX_1);
                _builder_4.append("(");
                String _eventID = StateMachineUtils.eventID((Event)e);
                _builder_4.append(_eventID);
                _builder_4.append(")].duration = ");
                _builder_4.append((Object)duration);
                _builder_4.append(";");
                _builder_4.newLineIfNotEmpty();
            }
            _builder_4.append("for(int i = ");
            String _TIME_EVENT_LOWER_BOUND_2 = this.cdefs.TIME_EVENT_LOWER_BOUND();
            _builder_4.append(_TIME_EVENT_LOWER_BOUND_2);
            _builder_4.append("; i < ");
            int _size_3 = this.timeEvents.size();
            _builder_4.append((Object)_size_3);
            _builder_4.append("; i++) {");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.append("timeEventThreadStructs", "\t");
            _builder_4.append("[");
            String _TE_INDEX_2 = this.cdefs.TE_INDEX();
            _builder_4.append(_TE_INDEX_2, "\t");
            _builder_4.append("(i)].id = i;");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.append("timeEventThreadStructs", "\t");
            _builder_4.append("[");
            String _TE_INDEX_3 = this.cdefs.TE_INDEX();
            _builder_4.append(_TE_INDEX_3, "\t");
            _builder_4.append("(i)].ptr = this;");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.append("timeEventThreadStructs", "\t");
            _builder_4.append("[");
            String _TE_INDEX_4 = this.cdefs.TE_INDEX();
            _builder_4.append(_TE_INDEX_4, "\t");
            _builder_4.append("(i)].func_type = ");
            _builder_4.append("statemachine::ThreadFunctions::TF_TIME_EVENT", "\t");
            _builder_4.append(";");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.append("timeEventMutexes", "\t");
            _builder_4.append("[");
            String _TE_INDEX_5 = this.cdefs.TE_INDEX();
            _builder_4.append(_TE_INDEX_5, "\t");
            _builder_4.append("(i)] = PTHREAD_MUTEX_INITIALIZER;");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.append("timeEventConds", "\t");
            _builder_4.append("[");
            String _TE_INDEX_6 = this.cdefs.TE_INDEX();
            _builder_4.append(_TE_INDEX_6, "\t");
            _builder_4.append("(i)] = PTHREAD_COND_INITIALIZER;");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.append("pthread_create", "\t");
            _builder_4.append("(&");
            _builder_4.append("timeEventThreads", "\t");
            _builder_4.append("[");
            String _TE_INDEX_7 = this.cdefs.TE_INDEX();
            _builder_4.append(_TE_INDEX_7, "\t");
            _builder_4.append("(i)], NULL, &");
            String _name_8 = this.superContext.getName();
            _builder_4.append(_name_8, "\t");
            _builder_4.append("::");
            _builder_4.append("thread_func_wrapper", "\t");
            _builder_4.append(", &");
            _builder_4.append("timeEventThreadStructs", "\t");
            _builder_4.append("[");
            String _TE_INDEX_8 = this.cdefs.TE_INDEX();
            _builder_4.append(_TE_INDEX_8, "\t");
            _builder_4.append("(i)]);");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.append("while (");
            _builder_4.append("timeEventFlags", "\t");
            _builder_4.append("[");
            String _TE_INDEX_9 = this.cdefs.TE_INDEX();
            _builder_4.append(_TE_INDEX_9, "\t");
            _builder_4.append("(i)]) {");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t\t");
            _builder_4.append("usleep(100);");
            _builder_4.newLine();
            _builder_4.append("\t");
            _builder_4.append("}");
            _builder_4.newLine();
            _builder_4.append("}");
            _builder_4.newLine();
        }
        _builder_4.newLine();
        boolean _isEmpty_1 = this.orthogonalRegions.isEmpty();
        boolean bl2 = _not = !_isEmpty_1;
        if (_not) {
            for (Region r : this.orthogonalRegions) {
                _builder_4.append("regionTable");
                _builder_4.append("[");
                String _regionMacroId = this.getRegionMacroId(r);
                _builder_4.append(_regionMacroId);
                _builder_4.append("] = &");
                String _name_9 = this.superContext.getName();
                _builder_4.append(_name_9);
                _builder_4.append("::");
                String _regionMethodName = this.getRegionMethodName(r);
                _builder_4.append(_regionMethodName);
                _builder_4.append(";");
                _builder_4.newLineIfNotEmpty();
                _builder_4.append("regionExitTable");
                _builder_4.append("[");
                String _regionMacroId_1 = this.getRegionMacroId(r);
                _builder_4.append(_regionMacroId_1);
                _builder_4.append("] = &");
                String _name_10 = this.superContext.getName();
                _builder_4.append(_name_10);
                _builder_4.append("::");
                String _regionMethodExitName = this.getRegionMethodExitName(r);
                _builder_4.append(_regionMethodExitName);
                _builder_4.append(";");
                _builder_4.newLineIfNotEmpty();
            }
        }
        _builder_4.newLine();
        boolean _isEmpty_2 = this.parallelTransitions.isEmpty();
        boolean bl3 = _not_1 = !_isEmpty_2;
        if (_not_1) {
            for (Transition t : this.parallelTransitions) {
                _builder_4.append("transitionTable");
                _builder_4.append("[");
                String _parallelTransitionId = this.concurrency.parallelTransitionId(t);
                _builder_4.append(_parallelTransitionId);
                _builder_4.append("] = &");
                String _name_11 = this.superContext.getName();
                _builder_4.append(_name_11);
                _builder_4.append("::");
                String _parallelTransitionMethodName = this.concurrency.parallelTransitionMethodName(t);
                _builder_4.append(_parallelTransitionMethodName);
                _builder_4.append(";");
                _builder_4.newLineIfNotEmpty();
            }
        }
        _builder_4.newLine();
        _builder_4.append("runToCompletionMutex");
        _builder_4.append(" = PTHREAD_MUTEX_INITIALIZER;");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("runToCompletionCond");
        _builder_4.append(" = PTHREAD_COND_INITIALIZER;");
        _builder_4.newLineIfNotEmpty();
        _builder_4.newLine();
        _builder_4.append("dispatchStruct = ");
        _builder_4.append("statemachine::StructForThread_t");
        _builder_4.append("(this, 0, 0, ");
        _builder_4.append("statemachine::ThreadFunctions::TF_STATE_MACHINE_TYPE");
        _builder_4.append(", 0);");
        _builder_4.newLineIfNotEmpty();
        String _name_12 = this.superContext.getName();
        _builder_4.append(_name_12);
        _builder_4.append("_THREAD_CREATE(dispatchThread, dispatchStruct)");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("while (!dispatchFlag) {");
        _builder_4.newLine();
        _builder_4.append("\t");
        _builder_4.append("usleep(100);");
        _builder_4.newLine();
        _builder_4.append("}");
        _builder_4.newLine();
        _builder_4.newLine();
        int _size_4 = this.changeEvents.size();
        boolean bl4 = _greaterThan_1 = _size_4 > 0;
        if (_greaterThan_1) {
            _builder_4.append("// threads for changeEvent");
            _builder_4.newLine();
            _builder_4.append("for(int i = ");
            String _CHANGE_EVENT_LOWER_BOUND_2 = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
            _builder_4.append(_CHANGE_EVENT_LOWER_BOUND_2);
            _builder_4.append("; i < ");
            String _CHANGE_EVENT_LOWER_BOUND_3 = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
            _builder_4.append(_CHANGE_EVENT_LOWER_BOUND_3);
            _builder_4.append(" + ");
            int _size_5 = this.changeEvents.size();
            _builder_4.append((Object)_size_5);
            _builder_4.append("; i++) {");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.append("changeEventThreadStructs", "\t");
            _builder_4.append("[");
            String _CHE_INDEX_1 = this.cdefs.CHE_INDEX();
            _builder_4.append(_CHE_INDEX_1, "\t");
            _builder_4.append("(i)].id = i;");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.append("changeEventThreadStructs", "\t");
            _builder_4.append("[");
            String _CHE_INDEX_2 = this.cdefs.CHE_INDEX();
            _builder_4.append(_CHE_INDEX_2, "\t");
            _builder_4.append("(i)].ptr = this;");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.append("changeEventThreadStructs", "\t");
            _builder_4.append("[");
            String _CHE_INDEX_3 = this.cdefs.CHE_INDEX();
            _builder_4.append(_CHE_INDEX_3, "\t");
            _builder_4.append("(i)].func_type = ");
            _builder_4.append("statemachine::ThreadFunctions::TF_CHANGE_EVENT", "\t");
            _builder_4.append(";");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.append("pthread_create", "\t");
            _builder_4.append("(&");
            _builder_4.append("changeEventThreads", "\t");
            _builder_4.append("[");
            String _CHE_INDEX_4 = this.cdefs.CHE_INDEX();
            _builder_4.append(_CHE_INDEX_4, "\t");
            _builder_4.append("(i)], NULL, &");
            String _name_13 = this.superContext.getName();
            _builder_4.append(_name_13, "\t");
            _builder_4.append("::");
            _builder_4.append("thread_func_wrapper", "\t");
            _builder_4.append(", &");
            _builder_4.append("changeEventThreadStructs", "\t");
            _builder_4.append("[");
            String _CHE_INDEX_5 = this.cdefs.CHE_INDEX();
            _builder_4.append(_CHE_INDEX_5, "\t");
            _builder_4.append("(i)]);");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("}");
            _builder_4.newLine();
        }
        _builder_4.newLine();
        _builder_4.append("//initialze root active state");
        _builder_4.newLine();
        _builder_4.append("//execute initial effect");
        _builder_4.newLine();
        String _regionMethodName_1 = this.getRegionMethodName(this.topRegion);
        _builder_4.append(_regionMethodName_1);
        _builder_4.append("(");
        String _initialMacroName = this.getInitialMacroName(this.topRegion);
        _builder_4.append(_initialMacroName);
        _builder_4.append(");");
        _builder_4.newLineIfNotEmpty();
        this.createOpaqueBehavior(this.superContext, startBehavior, _builder_4.toString());
        Property dispatchFlagAttribute = this.superContext.createOwnedAttribute("dispatchFlag", this.boolType);
        ValueSpecification _createDefaultValue = dispatchFlagAttribute.createDefaultValue("defaultValue", this.boolType, UMLPackage.Literals.LITERAL_BOOLEAN);
        LiteralBoolean litBool = (LiteralBoolean)_createDefaultValue;
        litBool.setValue(false);
        BiConsumer<Event, List<Transition>> _function_13 = new BiConsumer<Event, List<Transition>>(){

            @Override
            public void accept(Event e_1, List<Transition> trans) {
                SM2ClassesTransformationCore.this.eventTransform.createEventMethod(e_1, trans);
            }
        };
        eventMap.forEach(_function_13);
        final ArrayList<Transition> autoTrans = new ArrayList<Transition>();
        Consumer<Transition> _function_14 = new Consumer<Transition>(){

            @Override
            public void accept(Transition it) {
                if (it.getSource() instanceof State && ListExtensions.map((List)it.getTriggers(), (Functions.Function1)new Functions.Function1<Trigger, Event>(){

                    public Event apply(Trigger it_1) {
                        return it_1.getEvent();
                    }
                }).size() == 0) {
                    autoTrans.add(it);
                }
            }
        };
        this.transitions.forEach(_function_14);
        this.eventTransform.createEventMethod("CompletionEvent", autoTrans);
        Consumer<State> _function_15 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                boolean _isBehaviorExist_2;
                boolean _isBehaviorExist_1;
                String _upperCase = it.getName().toUpperCase();
                String _plus = String.valueOf(_upperCase) + "_ID";
                SM2ClassesTransformationCore.this.stateIdEnum.createOwnedLiteral(_plus);
                boolean _isBehaviorExist = StateMachineUtils.isBehaviorExist((Behavior)it.getEntry());
                if (_isBehaviorExist) {
                    String _name = it.getName();
                    String _plus_1 = String.valueOf(_name) + "_";
                    String _plus_2 = String.valueOf(_plus_1) + "entry";
                    Operation entry = SM2ClassesTransformationCore.this.superContext.createOwnedOperation(_plus_2, null, null);
                    Behavior _entry = it.getEntry();
                    OpaqueBehavior opaque = SM2ClassesTransformationCore.this.createOpaqueBehavior(SM2ClassesTransformationCore.this.superContext, entry, (String)IterableExtensions.head((Iterable)((OpaqueBehavior)_entry).getBodies()));
                    opaque.getLanguages().add((Object)SM2ClassesTransformationCore.this.langID);
                }
                if (_isBehaviorExist_1 = StateMachineUtils.isBehaviorExist((Behavior)it.getExit())) {
                    String _name_1 = it.getName();
                    String _plus_3 = String.valueOf(_name_1) + "_";
                    String _plus_4 = String.valueOf(_plus_3) + "exit";
                    Operation exit = SM2ClassesTransformationCore.this.superContext.createOwnedOperation(_plus_4, null, null);
                    Behavior _exit = it.getExit();
                    OpaqueBehavior opaque_1 = SM2ClassesTransformationCore.this.createOpaqueBehavior(SM2ClassesTransformationCore.this.superContext, exit, (String)IterableExtensions.head((Iterable)((OpaqueBehavior)_exit).getBodies()));
                    opaque_1.getLanguages().add((Object)SM2ClassesTransformationCore.this.langID);
                }
                if (_isBehaviorExist_2 = StateMachineUtils.isBehaviorExist((Behavior)it.getDoActivity())) {
                    SM2ClassesTransformationCore.this.doActivityList.add(it.getDoActivity());
                    String _name_2 = it.getName();
                    String _plus_5 = String.valueOf(_name_2) + "_";
                    String _plus_6 = String.valueOf(_plus_5) + "doActivity";
                    Operation doActivity = SM2ClassesTransformationCore.this.superContext.createOwnedOperation(_plus_6, null, null);
                    StringConcatenation _builder = new StringConcatenation();
                    String callCompletionEvent = _builder.toString();
                    boolean _isComposite = it.isComposite();
                    boolean _not = !_isComposite;
                    Behavior _doActivity = it.getDoActivity();
                    String _head = (String)IterableExtensions.head((Iterable)((OpaqueBehavior)_doActivity).getBodies());
                    String _plus_7 = String.valueOf(_head) + "\n";
                    String _plus_8 = String.valueOf(_plus_7) + callCompletionEvent;
                    OpaqueBehavior opaque_2 = SM2ClassesTransformationCore.this.createOpaqueBehavior(SM2ClassesTransformationCore.this.superContext, doActivity, _plus_8);
                    opaque_2.getLanguages().add((Object)SM2ClassesTransformationCore.this.langID);
                }
            }
        };
        this.states.forEach(_function_15);
        this.stateIdEnum.createOwnedLiteral("STATE_MAX");
        this.concurrency.createThreadBasedParallelism();
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append("#define ");
        String _name_14 = this.superContext.getName();
        _builder_5.append(_name_14);
        _builder_5.append("_THREAD_CREATE(thThread, str) ");
        _builder_5.append("pthread_create");
        _builder_5.append("(&thThread, NULL, &");
        String _name_15 = this.superContext.getName();
        _builder_5.append(_name_15);
        _builder_5.append("::");
        _builder_5.append("thread_func_wrapper");
        _builder_5.append(", &str);");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("#define ");
        String _upperCase_6 = this.superContext.getName().toUpperCase();
        _builder_5.append(_upperCase_6);
        _builder_5.append("_GET_CONTROL /*mutex synchronization to protect run-to-completion semantics*/ \\");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t\t");
        _builder_5.append("pthread_mutex_lock(&");
        _builder_5.append("runToCompletionMutex", "\t\t");
        _builder_5.append("); \\");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t\t");
        _builder_5.append("while (");
        _builder_5.append("systemState", "\t\t");
        _builder_5.append(" != statemachine::SystemStateEnum_t::IDLE) {\\");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t\t\t");
        _builder_5.append("pthread_cond_wait(&");
        _builder_5.append("runToCompletionCond", "\t\t\t");
        _builder_5.append(", &");
        _builder_5.append("runToCompletionMutex", "\t\t\t");
        _builder_5.append(");\\");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("#define ");
        String _upperCase_7 = this.superContext.getName().toUpperCase();
        _builder_5.append(_upperCase_7);
        _builder_5.append("_RELEASE_CONTROL ");
        _builder_5.append("systemState");
        _builder_5.append(" = statemachine::SystemStateEnum_t::IDLE; pthread_cond_signal(&");
        _builder_5.append("runToCompletionCond");
        _builder_5.append("); \\");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t\t\t");
        _builder_5.append("pthread_mutex_unlock(&");
        _builder_5.append("runToCompletionMutex", "\t\t\t");
        _builder_5.append(");");
        _builder_5.newLineIfNotEmpty();
        IncludeUtils.appendIncludeHeader(this.superContext, _builder_5.toString());
        Type eventClass = this.smPack.getOwnedType("Event_t");
        Type eventQueueClass = this.smPack.getOwnedType("EventPriorityQueue");
        this.superContext.createOwnedAttribute("eventQueue", eventQueueClass);
        Property curentEvent = this.superContext.createOwnedAttribute("currentEvent", eventClass);
        StereotypeUtil.apply((Element)curentEvent, Ptr.class);
        Operation eventDispatch = this.superContext.createOwnedOperation("dispatchEvent", null, null);
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("bool popDeferred = false;");
        _builder_6.newLine();
        _builder_6.append("while(true) {");
        _builder_6.newLine();
        _builder_6.append("\t");
        _builder_6.append("//run-to-completion: need to have a mutex here");
        _builder_6.newLine();
        _builder_6.append("\t");
        _builder_6.append("currentEvent = ");
        _builder_6.append("eventQueue", "\t");
        _builder_6.append(".pop(popDeferred);");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t");
        _builder_6.append("dispatchFlag = true;");
        _builder_6.newLine();
        _builder_6.append("\t");
        _builder_6.append("if (currentEvent != NULL) {");
        _builder_6.newLine();
        _builder_6.append("\t\t");
        _builder_6.append("unsigned int eventID = currentEvent->eventID;");
        _builder_6.newLine();
        _builder_6.append("\t\t");
        String _upperCase_8 = this.superContext.getName().toUpperCase();
        _builder_6.append(_upperCase_8, "\t\t");
        _builder_6.append("_GET_CONTROL");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t\t");
        _builder_6.append("switch(eventID) {");
        _builder_6.newLine();
        Functions.Function1<Event, Boolean> _function_16 = new Functions.Function1<Event, Boolean>(){

            public Boolean apply(Event it) {
                return !(it instanceof CallEvent);
            }
        };
        Iterable _filter = IterableExtensions.filter(eventMap.keySet(), (Functions.Function1)_function_16);
        for (Event e_1 : _filter) {
            _builder_6.append("\t\t\t");
            _builder_6.append("case ");
            String _eventID_1 = StateMachineUtils.eventID((Event)e_1);
            _builder_6.append(_eventID_1, "\t\t\t");
            _builder_6.append(": {");
            _builder_6.newLineIfNotEmpty();
            if (e_1 instanceof SignalEvent) {
                boolean _tripleNotEquals;
                Signal _signal = ((SignalEvent)e_1).getSignal();
                boolean bl5 = _tripleNotEquals = _signal != null;
                if (_tripleNotEquals) {
                    _builder_6.append("\t\t\t");
                    _builder_6.append("\t");
                    String _cppQualifiedName = CppGenUtils.cgu((Element)this.superContext).cppQualifiedName((NamedElement)((SignalEvent)e_1).getSignal());
                    _builder_6.append(_cppQualifiedName, "\t\t\t\t");
                    _builder_6.append(" sig_");
                    String _eventID_2 = StateMachineUtils.eventID((Event)e_1);
                    _builder_6.append(_eventID_2, "\t\t\t\t");
                    _builder_6.append(";");
                    _builder_6.newLineIfNotEmpty();
                    _builder_6.append("\t\t\t");
                    _builder_6.append("\t");
                    _builder_6.append("if (currentEvent != NULL) {");
                    _builder_6.newLine();
                    _builder_6.append("\t\t\t");
                    _builder_6.append("\t");
                    _builder_6.append("\t");
                    _builder_6.append("memcpy(&sig_");
                    String _eventID_3 = StateMachineUtils.eventID((Event)e_1);
                    _builder_6.append(_eventID_3, "\t\t\t\t\t");
                    _builder_6.append(", currentEvent->data, sizeof(");
                    String _cppQualifiedName_1 = CppGenUtils.cgu((Element)this.superContext).cppQualifiedName((NamedElement)((SignalEvent)e_1).getSignal());
                    _builder_6.append(_cppQualifiedName_1, "\t\t\t\t\t");
                    _builder_6.append("));");
                    _builder_6.newLineIfNotEmpty();
                    _builder_6.append("\t\t\t");
                    _builder_6.append("\t");
                    _builder_6.append("\t");
                    _builder_6.append("process");
                    String _eventName = StateMachineUtils.eventName((Event)e_1);
                    _builder_6.append(_eventName, "\t\t\t\t\t");
                    _builder_6.append("(sig_");
                    String _eventID_4 = StateMachineUtils.eventID((Event)e_1);
                    _builder_6.append(_eventID_4, "\t\t\t\t\t");
                    _builder_6.append(");");
                    _builder_6.newLineIfNotEmpty();
                    _builder_6.append("\t\t\t");
                    _builder_6.append("\t");
                    _builder_6.append("}");
                    _builder_6.newLine();
                } else {
                    _builder_6.append("\t\t\t");
                    _builder_6.append("\t");
                    _builder_6.append("process");
                    String _eventName_1 = StateMachineUtils.eventName((Event)e_1);
                    _builder_6.append(_eventName_1, "\t\t\t\t");
                    _builder_6.append("();");
                    _builder_6.newLineIfNotEmpty();
                }
            } else {
                _builder_6.append("\t\t\t");
                _builder_6.append("\t");
                _builder_6.append("process");
                String _eventName_2 = StateMachineUtils.eventName((Event)e_1);
                _builder_6.append(_eventName_2, "\t\t\t\t");
                _builder_6.append("();");
                _builder_6.newLineIfNotEmpty();
            }
            _builder_6.append("\t\t\t");
            _builder_6.append("\t");
            _builder_6.append("break;");
            _builder_6.newLine();
            _builder_6.append("\t\t\t");
            _builder_6.append("}");
            _builder_6.newLine();
        }
        _builder_6.append("\t\t\t");
        _builder_6.append("case COMPLETIONEVENT_ID: {");
        _builder_6.newLine();
        _builder_6.append("\t\t\t\t");
        _builder_6.append("processCompletionEvent();");
        _builder_6.newLine();
        _builder_6.append("\t\t\t\t");
        _builder_6.append("break;");
        _builder_6.newLine();
        _builder_6.append("\t\t\t\t");
        _builder_6.append("}");
        _builder_6.newLine();
        _builder_6.append("\t\t");
        _builder_6.append("}");
        _builder_6.newLine();
        _builder_6.append("\t\t");
        _builder_6.append("if (");
        _builder_6.append("systemState", "\t\t");
        _builder_6.append(" == statemachine::SystemStateEnum_t::EVENT_DEFERRED) {");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t\t\t");
        _builder_6.append("eventQueue", "\t\t\t");
        _builder_6.append(".saveDeferred(*currentEvent);");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t\t");
        _builder_6.append("}");
        _builder_6.newLine();
        _builder_6.append("\t\t");
        _builder_6.append("popDeferred = (");
        _builder_6.append("systemState", "\t\t");
        _builder_6.append(" != statemachine::SystemStateEnum_t::EVENT_DEFERRED);");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t\t");
        _builder_6.append("systemState", "\t\t");
        _builder_6.append(" = statemachine::SystemStateEnum_t::IDLE;");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t\t");
        String _upperCase_9 = this.superContext.getName().toUpperCase();
        _builder_6.append(_upperCase_9, "\t\t");
        _builder_6.append("_RELEASE_CONTROL");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t");
        _builder_6.append("}");
        _builder_6.newLine();
        _builder_6.append("\t");
        _builder_6.append("usleep(100);");
        _builder_6.newLine();
        _builder_6.append("}");
        _builder_6.newLine();
        this.createOpaqueBehavior(this.superContext, eventDispatch, _builder_6.toString());
        this.concurrency.createConcurrencyForTransitions();
        this.superContext.createOwnedAttribute("dispatchThread", this.ptTypes.getPthread());
        this.superContext.createOwnedAttribute("dispatchStruct", this.concurrency.threadStructType);
        this.superContext.createOwnedAttribute("runToCompletionMutex", this.ptTypes.getPthreadMutex());
        this.superContext.createOwnedAttribute("runToCompletionCond", this.ptTypes.getPthreadCond());
        this.createChangeEvents();
    }

    private void createChangeEvents() {
        new ChangeEventTransformation(this).createChangeEvents();
    }

    public String generateChangeState(State s) {
        Region _container = s.getContainer();
        boolean _equals = Objects.equal((Object)_container, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("activeStateID");
            _builder.append(" = ");
            String _upperCase = s.getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_ID;");
            return _builder.toString();
        }
        int rIndex = s.getContainer().getState().getRegions().indexOf((Object)s.getContainer());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("states");
        _builder_1.append("[");
        String _upperCase_1 = s.getContainer().getState().getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID].");
        _builder_1.append("actives");
        _builder_1.append("[");
        _builder_1.append((Object)rIndex);
        _builder_1.append("] = ");
        String _upperCase_2 = s.getName().toUpperCase();
        _builder_1.append(_upperCase_2);
        _builder_1.append("_ID;");
        return _builder_1.toString();
    }

    public String generateExitingSubStates(State parent, boolean exitParent) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            _builder_1.append("//exiting concurrent state ");
            String _name = parent.getName();
            _builder_1.append(_name);
            _builder_1.newLineIfNotEmpty();
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                String _generateForkCall = this.concurrency.generateForkCall(r, false, "0");
                _builder_1.append(_generateForkCall);
                _builder_1.newLineIfNotEmpty();
            }
            EList _regions_1 = parent.getRegions();
            for (Region r_1 : _regions_1) {
                String _generateJoinCall = this.concurrency.generateJoinCall(r_1, false);
                _builder_1.append(_generateJoinCall);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                String _regionMethodExitName = this.getRegionMethodExitName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                _builder_1.append(_regionMethodExitName);
                _builder_1.append("();");
                _builder_1.newLineIfNotEmpty();
            }
        }
        if (exitParent) {
            boolean _isBehaviorExist = StateMachineUtils.isBehaviorExist((Behavior)parent.getDoActivity());
            if (_isBehaviorExist) {
                _builder_1.append("//signal to exit the doActivity of ");
                String _name_1 = parent.getName();
                _builder_1.append(_name_1);
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("setFlag");
                _builder_1.append("(");
                String _upperCase_1 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_1);
                _builder_1.append("_ID, ");
                _builder_1.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY");
                _builder_1.append(", false);");
                _builder_1.newLineIfNotEmpty();
            }
            CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(parent, "false");
            _builder_1.append((Object)_generateActivateTimeEvent);
            _builder_1.newLineIfNotEmpty();
            boolean _isBehaviorExist_1 = StateMachineUtils.isBehaviorExist((Behavior)parent.getExit());
            if (_isBehaviorExist_1) {
                _builder_1.append("//exit action of ");
                String _name_2 = parent.getName();
                _builder_1.append(_name_2);
                _builder_1.newLineIfNotEmpty();
                String _fptrCall = this.getFptrCall(pAttr, false, "exit");
                _builder_1.append(_fptrCall);
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("\t\t");
        }
        return _builder_1.toString();
    }

    public CharSequence generateActivateTimeEvent(State s, String trueOrFalse) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        List<TimeEvent> _get = this.states2TimeEvents.get(s);
        boolean bl = _tripleNotEquals = _get != null;
        if (_tripleNotEquals) {
            List<TimeEvent> _get_1 = this.states2TimeEvents.get(s);
            for (TimeEvent te : _get_1) {
                _builder.append("setFlag");
                _builder.append("(");
                String _TE_INDEX = this.cdefs.TE_INDEX();
                _builder.append(_TE_INDEX);
                _builder.append("(");
                String _eventID = StateMachineUtils.eventID((Event)te);
                _builder.append(_eventID);
                _builder.append("), ");
                _builder.append("statemachine::ThreadFunctions::TF_TIME_EVENT");
                _builder.append(", ");
                _builder.append(trueOrFalse);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    @Deprecated
    public String generateExitingSubStatesWithTransition(State parent, boolean exitParent, Transition t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return !(it instanceof FinalState) && it.isComposite();
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function);
                boolean _hasElements = false;
                for (State s : _filter) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "");
                    }
                    _builder_1.append("if (");
                    _builder_1.append("states");
                    _builder_1.append("[");
                    String _upperCase_1 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_1);
                    _builder_1.append("_ID].");
                    _builder_1.append("actives");
                    _builder_1.append("[");
                    int _indexOf = parent.getRegions().indexOf((Object)r);
                    _builder_1.append((Object)_indexOf);
                    _builder_1.append("] == &");
                    _builder_1.append("states");
                    _builder_1.append("[");
                    String _upperCase_2 = s.getName().toUpperCase();
                    _builder_1.append(_upperCase_2);
                    _builder_1.append("_ID]) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    String _generateExitingSubStates = this.generateExitingSubStates(s, true);
                    _builder_1.append(_generateExitingSubStates, "\t");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("if (");
                _builder_1.append("states");
                _builder_1.append("[");
                String _upperCase_3 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_3);
                _builder_1.append("_ID].");
                _builder_1.append("actives");
                _builder_1.append("[");
                int _indexOf_1 = parent.getRegions().indexOf((Object)r);
                _builder_1.append((Object)_indexOf_1);
                _builder_1.append("] != NULL) {");
                _builder_1.newLineIfNotEmpty();
                Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return !(it instanceof FinalState);
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function_1);
                boolean _hasElements_1 = false;
                for (State sub : _filter_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "\t");
                    }
                    _builder_1.append("\t");
                    _builder_1.append("if (");
                    _builder_1.append("states", "\t");
                    _builder_1.append("[");
                    String _upperCase_4 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_4, "\t");
                    _builder_1.append("_ID].");
                    _builder_1.append("actives", "\t");
                    _builder_1.append("[");
                    int _indexOf_2 = parent.getRegions().indexOf((Object)r);
                    _builder_1.append((Object)_indexOf_2, "\t");
                    _builder_1.append("] == &");
                    _builder_1.append("states", "\t");
                    _builder_1.append("[");
                    String _upperCase_5 = sub.getName().toUpperCase();
                    _builder_1.append(_upperCase_5, "\t");
                    _builder_1.append("_ID]) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("\t");
                    _builder_1.append("setFlag", "\t\t");
                    _builder_1.append("(");
                    String _upperCase_6 = sub.getName().toUpperCase();
                    _builder_1.append(_upperCase_6, "\t\t");
                    _builder_1.append("_ID, ");
                    _builder_1.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY", "\t\t");
                    _builder_1.append(", false);");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("\t");
                String _upperCase_7 = parent.getName().toUpperCase();
                String _plus = "states[" + _upperCase_7;
                String _plus_1 = String.valueOf(_plus) + "_ID].";
                String _plus_2 = String.valueOf(_plus_1) + "actives";
                String _plus_3 = String.valueOf(_plus_2) + "[";
                int _indexOf_3 = parent.getRegions().indexOf((Object)r);
                String _plus_4 = String.valueOf(_plus_3) + Integer.valueOf(_indexOf_3);
                String _plus_5 = String.valueOf(_plus_4) + "]";
                String _fptrCall = this.getFptrCall(_plus_5, true, "exit");
                _builder_1.append(_fptrCall, "\t");
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("}");
                _builder_1.newLine();
                _builder_1.append("states");
                _builder_1.append("[");
                String _upperCase_8 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_8);
                _builder_1.append("_ID].");
                _builder_1.append("actives");
                _builder_1.append("[");
                int _indexOf_4 = parent.getRegions().indexOf((Object)r);
                _builder_1.append((Object)_indexOf_4);
                _builder_1.append("] = NULL;");
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return !(it instanceof FinalState) && it.isComposite();
                    }
                };
                Iterable _filter_2 = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)parent.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function_2);
                boolean _hasElements_2 = false;
                for (State s_1 : _filter_2) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "");
                    }
                    _builder_1.append("if (");
                    _builder_1.append("states");
                    _builder_1.append("[");
                    String _upperCase_9 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_9);
                    _builder_1.append("_ID].");
                    _builder_1.append("actives");
                    _builder_1.append("[0] == &");
                    _builder_1.append("states");
                    _builder_1.append("[");
                    String _upperCase_10 = s_1.getName().toUpperCase();
                    _builder_1.append(_upperCase_10);
                    _builder_1.append("_ID]) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    String _generateExitingSubStates_1 = this.generateExitingSubStates(s_1, true);
                    _builder_1.append(_generateExitingSubStates_1, "\t");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("if (");
                _builder_1.append("states");
                _builder_1.append("[");
                String _upperCase_11 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_11);
                _builder_1.append("_ID].");
                _builder_1.append("actives");
                _builder_1.append("[0] != NULL) {");
                _builder_1.newLineIfNotEmpty();
                Functions.Function1<State, Boolean> _function_3 = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return !(it instanceof FinalState);
                    }
                };
                Iterable _filter_3 = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)parent.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function_3);
                boolean _hasElements_3 = false;
                for (State sub_1 : _filter_3) {
                    if (!_hasElements_3) {
                        _hasElements_3 = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "\t");
                    }
                    _builder_1.append("\t");
                    _builder_1.append("if (");
                    _builder_1.append("states", "\t");
                    _builder_1.append("[");
                    String _upperCase_12 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_12, "\t");
                    _builder_1.append("_ID].");
                    _builder_1.append("actives", "\t");
                    _builder_1.append("[0] == &");
                    _builder_1.append("states", "\t");
                    _builder_1.append("[");
                    String _upperCase_13 = sub_1.getName().toUpperCase();
                    _builder_1.append(_upperCase_13, "\t");
                    _builder_1.append("_ID]) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("\t");
                    _builder_1.append("setFlag", "\t\t");
                    _builder_1.append("(");
                    String _upperCase_14 = sub_1.getName().toUpperCase();
                    _builder_1.append(_upperCase_14, "\t\t");
                    _builder_1.append("_ID, ");
                    _builder_1.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY", "\t\t");
                    _builder_1.append(", false);");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("\t");
                String _upperCase_15 = parent.getName().toUpperCase();
                String _plus_6 = "states[" + _upperCase_15;
                String _plus_7 = String.valueOf(_plus_6) + "_ID].";
                String _plus_8 = String.valueOf(_plus_7) + "actives";
                String _plus_9 = String.valueOf(_plus_8) + "[0]";
                String _fptrCall_1 = this.getFptrCall(_plus_9, true, "exit");
                _builder_1.append(_fptrCall_1, "\t");
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("}");
                _builder_1.newLine();
                _builder_1.append("states");
                _builder_1.append("[");
                String _upperCase_16 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_16);
                _builder_1.append("_ID].");
                _builder_1.append("actives");
                _builder_1.append("[0] = NULL;");
                _builder_1.newLineIfNotEmpty();
            }
        }
        if (exitParent) {
            _builder_1.append("setFlag");
            _builder_1.append("(");
            String _upperCase_17 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_17);
            _builder_1.append("_ID, ");
            _builder_1.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY");
            _builder_1.append(", false);");
            _builder_1.newLineIfNotEmpty();
            String _fptrCall_2 = this.getFptrCall(pAttr, false, "exit");
            _builder_1.append(_fptrCall_2);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
        }
        String _transitionEffect = StateMachineUtils.getTransitionEffect((Transition)t);
        _builder_1.append(_transitionEffect);
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringSubStates(State parent, boolean enterParent) {
        boolean _isOrthogonal;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        if (enterParent) {
            String _generateChangeState = this.generateChangeState(parent);
            _builder_1.append(_generateChangeState);
            _builder_1.newLineIfNotEmpty();
            String _fptrCall = this.getFptrCall(pAttr, false, "entry");
            _builder_1.append(_fptrCall);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("//start activity of ");
            String _name = parent.getName();
            _builder_1.append(_name);
            _builder_1.append(" by calling setFlag");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("setFlag");
            _builder_1.append("(");
            String _upperCase_1 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_1);
            _builder_1.append("_ID, ");
            _builder_1.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY");
            _builder_1.append(", true);");
            _builder_1.newLineIfNotEmpty();
        }
        if (_isOrthogonal = parent.isOrthogonal()) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _tripleNotEquals;
                State _findInitialState = StateMachineUtils.findInitialState((Region)r);
                boolean bl = _tripleNotEquals = _findInitialState != null;
                if (!_tripleNotEquals) continue;
                String _initialEffect = StateMachineUtils.getInitialEffect((Region)r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates = this.generateEnteringSubStates(StateMachineUtils.findInitialState((Region)r), true);
                _builder_1.append(_generateEnteringSubStates);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                boolean _tripleNotEquals_1;
                State _findInitialState_1 = StateMachineUtils.findInitialState((Region)((Region)IterableExtensions.head((Iterable)parent.getRegions())));
                boolean bl = _tripleNotEquals_1 = _findInitialState_1 != null;
                if (_tripleNotEquals_1) {
                    String _initialEffect_1 = StateMachineUtils.getInitialEffect((Region)((Region)IterableExtensions.head((Iterable)parent.getRegions())));
                    _builder_1.append(_initialEffect_1);
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSubStates_1 = this.generateEnteringSubStates(StateMachineUtils.findInitialState((Region)((Region)IterableExtensions.head((Iterable)parent.getRegions()))), true);
                    _builder_1.append(_generateEnteringSubStates_1);
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringSubStates(State parent, State child, boolean enterParent, boolean gotoSubstate) {
        boolean _isOrthogonal;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        if (enterParent) {
            String _generateChangeState = this.generateChangeState(parent);
            _builder_1.append(_generateChangeState);
            _builder_1.newLineIfNotEmpty();
            String _fptrCall = this.getFptrCall(pAttr, false, "entry");
            _builder_1.append(_fptrCall);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("//start activity of ");
            String _name = parent.getName();
            _builder_1.append(_name);
            _builder_1.append(" by calling setFlag");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("setFlag");
            _builder_1.append("(");
            String _upperCase_1 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_1);
            _builder_1.append("_ID, ");
            _builder_1.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY");
            _builder_1.append(", true);");
            _builder_1.newLineIfNotEmpty();
        }
        if (_isOrthogonal = parent.isOrthogonal()) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _tripleNotEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    if (!gotoSubstate) continue;
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = StateMachineUtils.findInitialState((Region)r);
                boolean bl = _tripleNotEquals = _findInitialState != null;
                if (!_tripleNotEquals) continue;
                String _initialEffect = StateMachineUtils.getInitialEffect((Region)r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates_1 = this.generateEnteringSubStates(StateMachineUtils.findInitialState((Region)r), true);
                _builder_1.append(_generateEnteringSubStates_1);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                _builder_1.append("//");
                _builder_1.append("states");
                _builder_1.append("[");
                String _upperCase_2 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_2);
                _builder_1.append("_ID].");
                _builder_1.append("actives");
                _builder_1.append("[0] = &");
                _builder_1.append("states");
                _builder_1.append("[");
                String _upperCase_3 = child.getName().toUpperCase();
                _builder_1.append(_upperCase_3);
                _builder_1.append("_ID];");
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates_2 = this.generateEnteringSubStates(child, true);
                _builder_1.append(_generateEnteringSubStates_2);
                _builder_1.newLineIfNotEmpty();
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringTransitiveSubStates(State parent, final State child) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, false, "entry");
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("//start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("setFlag");
        _builder_1.append("(");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID, ");
        _builder_1.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY");
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _tripleNotEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                boolean _contains = StateMachineUtils.transitiveSubStates((Region)r).contains(child);
                if (_contains) {
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return StateMachineUtils.transitiveSubStates((State)it).contains(child);
                        }
                    };
                    State nextParent = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function));
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringTransitiveSubStates = this.generateEnteringTransitiveSubStates(nextParent, child);
                    _builder_1.append(_generateEnteringTransitiveSubStates);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = StateMachineUtils.findInitialState((Region)r);
                boolean bl = _tripleNotEquals = _findInitialState != null;
                if (!_tripleNotEquals) continue;
                String _initialEffect = StateMachineUtils.getInitialEffect((Region)r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates_1 = this.generateEnteringSubStates(StateMachineUtils.findInitialState((Region)r), true);
                _builder_1.append(_generateEnteringSubStates_1);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                State _state = child.getContainer().getState();
                boolean _equals_1 = Objects.equal((Object)_state, (Object)parent);
                if (_equals_1) {
                    String _generateEnteringSubStates_2 = this.generateEnteringSubStates(parent, child, false, false);
                    _builder_1.append(_generateEnteringSubStates_2);
                    _builder_1.newLineIfNotEmpty();
                } else {
                    Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return StateMachineUtils.transitiveSubStates((State)it).contains(child);
                        }
                    };
                    State nextParent_1 = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)parent.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function_1));
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringTransitiveSubStates_1 = this.generateEnteringTransitiveSubStates(nextParent_1, child);
                    _builder_1.append(_generateEnteringTransitiveSubStates_1);
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringTransitiveSubStates(State parent, final State child, boolean enterParent, boolean gotoChild) {
        boolean _isOrthogonal;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        if (enterParent) {
            String _generateChangeState = this.generateChangeState(parent);
            _builder_1.append(_generateChangeState);
            _builder_1.newLineIfNotEmpty();
            String _fptrCall = this.getFptrCall(pAttr, false, "entry");
            _builder_1.append(_fptrCall);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("//start activity of ");
            String _name = parent.getName();
            _builder_1.append(_name);
            _builder_1.append(" by calling setFlag");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("setFlag");
            _builder_1.append("(");
            String _upperCase_1 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_1);
            _builder_1.append("_ID, ");
            _builder_1.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY");
            _builder_1.append(", true);");
            _builder_1.newLineIfNotEmpty();
        }
        if (_isOrthogonal = parent.isOrthogonal()) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _tripleNotEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    if (!gotoChild) continue;
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                boolean _contains = StateMachineUtils.transitiveSubStates((Region)r).contains(child);
                if (_contains) {
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return StateMachineUtils.transitiveSubStates((State)it).contains(child);
                        }
                    };
                    State nextParent = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function));
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringTransitiveSubStates = this.generateEnteringTransitiveSubStates(nextParent, child);
                    _builder_1.append(_generateEnteringTransitiveSubStates);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = StateMachineUtils.findInitialState((Region)r);
                boolean bl = _tripleNotEquals = _findInitialState != null;
                if (!_tripleNotEquals) continue;
                String _initialEffect = StateMachineUtils.getInitialEffect((Region)r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates_1 = this.generateEnteringSubStates(StateMachineUtils.findInitialState((Region)r), true);
                _builder_1.append(_generateEnteringSubStates_1);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                State _state = child.getContainer().getState();
                boolean _equals_1 = Objects.equal((Object)_state, (Object)parent);
                if (_equals_1) {
                    if (gotoChild) {
                        String _generateEnteringSubStates_2 = this.generateEnteringSubStates(parent, child, enterParent, false);
                        _builder_1.append(_generateEnteringSubStates_2);
                        _builder_1.newLineIfNotEmpty();
                    }
                } else {
                    Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return StateMachineUtils.transitiveSubStates((State)it).contains(child);
                        }
                    };
                    State nextParent_1 = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)parent.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function_1));
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringTransitiveSubStates_1 = this.generateEnteringTransitiveSubStates(nextParent_1, child);
                    _builder_1.append(_generateEnteringTransitiveSubStates_1);
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringSpecial(State parent, final Pseudostate child) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, false, "entry");
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("//start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("setFlag");
        _builder_1.append("(");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID, ");
        _builder_1.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY");
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _tripleNotEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    String _generatePseudo = this.pseudostateGenerator.generatePseudo(child);
                    _builder_1.append(_generatePseudo);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                boolean _contains = StateMachineUtils.transitiveSubStates((Region)r).contains(child);
                if (_contains) {
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return StateMachineUtils.transitiveSubStates((State)it).contains(child);
                        }
                    };
                    State nextParent = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function));
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("states");
                    _builder_1.append("[");
                    String _upperCase_2 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_2);
                    _builder_1.append("_ID].");
                    _builder_1.append("actives");
                    _builder_1.append("[");
                    int _indexOf = parent.getRegions().indexOf((Object)r);
                    _builder_1.append((Object)_indexOf);
                    _builder_1.append("] = ");
                    String _upperCase_3 = nextParent.getName().toUpperCase();
                    _builder_1.append(_upperCase_3);
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSpecial = this.generateEnteringSpecial(nextParent, child);
                    _builder_1.append(_generateEnteringSpecial);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = StateMachineUtils.findInitialState((Region)r);
                boolean bl = _tripleNotEquals = _findInitialState != null;
                if (!_tripleNotEquals) continue;
                String _initialEffect = StateMachineUtils.getInitialEffect((Region)r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("states");
                _builder_1.append("[");
                String _upperCase_4 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_4);
                _builder_1.append("_ID].");
                _builder_1.append("actives");
                _builder_1.append("[");
                int _indexOf_1 = parent.getRegions().indexOf((Object)r);
                _builder_1.append((Object)_indexOf_1);
                _builder_1.append("] = ");
                String _upperCase_5 = StateMachineUtils.findInitialState((Region)r).getName().toUpperCase();
                _builder_1.append(_upperCase_5);
                _builder_1.append("_ID;");
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates = this.generateEnteringSubStates(StateMachineUtils.findInitialState((Region)r), true);
                _builder_1.append(_generateEnteringSubStates);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                State _state = child.getContainer().getState();
                boolean _equals_1 = Objects.equal((Object)_state, (Object)parent);
                if (_equals_1) {
                    String _generatePseudo_1 = this.pseudostateGenerator.generatePseudo(child);
                    _builder_1.append(_generatePseudo_1);
                    _builder_1.newLineIfNotEmpty();
                } else {
                    Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return StateMachineUtils.transitiveSubStates((State)it).contains(child);
                        }
                    };
                    State nextParent_1 = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)parent.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function_1));
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("states");
                    _builder_1.append("[");
                    String _upperCase_6 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_6);
                    _builder_1.append("_ID].");
                    _builder_1.append("actives");
                    _builder_1.append("[0] = ");
                    String _upperCase_7 = nextParent_1.getName().toUpperCase();
                    _builder_1.append(_upperCase_7);
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSpecial_1 = this.generateEnteringSpecial(nextParent_1, child);
                    _builder_1.append(_generateEnteringSpecial_1);
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringSpecial(State parent, final Pseudostate child, Transition t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        String _transitionEffect = StateMachineUtils.getTransitionEffect((Transition)t);
        _builder_1.append(_transitionEffect);
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, false, "entry");
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("//start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("setFlag");
        _builder_1.append("(");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID, ");
        _builder_1.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY");
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
        _builder_1.newLine();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _tripleNotEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    String _generatePseudo = this.pseudostateGenerator.generatePseudo(child);
                    _builder_1.append(_generatePseudo);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                boolean _contains = StateMachineUtils.transitiveSubStates((Region)r).contains(child);
                if (_contains) {
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return StateMachineUtils.transitiveSubStates((State)it).contains(child);
                        }
                    };
                    State nextParent = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function));
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("states");
                    _builder_1.append("[");
                    String _upperCase_2 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_2);
                    _builder_1.append("_ID].");
                    _builder_1.append("actives");
                    _builder_1.append("[");
                    int _indexOf = parent.getRegions().indexOf((Object)r);
                    _builder_1.append((Object)_indexOf);
                    _builder_1.append("] = ");
                    String _upperCase_3 = nextParent.getName().toUpperCase();
                    _builder_1.append(_upperCase_3);
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSpecial = this.generateEnteringSpecial(nextParent, child);
                    _builder_1.append(_generateEnteringSpecial);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = StateMachineUtils.findInitialState((Region)r);
                boolean bl = _tripleNotEquals = _findInitialState != null;
                if (!_tripleNotEquals) continue;
                String _initialEffect = StateMachineUtils.getInitialEffect((Region)r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("states");
                _builder_1.append("[");
                String _upperCase_4 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_4);
                _builder_1.append("_ID].");
                _builder_1.append("actives");
                _builder_1.append("[");
                int _indexOf_1 = parent.getRegions().indexOf((Object)r);
                _builder_1.append((Object)_indexOf_1);
                _builder_1.append("] = ");
                String _upperCase_5 = StateMachineUtils.findInitialState((Region)r).getName().toUpperCase();
                _builder_1.append(_upperCase_5);
                _builder_1.append("_ID;");
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates = this.generateEnteringSubStates(StateMachineUtils.findInitialState((Region)r), true);
                _builder_1.append(_generateEnteringSubStates);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                State _state = child.getContainer().getState();
                boolean _equals_1 = Objects.equal((Object)_state, (Object)parent);
                if (_equals_1) {
                    String _generatePseudo_1 = this.pseudostateGenerator.generatePseudo(child);
                    _builder_1.append(_generatePseudo_1);
                    _builder_1.newLineIfNotEmpty();
                } else {
                    Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return StateMachineUtils.transitiveSubStates((State)it).contains(child);
                        }
                    };
                    State nextParent_1 = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)parent.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function_1));
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("states");
                    _builder_1.append("[");
                    String _upperCase_6 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_6);
                    _builder_1.append("_ID].");
                    _builder_1.append("actives");
                    _builder_1.append("[0] = ");
                    String _upperCase_7 = nextParent_1.getName().toUpperCase();
                    _builder_1.append(_upperCase_7);
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSpecial_1 = this.generateEnteringSpecial(nextParent_1, child);
                    _builder_1.append(_generateEnteringSpecial_1);
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    public String generateCompletionCall(State state) {
        StringConcatenation _builder = new StringConcatenation();
        String callCompletionEvent = _builder.toString();
        State composite = state.getContainer().getState();
        if (composite == null) {
            StringConcatenation _builder_1 = new StringConcatenation();
            callCompletionEvent = _builder_1.toString();
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("if (");
            EList _regions = composite.getRegions();
            boolean _hasElements = false;
            for (Region r : _regions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_2.appendImmediate((Object)" && ", "");
                }
                _builder_2.append("(");
                _builder_2.append("states");
                _builder_2.append("[");
                String _upperCase = composite.getName().toUpperCase();
                _builder_2.append(_upperCase);
                _builder_2.append("_ID].");
                _builder_2.append("actives");
                _builder_2.append("[");
                int _indexOf = composite.getRegions().indexOf((Object)r);
                _builder_2.append((Object)_indexOf);
                _builder_2.append("] == ");
                _builder_2.append("STATE_MAX");
                _builder_2.append(")");
            }
            _builder_2.append(") {");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t");
            _builder_2.append("eventQueue", "\t");
            _builder_2.append(".push(statemachine::EventPriority_t::PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine::EventType_t::COMPLETION_EVENT, ");
            String _upperCase_1 = composite.getName().toUpperCase();
            _builder_2.append(_upperCase_1, "\t");
            _builder_2.append("_ID);");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("}");
            callCompletionEvent = _builder_2.toString();
        }
        return callCompletionEvent;
    }

    public TransitionGraph calculateTransitionGraphs(final State s, final Transition t) {
        TransitionGraph ret = new TransitionGraph();
        Vertex _target = t.getTarget();
        ret.P.add((Pseudostate)_target);
        ret.T.add(t);
        ret.S.add(s);
        Vertex _target_1 = t.getTarget();
        Pseudostate target = (Pseudostate)_target_1;
        PseudostateKind _kind = target.getKind();
        boolean _equals = Objects.equal((Object)_kind, (Object)PseudostateKind.JOIN_LITERAL);
        if (_equals) {
            Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition it) {
                    State _state = it.getSource().getContainer().getState();
                    State _state_1 = s.getContainer().getState();
                    return Objects.equal((Object)_state, (Object)_state_1);
                }
            };
            List ins = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)target.getIncomings(), (Functions.Function1)_function));
            Functions.Function1<Transition, Vertex> _function_1 = new Functions.Function1<Transition, Vertex>(){

                public Vertex apply(Transition it) {
                    return it.getSource();
                }
            };
            Iterables.addAll(ret.S, (Iterable)Iterables.filter((Iterable)ListExtensions.map((List)ins, (Functions.Function1)_function_1), State.class));
            ret.T.addAll(ins);
        }
        List nexts = SMCommon.findTrans((Vertex)t.getTarget());
        ret.T.addAll(nexts);
        Functions.Function1<Transition, Vertex> _function_2 = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return t.getTarget();
            }
        };
        Functions.Function1<Pseudostate, Boolean> _function_3 = new Functions.Function1<Pseudostate, Boolean>(){

            public Boolean apply(Pseudostate it) {
                return Objects.equal((Object)it.getKind(), (Object)PseudostateKind.DEEP_HISTORY_LITERAL) || Objects.equal((Object)it.getKind(), (Object)PseudostateKind.SHALLOW_HISTORY_LITERAL);
            }
        };
        Iterable H = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)nexts, (Functions.Function1)_function_2), Pseudostate.class), (Functions.Function1)_function_3);
        Iterables.addAll(ret.P, (Iterable)H);
        Functions.Function1<Transition, Vertex> _function_4 = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return it.getSource();
            }
        };
        Iterables.addAll(ret.P, (Iterable)Iterables.filter((Iterable)ListExtensions.map((List)nexts, (Functions.Function1)_function_4), Pseudostate.class));
        Functions.Function1<Transition, Vertex> _function_5 = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return it.getTarget();
            }
        };
        Iterables.addAll(ret.L, (Iterable)Iterables.filter((Iterable)ListExtensions.map((List)nexts, (Functions.Function1)_function_5), State.class));
        return ret;
    }

    public String generateDelegation(State s, List<Transition> transitions) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _checkTransitiveSubStatesAcceptEvent = this.checkTransitiveSubStatesAcceptEvent(s, transitions);
        if (_checkTransitiveSubStatesAcceptEvent) {
            boolean _isOrthogonal = s.isOrthogonal();
            if (!_isOrthogonal) {
                _builder.append("\t");
                _builder.newLine();
            }
            _builder.append("\t\t");
        }
        return _builder.toString();
    }

    public boolean checkSubStatesAcceptEvent(State parent, List<Transition> transitions) {
        final ArrayList substates = new ArrayList();
        Consumer<Region> _function = new Consumer<Region>(){

            @Override
            public void accept(Region it) {
                Iterables.addAll((Collection)substates, (Iterable)Iterables.filter((Iterable)it.getSubvertices(), State.class));
            }
        };
        parent.getRegions().forEach((Consumer)_function);
        boolean ret = false;
        for (Transition t : transitions) {
            if (ret || !substates.contains(t.getSource())) continue;
            ret = true;
        }
        return ret;
    }

    public boolean checkTransitiveSubStatesAcceptEvent(State parent, List<Transition> transitions) {
        List substates = StateMachineUtils.transitiveSubStates((State)parent);
        boolean ret = false;
        for (Transition t : transitions) {
            if (ret || !substates.contains(t.getSource())) continue;
            ret = true;
        }
        return ret;
    }

    public Dependency createStateStruct() {
        Dependency _xblockexpression = null;
        this.superContext.createOwnedOperation("entry_dft", null, null);
        this.superContext.createOwnedOperation("exit_dft", null, null);
        this.superContext.createOwnedOperation("doActivity_dft", null, null);
        this.stateStruct = this.superContext.createNestedClassifier("State_t", UMLPackage.Literals.PRIMITIVE_TYPE);
        StereotypeUtil.apply((Element)this.stateStruct, Typedef.class);
        Typedef _stereotypeApplication = (Typedef)UMLUtil.getStereotypeApplication((Element)this.stateStruct, Typedef.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("struct ");
        _builder.append("State_t");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("//");
        _builder.append((Object)this.MAX_NUMBER_ORTHOGONAL_REGIONS, "\t");
        _builder.append(" is configured as the maximum number of orthogonal regions a composite states can have");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("unsigned int /*");
        _builder.append("StateIDEnum", "\t");
        _builder.append("*/ ");
        _builder.append("previousStates", "\t");
        _builder.append("[");
        _builder.append((Object)this.MAX_NUMBER_ORTHOGONAL_REGIONS, "\t");
        _builder.append("]; //for history states");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("unsigned int /*");
        _builder.append("StateIDEnum", "\t");
        _builder.append("*/ ");
        _builder.append("actives", "\t");
        _builder.append("[");
        _builder.append((Object)this.MAX_NUMBER_ORTHOGONAL_REGIONS, "\t");
        _builder.append("];");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("void (");
        String _name = this.superContext.getName();
        _builder.append(_name, "\t");
        _builder.append("::*entry)();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("void (");
        String _name_1 = this.superContext.getName();
        _builder.append(_name_1, "\t");
        _builder.append("::*exit)();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("void (");
        String _name_2 = this.superContext.getName();
        _builder.append(_name_2, "\t");
        _builder.append("::*doActivity)();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("State_t", "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("entry = &");
        String _name_3 = this.superContext.getName();
        _builder.append(_name_3, "\t\t");
        _builder.append("::entry_dft;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("exit = &");
        String _name_4 = this.superContext.getName();
        _builder.append(_name_4, "\t\t");
        _builder.append("::exit_dft;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("doActivity = &");
        String _name_5 = this.superContext.getName();
        _builder.append(_name_5, "\t\t");
        _builder.append("::doActivity_dft;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("for(int i = 0; i < ");
        _builder.append((Object)this.MAX_NUMBER_ORTHOGONAL_REGIONS, "\t\t");
        _builder.append("; i++) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("previousStates", "\t\t\t");
        _builder.append("[i] = ");
        _builder.append("STATE_MAX", "\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("actives", "\t\t\t");
        _builder.append("[i] = ");
        _builder.append("STATE_MAX", "\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("} ");
        _stereotypeApplication.setDefinition(_builder.toString());
        _xblockexpression = this.stateStruct.createDependency((NamedElement)this.stateIdEnum);
        return _xblockexpression;
    }

    public String getFptrCall(String attr, boolean isPointer, String fptrName) {
        if (isPointer) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(this->*");
            _builder.append(attr);
            _builder.append("->");
            _builder.append(fptrName);
            _builder.append(")()");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(this->*");
        _builder_1.append(attr);
        _builder_1.append(".");
        _builder_1.append(fptrName);
        _builder_1.append(")()");
        return _builder_1.toString();
    }

    private Map<Event, List<Transition>> getAllEvents(Region region) {
        final LinkedHashMap<Event, List<Transition>> ret = new LinkedHashMap<Event, List<Transition>>();
        EList subVertices = region.getSubvertices();
        EList transitions = region.getTransitions();
        Consumer<Transition> _function = new Consumer<Transition>(){

            @Override
            public void accept(Transition it) {
                EList _triggers = it.getTriggers();
                for (Trigger trigger : _triggers) {
                    boolean _contains;
                    boolean _not_1;
                    boolean _not;
                    boolean _tripleNotEquals;
                    Event _event = trigger.getEvent();
                    boolean bl = _tripleNotEquals = _event != null;
                    if (!_tripleNotEquals) continue;
                    boolean _containsKey = ret.containsKey(trigger.getEvent());
                    boolean bl2 = _not = !_containsKey;
                    if (_not) {
                        Event _event_1 = trigger.getEvent();
                        ArrayList _arrayList = new ArrayList();
                        ret.put(_event_1, _arrayList);
                    }
                    boolean bl3 = _not_1 = !(_contains = ((List)ret.get(trigger.getEvent())).contains(it));
                    if (!_not_1) continue;
                    ((List)ret.get(trigger.getEvent())).add(it);
                }
            }
        };
        transitions.forEach((Consumer)_function);
        Consumer<State> _function_1 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                EList _regions = it.getRegions();
                for (Region subRe : _regions) {
                    Map<Event, List<Transition>> m = SM2ClassesTransformationCore.this.getAllEvents(subRe);
                    Set<Map.Entry<Event, List<Transition>>> _entrySet = m.entrySet();
                    for (Map.Entry<Event, List<Transition>> e : _entrySet) {
                        boolean _not;
                        boolean _containsKey = ret.containsKey(e.getKey());
                        boolean bl = _not = !_containsKey;
                        if (_not) {
                            ret.put(e.getKey(), e.getValue());
                            continue;
                        }
                        ((List)ret.get(e.getKey())).addAll((Collection)e.getValue());
                    }
                }
            }
        };
        Iterables.filter((Iterable)subVertices, State.class).forEach(_function_1);
        return ret;
    }

    private void getAllActionsTransitionsStates(Region region) {
        boolean _not;
        boolean _contains = this.regions.contains(region);
        boolean bl = _not = !_contains;
        if (_not) {
            this.regions.add(region);
        }
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                return it.getSource() != null && it.getTarget() != null;
            }
        };
        Iterables.addAll(this.transitions, (Iterable)IterableExtensions.filter((Iterable)region.getTransitions(), (Functions.Function1)_function));
        Functions.Function1<Transition, Boolean> _function_1 = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                boolean _contains = SM2ClassesTransformationCore.this.parallelTransitions.contains(it);
                return !_contains;
            }
        };
        Consumer<Transition> _function_2 = new Consumer<Transition>(){

            @Override
            public void accept(Transition it) {
                Vertex _target;
                Vertex _source = it.getSource();
                if (_source instanceof Pseudostate && Objects.equal((Object)((Pseudostate)it.getSource()).getKind(), (Object)PseudostateKind.FORK_LITERAL) && it.getEffect() != null) {
                    SM2ClassesTransformationCore.this.parallelTransitions.add(it);
                }
                if ((_target = it.getTarget()) instanceof Pseudostate && Objects.equal((Object)((Pseudostate)it.getTarget()).getKind(), (Object)PseudostateKind.JOIN_LITERAL) && it.getEffect() != null) {
                    SM2ClassesTransformationCore.this.parallelTransitions.add(it);
                }
            }
        };
        IterableExtensions.filter(this.transitions, (Functions.Function1)_function_1).forEach(_function_2);
        EList _subvertices = region.getSubvertices();
        for (Vertex s : _subvertices) {
            this.vertexes.add(s);
            if (!(s instanceof State)) continue;
            if (!(s instanceof FinalState)) {
                this.states.add((State)s);
            }
            if (((State)s).getEntry() != null && ((State)s).getEntry() instanceof OpaqueBehavior) {
                Behavior _entry = ((State)s).getEntry();
                this.actions.add((OpaqueBehavior)_entry);
            }
            if (((State)s).getExit() != null && ((State)s).getExit() instanceof OpaqueBehavior) {
                Behavior _exit = ((State)s).getExit();
                this.actions.add((OpaqueBehavior)_exit);
            }
            if (this.createDoActivity && ((State)s).getDoActivity() != null && ((State)s).getDoActivity() instanceof OpaqueBehavior) {
                Behavior _doActivity = ((State)s).getDoActivity();
                this.actions.add((OpaqueBehavior)_doActivity);
            }
            Consumer<Region> _function_3 = new Consumer<Region>(){

                @Override
                public void accept(Region it) {
                    SM2ClassesTransformationCore.this.getAllActionsTransitionsStates(it);
                }
            };
            ((State)s).getRegions().forEach((Consumer)_function_3);
        }
    }

    private void createRegionMethods() {
        boolean _not;
        String macros = "";
        int i = 0;
        while (i < this.regions.size()) {
            String _macros = macros;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("#define ");
            String _regionMacroName = this.getRegionMacroName(this.regions.get(i));
            _builder.append(_regionMacroName);
            _builder.append(" (");
            _builder.append((Object)i);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            macros = String.valueOf(_macros) + _builder;
            this.createRegionMethod(this.regions.get(i));
            this.createRegionMethodExit(this.regions.get(i));
            if (this.regions.get(i).getState() != null && this.regions.get(i).getState().isOrthogonal()) {
                this.orthogonalRegions.add(this.regions.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.orthogonalRegions.size()) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("#define ");
            String _regionMacroId = this.getRegionMacroId(this.orthogonalRegions.get(i));
            _builder.append(_regionMacroId);
            _builder.append(" (");
            _builder.append((Object)i);
            _builder.append(")");
            IncludeUtils.appendIncludeHeader(this.superContext, _builder.toString());
            ++i;
        }
        boolean _isApplied = StereotypeUtil.isApplied((Element)this.superContext, Include.class);
        boolean bl = _not = !_isApplied;
        if (_not) {
            StereotypeUtil.apply((Element)this.superContext, Include.class);
        }
        String header = ((Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class)).getHeader();
        Include _stereotypeApplication = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(header);
        _builder.newLineIfNotEmpty();
        _builder.append(macros);
        _stereotypeApplication.setHeader(_builder.toString());
    }

    public String getRegionMacroId(Region r) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("REGION_ID_");
        String _upperCase = r.getState().getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_");
        String _upperCase_1 = r.getName().toUpperCase();
        _builder.append(_upperCase_1);
        return _builder.toString();
    }

    public String getRegionMethodName(Region r) {
        boolean _equals = Objects.equal((Object)r, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = r.getStateMachine().getName();
            _builder.append(_name);
            _builder.append("_");
            String _name_1 = r.getName();
            _builder.append(_name_1);
            _builder.append("_Enter");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _name_2 = r.getState().getName();
        _builder_1.append(_name_2);
        _builder_1.append("_");
        String _name_3 = r.getName();
        _builder_1.append(_name_3);
        _builder_1.append("_Enter");
        return _builder_1.toString();
    }

    public String getRegionMacroName(Region r) {
        boolean _equals = Objects.equal((Object)r, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            String _upperCase = r.getStateMachine().getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_");
            String _upperCase_1 = r.getName().toUpperCase();
            _builder.append(_upperCase_1);
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _upperCase_2 = r.getState().getName().toUpperCase();
        _builder_1.append(_upperCase_2);
        _builder_1.append("_");
        String _upperCase_3 = r.getName().toUpperCase();
        _builder_1.append(_upperCase_3);
        return _builder_1.toString();
    }

    public String getVertexMacroName(Vertex v) {
        Region _container = v.getContainer();
        boolean _equals = Objects.equal((Object)_container, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            String _upperCase = this.topRegion.getStateMachine().getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_");
            String _upperCase_1 = v.getContainer().getName().toUpperCase();
            _builder.append(_upperCase_1);
            _builder.append("_");
            String _upperCase_2 = v.getName().toUpperCase();
            _builder.append(_upperCase_2);
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _upperCase_3 = v.getContainer().getState().getName().toUpperCase();
        _builder_1.append(_upperCase_3);
        _builder_1.append("_");
        String _upperCase_4 = v.getContainer().getName().toUpperCase();
        _builder_1.append(_upperCase_4);
        _builder_1.append("_");
        String _upperCase_5 = v.getName().toUpperCase();
        _builder_1.append(_upperCase_5);
        return _builder_1.toString();
    }

    public String getInitialMacroName(Region r) {
        boolean _equals = Objects.equal((Object)r, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            String _upperCase = r.getStateMachine().getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_");
            String _upperCase_1 = r.getName().toUpperCase();
            _builder.append(_upperCase_1);
            _builder.append("_DEFAULT");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _upperCase_2 = r.getState().getName().toUpperCase();
        _builder_1.append(_upperCase_2);
        _builder_1.append("_");
        String _upperCase_3 = r.getName().toUpperCase();
        _builder_1.append(_upperCase_3);
        _builder_1.append("_DEFAULT");
        return _builder_1.toString();
    }

    private ArrayList<Vertex> getSubVertexes(State state) {
        final ArrayList<Vertex> ret = new ArrayList<Vertex>();
        Consumer<Region> _function = new Consumer<Region>(){

            @Override
            public void accept(Region it) {
                ret.addAll(it.getSubvertices());
            }
        };
        state.getRegions().forEach((Consumer)_function);
        return ret;
    }

    private void createRegionMethod(Region r) {
        boolean _tripleNotEquals;
        ArrayList<Vertex> endVertices = new ArrayList<Vertex>();
        EList _subvertices = r.getSubvertices();
        for (final Vertex v : _subvertices) {
            boolean _not;
            boolean _greaterThan;
            Functions.Function1<Transition, Vertex> _function_1;
            Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition it) {
                    return !Objects.equal((Object)it.getSource().getContainer(), (Object)v.getContainer()) || it.getSource() instanceof State && SM2ClassesTransformationCore.this.getSubVertexes((State)it.getSource()).contains(it.getTarget());
                }
            };
            Iterable incomings = IterableExtensions.filter((Iterable)v.getIncomings(), (Functions.Function1)_function);
            Iterable sources = IterableExtensions.map((Iterable)incomings, (Functions.Function1)(_function_1 = new Functions.Function1<Transition, Vertex>(){

                public Vertex apply(Transition it) {
                    return it.getSource();
                }
            }));
            int _size = IterableExtensions.size((Iterable)sources);
            boolean bl = _greaterThan = _size > 0;
            if (!_greaterThan) continue;
            boolean _contains = endVertices.contains(v);
            boolean bl2 = _not = !_contains;
            if (!_not) continue;
            endVertices.add(v);
        }
        String body = "";
        String macros = "";
        Pseudostate _firstPseudoState = StateMachineUtils.firstPseudoState((Region)r, (PseudostateKind)PseudostateKind.INITIAL_LITERAL);
        boolean bl = _tripleNotEquals = _firstPseudoState != null;
        if (_tripleNotEquals) {
            boolean _isComposite;
            Pseudostate initialP = StateMachineUtils.firstPseudoState((Region)r, (PseudostateKind)PseudostateKind.INITIAL_LITERAL);
            Vertex _target = ((Transition)IterableExtensions.head((Iterable)initialP.getOutgoings())).getTarget();
            State initialState = (State)_target;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("states");
            _builder.append("[");
            String _upperCase = initialState.getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_ID]");
            String pAttr = _builder.toString();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(macros);
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("#define ");
            String _initialMacroName = this.getInitialMacroName(r);
            _builder_1.append(_initialMacroName);
            _builder_1.append(" (0)");
            macros = _builder_1.toString();
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(body);
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("case ");
            String _initialMacroName_1 = this.getInitialMacroName(r);
            _builder_2.append(_initialMacroName_1);
            _builder_2.append(":");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t");
            String _transitionEffect = StateMachineUtils.getTransitionEffect((Transition)((Transition)IterableExtensions.head((Iterable)initialP.getOutgoings())));
            _builder_2.append(_transitionEffect, "\t");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t");
            String _generateChangeState = this.generateChangeState(initialState);
            _builder_2.append(_generateChangeState, "\t");
            _builder_2.newLineIfNotEmpty();
            _builder_2.newLine();
            boolean _isBehaviorExist = StateMachineUtils.isBehaviorExist((Behavior)initialState.getEntry());
            if (_isBehaviorExist) {
                _builder_2.append("\t");
                String _fptrCall = this.getFptrCall(pAttr, false, "entry");
                _builder_2.append(_fptrCall, "\t");
                _builder_2.append(";");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("\t");
                _builder_2.append("//starting the counters for time events");
                _builder_2.newLine();
            }
            _builder_2.append("\t");
            CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(initialState, "true");
            _builder_2.append((Object)_generateActivateTimeEvent, "\t");
            _builder_2.newLineIfNotEmpty();
            _builder_2.newLine();
            if (StateMachineUtils.isBehaviorExist((Behavior)initialState.getDoActivity()) || StateMachineUtils.hasTriggerlessTransition((State)initialState)) {
                _builder_2.append("\t");
                _builder_2.append("//start activity of ");
                String _name = initialState.getName();
                _builder_2.append(_name, "\t");
                _builder_2.append(" by calling setFlag");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("\t");
                _builder_2.append("setFlag", "\t");
                _builder_2.append("(");
                String _upperCase_1 = initialState.getName().toUpperCase();
                _builder_2.append(_upperCase_1, "\t");
                _builder_2.append("_ID, ");
                _builder_2.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY", "\t");
                _builder_2.append(", true);");
                _builder_2.newLineIfNotEmpty();
            }
            if (_isComposite = initialState.isComposite()) {
                boolean _isOrthogonal = initialState.isOrthogonal();
                if (_isOrthogonal) {
                    _builder_2.append("\t");
                    _builder_2.append("//TODO: fork region funtions");
                    _builder_2.newLine();
                    EList _regions = initialState.getRegions();
                    for (Region subRegion : _regions) {
                        _builder_2.append("\t");
                        _builder_2.append("//");
                        String _regionMethodName = this.getRegionMethodName(subRegion);
                        _builder_2.append(_regionMethodName, "\t");
                        _builder_2.append("(");
                        String _initialMacroName_2 = this.getInitialMacroName(subRegion);
                        _builder_2.append(_initialMacroName_2, "\t");
                        _builder_2.append(");");
                        _builder_2.newLineIfNotEmpty();
                        _builder_2.append("\t");
                        String _generateForkCall = this.concurrency.generateForkCall(subRegion, true, this.getInitialMacroName(subRegion));
                        _builder_2.append(_generateForkCall, "\t");
                        _builder_2.newLineIfNotEmpty();
                    }
                    _builder_2.append("\t");
                    _builder_2.append("//TODO: join region functions");
                    _builder_2.newLine();
                    EList _regions_1 = initialState.getRegions();
                    for (Region subRegion_1 : _regions_1) {
                        _builder_2.append("\t");
                        _builder_2.append("//");
                        String _regionMethodName_1 = this.getRegionMethodName(subRegion_1);
                        _builder_2.append(_regionMethodName_1, "\t");
                        _builder_2.append("(");
                        String _initialMacroName_3 = this.getInitialMacroName(subRegion_1);
                        _builder_2.append(_initialMacroName_3, "\t");
                        _builder_2.append(");");
                        _builder_2.newLineIfNotEmpty();
                        _builder_2.append("\t");
                        String _generateJoinCall = this.concurrency.generateJoinCall(subRegion_1, true);
                        _builder_2.append(_generateJoinCall, "\t");
                        _builder_2.newLineIfNotEmpty();
                    }
                } else {
                    _builder_2.append("\t");
                    String _regionMethodName_2 = this.getRegionMethodName((Region)IterableExtensions.head((Iterable)initialState.getRegions()));
                    _builder_2.append(_regionMethodName_2, "\t");
                    _builder_2.append("(");
                    String _initialMacroName_4 = this.getInitialMacroName((Region)IterableExtensions.head((Iterable)initialState.getRegions()));
                    _builder_2.append(_initialMacroName_4, "\t");
                    _builder_2.append(");");
                    _builder_2.newLineIfNotEmpty();
                }
            }
            _builder_2.append("\t");
            _builder_2.append("//TODO: set systemState to EVENT_CONSUMED");
            _builder_2.newLine();
            _builder_2.append("\t");
            _builder_2.append("break;");
            _builder_2.newLine();
            body = _builder_2.toString();
        }
        int i = 0;
        while (i < endVertices.size()) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append(macros);
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("#define ");
            String _vertexMacroName = this.getVertexMacroName((Vertex)endVertices.get(i));
            _builder_3.append(_vertexMacroName);
            _builder_3.append(" (");
            _builder_3.append((Object)(i + 1));
            _builder_3.append(")");
            macros = _builder_3.toString();
            ++i;
        }
        IncludeUtils.appendIncludeHeader(this.superContext, macros);
        Operation regionMethod = this.superContext.createOwnedOperation(this.getRegionMethodName(r), null, null);
        regionMethod.createOwnedParameter("enter_mode", this.charType);
        String _body = body;
        StringConcatenation _builder_3 = new StringConcatenation();
        for (Vertex v_1 : endVertices) {
            if (v_1 instanceof State) {
                boolean _isComposite_1;
                _builder_3.append("case ");
                String _vertexMacroName = this.getVertexMacroName(v_1);
                _builder_3.append(_vertexMacroName);
                _builder_3.append(":");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("\t");
                String _generateChangeState_1 = this.generateChangeState((State)v_1);
                _builder_3.append(_generateChangeState_1, "\t");
                _builder_3.newLineIfNotEmpty();
                boolean _isBehaviorExist_1 = StateMachineUtils.isBehaviorExist((Behavior)((State)v_1).getEntry());
                if (_isBehaviorExist_1) {
                    _builder_3.append("\t");
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("states");
                    _builder_4.append("[");
                    String _upperCase_2 = ((State)v_1).getName().toUpperCase();
                    _builder_4.append(_upperCase_2);
                    _builder_4.append("_ID]");
                    String _fptrCall_1 = this.getFptrCall(_builder_4.toString(), false, "entry");
                    _builder_3.append(_fptrCall_1, "\t");
                    _builder_3.append(";");
                    _builder_3.newLineIfNotEmpty();
                }
                _builder_3.append("\t");
                _builder_3.append("//starting the counters for time events");
                _builder_3.newLine();
                _builder_3.append("\t");
                CharSequence _generateActivateTimeEvent_1 = this.generateActivateTimeEvent((State)v_1, "true");
                _builder_3.append((Object)_generateActivateTimeEvent_1, "\t");
                _builder_3.newLineIfNotEmpty();
                if (StateMachineUtils.isBehaviorExist((Behavior)((State)v_1).getDoActivity()) || StateMachineUtils.hasTriggerlessTransition((State)((State)v_1))) {
                    _builder_3.append("\t");
                    _builder_3.append("//start activity of ");
                    String _name_1 = ((State)v_1).getName();
                    _builder_3.append(_name_1, "\t");
                    _builder_3.append(" by calling setFlag");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("\t");
                    _builder_3.append("setFlag", "\t");
                    _builder_3.append("(");
                    String _upperCase_3 = ((State)v_1).getName().toUpperCase();
                    _builder_3.append(_upperCase_3, "\t");
                    _builder_3.append("_ID, ");
                    _builder_3.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY", "\t");
                    _builder_3.append(", true);");
                    _builder_3.newLineIfNotEmpty();
                }
                if (_isComposite_1 = ((State)v_1).isComposite()) {
                    boolean _isOrthogonal_1 = ((State)v_1).isOrthogonal();
                    if (_isOrthogonal_1) {
                        _builder_3.append("\t");
                        _builder_3.append("//TODO: fork region funtions");
                        _builder_3.newLine();
                        EList _regions_2 = ((State)v_1).getRegions();
                        for (Region subRegion_2 : _regions_2) {
                            _builder_3.append("\t");
                            _builder_3.append("//");
                            String _regionMethodName_3 = this.getRegionMethodName(subRegion_2);
                            _builder_3.append(_regionMethodName_3, "\t");
                            _builder_3.append("(");
                            String _initialMacroName_5 = this.getInitialMacroName(subRegion_2);
                            _builder_3.append(_initialMacroName_5, "\t");
                            _builder_3.append(");");
                            _builder_3.newLineIfNotEmpty();
                            _builder_3.append("\t");
                            String _generateForkCall_1 = this.concurrency.generateForkCall(subRegion_2, true, this.getInitialMacroName(subRegion_2));
                            _builder_3.append(_generateForkCall_1, "\t");
                            _builder_3.newLineIfNotEmpty();
                        }
                        _builder_3.append("\t");
                        _builder_3.append("//TODO: join region functions");
                        _builder_3.newLine();
                        EList _regions_3 = ((State)v_1).getRegions();
                        for (Region subRegion_3 : _regions_3) {
                            _builder_3.append("\t");
                            _builder_3.append("//");
                            String _regionMethodName_4 = this.getRegionMethodName(subRegion_3);
                            _builder_3.append(_regionMethodName_4, "\t");
                            _builder_3.append("(");
                            String _initialMacroName_6 = this.getInitialMacroName(subRegion_3);
                            _builder_3.append(_initialMacroName_6, "\t");
                            _builder_3.append(");");
                            _builder_3.newLineIfNotEmpty();
                            _builder_3.append("\t");
                            String _generateJoinCall_1 = this.concurrency.generateJoinCall(subRegion_3, true);
                            _builder_3.append(_generateJoinCall_1, "\t");
                            _builder_3.newLineIfNotEmpty();
                        }
                    } else {
                        _builder_3.append("\t");
                        String _regionMethodName_5 = this.getRegionMethodName((Region)IterableExtensions.head((Iterable)((State)v_1).getRegions()));
                        _builder_3.append(_regionMethodName_5, "\t");
                        _builder_3.append("(");
                        String _initialMacroName_7 = this.getInitialMacroName((Region)IterableExtensions.head((Iterable)((State)v_1).getRegions()));
                        _builder_3.append(_initialMacroName_7, "\t");
                        _builder_3.append(");");
                        _builder_3.newLineIfNotEmpty();
                    }
                }
            } else {
                _builder_3.append("case ");
                String _vertexMacroName_1 = this.getVertexMacroName(v_1);
                _builder_3.append(_vertexMacroName_1);
                _builder_3.append(": ");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("\t");
                String _generatePseudo = this.pseudostateGenerator.generatePseudo((Pseudostate)v_1);
                _builder_3.append(_generatePseudo, "\t");
                _builder_3.newLineIfNotEmpty();
            }
            _builder_3.append("\t");
            _builder_3.append("//TODO: set systemState to EVENT_CONSUMED");
            _builder_3.newLine();
            _builder_3.append("\t");
            _builder_3.append("break;");
            _builder_3.newLine();
        }
        body = String.valueOf(_body) + _builder_3;
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append("switch(");
        _builder_5.append("enter_mode");
        _builder_5.append(") {");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t");
        _builder_5.append(body, "\t");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("}");
        _builder_5.newLine();
        String switchBody = _builder_5.toString();
        this.createOpaqueBehavior(this.superContext, regionMethod, switchBody);
    }

    public CharSequence generateEnteringOnSubVertex(State parent, final Vertex subVertex) {
        StringConcatenation _builder = new StringConcatenation();
        String _generateChangeState = this.generateChangeState(parent);
        _builder.append(_generateChangeState);
        _builder.newLineIfNotEmpty();
        boolean _isBehaviorExist = StateMachineUtils.isBehaviorExist((Behavior)parent.getEntry());
        if (_isBehaviorExist) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("states");
            _builder_1.append("[");
            String _upperCase = parent.getName().toUpperCase();
            _builder_1.append(_upperCase);
            _builder_1.append("_ID]");
            String _fptrCall = this.getFptrCall(_builder_1.toString(), false, "entry");
            _builder.append(_fptrCall);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("//starting the counters for time events");
        _builder.newLine();
        CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(parent, "true");
        _builder.append((Object)_generateActivateTimeEvent);
        _builder.newLineIfNotEmpty();
        if (StateMachineUtils.isBehaviorExist((Behavior)parent.getDoActivity()) || StateMachineUtils.hasTriggerlessTransition((State)parent)) {
            _builder.append("//start activity of ");
            String _name = parent.getName();
            _builder.append(_name);
            _builder.append(" by calling setFlag");
            _builder.newLineIfNotEmpty();
            _builder.append("setFlag");
            _builder.append("(");
            String _upperCase_1 = parent.getName().toUpperCase();
            _builder.append(_upperCase_1);
            _builder.append("_ID, ");
            _builder.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY");
            _builder.append(", true);");
            _builder.newLineIfNotEmpty();
        }
        if (parent.isComposite() && !Objects.equal((Object)parent, (Object)subVertex)) {
            boolean _isOrthogonal = parent.isOrthogonal();
            if (_isOrthogonal) {
                ArrayList<Region> toJoinList = new ArrayList<Region>();
                _builder.newLineIfNotEmpty();
                EList _regions = parent.getRegions();
                for (Region r : _regions) {
                    boolean _tripleNotEquals_1;
                    if (subVertex != null) {
                        boolean _tripleNotEquals;
                        Region _container = subVertex.getContainer();
                        boolean _equals = Objects.equal((Object)_container, (Object)r);
                        if (_equals) {
                            boolean _add = toJoinList.add(r);
                            _builder.append((Object)_add);
                            _builder.newLineIfNotEmpty();
                            _builder.append("//");
                            String _regionMethodName = this.getRegionMethodName(r);
                            _builder.append(_regionMethodName);
                            _builder.append("(");
                            String _vertexMacroName = this.getVertexMacroName(subVertex);
                            _builder.append(_vertexMacroName);
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                            String _generateForkCall = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                            _builder.append(_generateForkCall);
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        boolean _contains = this.allSubVertexes(r).contains(subVertex);
                        if (_contains) {
                            boolean _add_1 = toJoinList.add(r);
                            _builder.append((Object)_add_1);
                            _builder.newLineIfNotEmpty();
                            _builder.append("//");
                            String _regionMethodName_1 = this.getRegionMethodName(r);
                            _builder.append(_regionMethodName_1);
                            _builder.append("(");
                            String _vertexMacroName_1 = this.getVertexMacroName(subVertex);
                            _builder.append(_vertexMacroName_1);
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                            String _generateForkCall_1 = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                            _builder.append(_generateForkCall_1);
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        State _findInitialState = StateMachineUtils.findInitialState((Region)r);
                        boolean bl = _tripleNotEquals = _findInitialState != null;
                        if (!_tripleNotEquals) continue;
                        boolean _add_2 = toJoinList.add(r);
                        _builder.append((Object)_add_2);
                        _builder.newLineIfNotEmpty();
                        _builder.append("//");
                        String _regionMethodName_2 = this.getRegionMethodName(r);
                        _builder.append(_regionMethodName_2);
                        _builder.append("(");
                        String _initialMacroName = this.getInitialMacroName(r);
                        _builder.append(_initialMacroName);
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        String _generateForkCall_2 = this.concurrency.generateForkCall(r, true, this.getInitialMacroName(r));
                        _builder.append(_generateForkCall_2);
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    if (subVertex != null && subVertex.getContainer() == null) {
                        EObject _eContainer = subVertex.eContainer();
                        boolean _equals_1 = Objects.equal((Object)_eContainer, (Object)parent);
                        if (_equals_1) {
                            boolean _add_3 = toJoinList.add(r);
                            _builder.append((Object)_add_3);
                            _builder.newLineIfNotEmpty();
                            String _generateForkCall_3 = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                            _builder.append(_generateForkCall_3);
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        boolean _add_4 = toJoinList.add(r);
                        _builder.append((Object)_add_4);
                        _builder.newLineIfNotEmpty();
                        String _generateForkCall_4 = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                        _builder.append(_generateForkCall_4);
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    State _findInitialState_1 = StateMachineUtils.findInitialState((Region)r);
                    boolean bl = _tripleNotEquals_1 = _findInitialState_1 != null;
                    if (!_tripleNotEquals_1) continue;
                    boolean _add_5 = toJoinList.add(r);
                    _builder.append((Object)_add_5);
                    _builder.newLineIfNotEmpty();
                    _builder.append("//");
                    String _regionMethodName_3 = this.getRegionMethodName(r);
                    _builder.append(_regionMethodName_3);
                    _builder.append("(");
                    String _initialMacroName_1 = this.getInitialMacroName(r);
                    _builder.append(_initialMacroName_1);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    String _generateForkCall_5 = this.concurrency.generateForkCall(r, true, this.getInitialMacroName(r));
                    _builder.append(_generateForkCall_5);
                    _builder.newLineIfNotEmpty();
                }
                for (Region r_1 : toJoinList) {
                    String _generateJoinCall = this.concurrency.generateJoinCall(r_1, true);
                    _builder.append(_generateJoinCall);
                    _builder.newLineIfNotEmpty();
                }
            } else {
                boolean _isComposite = parent.isComposite();
                if (_isComposite) {
                    if (subVertex != null) {
                        if (subVertex.getContainer() == null && subVertex.eContainer() instanceof State) {
                            String _regionMethodName_4 = this.getRegionMethodName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                            _builder.append(_regionMethodName_4);
                            _builder.append("(");
                            String _vertexMacroName_2 = this.getVertexMacroName(subVertex);
                            _builder.append(_vertexMacroName_2);
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                        } else {
                            State _state = subVertex.getContainer().getState();
                            boolean _equals_2 = Objects.equal((Object)_state, (Object)parent);
                            if (_equals_2) {
                                String _regionMethodName_5 = this.getRegionMethodName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                                _builder.append(_regionMethodName_5);
                                _builder.append("(");
                                String _vertexMacroName_3 = this.getVertexMacroName(subVertex);
                                _builder.append(_vertexMacroName_3);
                                _builder.append(");");
                                _builder.newLineIfNotEmpty();
                            } else {
                                Functions.Function1<Region, Boolean> _function = new Functions.Function1<Region, Boolean>(){

                                    public Boolean apply(Region it) {
                                        return SM2ClassesTransformationCore.this.allSubVertexes(it).contains(subVertex);
                                    }
                                };
                                Region containingRegion = (Region)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)parent.getRegions(), (Functions.Function1)_function));
                                _builder.newLineIfNotEmpty();
                                if (containingRegion != null) {
                                    String _regionMethodName_6 = this.getRegionMethodName(containingRegion);
                                    _builder.append(_regionMethodName_6);
                                    _builder.append("(");
                                    String _vertexMacroName_4 = this.getVertexMacroName(subVertex);
                                    _builder.append(_vertexMacroName_4);
                                    _builder.append(");");
                                    _builder.newLineIfNotEmpty();
                                }
                            }
                        }
                    } else {
                        String _regionMethodName_7 = this.getRegionMethodName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                        _builder.append(_regionMethodName_7);
                        _builder.append("(");
                        String _initialMacroName_2 = this.getInitialMacroName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                        _builder.append(_initialMacroName_2);
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
        } else if (parent.isComposite() && Objects.equal((Object)parent, (Object)subVertex)) {
            boolean _isOrthogonal_1 = parent.isOrthogonal();
            if (_isOrthogonal_1) {
                ArrayList<Region> toJoinList_1 = new ArrayList<Region>();
                _builder.newLineIfNotEmpty();
                EList _regions_1 = parent.getRegions();
                for (Region r_2 : _regions_1) {
                    boolean _tripleNotEquals_2;
                    State _findInitialState_2 = StateMachineUtils.findInitialState((Region)r_2);
                    boolean bl = _tripleNotEquals_2 = _findInitialState_2 != null;
                    if (!_tripleNotEquals_2) continue;
                    boolean _add_6 = toJoinList_1.add(r_2);
                    _builder.append((Object)_add_6);
                    _builder.newLineIfNotEmpty();
                    _builder.append("//");
                    String _regionMethodName_8 = this.getRegionMethodName(r_2);
                    _builder.append(_regionMethodName_8);
                    _builder.append("(");
                    String _initialMacroName_3 = this.getInitialMacroName(r_2);
                    _builder.append(_initialMacroName_3);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    String _generateForkCall_6 = this.concurrency.generateForkCall(r_2, true, this.getInitialMacroName(r_2));
                    _builder.append(_generateForkCall_6);
                    _builder.newLineIfNotEmpty();
                }
                for (Region r_3 : toJoinList_1) {
                    String _generateJoinCall_1 = this.concurrency.generateJoinCall(r_3, true);
                    _builder.append(_generateJoinCall_1);
                    _builder.newLineIfNotEmpty();
                }
            } else {
                boolean _tripleNotEquals_3;
                State _findInitialState_3 = StateMachineUtils.findInitialState((Region)((Region)IterableExtensions.head((Iterable)parent.getRegions())));
                boolean bl = _tripleNotEquals_3 = _findInitialState_3 != null;
                if (_tripleNotEquals_3) {
                    String _regionMethodName_9 = this.getRegionMethodName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                    _builder.append(_regionMethodName_9);
                    _builder.append("(");
                    String _initialMacroName_4 = this.getInitialMacroName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                    _builder.append(_initialMacroName_4);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    private void createRegionMethodExit(Region r) {
        if (r.getState() == null || !r.getState().isComposite()) {
            return;
        }
        State parent = r.getState();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//exiting region ");
        String _name = r.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        int regionIndex = r.getState().getRegions().indexOf((Object)r);
        _builder.newLineIfNotEmpty();
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return !(it instanceof FinalState) && it.isComposite();
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function);
        boolean _hasElements = false;
        for (State s : _filter) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" else ", "");
            }
            _builder.append("if (");
            _builder.append("states");
            _builder.append("[");
            String _upperCase = parent.getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_ID].");
            _builder.append("actives");
            _builder.append("[");
            _builder.append((Object)regionIndex);
            _builder.append("] == ");
            String _upperCase_1 = s.getName().toUpperCase();
            _builder.append(_upperCase_1);
            _builder.append("_ID) {");
            _builder.newLineIfNotEmpty();
            boolean _isOrthogonal = s.isOrthogonal();
            if (_isOrthogonal) {
                EList _regions = s.getRegions();
                for (Region subRegion : _regions) {
                    _builder.append("\t");
                    String _generateForkCall = this.concurrency.generateForkCall(subRegion, false, "0");
                    _builder.append(_generateForkCall, "\t");
                    _builder.newLineIfNotEmpty();
                }
                EList _regions_1 = s.getRegions();
                for (Region subRegion_1 : _regions_1) {
                    _builder.append("\t");
                    String _generateJoinCall = this.concurrency.generateJoinCall(subRegion_1, false);
                    _builder.append(_generateJoinCall, "\t");
                    _builder.newLineIfNotEmpty();
                }
            } else {
                _builder.append("\t");
                String _regionMethodExitName = this.getRegionMethodExitName((Region)IterableExtensions.head((Iterable)s.getRegions()));
                _builder.append(_regionMethodExitName, "\t");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("if (");
        _builder.append("states");
        _builder.append("[");
        String _upperCase_2 = parent.getName().toUpperCase();
        _builder.append(_upperCase_2);
        _builder.append("_ID].");
        _builder.append("actives");
        _builder.append("[");
        _builder.append((Object)regionIndex);
        _builder.append("] != ");
        _builder.append("STATE_MAX");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("//signal to exit the doActivity of sub-state of ");
        String _name_1 = parent.getName();
        _builder.append(_name_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("setFlag", "\t");
        _builder.append("(");
        _builder.append("states", "\t");
        _builder.append("[");
        String _upperCase_3 = parent.getName().toUpperCase();
        _builder.append(_upperCase_3, "\t");
        _builder.append("_ID].");
        _builder.append("actives", "\t");
        _builder.append("[0], ");
        _builder.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY", "\t");
        _builder.append(", false);");
        _builder.newLineIfNotEmpty();
        Iterable _filter_1 = Iterables.filter((Iterable)r.getSubvertices(), State.class);
        boolean _hasElements_1 = false;
        for (State sub : _filter_1) {
            boolean _tripleNotEquals;
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" else ", "\t");
            }
            List<TimeEvent> _get = this.states2TimeEvents.get(sub);
            boolean bl = _tripleNotEquals = _get != null;
            if (!_tripleNotEquals) continue;
            _builder.append("\t");
            _builder.append("if (");
            String _upperCase_4 = sub.getName().toUpperCase();
            _builder.append(_upperCase_4, "\t");
            _builder.append("_ID == ");
            _builder.append("states", "\t");
            _builder.append("[");
            String _upperCase_5 = parent.getName().toUpperCase();
            _builder.append(_upperCase_5, "\t");
            _builder.append("_ID].");
            _builder.append("actives", "\t");
            _builder.append("[");
            _builder.append((Object)regionIndex, "\t");
            _builder.append("]) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(sub, "false");
            _builder.append((Object)_generateActivateTimeEvent, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("//exit action of sub-state of ");
        String _name_2 = parent.getName();
        _builder.append(_name_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("(this->*");
        _builder.append("states", "\t");
        _builder.append("[");
        _builder.append("states", "\t");
        _builder.append("[");
        String _upperCase_6 = parent.getName().toUpperCase();
        _builder.append(_upperCase_6, "\t");
        _builder.append("_ID].");
        _builder.append("actives", "\t");
        _builder.append("[0]].");
        _builder.append("exit", "\t");
        _builder.append(")();");
        _builder.newLineIfNotEmpty();
        boolean _isSavehistory = StateMachineUtils.isSavehistory((Region)r);
        if (_isSavehistory) {
            _builder.append("\t");
            _builder.append("//save history region ");
            String _name_3 = r.getName();
            _builder.append(_name_3, "\t");
            _builder.append(" of state ");
            String _name_4 = parent.getName();
            _builder.append(_name_4, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("states", "\t");
            _builder.append("[");
            String _upperCase_7 = parent.getName().toUpperCase();
            _builder.append(_upperCase_7, "\t");
            _builder.append("_ID].");
            _builder.append("previousStates", "\t");
            _builder.append("[");
            _builder.append((Object)regionIndex, "\t");
            _builder.append("] = ");
            _builder.append("states", "\t");
            _builder.append("[");
            String _upperCase_8 = parent.getName().toUpperCase();
            _builder.append(_upperCase_8, "\t");
            _builder.append("_ID].");
            _builder.append("actives", "\t");
            _builder.append("[");
            _builder.append((Object)regionIndex, "\t");
            _builder.append("];");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("//set active sub-state of ");
        String _name_5 = parent.getName();
        _builder.append(_name_5, "\t");
        _builder.append(" to ");
        _builder.append("STATE_MAX", "\t");
        _builder.append(" meaning NULL");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("states", "\t");
        _builder.append("[");
        String _upperCase_9 = parent.getName().toUpperCase();
        _builder.append(_upperCase_9, "\t");
        _builder.append("_ID].");
        _builder.append("actives", "\t");
        _builder.append("[");
        _builder.append((Object)regionIndex, "\t");
        _builder.append("] = ");
        _builder.append("STATE_MAX", "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        String body = _builder.toString();
        Operation exitOp = this.superContext.createOwnedOperation(this.getRegionMethodExitName(r), null, null);
        this.createOpaqueBehavior(this.superContext, exitOp, body);
    }

    private String getRegionMethodExitName(Region r) {
        boolean _equals = Objects.equal((Object)r, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = r.getStateMachine().getName();
            _builder.append(_name);
            _builder.append("_");
            String _name_1 = r.getName();
            _builder.append(_name_1);
            _builder.append("_Exit");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _name_2 = r.getState().getName();
        _builder_1.append(_name_2);
        _builder_1.append("_");
        String _name_3 = r.getName();
        _builder_1.append(_name_3);
        _builder_1.append("_Exit");
        return _builder_1.toString();
    }

    public List<Vertex> allSubVertexes(Region r) {
        final ArrayList<Vertex> ret = new ArrayList<Vertex>();
        ret.addAll((Collection<Vertex>)r.getSubvertices());
        Consumer<State> _function = new Consumer<State>(){

            @Override
            public void accept(State it) {
                Consumer<Region> _function = new Consumer<Region>(){

                    @Override
                    public void accept(Region it_1) {
                        ret.addAll(SM2ClassesTransformationCore.this.allSubVertexes(it_1));
                    }
                };
                it.getRegions().forEach((Consumer)_function);
            }
        };
        Iterables.filter((Iterable)r.getSubvertices(), State.class).forEach(_function);
        return ret;
    }

    private OpaqueBehavior createOpaqueBehavior(Class container, Operation op) {
        OpaqueBehavior opaque = (OpaqueBehavior)IterableExtensions.head((Iterable)Iterables.filter((Iterable)op.getMethods(), OpaqueBehavior.class));
        if (opaque == null) {
            Behavior _createClassifierBehavior = container.createClassifierBehavior(op.getName(), UMLPackage.Literals.OPAQUE_BEHAVIOR);
            opaque = (OpaqueBehavior)_createClassifierBehavior;
            op.getMethods().add((Object)opaque);
            opaque.getLanguages().add((Object)this.langID);
        }
        return opaque;
    }

    public OpaqueBehavior createOpaqueBehavior(Class container, Operation op, String body) {
        boolean _greaterThan;
        OpaqueBehavior opaque = this.createOpaqueBehavior(container, op);
        int _size = opaque.getBodies().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            opaque.getBodies().set(0, (Object)body);
        } else {
            opaque.getLanguages().add((Object)this.langID);
            opaque.getBodies().add((Object)body);
        }
        return opaque;
    }

    private OpaqueExpression createOpaqueExpressionDefaultValue(Property container, String name) {
        ValueSpecification _defaultValue = container.getDefaultValue();
        OpaqueExpression opaque = (OpaqueExpression)_defaultValue;
        if (opaque == null) {
            ValueSpecification _createDefaultValue = container.createDefaultValue(name, null, UMLPackage.Literals.OPAQUE_EXPRESSION);
            opaque = (OpaqueExpression)_createDefaultValue;
            opaque.getLanguages().add((Object)this.langID);
        }
        return opaque;
    }

    public OpaqueExpression createOpaqueExpressionDefaultValue(Property container, String name, String body) {
        boolean _greaterThan;
        OpaqueExpression opaque = this.createOpaqueExpressionDefaultValue(container, name);
        int _size = opaque.getBodies().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            opaque.getBodies().set(0, (Object)body);
        } else {
            opaque.getLanguages().add((Object)this.langID);
            opaque.getBodies().add((Object)body);
        }
        return opaque;
    }

    public Operation createDerivedOperation(Class clz, Operation source) {
        Operation _xblockexpression = null;
        String name = source.getName();
        Operation derivedOp = clz.createOwnedOperation(name, null, null);
        OperationSync.sync((Operation)source, (Operation)derivedOp);
        derivedOp.setName(name);
        StereotypeUtil.apply((Element)derivedOp, DerivedElement.class);
        DerivedElement _stereotypeApplication = (DerivedElement)UMLUtil.getStereotypeApplication((Element)derivedOp, DerivedElement.class);
        _stereotypeApplication.setSource((Element)source);
        StereotypeUtil.apply((Element)derivedOp, Virtual.class);
        _xblockexpression = derivedOp;
        return _xblockexpression;
    }

    public String getGuard(Transition t) {
        ValueSpecification _specification = t.getGuard().getSpecification();
        return (String)IterableExtensions.head((Iterable)((OpaqueExpression)_specification).getBodies());
    }
}

