/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.reverse;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureTemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Template;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Visibility;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.ASTUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.BatchReverseFunctionBody;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.MethodUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.PkgDependencies;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.PropertyUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.ReverseCpp2Uml;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.ReverseData;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.ReverseUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.RedefinableTemplateSignature;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GetOrCreateP2 {
    public static void getOrCreateClassifiers(IParent parent) throws Exception {
        ICElement[] children = ReverseUtils.safeGetChilds(parent);
        int i = 0;
        while (i < children.length) {
            ICElement child = children[i];
            boolean _isActive = ReverseUtils.isActive(child);
            if (_isActive) {
                boolean _matched = false;
                if (child instanceof IStructure) {
                    _matched = true;
                }
                if (!_matched && child instanceof IEnumeration) {
                    _matched = true;
                }
                if (_matched) {
                    GetOrCreateP2.getOrCreateClassifier(child);
                }
                if (!_matched && child instanceof IMethod) {
                    IMethod method;
                    Classifier type;
                    _matched = true;
                    if (((IMethod)child).getTranslationUnit().isHeaderUnit() && !(child.getParent() instanceof IStructure) && (type = ReverseUtils.getTypeOfVariableOrMethod((ICElement)(method = (IMethod)child), method.getTranslationUnit())) != null) {
                        ITranslationUnit _translationUnit = method.getTranslationUnit();
                        String _elementName = method.getCProject().getElementName();
                        BatchReverseFunctionBody batchReverser = new BatchReverseFunctionBody(_translationUnit, _elementName, type);
                        String name = method.getElementName();
                        IASTNode node = ASTUtils.findEnclosingNode((ISourceReference)method);
                        if (node instanceof IASTFunctionDefinition) {
                            IASTFunctionDefinition definition = (IASTFunctionDefinition)node;
                            IASTFunctionDeclarator declarator = definition.getDeclarator();
                            String body = MethodUtils.getBody((IMethodDeclaration)method);
                            Operation operation = batchReverser.updateMethod((IFunctionDeclaration)method, node, 0, parent, name, body, declarator);
                        }
                    }
                }
                if (!_matched && child instanceof IFunction) {
                    _matched = true;
                }
                if (!_matched && child instanceof IParent) {
                    _matched = true;
                    GetOrCreateP2.getOrCreateClassifiers((IParent)child);
                }
                if (!_matched && child instanceof ITypeDef) {
                    _matched = true;
                    GetOrCreateP2.getOrCreateClassifier(child);
                }
                if (!_matched && child instanceof IUsing) {
                    _matched = true;
                }
                if (!_matched && child instanceof IInclude) {
                    _matched = true;
                    ITranslationUnit headerUnit = ReverseUtils.getTranslationUnitFromInclude((IInclude)child, ReverseData.current.project);
                    if (headerUnit != null && ReverseUtils.getSourceFolder((ICElement)headerUnit) != null) {
                        ReverseCpp2Uml.currentCpp2Uml().reverseHeader(headerUnit);
                    }
                }
            }
            ++i;
        }
    }

    public static Classifier getOrCreateClassifier(ICElement ideclaration) {
        Map<ICElement, Boolean> analyzeMap;
        Map<ICElement, EObject> map;
        block14: {
            map = ReverseData.current.map;
            analyzeMap = ReverseData.current.analyzeMap;
            if (ideclaration.getElementType() == 65 || ideclaration.getElementType() == 83 || ideclaration.getElementType() == 67 || ideclaration.getElementType() == 69 || ideclaration.getElementType() == 85) break block14;
            return null;
        }
        try {
            boolean _containsKey;
            Classifier existing = null;
            EObject _get = map.get(ideclaration);
            if (_get instanceof Classifier) {
                EObject _get_1 = map.get(ideclaration);
                existing = (Classifier)_get_1;
            }
            if (_containsKey = analyzeMap.containsKey(ideclaration)) {
                return existing;
            }
            analyzeMap.put(ideclaration, true);
            String _elementName = ideclaration.getElementName();
            String _plus = "Completing type " + _elementName;
            ReverseData.current.monitor.subTask(_plus);
            IStructure iStructure = (IStructure)ideclaration;
            if (existing instanceof Class) {
                boolean _equals;
                ICElement[] _children;
                Class classifier = (Class)existing;
                GetOrCreateP2.addSuperTypes((Classifier)classifier, (ISourceReference)iStructure);
                ICElement[] iCElementArray = _children = iStructure.getChildren();
                int n = _children.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement child = iCElementArray[n2];
                    if (child instanceof IField) {
                        PropertyUtils.createProperty((IField)child, (Classifier)classifier);
                    } else if (child instanceof IMethodDeclaration) {
                        MethodUtils.createMethod((IMethodDeclaration)child, classifier);
                    }
                    ++n2;
                }
                int _elementType = iStructure.getElementType();
                boolean bl = _equals = _elementType == 83;
                if (_equals) {
                    IStructureTemplate istructureTemplate = (IStructureTemplate)iStructure;
                    Template template = (Template)StereotypeUtil.applyApp((Element)classifier, Template.class);
                    template.setDeclaration(istructureTemplate.getTemplateSignature());
                }
                return classifier;
            }
            if (existing instanceof DataType) {
                ICElement[] _children_1;
                DataType dataType = (DataType)existing;
                GetOrCreateP2.addSuperTypes((Classifier)dataType, (ISourceReference)iStructure);
                GetOrCreateP2.getOrCreateClassifiers((IParent)iStructure);
                ICElement[] iCElementArray = _children_1 = iStructure.getChildren();
                int n = _children_1.length;
                int n3 = 0;
                while (n3 < n) {
                    boolean _equals_1;
                    ICElement child_1 = iCElementArray[n3];
                    int _elementType_1 = child_1.getElementType();
                    boolean bl = _equals_1 = _elementType_1 == 72;
                    if (_equals_1) {
                        PropertyUtils.createProperty((IField)child_1, (Classifier)dataType);
                    }
                    ++n3;
                }
                return dataType;
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void addSuperTypes(Classifier classifier, ISourceReference sourceRef) {
        IASTNode astNode = ASTUtils.findEnclosingNode(sourceRef);
        if (astNode instanceof ICPPASTCompositeTypeSpecifier) {
            ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] _baseSpecifiers;
            ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] iCPPASTBaseSpecifierArray = _baseSpecifiers = ((ICPPASTCompositeTypeSpecifier)astNode).getBaseSpecifiers();
            int n = _baseSpecifiers.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier superTypeAST = iCPPASTBaseSpecifierArray[n2];
                String qName = ASTUtils.getQualifiedNameFromNSpec(superTypeAST.getNameSpecifier());
                Type superType = ReverseUtils.getUMLType(qName, (ICElement)sourceRef);
                if (superType instanceof Classifier) {
                    boolean _notEquals;
                    PkgDependencies.createDependency((NamedElement)classifier, (NamedElement)superType);
                    Generalization generalization = classifier.createGeneralization((Classifier)superType);
                    VisibilityKind visibility = ASTUtils.convertVisibility(superTypeAST.getVisibility());
                    boolean bl = _notEquals = !Objects.equal((Object)visibility, (Object)VisibilityKind.PUBLIC_LITERAL);
                    if (_notEquals) {
                        Visibility visibilitySt = (Visibility)StereotypeUtil.applyApp((Element)generalization, Visibility.class);
                        visibilitySt.setValue(visibility.getLiteral().toLowerCase());
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Type> getOrCreateIncludes(IDeclaration iStructure, IParent parent, Model model) {
        try {
            ICElement[] _children;
            Include include;
            boolean _not;
            int _size_1;
            UniqueEList ret = new UniqueEList();
            String _elementName = iStructure.getElementName();
            String _plus = "Parsing type " + _elementName;
            ReverseData.current.monitor.subTask(_plus);
            Classifier tempType = null;
            IDeclaration istructure = iStructure;
            String elementName = istructure.getElementName();
            Namespace container = ReverseUtils.getContainer((ICElement)istructure);
            NamedElement _ownedMember = container.getOwnedMember(elementName);
            tempType = (Classifier)_ownedMember;
            if (tempType == null) {
                Classifier _orCreateClassifier;
                tempType = _orCreateClassifier = GetOrCreateP2.getOrCreateClassifier((ICElement)istructure);
            }
            if (tempType != null) {
                ret.add(tempType);
                if (istructure instanceof IParent) {
                    UniqueEList nestedStructures = new UniqueEList();
                    Iterables.addAll((Collection)nestedStructures, (Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)((IParent)istructure).getChildren())), IDeclaration.class));
                    Iterables.addAll((Collection)nestedStructures, (Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)((IParent)istructure).getChildren())), ITypeDef.class));
                    int _size = nestedStructures.size();
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
                    for (Integer i : _doubleDotLessThan) {
                        Classifier _orCreateClassifier_2;
                        Classifier t_1;
                        boolean isAnonEnumInstance;
                        ICElement ns;
                        block31: {
                            boolean _not2;
                            ns = (ICElement)nestedStructures.get(i);
                            boolean _isEmpty = ns.getElementName().trim().isEmpty();
                            boolean bl = _not2 = !_isEmpty;
                            if (_not2) {
                                Classifier _orCreateClassifier_1 = GetOrCreateP2.getOrCreateClassifier(ns);
                                Classifier t = _orCreateClassifier_1;
                                if (t == null) continue;
                                ret.add(t);
                                continue;
                            }
                            if (!(ns instanceof IEnumeration)) continue;
                            isAnonEnumInstance = false;
                            try {
                                ICElement nextNs;
                                boolean _lessThan;
                                int _size_12 = nestedStructures.size();
                                boolean bl2 = _lessThan = i + 1 < _size_12;
                                if (!_lessThan || !((nextNs = (ICElement)nestedStructures.get(i + 1)) instanceof IField)) break block31;
                                String nsRaw = ASTUtils.findEnclosingNode((ISourceReference)ns).getRawSignature();
                                String nextNsRaw = ASTUtils.findEnclosingNode((ISourceReference)nextNs).getRawSignature();
                                boolean _contains = nextNsRaw.contains(nsRaw);
                                if (_contains) {
                                    isAnonEnumInstance = true;
                                }
                            }
                            catch (Throwable _t) {
                                if (!(_t instanceof Exception)) throw Exceptions.sneakyThrow((Throwable)_t);
                                Exception e = (Exception)_t;
                                e.printStackTrace();
                            }
                        }
                        if (isAnonEnumInstance || (t_1 = (_orCreateClassifier_2 = GetOrCreateP2.getOrCreateClassifier(ns))) == null) continue;
                        ret.add(t_1);
                    }
                }
            }
            if (istructure instanceof IStructureTemplate) {
                IStructureTemplate istructureTemplate = (IStructureTemplate)istructure;
                int ti = 0;
                while (ti < ((List)Conversions.doWrapArray((Object)istructureTemplate.getTemplateParameterTypes())).size()) {
                    GetOrCreateP2.getOrCreateTemplateParameter((NamedElement)tempType, istructureTemplate.getTemplateParameterTypes()[ti], "class");
                    ++ti;
                }
            }
            boolean _greaterThan = (_size_1 = ret.size()) > 0;
            if (!_greaterThan) return ret;
            if (tempType instanceof Enumeration) return ret;
            if (tempType instanceof PrimitiveType) return ret;
            IParent file = parent;
            boolean _isApplied = StereotypeUtil.isApplied((Element)tempType, Include.class);
            boolean bl = _not = !_isApplied;
            if (_not) {
                StereotypeUtil.apply((Element)tempType, Include.class);
            }
            if ((include = (Include)UMLUtil.getStereotypeApplication((Element)tempType, Include.class)) == null) return ret;
            String header = include.getHeader();
            String escape = "";
            ICElement[] iCElementArray = _children = file.getChildren();
            int n = _children.length;
            int t_1 = 0;
            while (true) {
                block32: {
                    ICElement j;
                    block33: {
                        boolean _not_1;
                        if (t_1 >= n) {
                            include.setHeader(header);
                            if (!(file instanceof ITranslationUnit)) return ret;
                            try {
                                IPath sourcePath = ((ITranslationUnit)file).getPath().removeFileExtension().addFileExtension("cpp");
                                ICElement sourceFile = ((ITranslationUnit)file).getCProject().findElement(sourcePath);
                                if (!(sourceFile instanceof ITranslationUnit)) return ret;
                                BatchReverseFunctionBody.updateCppInclude((ITranslationUnit)sourceFile, tempType);
                                return ret;
                            }
                            catch (Throwable _t) {
                                if (_t instanceof Exception) return ret;
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                        }
                        j = iCElementArray[t_1];
                        if (!(j instanceof IInclude)) break block33;
                        boolean _contains = header.contains(((IInclude)j).getElementName());
                        boolean bl3 = _not_1 = !_contains;
                        if (_not_1) {
                            boolean _contains_1 = ((IInclude)j).getElementName().contains("Pkg_");
                            if (_contains_1) {
                                try {
                                    boolean _not_2;
                                    String[] includeTokens = ((IInclude)j).getElementName().split("/");
                                    String includeTrimmed = "";
                                    int _length = includeTokens.length;
                                    int _minus = _length - 1;
                                    ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _minus, true);
                                    for (Integer i_1 : _doubleDotLessThan_1) {
                                        String _includeTrimmed = includeTrimmed;
                                        String _get = includeTokens[i_1];
                                        includeTrimmed = String.valueOf(_includeTrimmed) + _get;
                                    }
                                    String[] typeQualifiedNameTokens = tempType.getQualifiedName().split("::");
                                    String typeQualifiedNameTrimmed = "";
                                    int _length_1 = typeQualifiedNameTokens.length;
                                    int _minus_1 = _length_1 - 1;
                                    ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(1, _minus_1, true);
                                    Iterator iterator = _doubleDotLessThan_2.iterator();
                                    while (true) {
                                        if (!iterator.hasNext()) {
                                            boolean _equals = includeTrimmed.equals(typeQualifiedNameTrimmed);
                                            boolean bl4 = _not_2 = !_equals;
                                        }
                                        Integer i_2 = (Integer)iterator.next();
                                        String _typeQualifiedNameTrimmed = typeQualifiedNameTrimmed;
                                        String _get_1 = typeQualifiedNameTokens[i_2];
                                        typeQualifiedNameTrimmed = String.valueOf(_typeQualifiedNameTrimmed) + _get_1;
                                    }
                                    if (_not_2) {
                                        String _plus_2;
                                        String _elementName_1 = ((IInclude)j).getElementName();
                                        String _plus_1 = String.valueOf(header) + escape + "#include " + "\"" + _elementName_1;
                                        header = _plus_2 = String.valueOf(_plus_1) + "\"";
                                        escape = "\n";
                                    }
                                    break block32;
                                }
                                catch (Throwable _t) {
                                    String _plus_4;
                                    if (!(_t instanceof Exception)) throw Exceptions.sneakyThrow((Throwable)_t);
                                    Exception e = (Exception)_t;
                                    e.printStackTrace();
                                    String _elementName_2 = ((IInclude)j).getElementName();
                                    String _plus_3 = String.valueOf(header) + escape + "#include " + "\"" + _elementName_2;
                                    header = _plus_4 = String.valueOf(_plus_3) + "\"";
                                    escape = "\n";
                                }
                                break block32;
                            } else {
                                String _plus_2;
                                String _elementName_1 = ((IInclude)j).getElementName();
                                String _plus_1 = String.valueOf(header) + escape + "#include " + "\"" + _elementName_1;
                                header = _plus_2 = String.valueOf(_plus_1) + "\"";
                                escape = "\n";
                            }
                        }
                        break block32;
                    }
                    if (j instanceof IMacro) {
                        IASTNode node;
                        boolean _not_2;
                        boolean _contains_2 = header.contains(((IMacro)j).getElementName());
                        boolean bl5 = _not_2 = !_contains_2;
                        if (_not_2 && (node = ASTUtils.findEnclosingNode((ISourceReference)j)) != null) {
                            int _indexOf;
                            int _plus_3;
                            String nodeString = node.toString();
                            String value = nodeString.substring(_plus_3 = (_indexOf = nodeString.indexOf("=")) + 1);
                            if (value == null || value.equals("")) {
                                boolean _not_3;
                                boolean _contains_3 = ((IMacro)j).getElementName().contains(tempType.getName().replaceAll(" ", "").toUpperCase());
                                boolean bl6 = _not_3 = !_contains_3;
                                if (_not_3) {
                                    String _plus_6;
                                    String _elementName_2 = ((IMacro)j).getElementName();
                                    String _plus_4 = String.valueOf(header) + escape + "#define " + _elementName_2;
                                    String _plus_5 = String.valueOf(_plus_4) + " ";
                                    header = _plus_6 = String.valueOf(_plus_5) + value;
                                    escape = "\n";
                                }
                            } else {
                                String _plus_9;
                                String _elementName_3 = ((IMacro)j).getElementName();
                                String _plus_7 = String.valueOf(header) + escape + "#define " + _elementName_3;
                                String _plus_8 = String.valueOf(_plus_7) + " ";
                                header = _plus_9 = String.valueOf(_plus_8) + value;
                                escape = "\n";
                            }
                        }
                    }
                }
                ++t_1;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Classifier getOrCreateTemplateParameter(NamedElement element, final String parameterTypeName, String keyWord) {
        Classifier ret = null;
        RedefinableTemplateSignature templateSignature = null;
        if (element instanceof Classifier) {
            Classifier classifier = (Classifier)element;
            if (classifier.getOwnedTemplateSignature() == null || !(classifier.getOwnedTemplateSignature() instanceof RedefinableTemplateSignature)) {
                TemplateSignature _createOwnedTemplateSignature = classifier.createOwnedTemplateSignature(UMLPackage.Literals.REDEFINABLE_TEMPLATE_SIGNATURE);
                templateSignature = (RedefinableTemplateSignature)_createOwnedTemplateSignature;
                templateSignature.setName("template_paremeter_signature");
            }
            TemplateSignature _ownedTemplateSignature = classifier.getOwnedTemplateSignature();
            templateSignature = (RedefinableTemplateSignature)_ownedTemplateSignature;
        } else if (element instanceof Operation) {
            Operation operation = (Operation)element;
            if (operation.getOwnedTemplateSignature() == null || !(operation.getOwnedTemplateSignature() instanceof TemplateSignature)) {
                TemplateSignature _createOwnedTemplateSignature_1 = operation.createOwnedTemplateSignature(UMLPackage.Literals.TEMPLATE_SIGNATURE);
                templateSignature = _createOwnedTemplateSignature_1;
            }
            TemplateSignature _ownedTemplateSignature_1 = operation.getOwnedTemplateSignature();
            templateSignature = _ownedTemplateSignature_1;
        } else {
            return null;
        }
        Iterable classifierTemplates = Iterables.filter((Iterable)templateSignature.getOwnedParameters(), ClassifierTemplateParameter.class);
        Functions.Function1<ClassifierTemplateParameter, Boolean> _function = new Functions.Function1<ClassifierTemplateParameter, Boolean>(){

            public Boolean apply(ClassifierTemplateParameter it) {
                ParameterableElement _ownedParameteredElement = it.getOwnedParameteredElement();
                return _ownedParameteredElement instanceof Classifier;
            }
        };
        Iterable classifierTemplatesContainClassifier = IterableExtensions.filter((Iterable)classifierTemplates, (Functions.Function1)_function);
        Functions.Function1<ClassifierTemplateParameter, ParameterableElement> _function_1 = new Functions.Function1<ClassifierTemplateParameter, ParameterableElement>(){

            public ParameterableElement apply(ClassifierTemplateParameter it) {
                return it.getOwnedParameteredElement();
            }
        };
        Iterable containedClassifiers = IterableExtensions.map((Iterable)classifierTemplatesContainClassifier, (Functions.Function1)_function_1);
        Functions.Function1<Classifier, Boolean> _function_2 = new Functions.Function1<Classifier, Boolean>(){

            public Boolean apply(Classifier it) {
                return it.getName().equals(parameterTypeName);
            }
        };
        ret = (Classifier)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)containedClassifiers, Classifier.class), (Functions.Function1)_function_2));
        if (ret == null) {
            TemplateParameter _createOwnedParameter = templateSignature.createOwnedParameter(UMLPackage.Literals.CLASSIFIER_TEMPLATE_PARAMETER);
            ClassifierTemplateParameter classifierTemplate = (ClassifierTemplateParameter)_createOwnedParameter;
            ParameterableElement _createOwnedParameteredElement = classifierTemplate.createOwnedParameteredElement(UMLPackage.Literals.CLASS);
            ret = (Classifier)_createOwnedParameteredElement;
            ret.setName(parameterTypeName);
            classifierTemplate.addKeyword(keyWord);
        }
        return ret;
    }

    public static Type getClassifier(ICElement declaration) throws Exception {
        Classifier _orCreateClassifier;
        Map<ICElement, EObject> map = ReverseData.current.map;
        if (map.get(declaration) != null && map.get(declaration) instanceof Type) {
            EObject _get = map.get(declaration);
            return (Type)_get;
        }
        Classifier ret = _orCreateClassifier = GetOrCreateP2.getOrCreateClassifier(declaration);
        return ret;
    }
}

