/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class AcslScript {
  public static String ACSL = "ACSL";

  public static String getACSLConstraint(final Constraint constraint) {
    String constraintText = "";
    ValueSpecification _specification = constraint.getSpecification();
    if ((_specification instanceof OpaqueExpression)) {
      ValueSpecification _specification_1 = constraint.getSpecification();
      OpaqueExpression opaqueExpression = ((OpaqueExpression) _specification_1);
      int _size = opaqueExpression.getBodies().size();
      int _size_1 = opaqueExpression.getLanguages().size();
      boolean _equals = (_size == _size_1);
      if (_equals) {
        for (int i = 0; (i < opaqueExpression.getLanguages().size()); i++) {
          boolean _equalsIgnoreCase = opaqueExpression.getLanguages().get(i).equalsIgnoreCase(AcslScript.ACSL);
          if (_equalsIgnoreCase) {
            String _constraintText = constraintText;
            String _cleanCR = GenUtils.cleanCR(opaqueExpression.getBodies().get(i));
            String _plus = (_cleanCR + "\n");
            constraintText = (_constraintText + _plus);
          }
        }
      }
    }
    return constraintText;
  }

  public static String genPrePostConditions(final Operation operation) {
    String _xblockexpression = null;
    {
      String specificationText = "";
      EList<Constraint> _preconditions = operation.getPreconditions();
      for (final Constraint constraint : _preconditions) {
        String _specificationText = specificationText;
        String _aCSLConstraint = AcslScript.getACSLConstraint(constraint);
        specificationText = (_specificationText + _aCSLConstraint);
      }
      EList<Constraint> _postconditions = operation.getPostconditions();
      for (final Constraint constraint_1 : _postconditions) {
        String _specificationText_1 = specificationText;
        String _aCSLConstraint_1 = AcslScript.getACSLConstraint(constraint_1);
        specificationText = (_specificationText_1 + _aCSLConstraint_1);
      }
      String _xifexpression = null;
      boolean _isEmpty = specificationText.isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        return AcslScript.getACSLComment(specificationText);
      } else {
        _xifexpression = "";
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  public static String getACSLComment(final String acslSpecification) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/*@");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(acslSpecification, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    return _builder.toString();
  }

  public static String getGuard(final Transition transition) {
    final Pattern selectedLanguages = Pattern.compile(AcslScript.ACSL);
    final String guard = StateMachineScript.getGuard(transition, selectedLanguages);
    boolean _isEmpty = guard.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return AcslScript.getACSLComment(guard);
    }
    return "";
  }
}
