/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.jdt;

import java.util.List;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.exception.NotFoundException;

public class JdtAstUtils {
    public static String getTypeShortname(Type requestedType) {
        switch (requestedType.getNodeType()) {
            case 43: {
                return ((SimpleType)requestedType).getName().getFullyQualifiedName();
            }
            case 74: {
                return JdtAstUtils.getTypeShortname(((ParameterizedType)requestedType).getType());
            }
            case 5: {
                return JdtAstUtils.getTypeShortname(((ArrayType)requestedType).getElementType());
            }
            case 39: {
                return ((PrimitiveType)requestedType).getPrimitiveTypeCode().toString();
            }
        }
        return null;
    }

    public static FieldDeclaration getField(TypeDeclaration typeDeclaration, String fieldName) throws NotFoundException {
        FieldDeclaration[] fields;
        FieldDeclaration[] fieldDeclarationArray = fields = typeDeclaration.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration field = fieldDeclarationArray[n2];
            List varDecls = field.fragments();
            for (VariableDeclaration decl : varDecls) {
                if (!fieldName.equals(decl.getName().getIdentifier())) continue;
                return field;
            }
            ++n2;
        }
        throw new NotFoundException("Name " + fieldName + "' is not found in Field");
    }
}

