/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal;

import java.util.List;

public final class MathUtils {
    private MathUtils() {
    }

    public static <T> double average(List<T> objects, Resolver<T> resolver) {
        long sum = 0L;
        int i = 0;
        while (i < objects.size()) {
            sum = (long)((double)sum + resolver.getValue(objects.get(i)));
            ++i;
        }
        return sum / (long)objects.size();
    }

    public static <T> double standardDeviation(List<T> objects, Resolver<T> resolver) {
        double avg = MathUtils.average(objects, resolver);
        double sum = 0.0;
        int i = 0;
        while (i < objects.size()) {
            double value = resolver.getValue(objects.get(i));
            double delta = Math.abs(value - avg);
            sum += delta * delta;
            ++i;
        }
        return Math.sqrt(sum / (double)objects.size());
    }

    public static interface Resolver<T> {
        public double getValue(T var1);
    }
}

