/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.common.ui.internal.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.modisco.facet.common.ui.internal.Activator;
import org.eclipse.modisco.facet.common.ui.internal.controls.PersistableColumn;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractTreeView
extends ViewPart {
    private final List<PersistableColumn> columns = new ArrayList<PersistableColumn>();
    private final Map<String, Integer> persistedValues = new HashMap<String, Integer>();
    private static final int JOB_SCHEDULE_DELAY = 500;
    private Job fRefreshJob = null;
    private TreeViewer fTreeViewer;

    public TreeViewer getViewer() {
        return this.fTreeViewer;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.fTreeViewer = new TreeViewer(parent, 66308);
        this.fTreeViewer.getTree().setLinesVisible(true);
        this.fTreeViewer.getTree().setHeaderVisible(true);
        this.fTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)AbstractTreeView.this.getViewer().getSelection();
                AbstractTreeView.this.openElement(selection.getFirstElement());
            }
        });
        this.createColumns();
        this.fTreeViewer.setContentProvider(this.getContentProvider());
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        this.refresh(false);
    }

    protected void createContextMenu() {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        Menu menu = contextMenu.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.getViewer());
    }

    protected abstract void createColumns();

    protected abstract IContentProvider getContentProvider();

    protected abstract void openElement(Object var1);

    public void setFocus() {
        this.fTreeViewer.getControl().setFocus();
    }

    protected void refresh(boolean delayed) {
        if (this.fRefreshJob == null) {
            this.fRefreshJob = new Job(this.getRefreshMessage()){

                protected IStatus run(IProgressMonitor monitor) {
                    AbstractTreeView.this.doRefresh();
                    return Status.OK_STATUS;
                }
            };
        }
        this.fRefreshJob.cancel();
        if (delayed) {
            this.fRefreshJob.setPriority(50);
            this.fRefreshJob.schedule(500L);
        } else {
            this.fRefreshJob.setPriority(10);
            this.fRefreshJob.schedule();
        }
    }

    protected abstract String getRefreshMessage();

    protected abstract Object getInput();

    protected void doRefresh() {
        final Object input = this.getInput();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractTreeView.this.getViewer().setInput(input);
                AbstractTreeView.this.getViewer().refresh();
            }
        });
    }

    protected void createColumn(String columnText, String uniqueID, int defaultWidth, ColumnLabelProvider columnLabelProvider) {
        PersistableColumn persistableColumn = new PersistableColumn(columnText, uniqueID, defaultWidth, columnLabelProvider, this.fTreeViewer);
        this.columns.add(persistableColumn);
        Integer width = this.persistedValues.get(uniqueID);
        if (width != null) {
            persistableColumn.setWidth(width);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        try {
            for (PersistableColumn column : this.columns) {
                column.saveState(memento);
            }
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (String)"Error saving view state", (Plugin)Activator.getDefault());
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            String[] attributeKeys;
            String[] stringArray = attributeKeys = memento.getAttributeKeys();
            int n = attributeKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                this.persistedValues.put(key, memento.getInteger(key));
                ++n2;
            }
        }
    }
}

