/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.usecase.simpletransformationschain;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.modisco.infra.common.core.internal.logging.MoDiscoLogHandler;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.usecase.simpletransformationschain.DiscoverUmlModelFromJavaProject;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;

@Deprecated
public class DiscoverUmlModelWithBidirectionalAssociationsFromJavaProject
extends AbstractModelDiscoverer<IJavaProject> {
    private static final String MODEL_FILE_SUFFIX = "_BidirectionalAssociations.uml";
    private URL customTransformation = null;

    @Parameter(name="CUSTOM_TRANSFORMATION", description="A URL pointing to an ATL transformation that will be used instead of the default one.")
    public void setCustomTransformation(URL customTransformation) {
        this.customTransformation = customTransformation;
    }

    protected URL getCustomTransformation() {
        return this.customTransformation;
    }

    public boolean isApplicableTo(IJavaProject source) {
        return source.getProject().isAccessible();
    }

    protected void basicDiscoverElement(IJavaProject source, IProgressMonitor monitor) throws DiscoveryException {
        IProject project = source.getProject();
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)(project.getFullPath().append(project.getName()) + MODEL_FILE_SUFFIX), (boolean)true));
        Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
        MoDiscoLogHandler logHandler = new MoDiscoLogHandler(String.valueOf(project.getLocation().append(project.getName()).toString()) + ".log");
        logger.addHandler((Handler)logHandler);
        try {
            try {
                Resource uml2Model = DiscoverUmlModelFromJavaProject.getUML2ModelFromJavaProject(source, this.getCustomTransformation());
                this.createBidirectionalAssociations(uml2Model);
                this.setTargetModel(uml2Model);
            }
            catch (Exception e) {
                throw new DiscoveryException((Throwable)e);
            }
        }
        finally {
            logger.removeHandler((Handler)logHandler);
            logHandler.close();
        }
    }

    private void createBidirectionalAssociations(Resource uml2Model) {
        HashSet<Association> associationsToRemove = new HashSet<Association>();
        HashSet propertiesToRemove = new HashSet();
        TreeIterator i = uml2Model.getAllContents();
        while (i.hasNext()) {
            Association currentAssociation;
            Association oppositeAssociation;
            EObject childEObject = (EObject)i.next();
            if (!(childEObject instanceof Association) || associationsToRemove.contains(childEObject) || (oppositeAssociation = this.searchAndMergeOppositeAssociation(currentAssociation = (Association)childEObject)) == null) continue;
            associationsToRemove.add(oppositeAssociation);
            propertiesToRemove.addAll(currentAssociation.getOwnedEnds());
        }
        EcoreUtil.deleteAll(associationsToRemove, (boolean)true);
        EcoreUtil.deleteAll(propertiesToRemove, (boolean)true);
    }

    private Association searchAndMergeOppositeAssociation(Association association) {
        Association oppositeAssociation = null;
        List<Class> endTypes = association.getEndTypes().stream().filter(Class.class::isInstance).map(Class.class::cast).collect(Collectors.toList());
        if (endTypes.size() == 1) {
            oppositeAssociation = this.searchAndMergeSelfOppositeAssociation(association, endTypes);
        } else if (endTypes.size() == 2) {
            Class sourceType = endTypes.get(0);
            Class targetType = endTypes.get(1);
            List sourceMatchingAtts = sourceType.getAttributes().stream().filter(att -> targetType.equals(att.getType()) && att.getAssociation() != null).collect(Collectors.toList());
            List targetMatchingAtts = targetType.getAttributes().stream().filter(att -> sourceType.equals(att.getType()) && att.getAssociation() != null).collect(Collectors.toList());
            if (sourceMatchingAtts.size() == 1 && targetMatchingAtts.size() == 1) {
                if (((Property)sourceMatchingAtts.get(0)).getAssociation() == association) {
                    oppositeAssociation = ((Property)targetMatchingAtts.get(0)).getAssociation();
                    ((Property)targetMatchingAtts.get(0)).setAssociation(association);
                } else {
                    oppositeAssociation = ((Property)sourceMatchingAtts.get(0)).getAssociation();
                    ((Property)sourceMatchingAtts.get(0)).setAssociation(association);
                }
            }
        }
        return oppositeAssociation;
    }

    private Association searchAndMergeSelfOppositeAssociation(Association association, List<Class> endTypes) {
        Class sourceType = endTypes.get(0);
        Association oppositeAssociation = null;
        List sourceMatchingAtts = sourceType.getAttributes().stream().filter(att -> sourceType.equals(att.getType()) && att.getAssociation() != null).collect(Collectors.toList());
        if (sourceMatchingAtts.size() == 2) {
            if (((Property)sourceMatchingAtts.get(0)).getAssociation() == association) {
                oppositeAssociation = ((Property)sourceMatchingAtts.get(1)).getAssociation();
                ((Property)sourceMatchingAtts.get(1)).setAssociation(association);
            } else {
                oppositeAssociation = ((Property)sourceMatchingAtts.get(0)).getAssociation();
                ((Property)sourceMatchingAtts.get(0)).setAssociation(association);
            }
        }
        return oppositeAssociation;
    }
}

