/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.ui.internal.widget;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.modisco.facet.efacet.ui.internal.Activator;
import org.eclipse.modisco.facet.efacet.ui.internal.Messages;
import org.eclipse.modisco.facet.efacet.ui.internal.exported.widget.IUriWidget;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IOkDialogFactory;
import org.eclipse.modisco.facet.util.ui.utils.UIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UriWidget
extends Composite
implements IUriWidget {
    private final Text textWidget;

    public UriWidget(Composite parent) {
        super(parent, 0);
        Label labelWidget = UIUtils.createLabel((Composite)parent, (String)Messages.UriWidget_EmfUri);
        labelWidget.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).create());
        this.textWidget = UIUtils.createTextField((Composite)parent, (String)"", (boolean)true, null);
    }

    public URI getURI() {
        URI result = null;
        String text = this.textWidget.getText();
        try {
            result = URI.createURI((String)text);
        }
        catch (IllegalArgumentException e) {
            String message = NLS.bind((String)"The URI '{0}' in malformed.", (Object)text);
            IOkDialogFactory.DEFAULT.openErrorDialog(new Shell(), (Exception)e, message);
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return result;
    }

    public void setURI(URI uri) {
        String uriStr = "platform:/resource/<your_project>/<your_file>.xmi";
        if (uri != null) {
            uriStr = uri.toString();
        }
        this.textWidget.setText(uriStr);
    }
}

