/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.editor.editors;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.gmt.modisco.infra.browser.custom.AttributeView;
import org.eclipse.gmt.modisco.infra.browser.custom.CustomView;
import org.eclipse.gmt.modisco.infra.browser.custom.CustomViewFeature;
import org.eclipse.gmt.modisco.infra.browser.custom.CustomizableFeatures;
import org.eclipse.gmt.modisco.infra.browser.custom.DerivedFeatureValue;
import org.eclipse.gmt.modisco.infra.browser.custom.FeatureValue;
import org.eclipse.gmt.modisco.infra.browser.custom.FeatureValueCase;
import org.eclipse.gmt.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.gmt.modisco.infra.browser.custom.ReferenceView;
import org.eclipse.gmt.modisco.infra.browser.custom.StaticFeatureValue;
import org.eclipse.gmt.modisco.infra.browser.custom.TypeView;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.Activator;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.Messages;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs.BooleanFeatureDialog;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs.ColorFeatureDialog;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs.CustomizationPropertiesDialog;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs.EditFeatureValueDialog;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs.FontFeatureDialog;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs.IconFeatureDialog;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs.OverlayIconFeatureDialog;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs.TextFeatureDialog;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.editors.CustomizationViewer;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.editors.MetaclassViewConfiguration;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.editors.MetaclassViewToolBar;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.editors.MetaclassViewer;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.editors.WorkspaceChangeListener;
import org.eclipse.gmt.modisco.infra.browser.custom.emf.UicustomFactory;
import org.eclipse.gmt.modisco.infra.browser.custom.emf.UicustomPackage;
import org.eclipse.gmt.modisco.infra.browser.dialogs.ErrorsDialog;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.EMFUtil;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.common.core.internal.builder.AbstractMoDiscoCatalog;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.common.ui.internal.controls.FormStyleSashForm;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.core.FacetSetCatalog;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationEditor
extends EditorPart
implements IGotoMarker {
    private static final int VERTICAL_SPACE_BETWEEN_BUTTON_GROUPS = 30;
    private static final int VERTICAL_SPACE_BEFORE_FIRST_BUTTON = 10;
    private static final int TOP_PANE_MARGIN_HEIGHT = 4;
    private static final int TOP_PANE_MARGIN_WIDTH = 5;
    public static final String ID = "org.eclipse.gmt.modisco.infra.browser.custom.editor";
    private static final int MAIN_FORM_MARGIN_WIDTH = 4;
    private static final int MAIN_FORM_MARGIN_HEIGHT = 6;
    private static final int LEFT_PANE_SASH_WEIGHT = 30;
    private static final int RIGHT_PANE_SASH_WEIGHT = 70;
    private MetamodelView fMetamodelView;
    private MetaclassViewer metaclassViewer;
    private MetaclassViewConfiguration metaclassViewConfiguration;
    private CustomizationViewer customizationViewer;
    private Button btnEditFeatureValue;
    private Button btnResetDefaults;
    private Button btnAdd;
    private Button btnEdit;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;
    private Button cbAppliesToSubinstances;
    private boolean dirty;
    private Label headerLabel;
    private FormToolkit toolkit;
    private boolean readOnly;
    private boolean resourceDeleted = false;
    private boolean resourceChanged = false;
    private final WorkspaceChangeListener resourceChangeListener;
    private Diagnostic fDiagnostic = null;
    private Button errorsButton;
    private Resource fMetamodel;
    private Form fForm;
    private final AdapterFactoryEditingDomain editingDomain;
    private final IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p == CustomizationEditor.this) {
                CustomizationEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };

    public CustomizationEditor() {
        FacetSetCatalog.getSingleton();
        final BasicCommandStack commandStack = new BasicCommandStack();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack);
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                CustomizationEditor.this.setDirty(commandStack.isSaveNeeded());
                CustomizationEditor.this.refresh();
                CustomizationEditor.this.updateSubinstancesChangedCheckbox();
                CustomizationEditor.this.refreshHeader();
            }
        });
        this.resourceChangeListener = new WorkspaceChangeListener(this);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput) && !(input instanceof URIEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput or URIEditorInput");
        }
        this.readOnly = input instanceof URIEditorInput;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener, 1);
    }

    public void createPartControl(Composite parent) {
        java.net.URI locationURI;
        String fileName = "";
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            try {
                locationURI = fileEditorInput.getFile().exists() ? new java.net.URI(URI.createPlatformResourceURI((String)fileEditorInput.getFile().getFullPath().toString(), (boolean)true).toString()) : fileEditorInput.getFile().getLocationURI();
            }
            catch (URISyntaxException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                locationURI = fileEditorInput.getFile().getLocationURI();
            }
            fileName = fileEditorInput.getFile().getName();
        } else if (editorInput instanceof URIEditorInput) {
            URIEditorInput uriEditorInput = (URIEditorInput)editorInput;
            try {
                locationURI = new java.net.URI(uriEditorInput.getURI().toString());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            fileName = new Path(locationURI.getPath()).lastSegment();
        } else {
            throw new IllegalStateException("wrong kind of input: " + editorInput.getClass().getName());
        }
        this.loadResource(locationURI);
        this.setPartName(fileName);
        this.metaclassViewConfiguration = new MetaclassViewConfiguration();
        this.metaclassViewConfiguration.load();
        this.getSite().getPage().addPartListener((IPartListener)new SaveSettingsOnCloseListener());
        this.createContents(parent);
        this.metaclassViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection selection = (ITreeSelection)CustomizationEditor.this.metaclassViewer.getSelection();
                CustomizationEditor.this.metaclassSelectionChanged(selection.getFirstElement());
                CustomizationEditor.this.customizationViewer.getViewer().getControl().setRedraw(false);
                CustomizationEditor.this.customizationViewer.getViewer().expandAll();
                CustomizationEditor.this.customizationViewer.getViewer().getControl().setRedraw(true);
            }
        });
        this.customizationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomizationEditor.this.customizationSelectionChanged(CustomizationEditor.this.getSelectedElement());
            }
        });
        this.customizationViewer.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object selectedElement = CustomizationEditor.this.getSelectedElement();
                if (selectedElement instanceof CustomViewFeature) {
                    CustomizationEditor.this.btnEditFeatureValueClicked();
                } else if (selectedElement instanceof FeatureValueCase) {
                    CustomizationEditor.this.btnEditClicked();
                }
            }
        });
        this.customizationViewer.getViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object selectedElement;
                if (e.keyCode == 127 && (selectedElement = CustomizationEditor.this.getSelectedElement()) instanceof FeatureValueCase) {
                    CustomizationEditor.this.btnRemoveClicked();
                }
            }
        });
        String metamodelURI = this.fMetamodelView.getMetamodelURI();
        this.fMetamodel = this.initMetamodel(metamodelURI);
    }

    private Resource initMetamodel(String metamodelURI) {
        Resource resource;
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(metamodelURI);
        if (ePackage != null && (resource = ePackage.eResource()) != null) {
            this.metaclassViewer.setInput(resource);
            return resource;
        }
        MoDiscoLogger.logError((String)NLS.bind((String)Messages.CustomizationEditor_cannotFindMetamodel, (Object)metamodelURI), (Plugin)Activator.getDefault());
        return null;
    }

    private void createContents(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.fForm = this.toolkit.createForm(parent);
        this.toolkit.decorateFormHeading(this.fForm);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 4;
        fillLayout.marginHeight = 6;
        this.fForm.getBody().setLayout((Layout)fillLayout);
        this.fForm.setHeadClient((Control)this.createTopPane(this.fForm.getHead()));
        this.createBottomPane(this.fForm.getBody());
        this.buttonsEnablementForSelection(null);
    }

    private Composite createTopPane(Composite parent) {
        Composite topPane = new Composite(parent, 0);
        GridData gridData = new GridData(4, 1, true, false);
        topPane.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 4;
        topPane.setLayout((Layout)gridLayout);
        this.headerLabel = new Label(topPane, 0);
        this.headerLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.refreshHeader();
        this.errorsButton = new Button(topPane, 8);
        this.errorsButton.setToolTipText(Messages.CustomizationEditor_btnTooltipViewErrors);
        this.errorsButton.setImage(ImageProvider.getInstance().getErrorIcon());
        this.errorsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorsDialog errorsDialog = new ErrorsDialog(CustomizationEditor.this.getSite().getShell(), CustomizationEditor.this.fDiagnostic);
                errorsDialog.open();
            }
        });
        if (this.fDiagnostic == null) {
            this.errorsButton.setVisible(false);
        }
        Button propertiesButton = new Button(topPane, 8);
        propertiesButton.setText(Messages.CustomizationEditor_btnProperties);
        propertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.propertiesClicked();
            }
        });
        return topPane;
    }

    private void refreshHeader() {
        String readOnlyText = this.readOnly ? Messages.CustomizationEditor_readonly : "";
        this.headerLabel.setText(String.valueOf(readOnlyText) + NLS.bind((String)Messages.CustomizationEditor_customViewFor, (Object)this.getMetamodelName(), (Object)this.fMetamodelView.getMetamodelURI()));
    }

    protected void propertiesClicked() {
        CustomizationPropertiesDialog dialog = new CustomizationPropertiesDialog(this.getSite().getShell(), this.readOnly);
        dialog.setInitialMetamodel(this.fMetamodelView.getMetamodelURI());
        EList importedQuerySets = this.fMetamodelView.getAvailableQuerySets();
        dialog.setInitialQuerySets((List<String>)importedQuerySets);
        dialog.setInitialImportAllQuerySets(this.fMetamodelView.isAllQuerySetsAvailable());
        if (dialog.open() == 0 && !this.readOnly) {
            Command setCommand;
            boolean changeMetamodel;
            CompoundCommand compoundCommand = new CompoundCommand();
            boolean bl = changeMetamodel = !dialog.getMetamodel().equals(this.fMetamodelView.getMetamodelURI());
            if (changeMetamodel) {
                setCommand = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.fMetamodelView, (Object)UicustomPackage.eINSTANCE.getMetamodelView_MetamodelURI(), (Object)dialog.getMetamodel());
                compoundCommand.append(setCommand);
                ChangeMetamodelCommand changeMetamodelCommand = new ChangeMetamodelCommand((EditingDomain)this.editingDomain, dialog.getMetamodel());
                compoundCommand.append((Command)changeMetamodelCommand);
            }
            setCommand = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.fMetamodelView, (Object)UicustomPackage.eINSTANCE.getMetamodelView_AllQuerySetsAvailable(), (Object)dialog.isAllQuerySetsAvailable());
            compoundCommand.append(setCommand);
            List<String> selectedQuerySets = Arrays.asList(dialog.getSelectedQuerySets());
            EList imports = this.fMetamodelView.getAvailableQuerySets();
            for (String anImport : imports) {
                if (selectedQuerySets.contains(anImport)) continue;
                Command removeCommand = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)this.fMetamodelView, (Object)UicustomPackage.eINSTANCE.getMetamodelView_AvailableQuerySets(), (Object)anImport);
                compoundCommand.append(removeCommand);
            }
            for (String selectedQuerySet : selectedQuerySets) {
                if (imports.contains((Object)selectedQuerySet)) continue;
                Command addCommand = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.fMetamodelView, (Object)UicustomPackage.eINSTANCE.getMetamodelView_AvailableQuerySets(), (Object)selectedQuerySet);
                compoundCommand.append(addCommand);
            }
            compoundCommand.setLabel(Messages.CustomizationEditor_changeProperties);
            this.editingDomain.getCommandStack().execute((Command)compoundCommand);
        }
    }

    private void promptToCleanCustomization(Resource newMetamodel) {
        String message = String.valueOf(Messages.CustomizationEditor_youChangedMetamodel) + Messages.CustomizationEditor_promptCleanCustomizations;
        if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.CustomizationEditor_Title_cleanCustomization, (String)message)) {
            EList typeViews = this.fMetamodelView.getTypes();
            List metaclasses = EMFUtil.getMetaclasses((Resource)newMetamodel);
            CompoundCommand compoundCommand = new CompoundCommand();
            for (TypeView typeView : typeViews) {
                String metaclassName = typeView.getMetaclassName();
                EClass eClass = EMFUtil.findMetaclassWithName((String)metaclassName, (List)metaclasses);
                if (eClass == null) {
                    Command removeCommand = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)this.fMetamodelView, (Object)UicustomPackage.eINSTANCE.getMetamodelView_Types(), (Object)typeView);
                    compoundCommand.append(removeCommand);
                    continue;
                }
                EList attributeViews = typeView.getAttributes();
                for (AttributeView attributeView : attributeViews) {
                    if (EMFUtil.findElementWithName((String)attributeView.getAttributeName(), (EList)eClass.getEAllAttributes()) != null) continue;
                    Command removeCommand = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)typeView, (Object)UicustomPackage.eINSTANCE.getTypeView_Attributes(), (Object)attributeView);
                    compoundCommand.append(removeCommand);
                }
                EList referenceViews = typeView.getReferences();
                for (ReferenceView referenceView : referenceViews) {
                    if (EMFUtil.findElementWithName((String)referenceView.getReferenceName(), (EList)eClass.getEAllReferences()) != null) continue;
                    Command removeCommand = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)typeView, (Object)UicustomPackage.eINSTANCE.getTypeView_References(), (Object)referenceView);
                    compoundCommand.append(removeCommand);
                }
            }
            compoundCommand.setLabel(Messages.CustomizationEditor_removeIrrelevantCustomizations);
            this.editingDomain.getCommandStack().execute((Command)compoundCommand);
        }
    }

    private String getMetamodelName() {
        String nsURI = this.fMetamodelView.getMetamodelURI();
        String metamodelName = EMFUtil.getMetamodelName((String)nsURI);
        if (metamodelName == null) {
            return Messages.CustomizationEditor_unknown;
        }
        return metamodelName;
    }

    private Composite createBottomPane(Composite parent) {
        FormStyleSashForm sashForm = new FormStyleSashForm(parent, 256, this.toolkit){

            protected void createContents() {
                CustomizationEditor.this.createLeftPane((Composite)this);
                CustomizationEditor.this.createRightPane((Composite)this);
            }
        };
        sashForm.setWeights(new int[]{30, 70});
        return sashForm;
    }

    private Composite createLeftPane(Composite parent) {
        Section section = this.toolkit.createSection(parent, 320);
        section.setText(Messages.CustomizationEditor_sectionName_types);
        Composite leftPaneComposite = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)leftPaneComposite);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftPaneComposite.setLayout((Layout)gridLayout);
        MetaclassViewToolBar toolBar = this.createToolBar((Composite)section);
        section.setTextClient((Control)toolBar.getParentComposite());
        this.metaclassViewer = new MetaclassViewer(leftPaneComposite, this.metaclassViewConfiguration, this.fMetamodelView);
        toolBar.setMetaclassViewer(this.metaclassViewer);
        GridData metaclassViewerGridData = new GridData();
        metaclassViewerGridData.grabExcessHorizontalSpace = true;
        metaclassViewerGridData.grabExcessVerticalSpace = true;
        metaclassViewerGridData.horizontalAlignment = 4;
        metaclassViewerGridData.verticalAlignment = 4;
        this.metaclassViewer.getViewer().getControl().setLayoutData((Object)metaclassViewerGridData);
        return leftPaneComposite;
    }

    private Composite createRightPane(Composite parent) {
        Section section = this.toolkit.createSection(parent, 320);
        section.setText(Messages.CustomizationEditor_sectionName_customizations);
        Composite rightPaneComposite = this.toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)rightPaneComposite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rightPaneComposite.setLayout((Layout)gridLayout);
        Composite middle = new Composite(rightPaneComposite, 0);
        GridLayout middleLayout = new GridLayout();
        middleLayout.marginHeight = 0;
        middleLayout.marginWidth = 0;
        middle.setLayout((Layout)middleLayout);
        middle.setLayoutData((Object)new GridData(4, 4, true, true));
        this.customizationViewer = new CustomizationViewer(middle);
        this.customizationViewer.getViewer().getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite optionsPane = this.toolkit.createComposite(middle);
        optionsPane.setLayout((Layout)new GridLayout());
        optionsPane.setLayoutData((Object)new GridData(4, 4, true, false));
        this.cbAppliesToSubinstances = this.toolkit.createButton(optionsPane, Messages.CustomizationEditor_appliesToSubInstances, 32);
        this.cbAppliesToSubinstances.setEnabled(false);
        this.cbAppliesToSubinstances.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.appliesToSubinstancesChanged(CustomizationEditor.this.cbAppliesToSubinstances.getSelection());
            }
        });
        if (this.readOnly) {
            this.cbAppliesToSubinstances.setEnabled(false);
        }
        GridData customizationViewerGridData = new GridData();
        customizationViewerGridData.grabExcessHorizontalSpace = true;
        customizationViewerGridData.grabExcessVerticalSpace = true;
        customizationViewerGridData.horizontalAlignment = 4;
        customizationViewerGridData.verticalAlignment = 4;
        this.customizationViewer.getViewer().getControl().setLayoutData((Object)customizationViewerGridData);
        if (!this.readOnly) {
            this.createButtonsPane(rightPaneComposite);
        }
        return rightPaneComposite;
    }

    private Composite createButtonsPane(Composite parent) {
        Composite buttonsPaneComposite = new Composite(parent, 0);
        GridData buttonsPaneGridData = new GridData();
        buttonsPaneGridData.grabExcessHorizontalSpace = false;
        buttonsPaneGridData.grabExcessVerticalSpace = true;
        buttonsPaneGridData.horizontalAlignment = 4;
        buttonsPaneGridData.verticalAlignment = 4;
        buttonsPaneComposite.setLayoutData((Object)buttonsPaneGridData);
        buttonsPaneComposite.setLayout((Layout)new GridLayout());
        Composite spacer1 = new Composite(buttonsPaneComposite, 0);
        GridData spacer1GridData = new GridData();
        spacer1GridData.heightHint = 10;
        spacer1.setLayoutData((Object)spacer1GridData);
        this.btnEditFeatureValue = new Button(buttonsPaneComposite, 8);
        this.btnEditFeatureValue.setText(Messages.CustomizationEditor_editFeatureValue);
        this.btnEditFeatureValue.setLayoutData(this.buttonsGridData());
        this.btnEditFeatureValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnEditFeatureValueClicked();
            }
        });
        this.btnResetDefaults = new Button(buttonsPaneComposite, 8);
        this.btnResetDefaults.setText(Messages.CustomizationEditor_resetDefaults);
        this.btnResetDefaults.setLayoutData(this.buttonsGridData());
        this.btnResetDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnResetDefaultsClicked();
            }
        });
        Composite spacer2 = new Composite(buttonsPaneComposite, 0);
        GridData spacer2GridData = new GridData();
        spacer2GridData.heightHint = 30;
        spacer2.setLayoutData((Object)spacer2GridData);
        Label lblConditions = new Label(buttonsPaneComposite, 0);
        lblConditions.setText(Messages.CustomizationEditor_conditions);
        this.btnAdd = new Button(buttonsPaneComposite, 8);
        this.btnAdd.setText(Messages.CustomizationEditor_add);
        this.btnAdd.setLayoutData(this.buttonsGridData());
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnAddClicked();
            }
        });
        this.btnEdit = new Button(buttonsPaneComposite, 8);
        this.btnEdit.setText(Messages.CustomizationEditor_edit);
        this.btnEdit.setLayoutData(this.buttonsGridData());
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnEditClicked();
            }
        });
        this.btnRemove = new Button(buttonsPaneComposite, 8);
        this.btnRemove.setText(Messages.CustomizationEditor_remove);
        this.btnRemove.setLayoutData(this.buttonsGridData());
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnRemoveClicked();
            }
        });
        this.btnUp = new Button(buttonsPaneComposite, 8);
        this.btnUp.setText(Messages.CustomizationEditor_up);
        this.btnUp.setLayoutData(this.buttonsGridData());
        this.btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnUpClicked();
            }
        });
        this.btnDown = new Button(buttonsPaneComposite, 8);
        this.btnDown.setText(Messages.CustomizationEditor_down);
        this.btnDown.setLayoutData(this.buttonsGridData());
        this.btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnDownClicked();
            }
        });
        return buttonsPaneComposite;
    }

    private Object buttonsGridData() {
        GridData buttonsGridData = new GridData();
        buttonsGridData.grabExcessHorizontalSpace = true;
        buttonsGridData.grabExcessVerticalSpace = false;
        buttonsGridData.horizontalAlignment = 4;
        buttonsGridData.verticalAlignment = 4;
        return buttonsGridData;
    }

    private MetaclassViewToolBar createToolBar(Composite parent) {
        Composite toolBarComposite = new Composite(parent, 0);
        GridData toolBarGridData = new GridData();
        toolBarGridData.grabExcessHorizontalSpace = true;
        toolBarGridData.horizontalAlignment = 4;
        toolBarComposite.setLayoutData((Object)toolBarGridData);
        return new MetaclassViewToolBar(toolBarComposite, this.metaclassViewConfiguration);
    }

    private void loadResource(java.net.URI locationURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.addResourceErrorsHandler((ResourceSet)resourceSet);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uiCustom", new XMIResourceFactoryImpl());
        URI uri = URI.createURI((String)locationURI.toString());
        Resource resource = resourceSet.createResource(uri);
        try {
            resource.load(null);
        }
        catch (IOException e) {
            Activator.logException("Error loading resource " + locationURI, e);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.CustomizationEditor_error, (String)Messages.CustomizationEditor_errorLoadingResource);
            throw new IllegalStateException("Model couldn't be loaded", e);
        }
        this.fMetamodelView = (MetamodelView)resource.getContents().get(0);
        this.convertToNewFormat(this.fMetamodelView);
    }

    private void convertToNewFormat(MetamodelView metamodelView) {
        try {
            boolean changed = false;
            for (TypeView typeView : metamodelView.getTypes()) {
                for (CustomViewFeature customViewFeature : typeView.getCustomizedFeatures()) {
                    if (customViewFeature.getCustomizedFeature() != CustomizableFeatures.FACET_MAIN_ICON) continue;
                    changed = true;
                    customViewFeature.setCustomizedFeature(CustomizableFeatures.INSTANCE_ICON);
                }
                EList attributes = typeView.getAttributes();
                for (AttributeView attributeView : attributes) {
                    EList customizedFeatures = attributeView.getCustomizedFeatures();
                    for (CustomViewFeature customAttributeFeature : customizedFeatures) {
                        if (customAttributeFeature.getCustomizedFeature() != CustomizableFeatures.ICON) continue;
                        changed = true;
                        customAttributeFeature.setCustomizedFeature(CustomizableFeatures.INSTANCE_ICON);
                    }
                }
                EList references = typeView.getReferences();
                for (ReferenceView referenceView : references) {
                    EList customizedFeatures = referenceView.getCustomizedFeatures();
                    for (CustomViewFeature customReferenceFeature : customizedFeatures) {
                        if (customReferenceFeature.getCustomizedFeature() != CustomizableFeatures.ICON) continue;
                        changed = true;
                        customReferenceFeature.setCustomizedFeature(CustomizableFeatures.INSTANCE_ICON);
                    }
                }
            }
            if (changed) {
                this.setDirty(true);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openInformation((Shell)CustomizationEditor.this.getSite().getShell(), (String)Messages.CustomizationEditor_customizationConverted, (String)Messages.CustomizationEditor_customizationConvertedLong);
                    }
                });
            }
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Error converting customization to new format", (Plugin)Activator.getDefault());
        }
    }

    private void addResourceErrorsHandler(ResourceSet resourceSet) {
        resourceSet.eAdapters().add((Object)new EContentAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void notifyChanged(Notification notification) {
                if (notification.getNotifier() instanceof Resource) {
                    switch (notification.getFeatureID(Resource.class)) {
                        case 4: 
                        case 6: 
                        case 7: {
                            Resource resource = (Resource)notification.getNotifier();
                            if (resource.getErrors().isEmpty()) return;
                            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.gmt.modisco.infra.ui.browser.custom.editor", 0, NLS.bind((String)Messages.CustomizationEditor_problemsInFile, (Object)resource.getURI()), new Object[]{resource});
                            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
                            CustomizationEditor.this.fDiagnostic = (Diagnostic)basicDiagnostic;
                            if (CustomizationEditor.this.errorsButton == null) return;
                            CustomizationEditor.this.errorsButton.setVisible(true);
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    super.notifyChanged(notification);
                }
            }

            protected void setTarget(Resource target) {
                this.basicSetTarget((Notifier)target);
            }

            protected void unsetTarget(Resource targetResource) {
                this.basicUnsetTarget((Notifier)targetResource);
            }
        });
    }

    private void metaclassSelectionChanged(Object selectedElement) {
        this.cbAppliesToSubinstances.setEnabled(false);
        this.cbAppliesToSubinstances.setSelection(false);
        if (selectedElement == null) {
            this.customizationViewer.setInput(null);
            return;
        }
        TypeView customView = null;
        if (selectedElement instanceof EClass) {
            EClass eClass = (EClass)selectedElement;
            customView = this.findOrCreateTypeView(eClass);
            if (!this.readOnly) {
                this.cbAppliesToSubinstances.setEnabled(true);
            }
            this.cbAppliesToSubinstances.setSelection(customView.isAppliesToSubInstances());
        } else if (selectedElement instanceof MetaclassViewer.Attribute) {
            MetaclassViewer.Attribute attribute = (MetaclassViewer.Attribute)selectedElement;
            customView = this.findOrCreateAttributeView(attribute.getEClass(), attribute.getEAttribute());
        } else if (selectedElement instanceof MetaclassViewer.Reference) {
            MetaclassViewer.Reference reference = (MetaclassViewer.Reference)selectedElement;
            customView = this.findOrCreateReferenceView(reference.getEClass(), reference.getEReference());
        } else {
            throw new IllegalStateException("Unexpected element type: " + selectedElement.getClass().getSimpleName());
        }
        EList customizedFeatures = customView.getCustomizedFeatures();
        CustomizableFeatures[] customizableFeaturesArray = CustomizableFeatures.values();
        int n = customizableFeaturesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomizableFeatures feature = customizableFeaturesArray[n2];
            if (this.appliesTo(feature, selectedElement)) {
                boolean present = false;
                for (CustomViewFeature customViewFeature : customizedFeatures) {
                    if (!customViewFeature.getCustomizedFeature().equals((Object)feature)) continue;
                    present = true;
                    break;
                }
                if (!present) {
                    CustomViewFeature newCustomViewFeature = UicustomFactory.eINSTANCE.createCustomViewFeature();
                    newCustomViewFeature.setCustomizedFeature(feature);
                    customizedFeatures.add((Object)newCustomViewFeature);
                }
            }
            ++n2;
        }
        this.customizationViewer.setInput(customView);
    }

    private boolean appliesTo(CustomizableFeatures feature, Object selectedElement) {
        if (feature == CustomizableFeatures.FACET_MAIN_ICON) {
            return false;
        }
        if (feature == CustomizableFeatures.ICON && (selectedElement instanceof MetaclassViewer.Attribute || selectedElement instanceof MetaclassViewer.Reference)) {
            return false;
        }
        if (selectedElement instanceof Facet) {
            switch (feature) {
                case ICON: 
                case FACET_OVERLAY_ICON: 
                case METACLASS_VISIBLE: 
                case METACLASS_ICON: 
                case STICKER_ICON: {
                    return true;
                }
            }
            return false;
        }
        switch (feature) {
            case HIDE_METACLASS_NAME: 
            case METACLASS_VISIBLE: {
                return selectedElement instanceof EClass;
            }
            case FACET_MAIN_ICON: 
            case FACET_OVERLAY_ICON: 
            case STICKER_ICON: {
                return true;
            }
            case COLLAPSE_LINK: {
                return selectedElement instanceof MetaclassViewer.Reference;
            }
        }
        return true;
    }

    private TypeView findOrCreateTypeView(EClass eClass) {
        TypeView typeView2;
        String className = ModelUtils.getMetaclassQualifiedName((EClassifier)eClass);
        if (className == null) {
            return null;
        }
        EList types = this.fMetamodelView.getTypes();
        for (TypeView typeView2 : types) {
            if (!className.equals(typeView2.getMetaclassName())) continue;
            return typeView2;
        }
        typeView2 = UicustomFactory.eINSTANCE.createTypeView();
        typeView2.setMetaclassName(className);
        this.fMetamodelView.getTypes().add((Object)typeView2);
        return typeView2;
    }

    private AttributeView findOrCreateAttributeView(EClass eClass, EAttribute attribute) {
        AttributeView attributeView2;
        TypeView typeView = this.findOrCreateTypeView(eClass);
        String attributeName = attribute.getName();
        EList attributeViews = typeView.getAttributes();
        for (AttributeView attributeView2 : attributeViews) {
            if (!attributeName.equals(attributeView2.getAttributeName())) continue;
            return attributeView2;
        }
        attributeView2 = UicustomFactory.eINSTANCE.createAttributeView();
        attributeView2.setAttributeName(attributeName);
        typeView.getAttributes().add((Object)attributeView2);
        return attributeView2;
    }

    private ReferenceView findOrCreateReferenceView(EClass eClass, EReference reference) {
        ReferenceView referenceView2;
        TypeView typeView = this.findOrCreateTypeView(eClass);
        String referenceName = reference.getName();
        EList referenceViews = typeView.getReferences();
        for (ReferenceView referenceView2 : referenceViews) {
            if (!referenceName.equals(referenceView2.getReferenceName())) continue;
            return referenceView2;
        }
        referenceView2 = UicustomFactory.eINSTANCE.createReferenceView();
        referenceView2.setReferenceName(referenceName);
        typeView.getReferences().add((Object)referenceView2);
        return referenceView2;
    }

    protected void customizationSelectionChanged(Object selectedElement) {
        this.buttonsEnablementForSelection(selectedElement);
    }

    private void buttonsEnablementForSelection(Object selectedElement) {
        if (this.readOnly) {
            return;
        }
        if (selectedElement == null) {
            this.btnEditFeatureValue.setEnabled(false);
            this.btnAdd.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else if (selectedElement instanceof CustomViewFeature) {
            this.btnEditFeatureValue.setEnabled(true);
            this.btnAdd.setEnabled(true);
            this.btnEdit.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else if (selectedElement instanceof FeatureValueCase) {
            FeatureValueCase featureValueCase = (FeatureValueCase)selectedElement;
            this.btnEditFeatureValue.setEnabled(false);
            this.btnAdd.setEnabled(false);
            this.btnEdit.setEnabled(true);
            this.btnUp.setEnabled(!this.isFirst(featureValueCase));
            this.btnDown.setEnabled(!this.isLast(featureValueCase));
            this.btnRemove.setEnabled(true);
        }
    }

    private boolean isFirst(FeatureValueCase featureValueCase) {
        EList valueCases = featureValueCase.getFeature().getValueCases();
        return valueCases.size() > 0 && ((FeatureValueCase)valueCases.get(0)).equals(featureValueCase);
    }

    private boolean isLast(FeatureValueCase featureValueCase) {
        EList valueCases = featureValueCase.getFeature().getValueCases();
        return valueCases.size() > 0 && ((FeatureValueCase)valueCases.get(valueCases.size() - 1)).equals(featureValueCase);
    }

    private Object getSelectedElement() {
        ITreeSelection selection = (ITreeSelection)this.customizationViewer.getSelection();
        return selection.getFirstElement();
    }

    private void btnEditFeatureValueClicked() {
        if (this.readOnly) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof CustomViewFeature) {
            EClass customizedMetaclass;
            CustomViewFeature customViewFeature = (CustomViewFeature)selectedElement;
            CustomizableFeatures customizedFeature = customViewFeature.getCustomizedFeature();
            EditFeatureValueDialog editFeatureValueDialog = this.createDialogFor(customizedFeature, false, true, customizedMetaclass = this.findCustomizedMetaclass(customViewFeature));
            if (editFeatureValueDialog == null) {
                return;
            }
            FeatureValue defaultValue = customViewFeature.getDefaultValue();
            if (defaultValue instanceof StaticFeatureValue) {
                editFeatureValueDialog.setSelectedValueType(EditFeatureValueDialog.ValueType.STATIC);
                StaticFeatureValue staticFeatureValue = (StaticFeatureValue)defaultValue;
                editFeatureValueDialog.setInitialStaticValue(staticFeatureValue.getValue());
            } else if (defaultValue instanceof DerivedFeatureValue) {
                editFeatureValueDialog.setSelectedValueType(EditFeatureValueDialog.ValueType.DERIVED);
                DerivedFeatureValue derivedFeatureValue = (DerivedFeatureValue)defaultValue;
                ModelQuery valueCalculator = derivedFeatureValue.getValueCalculator();
                if (EMFUtil.tryResolve((EObject)valueCalculator)) {
                    editFeatureValueDialog.setSelectedQuery(valueCalculator.getModelQuerySet().getName(), valueCalculator.getName());
                }
            } else {
                editFeatureValueDialog.setSelectedValueType(EditFeatureValueDialog.ValueType.DEFAULT);
            }
            editFeatureValueDialog.open();
            if (editFeatureValueDialog.getReturnCode() == 0) {
                String selectedQueryName;
                String selectedQuerySetName;
                ModelQuery modelQuery;
                EditFeatureValueDialog.ValueType selectedValueType = editFeatureValueDialog.getSelectedValueType();
                if (selectedValueType == EditFeatureValueDialog.ValueType.STATIC) {
                    String staticValue = editFeatureValueDialog.getStaticValue();
                    if (staticValue != null) {
                        StaticFeatureValue value = UicustomFactory.eINSTANCE.createStaticFeatureValue();
                        value.setValue(staticValue);
                        Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)customViewFeature, (Object)UicustomPackage.eINSTANCE.getCustomViewFeature_DefaultValue(), (Object)value);
                        this.editingDomain.getCommandStack().execute(command);
                    }
                } else if (selectedValueType == EditFeatureValueDialog.ValueType.DEFAULT) {
                    Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)customViewFeature, (Object)UicustomPackage.eINSTANCE.getCustomViewFeature_DefaultValue(), null);
                    this.editingDomain.getCommandStack().execute(command);
                } else if (selectedValueType == EditFeatureValueDialog.ValueType.DERIVED && (modelQuery = this.findModelQuery(selectedQuerySetName = editFeatureValueDialog.getSelectedQuerySetName(), selectedQueryName = editFeatureValueDialog.getSelectedQueryName())) != null) {
                    DerivedFeatureValue value = UicustomFactory.eINSTANCE.createDerivedFeatureValue();
                    value.setValueCalculator(modelQuery);
                    Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)customViewFeature, (Object)UicustomPackage.eINSTANCE.getCustomViewFeature_DefaultValue(), (Object)value);
                    this.editingDomain.getCommandStack().execute(command);
                }
            }
        }
        this.refresh();
    }

    private void btnResetDefaultsClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.metaclassViewer.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof EClass) {
            EClass eClass = (EClass)selectedElement;
            TypeView typeView = this.findOrCreateTypeView(eClass);
            this.resetDefaults((CustomView)typeView);
        } else if (selectedElement instanceof MetaclassViewer.Attribute) {
            MetaclassViewer.Attribute attribute = (MetaclassViewer.Attribute)selectedElement;
            AttributeView customView = this.findOrCreateAttributeView(attribute.getEClass(), attribute.getEAttribute());
            this.resetDefaults((CustomView)customView);
        } else if (selectedElement instanceof MetaclassViewer.Reference) {
            MetaclassViewer.Reference reference = (MetaclassViewer.Reference)selectedElement;
            ReferenceView customView = this.findOrCreateReferenceView(reference.getEClass(), reference.getEReference());
            this.resetDefaults((CustomView)customView);
        }
    }

    private void resetDefaults(CustomView customView) {
        EList customizedFeatures = customView.getCustomizedFeatures();
        CompoundCommand compoundCommand = new CompoundCommand();
        for (CustomViewFeature customViewFeature : customizedFeatures) {
            if (!customViewFeature.getValueCases().isEmpty()) {
                Command removeCommand = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)customViewFeature, (Object)UicustomPackage.eINSTANCE.getCustomViewFeature_ValueCases(), (Collection)customViewFeature.getValueCases());
                compoundCommand.append(removeCommand);
            }
            Command setCommand = SetCommand.create((EditingDomain)this.editingDomain, (Object)customViewFeature, (Object)UicustomPackage.eINSTANCE.getCustomViewFeature_DefaultValue(), null);
            compoundCommand.append(setCommand);
        }
        compoundCommand.setLabel(Messages.CustomizationEditor_resetDefaults);
        this.editingDomain.getCommandStack().execute((Command)compoundCommand);
    }

    private ModelQuery findModelQuery(String querySetName, String queryName) {
        ModelQuerySet modelQuerySet = ModelQuerySetCatalog.getSingleton().getModelQuerySet(querySetName);
        if (modelQuerySet != null) {
            EList queries = modelQuerySet.getQueries();
            ModelQuery query = null;
            for (ModelQuery modelQuery : queries) {
                if (!modelQuery.getName().equals(queryName)) continue;
                query = modelQuery;
                break;
            }
            if (query == null) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.CustomizationEditor_nonExistingQuery, (String)NLS.bind((String)Messages.CustomizationEditor_missingQuery, (Object)queryName, (Object)querySetName));
                return null;
            }
            return query;
        }
        MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.CustomizationEditor_nonExistingQuerySet, (String)NLS.bind((String)Messages.CustomizationEditor_missingQuerySet, (Object)querySetName));
        return null;
    }

    private EditFeatureValueDialog createDialogFor(CustomizableFeatures customizedFeature, boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        switch (customizedFeature) {
            case BOLD: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_bold, withCondition, withDefault, customizedMetaclass);
            }
            case ITALIC: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_italic, withCondition, withDefault, customizedMetaclass);
            }
            case STRUCKTHROUGH: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_strikethrough, withCondition, withDefault, customizedMetaclass);
            }
            case UNDERLINED: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_underlined, withCondition, withDefault, customizedMetaclass);
            }
            case VISIBLE: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_visible, withCondition, withDefault, customizedMetaclass);
            }
            case METACLASS_VISIBLE: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_metaclassVisible, withCondition, withDefault, customizedMetaclass);
            }
            case LABEL: {
                return this.createTextFeatureDialog(Messages.CustomizationEditor_text, withCondition, withDefault, customizedMetaclass);
            }
            case COLOR: 
            case BACKGROUND_COLOR: {
                return this.createColorFeatureDialog(withCondition, withDefault, customizedMetaclass);
            }
            case ICON: 
            case FACET_MAIN_ICON: 
            case METACLASS_ICON: 
            case INSTANCE_ICON: 
            case STICKER_ICON: {
                return this.createIconFeatureDialog(withCondition, withDefault, customizedMetaclass);
            }
            case FACET_OVERLAY_ICON: {
                return this.createOverlayIconFeatureDialog(withCondition, withDefault, customizedMetaclass);
            }
            case FONT_NAME: {
                return this.createFontFeatureDialog(withCondition, withDefault, customizedMetaclass);
            }
            case HIDE_METACLASS_NAME: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_hideMetaclassName, withCondition, withDefault, customizedMetaclass);
            }
            case COLLAPSE_LINK: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_collapseLink, withCondition, withDefault, customizedMetaclass);
            }
        }
        Activator.logError("Unhandled CustomizableFeature : " + customizedFeature.getName());
        return null;
    }

    private List<String> getAvailableQuerySets() {
        if (this.fMetamodelView.isAllQuerySetsAvailable()) {
            return null;
        }
        return this.fMetamodelView.getAvailableQuerySets();
    }

    private List<Class<?>> returnTypes(Class<?> ... types) {
        ArrayList returnTypes = new ArrayList();
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            returnTypes.add(clazz);
            ++n2;
        }
        return returnTypes;
    }

    private EditFeatureValueDialog createBooleanFeatureDialog(String text, boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        return new BooleanFeatureDialog(this.getSite().getShell(), withCondition, withDefault, this.getAvailableQuerySets(), this.returnTypes(Boolean.class, Boolean.TYPE), customizedMetaclass, text);
    }

    private EditFeatureValueDialog createTextFeatureDialog(String labelText, boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        return new TextFeatureDialog(this.getSite().getShell(), withCondition, withDefault, this.getAvailableQuerySets(), this.returnTypes(String.class), customizedMetaclass, labelText);
    }

    private EditFeatureValueDialog createColorFeatureDialog(boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        return new ColorFeatureDialog(this.getSite().getShell(), withCondition, withDefault, this.getAvailableQuerySets(), this.returnTypes(String.class), customizedMetaclass);
    }

    private EditFeatureValueDialog createIconFeatureDialog(boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        return new IconFeatureDialog(this.getSite().getShell(), withCondition, withDefault, this.getAvailableQuerySets(), this.returnTypes(String.class), customizedMetaclass);
    }

    private EditFeatureValueDialog createOverlayIconFeatureDialog(boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        return new OverlayIconFeatureDialog(this.getSite().getShell(), withCondition, withDefault, this.getAvailableQuerySets(), this.returnTypes(String.class), customizedMetaclass);
    }

    private EditFeatureValueDialog createFontFeatureDialog(boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        return new FontFeatureDialog(this.getSite().getShell(), withCondition, withDefault, this.getAvailableQuerySets(), this.returnTypes(String.class), customizedMetaclass);
    }

    private void btnAddClicked() {
        if (this.readOnly) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof CustomViewFeature) {
            CustomViewFeature customViewFeature = (CustomViewFeature)selectedElement;
            CustomizableFeatures customizedFeature = customViewFeature.getCustomizedFeature();
            EClass customizedMetaclass = this.findCustomizedMetaclass(customViewFeature);
            EditFeatureValueDialog editFeatureValueDialog = this.createDialogFor(customizedFeature, true, false, customizedMetaclass);
            FeatureValueCase newValueCase = null;
            if (editFeatureValueDialog != null) {
                editFeatureValueDialog.open();
                if (editFeatureValueDialog.getReturnCode() == 0) {
                    EditFeatureValueDialog.ValueType selectedValueType = editFeatureValueDialog.getSelectedValueType();
                    if (selectedValueType == EditFeatureValueDialog.ValueType.STATIC) {
                        ModelQuery conditionQuery;
                        String staticValue = editFeatureValueDialog.getStaticValue();
                        if (staticValue != null && (conditionQuery = this.findModelQuery(editFeatureValueDialog.getSelectedConditionQuerySetName(), editFeatureValueDialog.getSelectedConditionQueryName())) != null) {
                            StaticFeatureValue value = UicustomFactory.eINSTANCE.createStaticFeatureValue();
                            value.setValue(staticValue);
                            newValueCase = UicustomFactory.eINSTANCE.createFeatureValueCase();
                            newValueCase.setValue((FeatureValue)value);
                            newValueCase.setCondition(conditionQuery);
                            Command command = AddCommand.create((EditingDomain)this.editingDomain, (Object)customViewFeature, (Object)UicustomPackage.eINSTANCE.getCustomViewFeature_ValueCases(), (Object)newValueCase);
                            this.editingDomain.getCommandStack().execute(command);
                        }
                    } else if (selectedValueType == EditFeatureValueDialog.ValueType.DERIVED) {
                        ModelQuery conditionQuery = this.findModelQuery(editFeatureValueDialog.getSelectedConditionQuerySetName(), editFeatureValueDialog.getSelectedConditionQueryName());
                        ModelQuery query = this.findModelQuery(editFeatureValueDialog.getSelectedQuerySetName(), editFeatureValueDialog.getSelectedQueryName());
                        if (conditionQuery != null && query != null) {
                            DerivedFeatureValue value = UicustomFactory.eINSTANCE.createDerivedFeatureValue();
                            value.setValueCalculator(query);
                            newValueCase = UicustomFactory.eINSTANCE.createFeatureValueCase();
                            newValueCase.setValue((FeatureValue)value);
                            newValueCase.setCondition(conditionQuery);
                            Command command = AddCommand.create((EditingDomain)this.editingDomain, (Object)customViewFeature, (Object)UicustomPackage.eINSTANCE.getCustomViewFeature_ValueCases(), (Object)newValueCase);
                            this.editingDomain.getCommandStack().execute(command);
                        }
                    }
                }
            }
            this.refresh();
            if (newValueCase != null) {
                this.customizationViewer.getViewer().setSelection((ISelection)new StructuredSelection(newValueCase), true);
            }
        }
    }

    private EClass findCustomizedMetaclass(CustomViewFeature customViewFeature) {
        CustomView customView = customViewFeature.getCustomView();
        List metaclasses = EMFUtil.getMetaclasses((Resource)this.fMetamodel);
        if (customView instanceof TypeView) {
            TypeView typeView = (TypeView)customView;
            return EMFUtil.findMetaclassWithName((String)typeView.getMetaclassName(), (List)metaclasses);
        }
        if (customView instanceof AttributeView) {
            AttributeView attributeView = (AttributeView)customView;
            return EMFUtil.findMetaclassWithName((String)attributeView.getType().getMetaclassName(), (List)metaclasses);
        }
        if (customView instanceof ReferenceView) {
            ReferenceView referenceView = (ReferenceView)customView;
            return EMFUtil.findMetaclassWithName((String)referenceView.getType().getMetaclassName(), (List)metaclasses);
        }
        throw new IllegalStateException("Unknown CustomView type: " + customView.getClass().getSimpleName());
    }

    private void btnEditClicked() {
        if (this.readOnly) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof FeatureValueCase) {
            FeatureValueCase featureValueCase = (FeatureValueCase)selectedElement;
            CustomViewFeature customViewFeature = featureValueCase.getFeature();
            CustomizableFeatures customizedFeature = customViewFeature.getCustomizedFeature();
            EClass customizedMetaclass = this.findCustomizedMetaclass(customViewFeature);
            EditFeatureValueDialog editFeatureValueDialog = this.createDialogFor(customizedFeature, true, false, customizedMetaclass);
            FeatureValue featureValue = featureValueCase.getValue();
            if (featureValue instanceof StaticFeatureValue) {
                StaticFeatureValue staticFeatureValue = (StaticFeatureValue)featureValue;
                editFeatureValueDialog.setSelectedValueType(EditFeatureValueDialog.ValueType.STATIC);
                editFeatureValueDialog.setInitialStaticValue(staticFeatureValue.getValue());
            } else if (featureValue instanceof DerivedFeatureValue) {
                DerivedFeatureValue derivedFeatureValue = (DerivedFeatureValue)featureValue;
                editFeatureValueDialog.setSelectedValueType(EditFeatureValueDialog.ValueType.DERIVED);
                ModelQuery valueCalculator = derivedFeatureValue.getValueCalculator();
                if (EMFUtil.tryResolve((EObject)valueCalculator)) {
                    editFeatureValueDialog.setSelectedQuery(valueCalculator.getModelQuerySet().getName(), valueCalculator.getName());
                }
            }
            ModelQuery condition = featureValueCase.getCondition();
            if (condition != null && EMFUtil.tryResolve((EObject)condition)) {
                editFeatureValueDialog.setSelectedConditionQuery(condition.getModelQuerySet().getName(), condition.getName());
            }
            if (editFeatureValueDialog != null) {
                editFeatureValueDialog.open();
                if (editFeatureValueDialog.getReturnCode() == 0) {
                    EditFeatureValueDialog.ValueType selectedValueType = editFeatureValueDialog.getSelectedValueType();
                    if (selectedValueType == EditFeatureValueDialog.ValueType.STATIC) {
                        String staticValue = editFeatureValueDialog.getStaticValue();
                        if (staticValue != null) {
                            StaticFeatureValue value = UicustomFactory.eINSTANCE.createStaticFeatureValue();
                            value.setValue(staticValue);
                            Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)featureValueCase, (Object)UicustomPackage.eINSTANCE.getFeatureValueCase_Value(), (Object)value);
                            this.editingDomain.getCommandStack().execute(command);
                        }
                    } else if (selectedValueType == EditFeatureValueDialog.ValueType.DERIVED) {
                        DerivedFeatureValue value = UicustomFactory.eINSTANCE.createDerivedFeatureValue();
                        ModelQuery query = this.findModelQuery(editFeatureValueDialog.getSelectedQuerySetName(), editFeatureValueDialog.getSelectedQueryName());
                        ModelQuery conditionQuery = this.findModelQuery(editFeatureValueDialog.getSelectedConditionQuerySetName(), editFeatureValueDialog.getSelectedConditionQueryName());
                        if (query != null && conditionQuery != null) {
                            value.setValueCalculator(query);
                            featureValueCase.setCondition(conditionQuery);
                            Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)featureValueCase, (Object)UicustomPackage.eINSTANCE.getFeatureValueCase_Value(), (Object)value);
                            this.editingDomain.getCommandStack().execute(command);
                        }
                    }
                }
            }
        }
        this.refresh();
    }

    private void btnRemoveClicked() {
        if (this.readOnly) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof FeatureValueCase) {
            FeatureValueCase featureValueCase = (FeatureValueCase)selectedElement;
            Command command = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)featureValueCase.getFeature(), (Object)UicustomPackage.eINSTANCE.getCustomViewFeature_ValueCases(), (Object)featureValueCase);
            this.editingDomain.getCommandStack().execute(command);
        }
    }

    private void btnUpClicked() {
        if (this.readOnly) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof FeatureValueCase) {
            FeatureValueCase featureValueCase = (FeatureValueCase)selectedElement;
            EList list = featureValueCase.getFeature().getValueCases();
            int index = list.indexOf((Object)featureValueCase);
            if (index - 1 >= 0) {
                Command command = MoveCommand.create((EditingDomain)this.editingDomain, (Object)featureValueCase.getFeature(), (Object)UicustomPackage.eINSTANCE.getCustomViewFeature_ValueCases(), (Object)list.get(index), (int)(index - 1));
                this.editingDomain.getCommandStack().execute(command);
            }
            this.refresh();
        }
    }

    private void btnDownClicked() {
        if (this.readOnly) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof FeatureValueCase) {
            FeatureValueCase featureValueCase = (FeatureValueCase)selectedElement;
            EList list = featureValueCase.getFeature().getValueCases();
            int index = list.indexOf((Object)featureValueCase);
            if (index + 1 < list.size()) {
                Command command = MoveCommand.create((EditingDomain)this.editingDomain, (Object)featureValueCase.getFeature(), (Object)UicustomPackage.eINSTANCE.getCustomViewFeature_ValueCases(), (Object)list.get(index), (int)(index + 1));
                this.editingDomain.getCommandStack().execute(command);
            }
            this.refresh();
        }
    }

    private void appliesToSubinstancesChanged(boolean newValue) {
        IStructuredSelection selection = (IStructuredSelection)this.metaclassViewer.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof EClass) {
            EClass eClass = (EClass)selectedElement;
            TypeView typeView = this.findOrCreateTypeView(eClass);
            Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)typeView, (Object)UicustomPackage.eINSTANCE.getTypeView_AppliesToSubInstances(), (Object)newValue);
            this.editingDomain.getCommandStack().execute(command);
        }
    }

    private void updateSubinstancesChangedCheckbox() {
        IStructuredSelection selection = (IStructuredSelection)this.metaclassViewer.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof EClass) {
            EClass eClass = (EClass)selectedElement;
            TypeView typeView = this.findOrCreateTypeView(eClass);
            this.cbAppliesToSubinstances.setSelection(typeView.isAppliesToSubInstances());
        }
    }

    private void refresh() {
        this.customizationViewer.refresh();
        this.metaclassViewer.refresh();
        this.buttonsEnablementForSelection(this.getSelectedElement());
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.readOnly) {
            return;
        }
        IFileEditorInput fileEditorInput = (IFileEditorInput)this.getEditorInput();
        String fileURI = fileEditorInput.getFile().getFullPath().toString();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uiCustom", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createPlatformResourceURI((String)fileURI, (boolean)true));
        MetamodelView metamodelViewCopy = (MetamodelView)EcoreUtil.copy((EObject)this.fMetamodelView);
        resource.getContents().add((Object)this.cleanModel(metamodelViewCopy));
        try {
            this.resourceChangeListener.setEditorSaved(true);
            resource.save(null);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.setDirty(false);
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    private MetamodelView cleanModel(MetamodelView metamodelView) {
        ListIterator typesIterator = metamodelView.getTypes().listIterator();
        while (typesIterator.hasNext()) {
            TypeView typeView = (TypeView)typesIterator.next();
            boolean containsInformation = true;
            if (!this.clean((CustomView)typeView)) {
                containsInformation = false;
            }
            ListIterator attributesIterator = typeView.getAttributes().listIterator();
            while (attributesIterator.hasNext()) {
                AttributeView attributeView = (AttributeView)attributesIterator.next();
                if (this.clean((CustomView)attributeView)) {
                    containsInformation = true;
                    continue;
                }
                attributesIterator.remove();
            }
            ListIterator referencesIterator = typeView.getReferences().listIterator();
            while (referencesIterator.hasNext()) {
                ReferenceView referenceView = (ReferenceView)referencesIterator.next();
                if (this.clean((CustomView)referenceView)) {
                    containsInformation = true;
                    continue;
                }
                referencesIterator.remove();
            }
            if (containsInformation) continue;
            typesIterator.remove();
        }
        return metamodelView;
    }

    private boolean clean(CustomView customView) {
        EList customizedFeatures = customView.getCustomizedFeatures();
        ListIterator featuresIterator = customizedFeatures.listIterator();
        while (featuresIterator.hasNext()) {
            CustomViewFeature customViewFeature = (CustomViewFeature)featuresIterator.next();
            if (customViewFeature.getDefaultValue() != null || customViewFeature.getValueCases().size() != 0) continue;
            featuresIterator.remove();
        }
        return customizedFeatures.size() > 0;
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dirty && !this.readOnly;
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.toolkit.dispose();
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if ((marker.getType().equals("org.eclipse.emf.ecore.diagnostic") || marker.getType().equals(AbstractMoDiscoCatalog.BROKEN_REF_MARKER)) && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.fMetamodelView.eResource().getEObject(uri.fragment());
                if (eObject != null && eObject instanceof FeatureValue) {
                    FeatureValueCase valueCase;
                    FeatureValue featureValue = (FeatureValue)eObject;
                    CustomViewFeature feature = featureValue.getFeature();
                    if (feature != null) {
                        CustomView customView = feature.getCustomView();
                        this.metaclassViewer.select(customView);
                        this.customizationViewer.getViewer().setSelection((ISelection)new StructuredSelection((Object)feature), true);
                    }
                    if ((valueCase = featureValue.getCase()) != null) {
                        CustomView customView = valueCase.getFeature().getCustomView();
                        this.metaclassViewer.select(customView);
                        this.customizationViewer.getViewer().setSelection((ISelection)new StructuredSelection((Object)valueCase), true);
                    }
                }
            }
        }
        catch (CoreException exception) {
            MoDiscoLogger.logError((Throwable)exception, (Plugin)Activator.getDefault());
        }
    }

    public MetamodelView getMetamodelView() {
        return this.fMetamodelView;
    }

    public void setResourceDeleted(boolean value) {
        this.resourceDeleted = value;
    }

    public void setResourceChanged(boolean value) {
        this.resourceChanged = value;
    }

    protected void handleActivate() {
        if (this.resourceDeleted) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.resourceDeleted = false;
                this.resourceChanged = false;
                this.setDirty(true);
            }
        } else if (this.resourceChanged) {
            this.resourceChanged = false;
            this.handleChangedResources();
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.CustomizationEditor_fileConflict, (String)Messages.CustomizationEditor_conflictingUnsavedChanges);
    }

    protected void handleChangedResources() {
        try {
            if (!this.isDirty() || this.handleDirtyConflict()) {
                Resource metamodel;
                this.editingDomain.getCommandStack().flush();
                ISelection selection = this.metaclassViewer.getSelection();
                this.loadResource(new java.net.URI(this.fMetamodelView.eResource().getURI().toString()));
                this.fMetamodel = metamodel = this.initMetamodel(this.fMetamodelView.getMetamodelURI());
                this.metaclassViewer.setMetamodelView(this.fMetamodelView);
                this.metaclassViewer.getViewer().setSelection(selection, true);
                this.refresh();
                this.refreshHeader();
            }
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private class ChangeMetamodelCommand
    extends AbstractOverrideableCommand {
        private final String newMetamodelURI;
        private String oldMetamodelURI;

        protected ChangeMetamodelCommand(EditingDomain domain, String newMetamodelURI) {
            super(domain);
            this.newMetamodelURI = newMetamodelURI;
        }

        protected boolean prepare() {
            this.oldMetamodelURI = CustomizationEditor.this.fMetamodel.getURI().toString();
            return true;
        }

        public void doExecute() {
            final Resource newMetamodel = CustomizationEditor.this.initMetamodel(this.newMetamodelURI);
            CustomizationEditor.this.fMetamodel = newMetamodel;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    CustomizationEditor.this.promptToCleanCustomization(newMetamodel);
                }
            });
        }

        public void doUndo() {
            Resource oldMetamodel = CustomizationEditor.this.initMetamodel(this.oldMetamodelURI);
            CustomizationEditor.this.fMetamodel = oldMetamodel;
        }

        public void doRedo() {
            Resource newMetamodel = CustomizationEditor.this.initMetamodel(this.newMetamodelURI);
            CustomizationEditor.this.fMetamodel = newMetamodel;
        }
    }

    private class SaveSettingsOnCloseListener
    implements IPartListener {
        private SaveSettingsOnCloseListener() {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == CustomizationEditor.this) {
                CustomizationEditor.this.metaclassViewConfiguration.save();
                CustomizationEditor.this.getSite().getPage().removePartListener((IPartListener)this);
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    }
}

