/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.FeatureCall;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionExpression
extends FeatureCall {
    private Expression closure;
    private Identifier eleName;

    public CollectionExpression(Identifier name, Identifier eleName, Expression closure) {
        super(name, null);
        this.eleName = eleName;
        this.closure = closure;
    }

    @Override
    protected String toStringInternal() {
        return String.valueOf(super.toStringInternal()) + "(" + (this.eleName != null ? String.valueOf(this.eleName.getValue()) + "|" : "") + this.closure + ")";
    }

    public Expression getClosure() {
        return this.closure;
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Object targetObj = null;
        if (this.getTarget() == null) {
            Variable v = ctx.getVariable("this");
            if (v != null) {
                targetObj = v.getValue();
            }
        } else {
            targetObj = this.getTarget().evaluate(ctx);
        }
        if (targetObj == null) {
            return ctx.handleNullEvaluation(this);
        }
        if (!(targetObj instanceof Collection)) {
            throw new EvaluationException("Couldn't call '" + this.toString() + "' on an object of java type " + targetObj.getClass().getName(), (SyntaxElement)this, ctx);
        }
        if (this.getName().getValue().equals("collect")) {
            return this.executeCollect((Collection)targetObj, ctx);
        }
        if (this.getName().getValue().equals("select")) {
            return this.executeSelect((Collection)targetObj, ctx);
        }
        if (this.getName().getValue().equals("selectFirst")) {
            return this.executeSelectFirst((Collection)targetObj, ctx);
        }
        if (this.getName().getValue().equals("reject")) {
            return this.executeReject((Collection)targetObj, ctx);
        }
        if (this.getName().getValue().equals("exists")) {
            return this.executeExists((Collection)targetObj, ctx);
        }
        if (this.getName().getValue().equals("notExists")) {
            return this.executeNotExists((Collection)targetObj, ctx);
        }
        if (this.getName().getValue().equals("forAll")) {
            return this.executeForAll((Collection)targetObj, ctx);
        }
        if (this.getName().getValue().equals("sortBy")) {
            return this.executeSortBy((Collection)targetObj, ctx);
        }
        throw new EvaluationException("Unknown collection operation : " + this.getName().getValue(), (SyntaxElement)this, ctx);
    }

    private Object executeSortBy(Collection collection, final ExecutionContext ctx) {
        ArrayList result = new ArrayList();
        result.addAll(collection);
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Object b;
                Object a = CollectionExpression.this.closure.evaluate(ctx.cloneWithVariable(new Variable(CollectionExpression.this.getElementName(), o1)));
                if (a == (b = CollectionExpression.this.closure.evaluate(ctx.cloneWithVariable(new Variable(CollectionExpression.this.getElementName(), o2))))) {
                    return 0;
                }
                if (a == null) {
                    return -1;
                }
                if (b == null) {
                    return 1;
                }
                if (a instanceof Comparable) {
                    return ((Comparable)a).compareTo(b);
                }
                return a.toString().compareTo(b.toString());
            }
        });
        return result;
    }

    private Object executeForAll(Collection collection, ExecutionContext ctx) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object result = this.closure.evaluate(ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), iter.next())));
            if (result instanceof Boolean && ((Boolean)result).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object executeExists(Collection collection, ExecutionContext ctx) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object result = this.closure.evaluate(ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), iter.next())));
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Object executeNotExists(Collection collection, ExecutionContext ctx) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object result = this.closure.evaluate(ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), iter.next())));
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object executeReject(Collection collection, ExecutionContext ctx) {
        ArrayList resultCol = new ArrayList(collection);
        for (Object ele : collection) {
            Object result = this.closure.evaluate(ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), ele)));
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
            resultCol.remove(ele);
        }
        return resultCol;
    }

    private Object executeSelect(Collection collection, ExecutionContext ctx) {
        ArrayList resultCol = new ArrayList();
        for (Object ele : collection) {
            Object result = this.closure.evaluate(ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), ele)));
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
            resultCol.add(ele);
        }
        return resultCol;
    }

    private Object executeSelectFirst(Collection collection, ExecutionContext ctx) {
        ArrayList resultCol = new ArrayList();
        for (Object ele : collection) {
            Object result = this.closure.evaluate(ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), ele)));
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
            resultCol.add(ele);
        }
        if (resultCol.size() == 0) {
            return null;
        }
        return resultCol.iterator().next();
    }

    private Object executeCollect(Collection collection, ExecutionContext ctx) {
        ArrayList<Object> resultCol = new ArrayList<Object>();
        for (Object ele : Collections.unmodifiableCollection(collection)) {
            ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), ele));
            resultCol.add(this.closure.evaluate(ctx));
        }
        return resultCol;
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type targetType = null;
        if (this.getTarget() == null) {
            Variable v = ctx.getVariable("this");
            if (v != null) {
                targetType = (Type)v.getValue();
            }
        } else {
            targetType = this.getTarget().analyze(ctx, issues);
        }
        if (targetType == null) {
            return null;
        }
        if (!(targetType instanceof ParameterizedType)) {
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "Collection type expected! was : " + targetType, this.getTarget()));
            return null;
        }
        Type innerType = ((ParameterizedType)targetType).getInnerType();
        Type result = null;
        ctx = ctx.cloneWithVariable(new Variable(this.getElementName(), innerType));
        Type closureType = this.closure.analyze(ctx, issues);
        if (this.getName().getValue().equals("collect")) {
            if (targetType.getName().startsWith("Set")) {
                return ctx.getSetType(closureType);
            }
            if (targetType.getName().startsWith("List")) {
                return ctx.getListType(closureType);
            }
            return ctx.getCollectionType(closureType);
        }
        if (this.getName().getValue().equals("select") || this.getName().getValue().equals("reject")) {
            return targetType;
        }
        if (this.getName().getValue().equals("selectFirst")) {
            return innerType;
        }
        if (this.getName().getValue().equals("sortBy")) {
            return ctx.getListType(innerType);
        }
        if (this.getName().getValue().equals("typeSelect")) {
            if (closureType == null) {
                return null;
            }
            return ctx.getListType(closureType);
        }
        if (this.getName().getValue().equals("exists") || this.getName().getValue().equals("notExists") || this.getName().getValue().equals("forAll")) {
            if (!ctx.getBooleanType().isAssignableFrom(closureType)) {
                issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "Boolean type expected! was : " + closureType, this.closure));
            }
            result = ctx.getBooleanType();
        } else {
            issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Unknown operation : " + this.getName().getValue(), this));
        }
        return result;
    }

    public String getElementName() {
        return this.eleName != null ? this.eleName.getValue() : "element";
    }
}

