/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.util.stdlib;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class SystemCommand
extends AbstractWorkflowComponent2 {
    private static final Log log = LogFactory.getLog(SystemCommand.class);
    private String command;
    private File directory;
    private final boolean inheritEnvironment = false;
    private final List<String> args = new ArrayList<String>();
    private final List<String> enventry = new ArrayList<String>();

    protected void checkConfigurationInternal(Issues issues) {
        if (this.command == null) {
            issues.addError("command not specified");
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        try {
            String lineRead;
            ArrayList<String> pbArgs = new ArrayList<String>();
            pbArgs.add(this.command);
            pbArgs.addAll(this.args);
            ProcessBuilder pb = new ProcessBuilder(pbArgs);
            if (this.directory != null) {
                pb.directory(this.directory);
            }
            for (String env : this.enventry) {
                String[] keyvalue = env.split(",");
                pb.environment().put(keyvalue[0], keyvalue[1]);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Environment:");
                log.debug(pb.environment());
                log.debug(System.getenv());
            }
            log.info((Object)("Running command '" + pb.command() + "' in directory " + pb.directory().getAbsolutePath() + " ..."));
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((lineRead = br.readLine()) != null) {
                log.info((Object)lineRead);
            }
            br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((lineRead = br.readLine()) != null) {
                log.error((Object)lineRead);
            }
            int rc = p.waitFor();
            if (rc != 0) {
                issues.addError("Error running '" + this.command + "'");
                return;
            }
            rc = p.exitValue();
            if (rc != 0) {
                issues.addError("Execution of command failed with error.");
            } else {
                log.info((Object)"Execution of command was successful.");
            }
        }
        catch (Exception re) {
            issues.addError("Runtime error: " + re.getMessage());
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void addArg(String arg) {
        this.args.add(arg);
    }

    public void addEnv(String entry) {
        if (!entry.matches("\\A[^,]+,.+\\z")) {
            throw new IllegalArgumentException(entry);
        }
        this.enventry.add(entry);
    }
}

