/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.util;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaCompositor;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xtend.typesystem.xsd.util.XSDUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Msg {
    private URI base = URI.createFileURI((String)new File(".").getAbsolutePath());
    private StringBuffer msg = new StringBuffer();

    public static Msg create(String msg) {
        Msg log = new Msg();
        log.txt(msg);
        return log;
    }

    private Msg() {
    }

    protected Msg collectIncludedSchemas(Set<XSDSchema> recursion, XSDSchema schema, URI uri) {
        if (recursion.contains(schema)) {
            return this.txt("<recursion!:").schema(schema).txt(">");
        }
        recursion.add(schema);
        int i = 0;
        for (XSDSchemaContent c : schema.getContents()) {
            XSDSchema r;
            if (!(c instanceof XSDSchemaCompositor) || (r = ((XSDSchemaCompositor)c).getResolvedSchema()) == null) continue;
            if (i == 0) {
                this.txt("[");
            }
            if (i == 1) {
                this.txt(",");
            }
            ++i;
            if (r.eResource() != null && r.eResource().getURI() != null) {
                URI u = r.eResource().getURI();
                this.txt(XSDUtil.deresolve(uri, u).toString());
                this.collectIncludedSchemas(new HashSet<XSDSchema>(recursion), r, u);
                continue;
            }
            this.txt("(unknown uri)");
            this.collectIncludedSchemas(new HashSet<XSDSchema>(recursion), r, uri);
        }
        if (i > 0) {
            this.txt("]");
        }
        return this;
    }

    public Msg diag(Resource.Diagnostic diag) {
        Msg u;
        if (diag == null) {
            return this.txt("(diagnostic is null)");
        }
        try {
            u = Msg.create("").uri(URI.createURI((String)diag.getLocation()));
        }
        catch (Exception exception) {
            u = Msg.create(diag.getLocation());
        }
        return this.txt(diag.getMessage()).txt(" ").txt(u).txt("[").i(diag.getLine()).txt(",").i(diag.getColumn()).txt("]");
    }

    public Msg diag(XSDDiagnostic diag) {
        return this.diag((Resource.Diagnostic)diag).txt(" primaryComponent:").path((EObject)diag.getPrimaryComponent());
    }

    public Msg err(Throwable err) {
        if (err == null) {
            return this.txt("(throwable is null)");
        }
        return this.txt(err.getMessage());
    }

    public Msg i(int m) {
        this.msg.append(m);
        return this;
    }

    public Msg ns(String ns) {
        return this.txt(ns);
    }

    public Msg ns(URI ns) {
        return this.ns(ns.toString());
    }

    public Msg path(EObject o) {
        if (o instanceof XSDParticle && ((XSDParticle)o).getContent() != null) {
            o = ((XSDParticle)o).getContent();
        }
        this.path2(o);
        return this;
    }

    private Msg path2(EObject o) {
        if (o == null) {
            return this.txt("(o is null)");
        }
        if (o.eContainer() != null) {
            return this.path2(o.eContainer()).txt("/").pathItem(o);
        }
        return this.txt("/").pathItem(o);
    }

    private Msg pathItem(EObject ele) {
        if (ele instanceof XSDSchema && ele.eResource() != null && ele.eResource().getURI() != null) {
            return this.txt(ele.eResource().getURI().lastSegment());
        }
        if (ele instanceof ENamedElement) {
            return this.scls(ele).txt("'").txt(((ENamedElement)ele).getName()).txt("'");
        }
        if (ele instanceof XSDNamedComponent) {
            return this.scls(ele).txt("'").txt(((XSDNamedComponent)ele).getName()).txt("'");
        }
        return this.scls(ele);
    }

    public Msg pkg(EPackage p) {
        return this.txt("EPackage ").pkg(p.getName()).txt(" (" + p.getNsURI() + ")");
    }

    public Msg pkg(String name) {
        return this.txt("'" + name + "'");
    }

    public Msg schema(XSDSchema s) {
        return this.txt("XSDSchema ").uri((EObject)s).txt(" (" + s.getTargetNamespace() + ")");
    }

    public Msg schemaDeep(XSDSchema s) {
        if (s == null) {
            return this.txt("(schema is null)");
        }
        return this.txt("XSDSchema ").uri((EObject)s).collectIncludedSchemas(new HashSet<XSDSchema>(), s, s.eResource().getURI()).txt(" (" + s.getTargetNamespace() + ")");
    }

    public Msg schemas(Collection<XSDSchema> s) {
        if (s == null) {
            return this.txt("(schemas are null)");
        }
        if (s.size() == 0) {
            return this.txt("(none)");
        }
        this.txt("XSDSchemas: ");
        boolean first = true;
        for (XSDSchema o : s) {
            if (first) {
                first = false;
            } else {
                this.txt(", ");
            }
            this.uri((EObject)o).txt(" (" + o.getTargetNamespace() + ")");
        }
        return this;
    }

    public Msg scls(EClass cls) {
        if (cls == null) {
            return this.scls("(class is null)");
        }
        return this.scls(cls.getName());
    }

    public Msg scls(EObject obj) {
        if (obj == null) {
            return this.scls("(obj is null)");
        }
        return this.scls(obj.eClass());
    }

    public Msg scls(Object obj) {
        if (obj == null) {
            return this.scls("(obj is null)");
        }
        return this.scls(obj.getClass().getSimpleName());
    }

    public Msg scls(String txt) {
        return this.txt(txt);
    }

    public Msg sclsname(EObject ele) {
        if (ele == null) {
            return this.txt("(ele is null)");
        }
        if (ele instanceof ENamedElement) {
            return this.scls(ele).txt(" '").txt(((ENamedElement)ele).getName()).txt("'");
        }
        return this.scls(ele);
    }

    public String toString() {
        return this.msg.toString();
    }

    public Msg txt(Msg m) {
        this.msg.append(m.msg);
        return this;
    }

    public Msg txt(String msg) {
        this.msg.append(msg);
        return this;
    }

    public Msg uri(EObject obj) {
        if (obj == null) {
            return this.txt("(obj is null)");
        }
        return this.uri(obj.eResource());
    }

    public Msg uri(Resource res) {
        if (res == null) {
            return this.uri("(resource is null)");
        }
        if (res.getURI() == null) {
            return this.uri("(resource uri is null)");
        }
        return this.uri(res.getURI());
    }

    public Msg uri(String uri) {
        return this.txt("'" + uri + "'");
    }

    public Msg uri(URI uri) {
        if (uri == null) {
            return this.uri("(uri is null)");
        }
        if (uri.scheme() == null || uri.scheme().equals("")) {
            uri = URI.createFileURI((String)uri.toString());
        }
        if (uri.isRelative()) {
            return this.uri(uri.toString());
        }
        URI res = uri.deresolve(this.base);
        if (res == uri) {
            return this.uri(uri.toString());
        }
        return this.uri("file:/.../" + res.toString());
    }

    public Msg uris(Collection<?> uris) {
        if (uris == null) {
            return this.txt("(uris are null)");
        }
        if (uris.size() == 0) {
            return this.txt("(none)");
        }
        boolean first = true;
        for (Object o : uris) {
            if (first) {
                first = false;
            } else {
                this.txt(", ");
            }
            if (o instanceof URI) {
                this.uri((URI)o);
                continue;
            }
            if (o instanceof EObject) {
                this.uri((EObject)o);
                continue;
            }
            this.uri(o.toString());
        }
        return this;
    }
}

