/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.runtime.BundleJarInfo;
import org.eclipse.jet.internal.runtime.IJETBundleProvider;
import org.eclipse.jet.internal.runtime.JETBundleManager;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class DirectoryBundleProvider
implements IJETBundleProvider {
    private static boolean DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/additionalBundleLoading")) != false;
    private final File directory;

    public DirectoryBundleProvider(String directoryLocation) {
        this(new File(directoryLocation));
    }

    public DirectoryBundleProvider(File directory) {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.directory = directory;
        System.out.println("DirectoryBundleProvider.DirectoryBundleProvider(" + directory.getAbsolutePath() + ")");
    }

    public Collection getAllJETBundleDescriptors() {
        Map descriptorsById = this.getDescriptorsById();
        return descriptorsById.values();
    }

    private Map getDescriptorsById() {
        final HashMap descriptorsById = new HashMap();
        this.directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                BundleJarInfo jarInfo = BundleJarInfo.createBundleJarInfo(pathname.getName());
                if (jarInfo != null) {
                    try {
                        URL bundleURL = pathname.toURL();
                        IJETBundleDescriptor descriptor = JETBundleManager.getJETBundleDescriptorForJAR(bundleURL);
                        if (descriptor != null) {
                            descriptorsById.put(jarInfo.getBundleSymbolicName(), descriptor);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                return false;
            }
        });
        return descriptorsById;
    }

    public Set getAllJETBundleIds() {
        if (DEBUG) {
            System.out.println("DirectoryBundleProvider.getAllJETBundleIds()");
        }
        Map descriptorsById = this.getDescriptorsById();
        if (DEBUG) {
            System.out.println("   ids: " + descriptorsById.keySet());
        }
        return descriptorsById.keySet();
    }

    private URL getBundleURL(final String id) {
        File[] jars = this.directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                BundleJarInfo jarInfo = BundleJarInfo.createBundleJarInfo(name);
                return jarInfo != null && jarInfo.getBundleSymbolicName().equals(id);
            }
        });
        URL url = null;
        if (jars.length > 0) {
            try {
                url = jars[0].toURL();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return url;
    }

    public IJETBundleDescriptor getDescriptor(String id) {
        if (DEBUG) {
            System.out.println("DirectoryBundleProvider.getDescriptor(" + id + ")");
        }
        URL bundleURL = this.getBundleURL(id);
        IJETBundleDescriptor descriptor = null;
        if (bundleURL != null) {
            descriptor = JETBundleManager.getJETBundleDescriptorForJAR(bundleURL);
        }
        if (DEBUG) {
            System.out.println("   " + (descriptor == null ? "not found" : "found"));
        }
        return descriptor;
    }

    public Bundle load(String id, IProgressMonitor monitor) throws BundleException {
        URL bundleURL = this.getBundleURL(id);
        Bundle bundle = null;
        if (bundleURL != null) {
            bundle = InternalJET2Platform.getDefault().getJETBundleInstaller().installBundle(bundleURL);
        }
        return bundle;
    }

    public void shutdown() {
    }

    public void startup() {
    }

    public void unload(String id) throws BundleException {
    }

    public void unload(Bundle bundle) throws BundleException {
        if (bundle != null) {
            bundle.uninstall();
        }
    }
}

