/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jet.internal.extensionpoints.TransformData;
import org.eclipse.jet.internal.runtime.JETBundleManifest;
import org.eclipse.jet.taglib.TagLibraryReference;
import org.eclipse.jet.transform.IJETBundleDescriptor;

public class JETBundleDescriptor
implements IJETBundleDescriptor {
    public static final String MAIN_TEMPLATE_DEFAULT = "templates/control.jet";
    private final String id;
    private final String name;
    private final String description;
    private final String modelLoaderId;
    private final String modelExtension;
    private final String overridesId;
    private final String version;
    private final String provider;
    private final String templateLoaderClass;
    private final String mainTemplate;
    private final boolean privateTransform;
    private final String modelSchema;
    private final TagLibraryReference[] tagLibraryReferences;
    private final URL baseURL;

    public JETBundleDescriptor(JETBundleManifest jetManifest, TransformData transformData, URL baseURL) {
        this.id = jetManifest.getTransformId();
        this.name = jetManifest.getName();
        this.version = jetManifest.getVersion();
        this.provider = jetManifest.getProvider();
        this.baseURL = baseURL;
        if (transformData == null) {
            this.templateLoaderClass = jetManifest.getTemplateLoaderClassName();
            this.mainTemplate = MAIN_TEMPLATE_DEFAULT;
            this.description = "";
            this.overridesId = null;
            this.modelLoaderId = null;
            this.modelExtension = null;
            this.tagLibraryReferences = new TagLibraryReference[0];
            this.privateTransform = false;
            this.modelSchema = null;
        } else {
            this.templateLoaderClass = transformData.getTemplateLoaderClassName();
            this.mainTemplate = transformData.getMainTemplate();
            this.description = transformData.getDescription();
            this.overridesId = transformData.getOverridesId();
            this.modelLoaderId = transformData.getModelLoaderId();
            this.modelExtension = transformData.getModelExtension();
            this.tagLibraryReferences = transformData.getTagLibraryReferences();
            this.privateTransform = transformData.isPrivateTransform();
            this.modelSchema = transformData.getModelSchema();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name == null ? this.id : this.name;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public String getModelLoaderId() {
        return this.modelLoaderId;
    }

    public String getModelExtension() {
        return this.modelExtension;
    }

    public String getOverridesId() {
        return this.overridesId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProvider() {
        return this.provider;
    }

    public TagLibraryReference[] getTagLibraryReferences() {
        return this.tagLibraryReferences;
    }

    public String getTemplateLoaderClass() {
        return this.templateLoaderClass;
    }

    public String getMainTemplate() {
        return this.mainTemplate;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public URL getModelSchema() throws MalformedURLException {
        return this.modelSchema == null ? null : new URL(this.baseURL, this.modelSchema);
    }

    public boolean isPrivate() {
        return this.privateTransform;
    }
}

