/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.XMLBodyElement;
import org.eclipse.jet.core.parser.ast.XMLEmptyElement;
import org.eclipse.jet.taglib.TagLibraryReference;

public class TagUsageVisitor
extends JETASTVisitor {
    private boolean hasTags = false;
    private Set nsPrefixesUsed = new HashSet();

    public boolean visit(XMLBodyElement xmlBodyElement) {
        this.nsPrefixesUsed.add(xmlBodyElement.getNSPrefix());
        this.hasTags = true;
        return true;
    }

    public boolean visit(XMLEmptyElement xmlEmptyElement) {
        this.nsPrefixesUsed.add(xmlEmptyElement.getNSPrefix());
        this.hasTags = true;
        return true;
    }

    public boolean hasTags() {
        return this.hasTags;
    }

    public TagLibraryReference[] getUsedTagLibraryReferences(JETCompilationUnit cu) {
        TagLibraryReference[] tlrefs = cu.getTagLibraryReferences();
        ArrayList<TagLibraryReference> usedRefs = new ArrayList<TagLibraryReference>();
        int i = 0;
        while (i < tlrefs.length) {
            if (this.nsPrefixesUsed.contains(tlrefs[i].getPrefix())) {
                usedRefs.add(tlrefs[i]);
            }
            ++i;
        }
        return usedRefs.toArray(new TagLibraryReference[usedRefs.size()]);
    }
}

