/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.ui.prefs;

import java.util.regex.Pattern;
import org.eclipse.jet.internal.ui.l10n.Messages;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.widgets.Composite;

public class ExtensionListEditor
extends ListEditor {
    public ExtensionListEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected String createList(String[] items) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            if (i != 0) {
                buffer.append(",");
            }
            buffer.append(items[i]);
            ++i;
        }
        return buffer.toString();
    }

    protected String getNewInputObject() {
        InputDialog dialog = new InputDialog(this.getShell(), Messages.ExtensionListEditor_AddDialogTitle, Messages.ExtensionListEditor_AddDialogPrompt, "", new IInputValidator(){

            public String isValid(String newText) {
                return !Pattern.matches("(\\p{L}|\\d)+", newText) ? Messages.ExtensionListEditor_AddDialogErrorMsg : null;
            }
        });
        int result = dialog.open();
        return result == 0 ? dialog.getValue() : null;
    }

    protected String[] parseString(String stringList) {
        return stringList.split(",");
    }
}

