/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.shared.ui.Messages;
import org.eclipse.xtend.shared.ui.MetamodelContributor;
import org.eclipse.xtend.shared.ui.ResourceContributor;
import org.eclipse.xtend.shared.ui.core.IModelManager;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandNature;
import org.eclipse.xtend.shared.ui.core.internal.XtendXpandModelManager;
import org.eclipse.xtend.shared.ui.core.metamodel.Contributor;
import org.eclipse.xtend.shared.ui.core.metamodel.MetamodelContributorRegistry;
import org.eclipse.xtend.shared.ui.expression.XpandPluginExecutionContext;
import org.eclipse.xtend.shared.ui.internal.XtendLog;
import org.eclipse.xtend.typesystem.MetaModel;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static final String RESOURCE_CONTRIBUTOR_ID = "org.eclipse.xtend.shared.ui.resourceContributor";
    public static final String PLUGIN_ID = "org.eclipse.xtend.shared.ui";
    private static Activator plugin;
    private static HashMap<String, ResourceContributor> contributors;
    private IModelManager modelManager;
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Job job = new Job(Messages.Activator_AnalyzingProgress){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                Activator.getExtXptModelManager().analyze(monitor);
                            }
                        }.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        XtendLog.logError(e);
                    }
                    catch (InterruptedException e) {
                        XtendLog.logError(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    };

    public static final String getNatureId() {
        return XtendXpandNature.NATURE_ID;
    }

    public Activator() {
        plugin = this;
        this.modelManager = new XtendXpandModelManager();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().addPropertyChangeListener(this.listener);
        Map<String, Contributor> registeredMetamodelContributors = MetamodelContributorRegistry.getRegisteredMetamodelContributors();
        for (Contributor c : registeredMetamodelContributors.values()) {
            c.getMetaModelContributor();
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.getPreferenceStore().removePropertyChangeListener(this.listener);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)Activator.getId(), (String)path);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static String getId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public static ResourceContributor[] getRegisteredResourceContributors() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(RESOURCE_CONTRIBUTOR_ID);
        HashSet<ResourceContributor> contrs = new HashSet<ResourceContributor>();
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configs = extension.getConfigurationElements();
                int j = 0;
                while (j < configs.length) {
                    IConfigurationElement element = configs[j];
                    try {
                        contrs.add((ResourceContributor)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        XtendLog.logError(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return contrs.toArray(new ResourceContributor[contrs.size()]);
    }

    public static IModelManager getExtXptModelManager() {
        return Activator.getDefault().modelManager;
    }

    public static ExecutionContext getExecutionContext(IJavaProject project) {
        IXtendXpandProject xp = Activator.getExtXptModelManager().findProject(project.getPath());
        XpandPluginExecutionContext ctx = new XpandPluginExecutionContext(xp);
        List<? extends MetamodelContributor> contr = MetamodelContributorRegistry.getActiveMetamodelContributors(project);
        for (MetamodelContributor metamodelContributor : contr) {
            MetaModel[] metamodels = metamodelContributor.getMetamodels(project, (TypeSystem)ctx);
            int i = 0;
            while (i < metamodels.length) {
                ctx.registerMetaModel(metamodels[i]);
                ++i;
            }
        }
        return ctx;
    }

    public static final boolean isXtendFile(Object object) {
        if (object instanceof IFile) {
            return "ext".equals(((IFile)object).getFileExtension());
        }
        return false;
    }

    public static ResourceContributor getRegisteredResourceContributorFor(String fileExtension) {
        if (contributors == null) {
            contributors = new HashMap();
            ResourceContributor[] resourceContributorArray = Activator.getRegisteredResourceContributors();
            int n = resourceContributorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceContributor contr = resourceContributorArray[n2];
                contributors.put(contr.getFileExtension(), contr);
                ++n2;
            }
        }
        return contributors.get(fileExtension);
    }

    public static void logError(String string, Exception e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, string, (Throwable)e));
    }
}

