/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib.java;

import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.taglib.DocumentHelper;
import org.eclipse.jet.internal.taglib.java.ImportsLocationTag;
import org.eclipse.jet.internal.taglib.java.PackageTag;
import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.workspace.ActionsUtil;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class JavaActionsUtil {
    static /* synthetic */ Class class$0;

    private JavaActionsUtil() {
    }

    public static IFolder getFolderForPackage(IPath sourceFolder, String packageName) throws JET2TagException {
        return (IFolder)JavaActionsUtil.getContainerForPackage(sourceFolder, packageName);
    }

    private static void buildProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            project.build(10, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IContainer getContainerForPackage(IPath sourceFolder, String packageName) throws JET2TagException {
        IContainer result = null;
        if (sourceFolder == null) throw new NullPointerException();
        if (packageName == null) {
            throw new NullPointerException();
        }
        if (sourceFolder.segmentCount() == 0) {
            throw new IllegalArgumentException();
        }
        IJavaElement jElementForFolder = JavaCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(sourceFolder));
        if (jElementForFolder == null) {
            ActionsUtil.checkpointWorkspace(false, (IProgressMonitor)new NullProgressMonitor());
            JavaActionsUtil.buildProject(sourceFolder.segment(0));
            jElementForFolder = JavaCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(sourceFolder));
        }
        if (jElementForFolder == null) throw new JET2TagException(MessageFormat.format(JET2Messages.JavaActionsUtil_InvalidSourceFolder, sourceFolder.toString()));
        if (jElementForFolder instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)jElementForFolder;
            IPackageFragment packageFragment = root.getPackageFragment(packageName);
            return (IContainer)packageFragment.getResource();
        }
        if (!(jElementForFolder instanceof IJavaProject)) throw new JET2TagException(MessageFormat.format(JET2Messages.JavaActionsUtil_InvalidSourceFolder, sourceFolder.toString()));
        try {
            return JavaActionsUtil.findOrCreateJavaPackage((IJavaProject)jElementForFolder, packageName);
        }
        catch (JavaModelException javaModelException) {
            String msg = JET2Messages.JavaActionsUtil_CannotFindSourceFolder;
            throw new JET2TagException(MessageFormat.format(msg, sourceFolder.segment(0), packageName));
        }
    }

    private static IContainer findOrCreateJavaPackage(IJavaProject jProject, String packageName) throws JavaModelException {
        IPackageFragment firstNonExistantFragment = null;
        IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getKind() == 1) {
                IPackageFragment fragment = roots[i].getPackageFragment(packageName);
                if (fragment.exists()) {
                    return (IContainer)fragment.getResource();
                }
                if (firstNonExistantFragment == null) {
                    firstNonExistantFragment = fragment;
                }
            }
            ++i;
        }
        return firstNonExistantFragment != null ? (IContainer)firstNonExistantFragment.getResource() : null;
    }

    public static ImportManager getImportManager(JET2Writer writer) throws JET2TagException {
        if (!(writer instanceof BufferedJET2Writer)) {
            throw new IllegalArgumentException();
        }
        BufferedJET2Writer bufferedWriter = (BufferedJET2Writer)writer;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDocument document = (IDocument)bufferedWriter.getAdapter((Class)clazz);
        DocumentHelper.installPositionCategory(document, "org.eclipse.jet.internal.taglib.java.imports");
        try {
            Position[] positions = document.getPositions("org.eclipse.jet.internal.taglib.java.imports");
            if (positions.length > 0) {
                ImportsLocationTag.ImportsPosition position = (ImportsLocationTag.ImportsPosition)positions[0];
                return position.getImportManager();
            }
            if (writer.getParentWriter() != null) {
                return JavaActionsUtil.getImportManager(writer.getParentWriter());
            }
            throw new JET2TagException(JET2Messages.ImportsLocationTag_MissingImportsLocation);
        }
        catch (BadPositionCategoryException e) {
            throw new RuntimeException(e);
        }
    }

    public static PackageTag findContainingJavaPackageTag(CustomTag tag) throws JET2TagException {
        CustomTag parent = tag.getParent();
        while (parent != null) {
            if (parent instanceof PackageTag) {
                return (PackageTag)parent;
            }
            parent = parent.getParent();
        }
        String msg = JET2Messages.JavaActionsUtil_RequiresAttrOrContainerTag;
        String attrName = "packageName";
        String tagName = "<java:package>";
        throw new JET2TagException(MessageFormat.format(msg, attrName, tagName));
    }

    public static IFile getResourceForJavaResource(IPath srcFolderPath, String pkgName, String fileName) throws JET2TagException {
        IContainer container = JavaActionsUtil.getContainerForPackage(srcFolderPath, pkgName);
        if (container instanceof IFolder) {
            return ((IFolder)container).getFile(fileName);
        }
        if (container instanceof IProject) {
            return ((IProject)container).getFile(fileName);
        }
        String msg = JET2Messages.JavaActionsUtil_CannotFindSourceFolder;
        throw new JET2TagException(MessageFormat.format(msg, srcFolderPath.toString(), pkgName));
    }
}

