/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability.engine;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.internal.traceability.engine.ExpressionTrace;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.ocl.expressions.OCLExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IterationTrace<C>
extends ExpressionTrace<C> {
    private int lastIteration = -1;
    private int lastOffsetOfCurrentIteration;
    private Map<InputElement, Set<GeneratedText>> currentIterationTraces;

    public IterationTrace(OCLExpression<C> expression) {
        super(expression);
    }

    public int getLastIteration() {
        return this.lastIteration;
    }

    public void advanceIteration(String next) {
        int startOffset = this.lastOffsetOfCurrentIteration;
        int endOffset = startOffset + next.length();
        this.currentIterationTraces = new LinkedHashMap<InputElement, Set<GeneratedText>>();
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : this.getTraces().entrySet()) {
            for (GeneratedText text : entry.getValue()) {
                if (text.getStartOffset() < startOffset || text.getEndOffset() > endOffset) continue;
                CompactLinkedHashSet iterationText = this.currentIterationTraces.get(entry.getKey());
                if (iterationText == null) {
                    iterationText = new CompactLinkedHashSet();
                    this.currentIterationTraces.put(entry.getKey(), (Set<GeneratedText>)iterationText);
                }
                iterationText.add((GeneratedText)text);
                if (text.getEndOffset() <= this.lastOffsetOfCurrentIteration) continue;
                this.lastOffsetOfCurrentIteration = text.getEndOffset();
            }
        }
        ++this.lastIteration;
    }

    public Map<InputElement, Set<GeneratedText>> getTracesForIteration() {
        return this.currentIterationTraces;
    }
}

