/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.edit;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.explorer.commands.MoveStateCommand;
import org.eclipse.emf.henshin.statespace.explorer.edit.StateEditPart;
import org.eclipse.emf.henshin.statespace.explorer.jobs.LayoutStateSpaceJob;
import org.eclipse.emf.henshin.statespace.explorer.parts.StateSpaceExplorer;
import org.eclipse.emf.henshin.statespace.layout.StateSpaceSpringLayouter;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class StateSpaceLayoutEditPolicy
extends XYLayoutEditPolicy {
    private StateSpaceSpringLayouter layouter;

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (child instanceof StateEditPart && constraint instanceof Rectangle) {
            State state = ((StateEditPart)child).getState();
            Rectangle bounds = (Rectangle)constraint;
            MoveStateCommand command = new MoveStateCommand(state, request, bounds);
            command.setLayouter(this.getLayouter());
            return command;
        }
        return super.createChangeConstraintCommand(request, child, constraint);
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof StateEditPart) {
            return new NonResizableEditPolicy(){

                protected IFigure createDragSourceFeedbackFigure() {
                    Ellipse ghost = new Ellipse();
                    ghost.setAntialias(1);
                    FigureUtilities.makeGhostShape((Shape)ghost);
                    ghost.setLineStyle(3);
                    ghost.setForegroundColor(ColorConstants.white);
                    ghost.setBounds(this.getInitialFeedbackBounds());
                    this.addFeedback((IFigure)ghost);
                    return ghost;
                }
            };
        }
        return super.createChildEditPolicy(child);
    }

    private StateSpaceSpringLayouter getLayouter() {
        if (this.layouter == null) {
            try {
                IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                LayoutStateSpaceJob job = ((StateSpaceExplorer)editor).getJobManager().getLayoutJob();
                this.layouter = job.getLayouter();
            }
            catch (Throwable throwable) {}
        }
        return this.layouter;
    }
}

