/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.actions;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractStateSpaceFileAction
implements IObjectActionDelegate {
    private IFile file;
    private StateSpaceManager manager;
    private IWorkbenchPart part;
    private ISelection selection;
    private final int numManagerThreads = Runtime.getRuntime().availableProcessors();

    protected abstract void doRun(IAction var1);

    public final void run(IAction action) {
        try {
            try {
                this.doRun(action);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        finally {
            if (this.manager != null) {
                this.manager.shutdown();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object first;
        this.file = null;
        this.manager = null;
        this.selection = selection;
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile && "henshin_statespace".equals(((IFile)first).getFileExtension())) {
            this.file = (IFile)first;
        }
        action.setEnabled(this.file != null);
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.part = part;
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return this.part;
    }

    protected int getNumManagerThreads() {
        return this.numManagerThreads;
    }

    protected Shell getShell() {
        return this.part.getSite().getShell();
    }

    protected IFile getStateSpaceFile() {
        return this.file;
    }

    protected ISelection getSelection() {
        return this.selection;
    }

    protected StateSpaceManager getStateSpaceManager() {
        if (this.manager == null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI uri = URI.createPlatformResourceURI((String)this.file.getFullPath().toString(), (boolean)false);
            StateSpaceResource resource = null;
            StateSpace stateSpace = null;
            try {
                resource = (StateSpaceResource)resourceSet.getResource(uri, true);
                stateSpace = resource.getStateSpace();
                this.manager = StateSpaceFactory.eINSTANCE.createStateSpaceManager(stateSpace, this.numManagerThreads);
            }
            catch (Throwable e) {
                StateSpaceExplorerPlugin.getInstance().logError("Error loading state space", e);
                MessageDialog.openError((Shell)this.getShell(), (String)"Load State Space", (String)"Error loading state space. See the error log for more information.");
            }
        }
        return this.manager;
    }

    public void setStateSpaceManager(StateSpaceManager manager) {
        this.manager = manager;
    }

    protected void saveStateSpace() {
        if (this.manager != null) {
            Resource resource = this.manager.getStateSpace().eResource();
            try {
                resource.save(null);
            }
            catch (IOException e) {
                StateSpaceExplorerPlugin.getInstance().logError("Error saving state space", e);
                MessageDialog.openError((Shell)this.getShell(), (String)"Load State Space", (String)"Error saving state space. See the error log for mor information.");
            }
        }
    }
}

