/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.gc2ac.actions;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import nestedcondition.NestedconditionPackage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.core.Integrator;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.util.TranslatorResourceSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class IntegrateAction
implements IObjectActionDelegate {
    public static final String NESTED_CONDITIONS = "/nestedconditions_";
    public static final String NESTED_CONDITION = ".nestedcondition";
    private static final String HENSHIN = ".henshin";
    private Shell shell;
    private List<IFile> files = null;
    private IFile henshinFile = null;
    private IFile nestedconditionFile = null;
    protected IWorkbenchPart workbenchPart;
    protected Module module;
    protected Rule rule;
    private NestedConstraint constraint;

    public void run(IAction action) {
        if (this.checkFiles()) {
            this.initModels();
            this.integrate();
            MessageDialog.openInformation((Shell)this.shell, (String)"Integration", (String)"Integration finished.");
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Integration", (String)"Integration can not be executed on the input.");
        }
    }

    private void initModels() {
        URI uriHenshin = URI.createPlatformResourceURI((String)this.henshinFile.getFullPath().toString(), (boolean)true);
        URI uriNestedcondition = URI.createPlatformResourceURI((String)this.nestedconditionFile.getFullPath().toString(), (boolean)true);
        if (uriHenshin != null && uriNestedcondition != null) {
            HenshinPackage.eINSTANCE.eClass();
            Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
            Map m = reg.getExtensionToFactoryMap();
            m.put("*.henshin", new XMIResourceFactoryImpl());
            ResourceSetImpl resSet = new ResourceSetImpl();
            Resource resourceHenshin = resSet.getResource(uriHenshin, true);
            this.module = (Module)resourceHenshin.getContents().get(0);
            NestedconditionPackage.eINSTANCE.eClass();
            m.put("*.nestedcondition", new XMIResourceFactoryImpl());
            Resource resourceNestedcondition = resSet.getResource(uriNestedcondition, true);
            this.constraint = (NestedConstraint)resourceNestedcondition.getContents().get(0);
        }
    }

    private boolean checkFiles() {
        IFile file1 = this.files.get(0);
        IFile file2 = this.files.get(1);
        System.out.println(file1.getName());
        System.out.println(file2.getName());
        if (!file1.getName().endsWith(HENSHIN) && !file2.getName().endsWith(HENSHIN)) {
            return false;
        }
        if (!file1.getName().endsWith(NESTED_CONDITION) && !file2.getName().endsWith(NESTED_CONDITION)) {
            return false;
        }
        if (file1.getName().endsWith(HENSHIN)) {
            this.henshinFile = file1;
            this.nestedconditionFile = file2;
        } else {
            this.henshinFile = file2;
            this.nestedconditionFile = file1;
        }
        return true;
    }

    protected void integrate() {
        if (this.rule != null) {
            Integrator integrator = new Integrator(this.constraint, this.rule);
            integrator.integrate();
            NestedCondition condition = integrator.getShiftedCondition();
            System.out.println(condition);
            System.out.println(condition.getDomain());
            this.constraint.setDomain(condition.getDomain());
            this.constraint.setCondition(condition);
            this.persistResults();
        }
    }

    private void persistResults() {
        Date date = new GregorianCalendar().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String path = this.nestedconditionFile.getParent().getLocation().append(NESTED_CONDITIONS + sdf.format(date)).toOSString();
        TranslatorResourceSet resourceSet = new TranslatorResourceSet(path);
        resourceSet.saveEObject((EObject)this.constraint, this.constraint.getName().concat(NESTED_CONDITION));
        resourceSet.saveEObject((EObject)this.rule.getModule(), this.henshinFile.getName());
        try {
            this.nestedconditionFile.getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.files = new ArrayList<IFile>();
        if (selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)selection;
            List objects = ss.toList();
            for (Object o : objects) {
                this.files.add((IFile)o);
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }
}

