/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.cda;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.ConflictAnalysis;
import org.eclipse.emf.henshin.preprocessing.Granularity;
import org.eclipse.emf.henshin.preprocessing.HenshinRuleLoader;
import org.eclipse.emf.henshin.preprocessing.NonDeletingPreparator;
import org.eclipse.emf.henshin.preprocessing.RulePair;
import org.eclipse.emf.henshin.preprocessing.RulePreparator;

public class RunConflictDetectionOnRefactoring {
    public static List<Granularity> granularities = Arrays.asList(Granularity.binary, Granularity.coarse, Granularity.fine);
    String logTimeStamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
    String path = String.valueOf(this.getDomainName()) + "\\" + this.logTimeStamp + ".log";
    private ResourceSetImpl resourceSet;
    private boolean WRITE_LOGS = false;

    public static void main(String[] args) {
        new RunConflictDetectionOnRefactoring().run(granularities);
    }

    public void run(List<Granularity> granularities) {
        this.init();
        List<Rule> rules = this.getRules();
        RunConflictDetectionOnRefactoring.prepareRules(rules);
        List nonDeleting = NonDeletingPreparator.prepareNonDeletingVersions(rules);
        this.doMultiGranularCDA(granularities, rules, nonDeleting);
    }

    public void init() {
        EcorePackage.eINSTANCE.eClass();
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("xmi", new XMIResourceFactoryImpl());
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        if (this.WRITE_LOGS) {
            this.initLogs();
        }
    }

    public List<Rule> getRules() {
        File f = new File(RunConflictDetectionOnRefactoring.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        String filePath = f.toString();
        String projectPath = filePath.replaceAll("bin", "");
        String subDirectoryPath = "src\\org\\eclipse\\emf\\henshin\\examples\\cda";
        String fullSubDirectoryPath = String.valueOf(projectPath) + subDirectoryPath;
        File dir = new File(fullSubDirectoryPath);
        return HenshinRuleLoader.loadAllRulesFromFileSystemPaths((File)dir);
    }

    public String getDomainName() {
        return "refactoring";
    }

    protected void doMultiGranularCDA(List<Granularity> granularities, List<Rule> rules, List<RulePair> nonDeleting) {
        Set result;
        ConflictAnalysis ca;
        long time;
        this.logbn("Starting CDA with " + rules.size() + " rules.");
        if (granularities.contains(Granularity.atoms)) {
            this.logn("[MultiCDA] Computing conflict atoms:");
            for (Rule r1 : rules) {
                for (RulePair r2 : nonDeleting) {
                    time = System.currentTimeMillis();
                    ca = new ConflictAnalysis(r1, r2.getCopy());
                    result = ca.computeAtoms();
                    this.log(String.valueOf(result.size()) + " ");
                    this.tlog(String.valueOf(System.currentTimeMillis() - time) + " ");
                }
                this.logbn("   | " + r1.getName());
            }
            this.logbn("");
        }
        if (granularities.contains(Granularity.binary)) {
            this.logn("[MultiCDA] Computing binary granularity:");
            for (Rule r1 : rules) {
                for (RulePair r2 : nonDeleting) {
                    time = System.currentTimeMillis();
                    ca = new ConflictAnalysis(r1, r2.getCopy());
                    result = ca.computeResultsBinary();
                    this.log(result == null ? "0 " : "1 ");
                    this.tlog(String.valueOf(System.currentTimeMillis() - time) + " ");
                }
                this.logbn("   | " + r1.getName());
            }
            this.logbn("");
        }
        if (granularities.contains(Granularity.coarse)) {
            this.logn("[MultiCDA] Computing minimal conflict reasons:");
            for (Rule r1 : rules) {
                for (RulePair r2 : nonDeleting) {
                    time = System.currentTimeMillis();
                    ca = new ConflictAnalysis(r1, r2.getCopy());
                    result = ca.computeResultsCoarse();
                    this.log(String.valueOf(result.size()) + " ");
                    this.tlog(String.valueOf(System.currentTimeMillis() - time) + " ");
                }
                this.logbn("   | " + r1.getName());
            }
            this.logbn("");
        }
        if (granularities.contains(Granularity.fine)) {
            this.logn("[MultiCDA] Computing initial conflict reasons:");
            for (Rule r1 : rules) {
                ArrayList<Integer> resultRow = new ArrayList<Integer>();
                for (RulePair r2 : nonDeleting) {
                    long time2 = System.currentTimeMillis();
                    ConflictAnalysis ca2 = new ConflictAnalysis(r1, r2.getCopy());
                    Set result2 = ca2.computeResultsFine();
                    this.log(String.valueOf(result2.size()) + " ");
                    this.tlog(String.valueOf(System.currentTimeMillis() - time2) + " ");
                    resultRow.add(result2.size());
                }
                this.logbn("   | " + r1.getName());
            }
            this.logbn("");
        }
    }

    protected void initLogs() {
        try {
            Files.write(Paths.get("logs\\time\\" + this.path, new String[0]), new String().getBytes(), StandardOpenOption.CREATE_NEW);
            Files.write(Paths.get("logs\\results\\" + this.path, new String[0]), new String().getBytes(), StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void logbn(String string) {
        this.log(String.valueOf(string) + "\n");
        this.tlog(String.valueOf(string) + "\n");
    }

    protected void tlog(String string) {
        if (this.WRITE_LOGS) {
            try {
                Files.write(Paths.get("logs\\time\\" + this.path, new String[0]), string.getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void log(String string) {
        System.out.print(string);
        if (this.WRITE_LOGS) {
            try {
                Files.write(Paths.get("logs\\results\\" + this.path, new String[0]), string.getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void logn(String string) {
        this.log(String.valueOf(string) + "\n");
    }

    private static void prepareRules(List<Rule> rules) {
        ArrayList prepared = new ArrayList();
        rules.removeAll(rules.stream().filter(r -> !r.getMultiRules().isEmpty()).collect(Collectors.toList()));
        rules.forEach(r -> {
            boolean bl = prepared.add(RulePreparator.prepareRule((Rule)r));
        });
        rules.clear();
        rules.addAll(prepared);
    }
}

