/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.sub;

import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class SubGraph
extends Graph {
    private Graph itsSuperGraph;

    public SubGraph(Graph supergraph) {
        super(supergraph.getTypeSet());
        this.itsSuperGraph = supergraph;
    }

    @Override
    public final void dispose() {
        this.itsSuperGraph = null;
        super.dispose();
    }

    public final Graph getSuperGraph() {
        return this.itsSuperGraph;
    }

    @Override
    public boolean isElement(GraphObject obj) {
        boolean res = false;
        if (obj instanceof Node) {
            res = this.itsNodes.contains(obj);
        }
        if (obj instanceof Arc) {
            res = this.itsArcs.contains(obj);
        }
        return res;
    }

    @Override
    public Enumeration<GraphObject> getElements() {
        Vector<GraphObject> elems = new Vector<GraphObject>();
        Iterator iter = this.itsNodes.iterator();
        while (iter.hasNext()) {
            elems.add((GraphObject)iter.next());
        }
        iter = this.itsArcs.iterator();
        while (iter.hasNext()) {
            elems.add((GraphObject)iter.next());
        }
        return elems.elements();
    }

    public final void addObject(GraphObject obj) {
        if (this.isElement(obj)) {
            return;
        }
        if (obj != null) {
            if (obj.isArc()) {
                if (!this.isElement(((Arc)obj).getSource())) {
                    this.itsNodes.add((Node)((Arc)obj).getSource());
                }
                if (!this.isElement(((Arc)obj).getTarget())) {
                    this.itsNodes.add((Node)((Arc)obj).getTarget());
                }
                this.itsArcs.add((Arc)obj);
            } else {
                this.itsNodes.add((Node)obj);
            }
        }
    }

    public final boolean removeObject(GraphObject obj) {
        if (obj == null) {
            return false;
        }
        Iterator<Arc> anEnum = ((Node)obj).getIncomingArcsSet().iterator();
        while (anEnum.hasNext()) {
            this.removeObject(anEnum.next());
        }
        anEnum = ((Node)obj).getOutgoingArcsSet().iterator();
        while (anEnum.hasNext()) {
            this.removeObject(anEnum.next());
        }
        boolean aFlag = obj instanceof Arc ? this.itsArcs.remove(obj) : this.itsNodes.remove(obj);
        return aFlag;
    }
}

