/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.sub;

import agg.xt_basis.BadMappingException;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.sub.SubGraph;
import java.util.Enumeration;
import java.util.Vector;

public class OrdinarySubMorphism
extends OrdinaryMorphism {
    private OrdinaryMorphism itsSuperMorph;
    private SubGraph itsSubOrig;
    private SubGraph itsSubImg;

    protected OrdinarySubMorphism(OrdinaryMorphism supermorph) {
        this(supermorph, null, null);
    }

    public OrdinarySubMorphism(OrdinaryMorphism supermorph, SubGraph orig, SubGraph img) {
        super(orig, img, supermorph.getAttrContext());
        this.itsSubOrig = orig;
        this.itsSubImg = img;
        this.itsSuperMorph = supermorph;
        if (orig != null) {
            Enumeration<GraphObject> allOrigObjects = orig.getElements();
            while (allOrigObjects.hasMoreElements()) {
                GraphObject anObj = allOrigObjects.nextElement();
                this.makeCommute(anObj);
            }
        }
    }

    private final void makeCommute(GraphObject obj) {
        GraphObject anImg = this.itsSuperMorph.getImage(obj);
        if (anImg != null) {
            if (!this.itsSubImg.isElement(anImg)) {
                this.itsSubImg.addObject(anImg);
            }
            this.addMapping(obj, anImg);
        }
    }

    public final OrdinaryMorphism getSuperMorphism() {
        return this.itsSuperMorph;
    }

    @Override
    public Graph getOriginal() {
        return this.itsSubOrig;
    }

    @Override
    public Graph getImage() {
        return this.itsSubImg;
    }

    @Override
    public Enumeration<GraphObject> getDomain() {
        return this.itsDomObjects.elements();
    }

    @Override
    public Enumeration<GraphObject> getCodomain() {
        return this.itsCodomObjects.elements();
    }

    @Override
    public GraphObject getImage(GraphObject o) {
        GraphObject result = null;
        int i = this.itsDomObjects.indexOf(o);
        if (i > -1) {
            result = (GraphObject)this.itsCodomObjects.elementAt(i);
        }
        return result;
    }

    @Override
    public Enumeration<GraphObject> getInverseImage(GraphObject o) {
        int index;
        Vector<GraphObject> invImages = new Vector<GraphObject>();
        int i = 0;
        while (i < this.itsCodomObjects.size() && (index = this.itsCodomObjects.indexOf(o, i)) != -1) {
            invImages.addElement((GraphObject)this.itsDomObjects.elementAt(index));
            i = index + 1;
        }
        return invImages.elements();
    }

    @Override
    public void addMapping(GraphObject o, GraphObject i) throws BadMappingException {
        if (this.itsSuperMorph.getImage(o) != i) {
            this.itsSuperMorph.addMapping(o, i);
        }
        this.itsDomObjects.addElement(o);
        this.itsCodomObjects.addElement(i);
    }

    @Override
    public void removeMapping(GraphObject o) {
        this.itsSuperMorph.removeMapping(o);
        this.itsDomObjects.remove(o);
        this.itsCodomObjects.remove(this.getImage(o));
    }
}

