/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.impl.ValueTuple;
import agg.util.Change;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import agg.xt_basis.UndirectedArc;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;

public class UndirectedGraph
extends Graph {
    public UndirectedGraph(TypeSet aTypeSet) {
        this.itsTypes = aTypeSet;
    }

    public UndirectedGraph(TypeSet aTypeSet, boolean completeGraph) {
        super(aTypeSet, completeGraph);
    }

    @Override
    public TypeError canCreateArc(Type edgeType, Node src, Node tar, int currentTypeGraphLevel) {
        TypeError error = this.itsTypes.canCreateArc(this, edgeType, src, tar, currentTypeGraphLevel);
        if (error == null) {
            error = this.itsTypes.canCreateArc(this, edgeType, tar, src, currentTypeGraphLevel);
        }
        return error;
    }

    @Override
    public TypeError checkConnectValid(Type edgeType, Node src, Node tar) {
        if (this.itsTypes.getTypeGraph() == null || this.itsTypes.getLevelOfTypeGraphCheck() == 0 || this.itsTypes.getLevelOfTypeGraphCheck() == 5) {
            if (this.isParallelArcAllowed(edgeType, src, tar)) {
                return null;
            }
            return new TypeError(29, "No parallel edges allowed");
        }
        Arc typearc = this.itsTypes.getTypeGraphArc(edgeType, src.getType(), tar.getType());
        if (typearc == null) {
            typearc = this.itsTypes.getTypeGraphArc(edgeType, tar.getType(), src.getType());
        }
        if (typearc != null) {
            if (this.isParallelArcAllowed(edgeType, src, tar)) {
                return null;
            }
            return new TypeError(29, "No parallel edges allowed");
        }
        return new TypeError(21, "The edge of the type \"" + edgeType.getName() + "\" is not allowed between node type \"" + src.getType().getName() + "\"  and  \"" + tar.getType().getName() + "\".");
    }

    @Override
    public boolean isParallelArcAllowed(Type edgeType, Node src, Node tar) {
        return this.itsTypes.isArcParallel() || src.getOutgoingArc(edgeType, tar) == null && tar.getOutgoingArc(edgeType, src) == null;
    }

    @Override
    public TypeError checkNodeRequiresArc(int actTypeGraphLevel) {
        if (this.itsTypes.getTypeGraph() == null || actTypeGraphLevel != 30) {
            return null;
        }
        for (Node n : this.itsNodes) {
            List<String> list = this.itsTypes.nodeRequiresArc(n);
            if (list == null || list.isEmpty()) continue;
            return new TypeError(23, "Node type  \"" + n.getType().getName() + "\" \n" + "requires edge(s) of type: \n" + list.toString(), n.getType());
        }
        return null;
    }

    @Override
    public Arc createArc(Type type, Node src, Node tar) throws TypeException {
        TypeError typeError;
        if (src == null || tar == null) {
            throw new TypeException("UndirectedGraph.createArc:: Cannot create an UndirectedArc of type : " + type.getStringRepr() + "   Source or target node is null!");
        }
        if (!this.isNode(src) || !this.isNode(tar)) {
            throw new TypeException("UndirectedGraph.createArc:: Cannot create an UndirectedArc of type : " + type.getStringRepr() + "  Source or target is not a Node!");
        }
        Type t = null;
        if (this.itsTypes.containsType(type)) {
            t = type;
        }
        if (t == null) {
            t = this.itsTypes.getSimilarType(type);
            if (t == null) {
                t = this.itsTypes.addType(type);
            }
            if (t.getAdditionalRepr().indexOf("[EDGE]") == -1) {
                t.setAdditionalRepr("[EDGE]");
            }
        }
        if ((typeError = this.checkConnectValid(t, src, tar)) != null) {
            throw new TypeException(typeError);
        }
        UndirectedArc anArc = new UndirectedArc(t, (GraphObject)src, (GraphObject)tar, (Graph)this);
        typeError = this.itsTypes.checkType(anArc, this.isCompleteGraph());
        if (typeError != null) {
            ((Node)anArc.getSource()).removeOut(anArc);
            ((Node)anArc.getTarget()).removeOut(anArc);
            throw new TypeException(typeError);
        }
        this.attributed = this.attributed || anArc.getAttribute() != null;
        this.itsArcs.add(anArc);
        this.addToTypeObjectsMap(anArc);
        this.changed = true;
        this.propagateChange(new Change(10, anArc));
        return anArc;
    }

    @Override
    public Arc copyArc(Arc orig, Node src, Node tar) throws TypeException {
        UndirectedArc arc;
        block5: {
            arc = null;
            try {
                arc = (UndirectedArc)this.createArc(orig.getType(), src, tar);
                if (arc != null) {
                    arc.setObjectName(orig.getObjectName());
                    if (orig.getAttribute() != null) {
                        arc.createAttributeInstance();
                        ((ValueTuple)arc.getAttribute()).copyEntries(orig.getAttribute());
                    }
                    break block5;
                }
                throw new TypeException("Graph.copyArc:: Cannot create an UndirectedArc of type : " + orig.getType().getName());
            }
            catch (TypeException ex) {
                if (src != null && tar != null) {
                    throw new TypeException("   " + orig.getType().getName() + " from  " + src.getType().getName() + " to  " + tar.getType().getName() + "   " + ex.getLocalizedMessage());
                }
                throw new TypeException(ex.getLocalizedMessage());
            }
        }
        return arc;
    }

    @Override
    protected Arc newArc(Type t, Node src, Node tar) throws TypeException {
        TypeError typeError = this.checkConnectValid(t, src, tar);
        if (typeError != null) {
            throw new TypeException(typeError);
        }
        UndirectedArc anArc = new UndirectedArc(t, (GraphObject)src, (GraphObject)tar, (Graph)this);
        typeError = this.itsTypes.checkType(anArc, this.isCompleteGraph());
        if (typeError != null) {
            ((Node)anArc.getSource()).removeOut(anArc);
            ((Node)anArc.getTarget()).removeOut(anArc);
            throw new TypeException(typeError);
        }
        this.attributed = this.attributed || anArc.getAttribute() != null;
        this.itsArcs.add(anArc);
        this.addToTypeObjectsMap(anArc);
        this.changed = true;
        this.propagateChange(new Change(10, anArc));
        return anArc;
    }

    @Override
    protected Arc newArcFast(Type t, Node src, Node tar) {
        UndirectedArc anArc = new UndirectedArc(t, (GraphObject)src, (GraphObject)tar, (Graph)this);
        this.attributed = this.attributed || anArc.getAttribute() != null;
        this.itsArcs.add(anArc);
        this.addToTypeObjectsMap(anArc);
        this.changed = true;
        this.propagateChange(new Change(10, anArc));
        return anArc;
    }

    @Override
    public void addArc(Arc anArc) {
        if (anArc instanceof UndirectedArc && !this.itsArcs.contains(anArc)) {
            this.itsArcs.add(anArc);
            this.addToTypeObjectsMap(anArc);
            this.attributed = this.attributed || anArc.getAttribute() != null;
            this.changed = true;
        }
    }

    @Override
    protected void addToTypeObjectsMap(GraphObject anObj) {
        if (anObj.isNode()) {
            this.extendTypeObjectsMapByNode((Node)anObj);
        } else {
            this.extendTypeObjectsMapByArc((Arc)anObj);
        }
    }

    @Override
    protected void extendTypeObjectsMapByArc(Arc arc) {
        if (this.itsTypes.hasInheritance() && arc.getSource().getType().hasParent() || arc.getTarget().getType().hasParent()) {
            Vector<Type> srcParents = arc.getSource().getType().getAllParents();
            Vector<Type> tarParents = arc.getTarget().getType().getAllParents();
            int i = 0;
            while (i < srcParents.size()) {
                int j = 0;
                while (j < tarParents.size()) {
                    String keystr = String.valueOf(srcParents.get(i).convertToKey()) + arc.getType().convertToKey() + tarParents.get(j).convertToKey();
                    String keystr2 = String.valueOf(tarParents.get(j).convertToKey()) + arc.getType().convertToKey() + srcParents.get(i).convertToKey();
                    LinkedHashSet<Arc> objSet = (LinkedHashSet<Arc>)this.itsTypeObjectsMap.get(keystr);
                    if (objSet == null) {
                        objSet = (HashSet)this.itsTypeObjectsMap.get(keystr2);
                    }
                    if (objSet == null) {
                        objSet = new LinkedHashSet<Arc>();
                        this.itsTypeObjectsMap.put(keystr, objSet);
                    }
                    objSet.add(arc);
                    ++j;
                }
                ++i;
            }
        } else {
            String keystr = arc.convertToKey();
            String keystr2 = ((UndirectedArc)arc).convertToInverseKey();
            LinkedHashSet<Arc> objSet = (LinkedHashSet<Arc>)this.itsTypeObjectsMap.get(keystr);
            if (objSet == null) {
                objSet = (HashSet)this.itsTypeObjectsMap.get(keystr2);
            }
            if (objSet == null) {
                objSet = new LinkedHashSet<Arc>();
                this.itsTypeObjectsMap.put(keystr, objSet);
            }
            objSet.add(arc);
        }
    }

    @Override
    protected void removeArc(Arc a) {
        if (a.getContext() == this) {
            ((Node)a.getSource()).removeOut(a);
            ((Node)a.getTarget()).removeOut(a);
            int i = 0;
            while (i < this.itsUsingMorphs.size()) {
                ((OrdinaryMorphism)this.itsUsingMorphs.get(i)).removeMapping(a);
                ++i;
            }
            this.itsArcs.remove(a);
            this.removeArcFromTypeObjectsMap(a);
            this.changed = true;
        }
    }

    @Override
    protected void removeArcFromTypeObjectsMap(Arc arc) {
        if (arc.getSource() != null && arc.getTarget() != null) {
            if (arc.getSource().getType().hasParent() || arc.getTarget().getType().hasParent()) {
                Vector<Type> srcParents = arc.getSource().getType().getAllParents();
                Vector<Type> tarParents = arc.getTarget().getType().getAllParents();
                int i = 0;
                while (i < srcParents.size()) {
                    int j = 0;
                    while (j < tarParents.size()) {
                        String keystr = String.valueOf(srcParents.get(i).convertToKey()) + arc.getType().convertToKey() + tarParents.get(j).convertToKey();
                        String keystr2 = String.valueOf(tarParents.get(j).convertToKey()) + arc.getType().convertToKey() + srcParents.get(i).convertToKey();
                        HashSet objSet = (HashSet)this.itsTypeObjectsMap.get(keystr);
                        if (objSet == null) {
                            objSet = (HashSet)this.itsTypeObjectsMap.get(keystr2);
                        }
                        if (objSet != null) {
                            objSet.remove(arc);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                String keystr = arc.convertToKey();
                String keystr2 = ((UndirectedArc)arc).convertToInverseKey();
                HashSet objSet = (HashSet)this.itsTypeObjectsMap.get(keystr);
                if (objSet == null) {
                    objSet = (HashSet)this.itsTypeObjectsMap.get(keystr2);
                }
                if (objSet != null) {
                    objSet.remove(arc);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean isUsingType(GraphObject t) {
        block5: {
            if (!t.isArc()) ** GOTO lbl18
            hasTypeGraphArc = this.getTypeSet().getTypeGraphArc(t.getType(), ((Arc)t).getSource().getType(), ((Arc)t).getTarget().getType()) != null;
            for (Arc o : this.itsArcs) {
                if (hasTypeGraphArc) {
                    if (!o.getType().compareTo(t.getType())) continue;
                    if ((o.getSource().getType().compareTo(((Arc)t).getSource().getType()) || o.getSource().getType().isChildOf(((Arc)t).getSource().getType())) && (o.getTarget().getType().compareTo(((Arc)t).getTarget().getType()) || o.getTarget().getType().isChildOf(((Arc)t).getTarget().getType()))) {
                        return true;
                    }
                    if (!o.getTarget().getType().compareTo(((Arc)t).getSource().getType()) && !o.getTarget().getType().isChildOf(((Arc)t).getSource().getType()) || !o.getSource().getType().compareTo(((Arc)t).getTarget().getType()) && !o.getSource().getType().isChildOf(((Arc)t).getTarget().getType())) continue;
                    return true;
                }
                if (!o.getType().compareTo(t.getType())) continue;
                return true;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                o = (Node)this.itsNodes.iterator().next();
                if (o.getType().compareTo(t.getType())) {
                    return true;
                }
                if (!o.getType().isChildOf(t.getType())) continue;
                return true;
lbl18:
                // 2 sources

                ** while (this.itsNodes.iterator().hasNext())
            }
        }
        return false;
    }
}

