/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.cons.Evaluable;
import agg.cons.Formula;
import agg.parser.CriticalPairOption;
import agg.parser.ExcludePairContainer;
import agg.parser.ParserFactory;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ParallelRule
extends Rule {
    List<Rule> sources;
    Vector<OrdinaryMorphism> embeddingLeft;
    Vector<OrdinaryMorphism> embeddingRight;
    private final List<OrdinaryMorphism> failedApplConds = new Vector<OrdinaryMorphism>();

    public ParallelRule(TypeSet types, Rule rule1, Rule rule2) {
        super(types);
        if (rule1 != null && rule2 != null) {
            this.sources = new Vector<Rule>();
            this.embeddingLeft = new Vector();
            this.embeddingRight = new Vector();
            this.sources.add(rule1);
            this.sources.add(rule2);
            this.makeParallelRule();
        }
    }

    public ParallelRule(TypeSet types, List<Rule> rules) {
        super(types);
        if (rules != null && !rules.isEmpty()) {
            this.sources = new Vector<Rule>();
            this.embeddingLeft = new Vector();
            this.embeddingRight = new Vector();
            this.sources.addAll(rules);
            this.makeParallelRule();
        }
    }

    public boolean isValid() {
        return this.sources != null && !this.sources.isEmpty();
    }

    public List<OrdinaryMorphism> getLeftEmbedding() {
        return this.embeddingLeft;
    }

    public List<OrdinaryMorphism> getRightEmbedding() {
        return this.embeddingRight;
    }

    public OrdinaryMorphism getLeftEmbeddingAtIndex(int indx) {
        return this.embeddingLeft != null ? this.embeddingLeft.get(indx) : null;
    }

    public OrdinaryMorphism getRightEmbeddingAtIndex(int indx) {
        return this.embeddingRight != null ? this.embeddingRight.get(indx) : null;
    }

    public OrdinaryMorphism getLeftEmbeddingOfObject(GraphObject go) {
        int i = 0;
        while (i < this.embeddingLeft.size()) {
            if (this.embeddingLeft.get(i).getInverseImage(go).hasMoreElements()) {
                return this.embeddingLeft.get(i);
            }
            ++i;
        }
        return null;
    }

    public OrdinaryMorphism getRightEmbeddingOfObject(GraphObject go) {
        int i = 0;
        while (i < this.embeddingRight.size()) {
            if (this.embeddingRight.get(i).getInverseImage(go).hasMoreElements()) {
                return this.embeddingRight.get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean makeMatch(Graph graph, MorphCompletionStrategy strategy) {
        boolean inj;
        Match m = this.getMatch();
        if (m == null) {
            m = BaseFactory.theBaseFactory.createMatch(this, graph);
            m.setCompletionStrategy(strategy, true);
        }
        if (inj = m.getCompletionStrategy().getProperties().get(0)) {
            m.getCompletionStrategy().removeProperty("injective");
        }
        while (m.nextCompletion()) {
            boolean ok = true;
            Vector<GraphObject> dom = m.getDomainObjects();
            Vector<GraphObject> dom1 = m.getDomainObjects();
            int i = 0;
            while (i < dom.size() && ok) {
                GraphObject go = (GraphObject)dom.get(i);
                GraphObject img = m.getImage(go);
                GraphObject src = this.getLeftRuleObjOf(go);
                int j = i + 1;
                while (j < dom1.size() && ok) {
                    GraphObject go1 = (GraphObject)dom1.get(j);
                    if (img == m.getImage(go1)) {
                        GraphObject src1 = this.getLeftRuleObjOf(go1);
                        if (src != null && src1 != null && src.getContext() == src1.getContext()) {
                            ok = false;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (!ok || !m.isValid()) continue;
            return true;
        }
        return false;
    }

    private GraphObject getLeftRuleObjOf(GraphObject go) {
        int l = 0;
        while (l < this.embeddingLeft.size()) {
            OrdinaryMorphism emb = this.embeddingLeft.get(l);
            Enumeration<GraphObject> iter = emb.getInverseImage(go);
            if (iter.hasMoreElements()) {
                return iter.nextElement();
            }
            ++l;
        }
        return null;
    }

    public static List<HashMap<GraphObject, GraphObject>> makeMatchOfRule(List<Rule> rules, Graph graph, MorphCompletionStrategy strategy) {
        Vector<HashMap<GraphObject, GraphObject>> result = new Vector<HashMap<GraphObject, GraphObject>>(rules.size());
        int i = 0;
        while (i < rules.size()) {
            Rule r = rules.get(i);
            Match m = BaseFactory.theBaseFactory.createMatch(r, graph);
            m.setCompletionStrategy(strategy, true);
            boolean found = false;
            while (m.nextCompletion()) {
                if (!m.isValid()) continue;
                found = true;
                HashMap<GraphObject, GraphObject> map = new HashMap<GraphObject, GraphObject>();
                Enumeration<GraphObject> dom = m.getDomain();
                while (dom.hasMoreElements()) {
                    GraphObject go = dom.nextElement();
                    map.put(go, m.getImage(go));
                }
                result.add(map);
                break;
            }
            if (!found) {
                return null;
            }
            ++i;
        }
        if (result.size() != rules.size()) {
            return null;
        }
        return result;
    }

    public static boolean parallelIndependent(GraGra gragra, List<Rule> rules, MorphCompletionStrategy strategy, CriticalPairOption cpOption) {
        ExcludePairContainer pc = new ExcludePairContainer(gragra);
        if (cpOption == null) {
            pc.enableComplete(true);
            pc.enableNACs(true);
            pc.enablePACs(true);
            pc.enableReduce(false);
            pc.enableConsistent(true);
            pc.enableStrongAttrCheck(true);
            pc.enableIgnoreIdenticalRules(true);
            pc.enableReduceSameMatch(true);
            pc.enableDirectlyStrictConfluent(false);
            pc.enableDirectlyStrictConfluentUpToIso(false);
            pc.enableNamedObjectOnly(false);
            pc.enableMaxBoundOfCriticKind(0);
        } else {
            pc.enableComplete(cpOption.completeEnabled());
            pc.enableNACs(cpOption.nacsEnabled());
            pc.enablePACs(cpOption.pacsEnabled());
            pc.enableReduce(cpOption.reduceEnabled());
            pc.enableConsistent(cpOption.consistentEnabled());
            pc.enableStrongAttrCheck(cpOption.strongAttrCheckEnabled());
            pc.enableIgnoreIdenticalRules(cpOption.ignoreIdenticalRulesEnabled());
            pc.enableReduceSameMatch(cpOption.reduceSameMatchEnabled());
            pc.enableDirectlyStrictConfluent(cpOption.directlyStrictConflEnabled());
            pc.enableDirectlyStrictConfluentUpToIso(cpOption.directlyStrictConflUpToIsoEnabled());
            pc.enableNamedObjectOnly(cpOption.namedObjectEnabled());
            pc.enableMaxBoundOfCriticKind(cpOption.getMaxBoundOfCriticKind());
        }
        pc.setRules(rules);
        pc.setMorphCompletionStrategy(strategy);
        Thread cpThread = ParserFactory.generateCriticalPairs(pc);
        while (cpThread.isAlive()) {
        }
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> conflicts = pc.getConflictContainer();
        int i = 0;
        while (i < rules.size()) {
            Rule r = rules.get(i);
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> ruleConflicts = conflicts.get(r);
            Iterator<Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> iter = ruleConflicts.values().iterator();
            while (iter.hasNext()) {
                if (!((Boolean)iter.next().first).booleanValue()) continue;
                return false;
            }
            ++i;
        }
        return true;
    }

    private void makeParallelRule() {
        int tgCheckLevel = this.getTypeSet().getLevelOfTypeGraphCheck();
        if (tgCheckLevel > 20) {
            this.getTypeSet().setLevelOfTypeGraph(20);
        }
        Hashtable<String, String> varNames = new Hashtable<String, String>();
        VarTuple vars = (VarTuple)this.sources.get(0).getAttrContext().getVariables();
        int j = 0;
        while (j < vars.getNumberOfEntries()) {
            VarMember var = vars.getVarMemberAt(j);
            varNames.put(var.getName(), var.getName());
            ++j;
        }
        int i = 1;
        while (i < this.sources.size()) {
            this.renameVarsWhereNeeded(i, this.sources.get(i), varNames);
            ++i;
        }
        boolean ok = true;
        int i2 = 0;
        while (i2 < this.sources.size() && ok) {
            ok = this.extendRuleByDisjointUnion(this.sources.get(i2));
            ++i2;
        }
        if (ok) {
            if (this.handleRuleApplConditions()) {
                this.handleAttrConditions();
            } else {
                this.notApplicable = true;
            }
        } else {
            this.notApplicable = true;
        }
        this.replaceRenamedVars(varNames);
        i2 = 0;
        while (i2 < this.embeddingLeft.size()) {
            this.adjustUnsetAttrsAboveMorph(this.embeddingLeft.get(i2));
            ++i2;
        }
        this.removeUnusedVariableOfAttrContext();
        this.getTypeSet().setLevelOfTypeGraph(tgCheckLevel);
    }

    private void renameVarsWhereNeeded(int i, Rule r, Hashtable<String, String> varNames) {
        VarTuple vars = (VarTuple)r.getAttrContext().getVariables();
        if (varNames.isEmpty()) {
            int j = 0;
            while (j < vars.getNumberOfEntries()) {
                VarMember var = vars.getVarMemberAt(j);
                varNames.put(var.getName(), var.getName());
                ++j;
            }
        }
        List<OrdinaryMorphism> nacs = r.getNACsList();
        List<OrdinaryMorphism> pacs = r.getPACsList();
        AttrContext ac = r.getAttrContext();
        VarTuple varsN = (VarTuple)ac.getVariables();
        int j = 0;
        while (j < varsN.getNumberOfEntries()) {
            VarMember var = varsN.getVarMemberAt(j);
            if (varNames.get(var.getName()) != null) {
                String fromName = var.getName();
                String toName = fromName.concat(String.valueOf(i));
                while (varNames.get(toName) != null) {
                    toName = toName.concat(String.valueOf(i));
                }
                varNames.put(toName, fromName);
                var.getDeclaration().setName(toName);
                BaseFactory.theBaseFactory.renameVariableOfCondition(ac, (CondTuple)ac.getConditions(), fromName, toName);
                BaseFactory.theBaseFactory.setAttributeVariable(r.getSource(), fromName, toName, ac, varsN);
                BaseFactory.theBaseFactory.setAttributeVariable(r.getTarget(), fromName, toName, ac, varsN);
                int n = 0;
                while (n < nacs.size()) {
                    OrdinaryMorphism nac = nacs.get(n);
                    BaseFactory.theBaseFactory.setAttributeVariable(nac.getTarget(), fromName, toName, ac, varsN);
                    ++n;
                }
                n = 0;
                while (n < pacs.size()) {
                    OrdinaryMorphism pac = pacs.get(n);
                    BaseFactory.theBaseFactory.setAttributeVariable(pac.getTarget(), fromName, toName, ac, varsN);
                    ++n;
                }
            }
            ++j;
        }
    }

    private void replaceRenamedVars(Hashtable<String, String> varNames) {
        int i = 1;
        while (i < this.sources.size()) {
            Rule r = this.sources.get(i);
            AttrContext ac = r.getAttrContext();
            VarTuple varsN = (VarTuple)ac.getVariables();
            CondTuple condsN = (CondTuple)ac.getConditions();
            List<OrdinaryMorphism> nacs = r.getNACsList();
            List<OrdinaryMorphism> pacs = r.getPACsList();
            int j = 0;
            while (j < varsN.getNumberOfEntries()) {
                VarMember var = varsN.getVarMemberAt(j);
                if (varNames.get(var.getName()) != null && !var.getName().equals(varNames.get(var.getName()))) {
                    String fromName = var.getName();
                    String toName = varNames.get(var.getName());
                    var.getDeclaration().setName(toName);
                    BaseFactory.theBaseFactory.renameVariableOfCondition(ac, condsN, fromName, toName);
                    BaseFactory.theBaseFactory.setAttributeVariable(r.getSource(), fromName, toName, ac, varsN);
                    BaseFactory.theBaseFactory.setAttributeVariable(r.getTarget(), fromName, toName, ac, varsN);
                    int n = 0;
                    while (n < nacs.size()) {
                        OrdinaryMorphism nac = nacs.get(n);
                        BaseFactory.theBaseFactory.setAttributeVariable(nac.getTarget(), fromName, toName, ac, varsN);
                        ++n;
                    }
                    n = 0;
                    while (n < pacs.size()) {
                        OrdinaryMorphism pac = pacs.get(n);
                        BaseFactory.theBaseFactory.setAttributeVariable(pac.getTarget(), fromName, toName, ac, varsN);
                        ++n;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean extendRuleByDisjointUnion(Rule rule) {
        boolean ok = true;
        OrdinaryMorphism leftRuleToLeft = null;
        try {
            leftRuleToLeft = BaseFactory.theFactory().extendGraphByGraph(this.getLeft(), rule.getLeft());
        }
        catch (Exception e) {
            ok = false;
            System.out.println("ParallelRule.extendRuleByDisjointUnion: (LHS) " + e.getLocalizedMessage());
        }
        if (leftRuleToLeft != null) {
            OrdinaryMorphism rightRuleToRight = null;
            try {
                rightRuleToRight = BaseFactory.theFactory().extendGraphByGraph(this.getRight(), rule.getRight());
            }
            catch (Exception e) {
                ok = false;
                System.out.println("ParallelRule.extendRuleByDisjointUnion: (RHS) " + e.getLocalizedMessage());
            }
            if (rightRuleToRight != null && (ok = this.completeDiagram(leftRuleToLeft, rule, rightRuleToRight))) {
                this.embeddingLeft.add(leftRuleToLeft);
                this.embeddingRight.add(rightRuleToRight);
            }
        }
        BaseFactory.theFactory().unsetAllTransientAttrValuesOfRule(rule);
        BaseFactory.theFactory().unsetAllTransientAttrValuesOfRule(this);
        return ok;
    }

    private OrdinaryMorphism replaceRightByLeftInsideOfGraph(Rule rule, OrdinaryMorphism embRight, Graph graph, OrdinaryMorphism r2rl) {
        GraphObject go;
        Vector<GraphObject> del = new Vector<GraphObject>();
        Graph g1 = r2rl.getTarget();
        Vector<GraphObject> codom = embRight.getCodomainObjects();
        int i = 0;
        while (i < codom.size()) {
            go = r2rl.getImage(codom.get(i));
            if (go.isArc()) {
                del.add(0, go);
            } else {
                del.add(go);
            }
            ++i;
        }
        i = 0;
        while (i < del.size()) {
            go = (GraphObject)del.get(i);
            if (go.isArc()) {
                try {
                    g1.destroyArc((Arc)go, false, true);
                }
                catch (TypeException typeException) {}
            } else {
                try {
                    g1.destroyNode((Node)go, false, true);
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
            ++i;
        }
        try {
            OrdinaryMorphism l2rl = BaseFactory.theFactory().extendGraphByGraph(g1, rule.getLeft());
            return l2rl;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean handleRuleApplConditionsOLD(Rule r1, Rule r2) {
        boolean ok = true;
        try {
            OrdinaryMorphism rhs1ToE = r1.getRight().isomorphicCopy();
            OrdinaryMorphism lhs2ToE = BaseFactory.theFactory().extendGraphByGraph(rhs1ToE.getTarget(), r2.getLeft());
            OrdinaryMorphism left2 = BaseFactory.theFactory().createMorphism(this.itsOrig, lhs2ToE.getTarget());
            if (left2.completeDiagram(this.embeddingLeft.get(0), r1, rhs1ToE)) {
                left2.completeDiagram2(this.embeddingLeft.get(1), lhs2ToE);
            }
            OrdinaryMorphism rhs2ToE = r2.getRight().isomorphicCopy();
            OrdinaryMorphism lhs1ToE = BaseFactory.theFactory().extendGraphByGraph(rhs2ToE.getTarget(), r1.getLeft());
            OrdinaryMorphism left1 = BaseFactory.theFactory().createMorphism(this.itsOrig, lhs1ToE.getTarget());
            if (left1.completeDiagram(this.embeddingLeft.get(1), r2, rhs2ToE)) {
                left1.completeDiagram2(this.embeddingLeft.get(0), lhs1ToE);
            }
            Vector<Evaluable> flist = new Vector<Evaluable>();
            ok = this.shiftCondsOverEmbMorphOLD(0, r1, this.embeddingLeft.get(0), flist);
            if (ok) {
                ok = this.shiftCondsOverMorphAndLeftOLD(0, r1, lhs1ToE, left1, this.embeddingLeft.get(0), flist);
            }
            if (ok) {
                ok = this.shiftCondsOverEmbMorphOLD(1, r2, this.embeddingLeft.get(1), flist);
            }
            if (ok) {
                ok = this.shiftCondsOverMorphAndLeftOLD(1, r2, lhs2ToE, left2, this.embeddingLeft.get(1), flist);
            }
            if (ok) {
                this.removeIsomorphicMorph(this.getNACsList());
                this.removeIsomorphicMorph(this.getPACsList());
                boolean bl = ok = this.shiftGACs(0, r1, this.embeddingLeft.get(0), lhs1ToE, left1, flist) && this.shiftGACs(1, r2, this.embeddingLeft.get(1), lhs2ToE, left2, flist);
                if (ok && !this.getNestedACsList().isEmpty() && !flist.isEmpty()) {
                    Formula f = new Formula(flist, 4);
                    this.setFormula(f);
                }
            }
            this.getSource().unsetTransientAttrValues();
            this.getTarget().unsetTransientAttrValues();
            this.setInputParameterIfNeeded(this);
        }
        catch (Exception e) {
            ok = false;
        }
        return ok;
    }

    private boolean handleRuleApplConditionsOLD() {
        Vector<Evaluable> flist = new Vector<Evaluable>();
        boolean ok = true;
        int i = 0;
        while (i < this.sources.size() && ok) {
            OrdinaryMorphism left;
            Rule r = this.sources.get(i);
            OrdinaryMorphism rhsToE = this.getRight().isoCopy();
            OrdinaryMorphism lhsToE = this.replaceRightByLeftInsideOfGraph(r, this.embeddingRight.get(i), rhsToE.getTarget(), rhsToE);
            if (lhsToE != null) {
                left = BaseFactory.theFactory().createMorphism(this.itsOrig, lhsToE.getTarget());
                int k = 0;
                while (k < this.sources.size()) {
                    if (ok && k != i) {
                        ok = left.completeDiagram(this.embeddingLeft.get(k), this.sources.get(k), this.embeddingRight.get(k).compose(rhsToE));
                    }
                    ++k;
                }
                ok = left.completeDiagram2(this.embeddingLeft.get(i), lhsToE);
                if (ok) {
                    ok = this.shiftCondsOverEmbMorphOLD(i, r, this.embeddingLeft.get(i), flist);
                }
                if (ok) {
                    ok = this.shiftCondsOverMorphAndLeftOLD(i, r, lhsToE, left, this.embeddingLeft.get(i), flist);
                }
                if (ok) {
                    this.removeIsomorphicMorph(this.getNACsList());
                    this.removeIsomorphicMorph(this.getPACsList());
                }
            } else {
                rhsToE.dispose();
                return false;
            }
            ok = this.shiftGACs(i, r, this.embeddingLeft.get(i), lhsToE, left, flist);
            this.getSource().unsetTransientAttrValues();
            this.getTarget().unsetTransientAttrValues();
            this.setInputParameterIfNeeded(this);
            ++i;
        }
        if (ok && !this.getNestedACsList().isEmpty() && !flist.isEmpty()) {
            Formula f = new Formula(flist, 4);
            this.setFormula(f);
        }
        this.getSource().unsetTransientAttrValues();
        this.getTarget().unsetTransientAttrValues();
        this.setInputParameterIfNeeded(this);
        return ok;
    }

    private boolean handleRuleApplConditions() {
        Vector<Evaluable> flist = new Vector<Evaluable>();
        boolean ok = true;
        int i = 0;
        while (i < this.sources.size() && ok) {
            OrdinaryMorphism left;
            Rule r = this.sources.get(i);
            OrdinaryMorphism rhsToE = this.getRight().isoCopy();
            OrdinaryMorphism lhsToE = this.replaceRightByLeftInsideOfGraph(r, this.embeddingRight.get(i), rhsToE.getTarget(), rhsToE);
            if (lhsToE != null) {
                left = BaseFactory.theFactory().createMorphism(this.itsOrig, lhsToE.getTarget());
                int k = 0;
                while (k < this.sources.size()) {
                    if (ok && k != i) {
                        ok = left.completeDiagram(this.embeddingLeft.get(k), this.sources.get(k), this.embeddingRight.get(k).compose(rhsToE));
                    }
                    ++k;
                }
                ok = left.completeDiagram2(this.embeddingLeft.get(i), lhsToE);
                if (ok) {
                    ok = this.shiftPACs(i, r, this.embeddingLeft.get(i), lhsToE, left, flist);
                }
                if (ok) {
                    this.shiftNACs(i, r, this.embeddingLeft.get(i), lhsToE, left);
                }
                if (ok) {
                    this.removeIsomorphicMorph(this.getNACsList());
                    this.removeIsomorphicMorph(this.getPACsList());
                }
            } else {
                rhsToE.dispose();
                return false;
            }
            ok = this.shiftGACs(i, r, this.embeddingLeft.get(i), lhsToE, left, flist);
            this.getSource().unsetTransientAttrValues();
            this.getTarget().unsetTransientAttrValues();
            this.setInputParameterIfNeeded(this);
            ++i;
        }
        if (ok && !this.getNestedACsList().isEmpty() && !flist.isEmpty()) {
            Formula f = new Formula(flist, 4);
            this.setFormula(f);
        }
        this.getSource().unsetTransientAttrValues();
        this.getTarget().unsetTransientAttrValues();
        this.setInputParameterIfNeeded(this);
        return ok;
    }

    private boolean shiftCondsOverMorphAndLeftOLD(int indx, Rule r, OrdinaryMorphism morph, OrdinaryMorphism left, OrdinaryMorphism embMorph, Vector<Evaluable> flist) {
        boolean ok = true;
        Vector<Formula> fl = new Vector<Formula>();
        ok = this.shiftPACsOverMorphAndLeftOLD(indx, r, r.getPACs(), morph, left, embMorph, fl);
        if (ok) {
            if (!fl.isEmpty()) {
                Vector<Evaluable> evals = new Vector<Evaluable>(fl.size());
                int k = 0;
                while (k < fl.size()) {
                    evals.add((Evaluable)fl.get(k));
                    ++k;
                }
                Formula f = new Formula(evals, 4);
                if (f.isValid()) {
                    flist.add(f);
                }
            }
            this.shiftNACsOverMorphAndLeft(indx, r, r.getNACs(), morph, left, embMorph);
        }
        return ok;
    }

    private boolean shiftPACsOverMorphAndLeftOLD(int indx, Rule rule, Enumeration<OrdinaryMorphism> conds, OrdinaryMorphism morph, OrdinaryMorphism left, OrdinaryMorphism embMorph, List<Formula> fl) {
        boolean ok = true;
        while (conds.hasMoreElements() && ok) {
            OrdinaryMorphism cond = conds.nextElement();
            ok = this.shiftPACOverMorphAndLeftOLD(indx, rule, cond, morph, left, embMorph, fl);
        }
        return ok;
    }

    private boolean shiftPACOverMorphAndLeftOLD(int indx, Rule rule, OrdinaryMorphism cond, OrdinaryMorphism morph, OrdinaryMorphism left, OrdinaryMorphism embMorph, List<Formula> fl) {
        this.notApplicable = false;
        Vector<OrdinaryMorphism> result = new Vector<OrdinaryMorphism>();
        if (cond.getSize() > 0) {
            List<Pair<OrdinaryMorphism, OrdinaryMorphism>> list = this.shiftCondOverMorph(rule, cond, morph);
            if (list != null && list.size() > 0) {
                Vector<OrdinaryMorphism> list2 = new Vector<OrdinaryMorphism>();
                int i = 0;
                while (i < list.size()) {
                    Pair<OrdinaryMorphism, OrdinaryMorphism> p = list.get(i);
                    OrdinaryMorphism c = (OrdinaryMorphism)p.second;
                    OrdinaryMorphism lc = BaseFactory.theBaseFactory.shiftApplCondLeft(c, left);
                    if (!(this.isFalseCond(cond, lc, embMorph) || lc.isRightTotal() && lc.doesIgnoreAttrs())) {
                        lc.setName(c.getName());
                        lc.setEnabled(cond.isEnabled());
                        lc.getImage().setAttrContext(this.getLeft().getAttrContext());
                        lc.setAttrContext(this.getLeft().getAttrContext());
                        BaseFactory.theBaseFactory.declareVariable(lc.getTarget(), (VarTuple)this.getAttrContext().getVariables());
                        this.adjustUnsetAttrsAboveMorphs(cond, this.embeddingLeft.get(indx), lc);
                        list2.add(lc);
                    }
                    ++i;
                }
                if (list2.size() > 0) {
                    if (list2.size() > 1) {
                        this.removeIsomorphicMorph(list2);
                        Formula f = BaseFactory.theBaseFactory.replacePACsByGACs(list2);
                        fl.add(f);
                        int l = 0;
                        while (l < list2.size()) {
                            this.addNestedAC((OrdinaryMorphism)list2.get(l));
                            ++l;
                        }
                    } else {
                        result.add((OrdinaryMorphism)list2.get(0));
                    }
                } else {
                    this.notApplicable = true;
                    return false;
                }
                list2.clear();
                this.disposeMorphs(list);
            } else {
                this.notApplicable = true;
                return false;
            }
        }
        if (!this.notApplicable) {
            int l = 0;
            while (l < result.size()) {
                this.addPAC((OrdinaryMorphism)result.get(l));
                ++l;
            }
        }
        result.clear();
        return !this.notApplicable;
    }

    private List<OrdinaryMorphism> shiftPACOverMorphAndLeft(int indx, Rule rule, OrdinaryMorphism cond, OrdinaryMorphism morph, OrdinaryMorphism left, OrdinaryMorphism embMorph, List<Formula> fl) {
        this.notApplicable = false;
        Vector<OrdinaryMorphism> list = new Vector<OrdinaryMorphism>();
        if (cond.getSize() > 0) {
            List<Pair<OrdinaryMorphism, OrdinaryMorphism>> shift = this.shiftCondOverMorph(rule, cond, morph);
            if (shift != null && shift.size() > 0) {
                int i = 0;
                while (i < shift.size()) {
                    Pair<OrdinaryMorphism, OrdinaryMorphism> p = shift.get(i);
                    OrdinaryMorphism c = (OrdinaryMorphism)p.second;
                    OrdinaryMorphism lc = BaseFactory.theBaseFactory.shiftApplCondLeft(c, left);
                    if (!(this.isFalseCond(cond, lc, embMorph) || lc.isRightTotal() && lc.doesIgnoreAttrs())) {
                        lc.setName(c.getName());
                        lc.setEnabled(cond.isEnabled());
                        lc.getImage().setAttrContext(this.getLeft().getAttrContext());
                        lc.setAttrContext(this.getLeft().getAttrContext());
                        BaseFactory.theBaseFactory.declareVariable(lc.getTarget(), (VarTuple)this.getAttrContext().getVariables());
                        this.adjustUnsetAttrsAboveMorphs(cond, this.embeddingLeft.get(indx), lc);
                        list.add(lc);
                    }
                    ++i;
                }
            } else {
                this.notApplicable = true;
                return null;
            }
        }
        return list;
    }

    private boolean shiftNACsOverMorphAndLeft(int indx, Rule rule, Enumeration<OrdinaryMorphism> conds, OrdinaryMorphism morph, OrdinaryMorphism left, OrdinaryMorphism embMorph) {
        Vector<OrdinaryMorphism> result = new Vector<OrdinaryMorphism>();
        while (conds.hasMoreElements()) {
            OrdinaryMorphism cond = conds.nextElement();
            if (cond.getSize() <= 0) continue;
            List<Pair<OrdinaryMorphism, OrdinaryMorphism>> shift = this.shiftCondOverMorph(rule, cond, morph);
            Vector<OrdinaryMorphism> list2 = new Vector<OrdinaryMorphism>(shift.size());
            int i = 0;
            while (i < shift.size()) {
                Pair<OrdinaryMorphism, OrdinaryMorphism> p = shift.get(i);
                OrdinaryMorphism c = (OrdinaryMorphism)p.second;
                OrdinaryMorphism lc = BaseFactory.theBaseFactory.shiftApplCondLeft(c, left);
                if (!this.isFalseCond(cond, lc, embMorph)) {
                    lc.setName(c.getName());
                    lc.setEnabled(cond.isEnabled());
                    lc.getTarget().unsetTransientAttrValues();
                    this.adjustUnsetAttrsAboveMorphs(cond, this.embeddingLeft.get(indx), lc);
                    list2.add(lc);
                }
                ++i;
            }
            result.addAll(list2);
            this.disposeMorphs(shift);
            list2.clear();
        }
        if (!result.isEmpty()) {
            this.removeIsomorphicMorph(result);
            int l = 0;
            while (l < result.size()) {
                OrdinaryMorphism lc = (OrdinaryMorphism)result.get(l);
                if (!lc.isRightTotal() || !lc.doesIgnoreAttrs()) {
                    lc.getImage().setAttrContext(this.getLeft().getAttrContext());
                    lc.setAttrContext(this.getLeft().getAttrContext());
                    BaseFactory.theBaseFactory.declareVariable(lc.getTarget(), (VarTuple)this.getAttrContext().getVariables());
                    this.addNAC(lc);
                }
                ++l;
            }
            result.clear();
        }
        return true;
    }

    private List<Pair<OrdinaryMorphism, OrdinaryMorphism>> shiftCondOverMorph(Rule rule, OrdinaryMorphism cond, OrdinaryMorphism morph) {
        Enumeration<GraphObject> dom = cond.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject go = dom.nextElement();
            if (morph.getImage(go) != null) continue;
            this.failedApplConds.add(cond);
            return null;
        }
        OrdinaryMorphism condIsom = cond.getTarget().isomorphicCopy();
        if (condIsom == null) {
            this.failedApplConds.add(cond);
            return null;
        }
        OrdinaryMorphism leftToCond = cond.compose(condIsom);
        Vector<GraphObject> condDom = cond.getDomainObjects();
        Vector<Object> requiredObjs = new Vector<Object>(condDom.size());
        Hashtable<Object, Object> objmap = new Hashtable<Object, Object>(condDom.size());
        int j = 0;
        while (j < condDom.size()) {
            GraphObject go = condDom.get(j);
            GraphObject go1 = leftToCond.getImage(go);
            GraphObject go2 = morph.getImage(go);
            if (go1 != null && go2 != null) {
                requiredObjs.add(go1);
                objmap.put(go1, go2);
            }
            ++j;
        }
        Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> overlaps = BaseFactory.theBaseFactory.getOverlappingByPartialPredefinedIntersection(condIsom.getTarget(), morph.getTarget(), requiredObjs, objmap, true);
        Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> list = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>();
        while (overlaps.hasMoreElements()) {
            Pair<OrdinaryMorphism, OrdinaryMorphism> p = overlaps.nextElement();
            if (((OrdinaryMorphism)p.second).getTarget().isEmpty()) continue;
            OrdinaryMorphism c = (OrdinaryMorphism)p.second;
            this.filterObjsOfRightRuleCond(rule, cond, condIsom, (OrdinaryMorphism)p.first, c, morph);
            c.setName(cond.getName().concat(String.valueOf(list.size())));
            c.setEnabled(cond.isEnabled());
            c.shifted = true;
            OrdinaryMorphism first = condIsom.compose((OrdinaryMorphism)p.first);
            if (first.getSize() == condIsom.getSize()) {
                list.add(new Pair<OrdinaryMorphism, OrdinaryMorphism>(first, (OrdinaryMorphism)p.second));
                continue;
            }
            list.add(p);
        }
        if (list.isEmpty()) {
            this.failedApplConds.add(cond);
        }
        return list;
    }

    private boolean isFalseCond(OrdinaryMorphism cond, OrdinaryMorphism condL, OrdinaryMorphism leftEmbMorph) {
        for (GraphObject graphObject : cond.getSource().getNodesSet()) {
            GraphObject graphObject2 = leftEmbMorph.getImage(graphObject);
            if ((cond.getImage(graphObject) != null || condL.getImage(graphObject2) == null) && (cond.getImage(graphObject) == null || condL.getImage(graphObject2) != null)) continue;
            return true;
        }
        for (GraphObject graphObject : cond.getSource().getArcsSet()) {
            GraphObject go1 = leftEmbMorph.getImage(graphObject);
            if ((cond.getImage(graphObject) != null || condL.getImage(go1) == null) && (cond.getImage(graphObject) == null || condL.getImage(go1) != null)) continue;
            return true;
        }
        return false;
    }

    private boolean filterObjsOfRightRuleCond(Rule r, OrdinaryMorphism condL, OrdinaryMorphism condIsom, OrdinaryMorphism condTargetToCondCR, OrdinaryMorphism condCR, OrdinaryMorphism leftEmbeddingMorph) {
        boolean ok = true;
        Vector<GraphObject> todelete = new Vector<GraphObject>();
        for (Arc go_condCR : condCR.getTarget().getArcsSet()) {
            Arc goInv_condCR = null;
            if (!condCR.getInverseImage(go_condCR).hasMoreElements()) continue;
            if (condTargetToCondCR.getInverseImage(go_condCR).hasMoreElements()) {
                goInv_condCR = (Arc)condTargetToCondCR.getInverseImage(go_condCR).nextElement();
            }
            if (goInv_condCR == null) {
                todelete.add(go_condCR);
                continue;
            }
            if (!condIsom.getInverseImage(goInv_condCR).hasMoreElements()) {
                todelete.add(go_condCR);
                continue;
            }
            Arc go_leftCR = (Arc)condCR.getInverseImage(go_condCR).nextElement();
            int j = 0;
            while (j < this.sources.size()) {
                if (r == this.sources.get(j)) {
                    int k = 0;
                    while (k < this.embeddingLeft.size()) {
                        if (k == j) {
                            Arc go_left2;
                            if (this.embeddingLeft.get(k).getInverseImage(go_leftCR).hasMoreElements() && condL.getImage(go_left2 = (Arc)this.embeddingLeft.get(k).getInverseImage(go_leftCR).nextElement()) == null) {
                                condCR.removeMapping(go_condCR);
                            }
                        } else if (this.embeddingLeft.get(k).getInverseImage(go_leftCR).hasMoreElements()) {
                            todelete.add(go_condCR);
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        int i = 0;
        while (i < todelete.size()) {
            try {
                condCR.getTarget().destroyArc((Arc)todelete.get(i), false, false);
            }
            catch (TypeException goInv_condCR) {
                // empty catch block
            }
            ++i;
        }
        todelete.clear();
        for (Node go_condCR : condCR.getTarget().getNodesSet()) {
            Node goInv_condCR = null;
            if (!condCR.getInverseImage(go_condCR).hasMoreElements()) continue;
            if (condTargetToCondCR.getInverseImage(go_condCR).hasMoreElements()) {
                goInv_condCR = (Node)condTargetToCondCR.getInverseImage(go_condCR).nextElement();
            }
            if (goInv_condCR == null) {
                todelete.add(go_condCR);
                continue;
            }
            if (!condIsom.getInverseImage(goInv_condCR).hasMoreElements()) {
                todelete.add(go_condCR);
                continue;
            }
            Node go_leftCR = (Node)condCR.getInverseImage(go_condCR).nextElement();
            int j = 0;
            while (j < this.sources.size()) {
                if (r == this.sources.get(j)) {
                    int k = 0;
                    while (k < this.embeddingLeft.size()) {
                        if (k == j) {
                            Node go_left2;
                            if (this.embeddingLeft.get(k).getInverseImage(go_leftCR).hasMoreElements() && condL.getImage(go_left2 = (Node)this.embeddingLeft.get(k).getInverseImage(go_leftCR).nextElement()) == null) {
                                condCR.removeMapping(go_condCR);
                            }
                        } else if (this.embeddingLeft.get(k).getInverseImage(go_leftCR).hasMoreElements()) {
                            todelete.add(go_condCR);
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        int i2 = 0;
        while (i2 < todelete.size()) {
            try {
                condCR.getTarget().destroyNode((Node)todelete.get(i2), false, false);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
            ++i2;
        }
        return ok;
    }

    private OrdinaryMorphism shiftGlobalRuleCond(Rule rule, OrdinaryMorphism cond, OrdinaryMorphism morph) {
        OrdinaryMorphism condIsom = cond.getTarget().isomorphicCopy();
        if (condIsom == null) {
            return null;
        }
        OrdinaryMorphism condCR = BaseFactory.theBaseFactory.createMorphism(morph.getTarget(), condIsom.getTarget());
        condCR.setName(cond.getName());
        condCR.setEnabled(cond.isEnabled());
        return condCR;
    }

    private void removeIsomorphicMorph(List<OrdinaryMorphism> list) {
        Vector<OrdinaryMorphism> list1 = new Vector<OrdinaryMorphism>(list);
        int i = 0;
        while (i < list1.size()) {
            OrdinaryMorphism m1 = (OrdinaryMorphism)list1.get(i);
            if (list.contains(m1)) {
                int j = 0;
                while (j < list.size()) {
                    OrdinaryMorphism iso;
                    OrdinaryMorphism m = list.get(j);
                    if (m != m1 && (iso = m1.getTarget().getIsomorphicWith(m.getTarget())) != null) {
                        if (m1.isCommutative(m, iso)) {
                            list.remove(j);
                            --j;
                        }
                        iso.dispose();
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void removeIsomorphicNestedMorph(List<NestedApplCond> list) {
        Vector<NestedApplCond> list1 = new Vector<NestedApplCond>(list);
        int i = 0;
        while (i < list1.size()) {
            OrdinaryMorphism m1 = (OrdinaryMorphism)list1.get(i);
            if (list.contains(m1)) {
                int j = 0;
                while (j < list.size()) {
                    OrdinaryMorphism iso;
                    OrdinaryMorphism m = list.get(j);
                    if (m != m1 && (iso = m1.getTarget().getIsomorphicWith(m.getTarget())) != null) {
                        if (m1.isCommutative(m, iso)) {
                            list.remove(j);
                            --j;
                        }
                        iso.dispose();
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void removeIsomorphicMorph(List<OrdinaryMorphism> list1, List<OrdinaryMorphism> list2) {
        Vector<OrdinaryMorphism> list = new Vector<OrdinaryMorphism>(list1);
        list.addAll(list2);
        Vector<OrdinaryMorphism> list3 = new Vector<OrdinaryMorphism>(list);
        int i = 0;
        while (i < list.size()) {
            OrdinaryMorphism m1 = (OrdinaryMorphism)list.get(i);
            if (list3.contains(m1)) {
                int j = 0;
                while (j < list3.size()) {
                    OrdinaryMorphism iso;
                    OrdinaryMorphism m = (OrdinaryMorphism)list3.get(j);
                    if (m != m1 && (iso = m1.getTarget().getIsomorphicWith(m.getTarget())) != null) {
                        if (m1.isCommutative(m, iso)) {
                            list3.remove(j);
                            --j;
                            list1.remove(m);
                            list2.remove(m);
                        }
                        iso.dispose();
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private boolean shiftCondsOverEmbMorphOLD(int indx, Rule r, OrdinaryMorphism morph, Vector<Evaluable> flist) {
        boolean result = true;
        if (r.getPACs().hasMoreElements()) {
            Vector<Formula> fl = new Vector<Formula>();
            result = this.shiftPACsOverEmbMorphOLD(indx, r, r.getPACs(), morph, fl);
            if (result && !fl.isEmpty()) {
                Vector<Evaluable> evals = new Vector<Evaluable>(fl.size());
                int k = 0;
                while (k < fl.size()) {
                    evals.add((Evaluable)fl.get(k));
                    ++k;
                }
                Formula f = new Formula(evals, 4);
                if (f.isValid()) {
                    flist.add(f);
                }
            }
        }
        if (result && r.getNACs().hasMoreElements()) {
            this.shiftNACsOverEmbMorph(indx, r, r.getNACs(), morph);
        }
        return result;
    }

    private boolean shiftNACs(int indx, Rule r, OrdinaryMorphism embMorph, OrdinaryMorphism morph, OrdinaryMorphism left) {
        boolean result = true;
        if (r.getNACs().hasMoreElements()) {
            this.shiftNACsOverEmbMorph(indx, r, r.getNACs(), embMorph);
            this.shiftNACsOverMorphAndLeft(indx, r, r.getNACs(), morph, left, embMorph);
        }
        return result;
    }

    private boolean shiftPACs(int indx, Rule r, OrdinaryMorphism embMorph, OrdinaryMorphism morph, OrdinaryMorphism left, Vector<Evaluable> flist) {
        boolean ok = true;
        if (r.getPACs().hasMoreElements()) {
            Vector<Formula> fl = new Vector<Formula>();
            Enumeration<OrdinaryMorphism> conds = r.getPACs();
            while (conds.hasMoreElements() && ok) {
                OrdinaryMorphism cond = conds.nextElement();
                List<OrdinaryMorphism> list1 = this.shiftPACOverEmbMorph(indx, r, cond, embMorph, fl);
                List<OrdinaryMorphism> list2 = this.shiftPACOverMorphAndLeft(indx, r, cond, morph, left, embMorph, fl);
                if (list1 != null && !list1.isEmpty() && list2 != null && !list2.isEmpty()) {
                    this.removeIsomorphicMorph(list1, list2);
                    Vector<OrdinaryMorphism> list = new Vector<OrdinaryMorphism>(list1);
                    list.addAll(list2);
                    if (list.size() > 1) {
                        Formula f = BaseFactory.theBaseFactory.replacePACsByGACs(list);
                        fl.add(f);
                        int l = 0;
                        while (l < list.size()) {
                            this.addNestedAC((OrdinaryMorphism)list.get(l));
                            ++l;
                        }
                    } else {
                        this.addPAC((OrdinaryMorphism)list.get(0));
                    }
                    list1.clear();
                    list2.clear();
                    list.clear();
                    continue;
                }
                ok = false;
            }
            if (ok && !fl.isEmpty()) {
                Vector<Evaluable> evals = new Vector<Evaluable>(fl.size());
                int k = 0;
                while (k < fl.size()) {
                    evals.add((Evaluable)fl.get(k));
                    ++k;
                }
                Formula f = new Formula(evals, 4);
                if (f.isValid()) {
                    flist.add(f);
                }
            }
        }
        return ok;
    }

    private boolean shiftGACs(int indx, Rule r, OrdinaryMorphism embMorph, OrdinaryMorphism morph, OrdinaryMorphism left, Vector<Evaluable> flist) {
        boolean result = true;
        if (r.getNestedACs().hasMoreElements()) {
            Hashtable<String, List<NestedApplCond>> cond2shift = new Hashtable<String, List<NestedApplCond>>();
            Enumeration<OrdinaryMorphism> conds = r.getNestedACs();
            while (conds.hasMoreElements()) {
                List<NestedApplCond> list1;
                NestedApplCond cond = (NestedApplCond)conds.nextElement();
                List<NestedApplCond> list = this.shiftGACOverEmbMorph(indx, r, cond, embMorph, cond2shift);
                if (list != null && !list.isEmpty() && (list1 = this.shiftGACOverMorphAndLeft(indx, r, cond, morph, left, this.embeddingLeft.get(indx), cond2shift)) != null && !list1.isEmpty()) {
                    list.addAll(list1);
                    this.removeIsomorphicNestedMorph(list);
                    int j = 0;
                    while (j < list.size()) {
                        NestedApplCond nc = list.get(j);
                        if (!nc.getTarget().isEmpty()) {
                            nc.getTarget().unsetTransientAttrValues();
                            nc.getImage().setAttrContext(this.getLeft().getAttrContext());
                            nc.setAttrContext(this.getLeft().getAttrContext());
                            BaseFactory.theBaseFactory.declareVariable(nc.getTarget(), (VarTuple)this.getAttrContext().getVariables());
                            this.addNestedAC(nc);
                        }
                        ++j;
                    }
                    List<Evaluable> evals = r.getEnabledGeneralACsAsEvaluable();
                    Formula f = new Formula(evals, r.getFormulaStr());
                    int j2 = 0;
                    while (j2 < evals.size()) {
                        List<NestedApplCond> shift;
                        NestedApplCond nc = (NestedApplCond)evals.get(j2);
                        String key = String.valueOf(nc.hashCode() + indx);
                        if (cond2shift != null && (shift = cond2shift.get(key)) != null) {
                            Vector<Evaluable> shiftEvals = new Vector<Evaluable>(shift.size());
                            int k = 0;
                            while (k < shift.size()) {
                                shiftEvals.add(shift.get(k));
                                ++k;
                            }
                            f.patchInEvaluableAsDisjunction(cond, shiftEvals);
                        }
                        ++j2;
                    }
                    if (f.isValid()) {
                        flist.add(f);
                    }
                    list.clear();
                }
                list = null;
            }
        }
        return result;
    }

    private void handleAttrConditions() {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        CondTuple conds = (CondTuple)this.getAttrContext().getConditions();
        int i = 0;
        while (i < this.sources.size()) {
            Rule r = this.sources.get(i);
            VarTuple varsN = (VarTuple)r.getAttrContext().getVariables();
            CondTuple condsN = (CondTuple)r.getAttrContext().getConditions();
            int j = 0;
            while (j < varsN.getNumberOfEntries()) {
                VarMember var = varsN.getVarMemberAt(j);
                if (vars.getVarMemberAt(var.getName()) == null) {
                    vars.declare(var.getHandler(), var.getDeclaration().getTypeName(), var.getName());
                }
                ++j;
            }
            j = 0;
            while (j < condsN.getNumberOfEntries()) {
                CondMember cond = condsN.getCondMemberAt(j);
                if (!conds.contains(cond.getExprAsText())) {
                    conds.addCondition(cond.getExprAsText());
                }
                ++j;
            }
            ++i;
        }
    }

    private List<Pair<OrdinaryMorphism, OrdinaryMorphism>> shiftCondOverEmbMorph(OrdinaryMorphism cond, OrdinaryMorphism morph) {
        Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> list = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>();
        OrdinaryMorphism condSrcIsom = cond.getSource().isomorphicCopy();
        if (condSrcIsom == null) {
            return null;
        }
        OrdinaryMorphism condExt = BaseFactory.theBaseFactory.extendTargetGraph1ByTargetGraph2(condSrcIsom, cond);
        Graph dCondGraph = condSrcIsom.getTarget();
        Vector<GraphObject> condDom = condSrcIsom.getDomainObjects();
        Vector<Object> requiredObjs = new Vector<Object>(condDom.size());
        Hashtable<Object, Object> objmap = new Hashtable<Object, Object>(condDom.size());
        int j = 0;
        while (j < condDom.size()) {
            GraphObject go = condDom.get(j);
            GraphObject go1 = condSrcIsom.getImage(go);
            GraphObject go2 = morph.getImage(go);
            if (go1 != null && go2 != null) {
                requiredObjs.add(go1);
                objmap.put(go1, go2);
            }
            ++j;
        }
        Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> overlaps = BaseFactory.theBaseFactory.getOverlappingByPartialPredefinedIntersection(dCondGraph, morph.getTarget(), requiredObjs, objmap, true);
        while (overlaps.hasMoreElements()) {
            Pair<OrdinaryMorphism, OrdinaryMorphism> p = overlaps.nextElement();
            if (((OrdinaryMorphism)p.second).getTarget().isEmpty()) continue;
            OrdinaryMorphism c = (OrdinaryMorphism)p.second;
            c.setEnabled(cond.isEnabled());
            c.setName(cond.getName());
            c.shifted = true;
            OrdinaryMorphism first = condExt.compose((OrdinaryMorphism)p.first);
            if (first.getSize() == condExt.getSize()) {
                list.add(new Pair<OrdinaryMorphism, OrdinaryMorphism>(first, (OrdinaryMorphism)p.second));
                continue;
            }
            list.add(p);
        }
        return list.isEmpty() ? null : list;
    }

    private boolean shiftNACsOverEmbMorph(int indx, Rule r, Enumeration<OrdinaryMorphism> conds, OrdinaryMorphism morph) {
        while (conds.hasMoreElements()) {
            OrdinaryMorphism lc;
            OrdinaryMorphism cond = conds.nextElement();
            if (cond.getSize() > 0) {
                List<Pair<OrdinaryMorphism, OrdinaryMorphism>> shift = this.shiftCondOverEmbMorph(cond, morph);
                if (shift == null || shift.size() <= 0) continue;
                int i = 0;
                while (i < shift.size()) {
                    Pair<OrdinaryMorphism, OrdinaryMorphism> p = shift.get(i);
                    OrdinaryMorphism lc2 = (OrdinaryMorphism)p.second;
                    if (!lc2.getTarget().isEmpty()) {
                        lc2.getTarget().unsetTransientAttrValues();
                        int j = 0;
                        while (j < this.embeddingLeft.size()) {
                            this.filterNotNeededObjs(lc2, this.embeddingLeft.get(j));
                            ++j;
                        }
                        if (lc2.getTarget().getSize() >= cond.getTarget().getSize() && !this.isFalseCond(cond, lc2, morph)) {
                            lc2.setName(String.valueOf(cond.getName()) + "_" + String.valueOf(indx) + String.valueOf(i));
                            lc2.setEnabled(cond.isEnabled());
                            this.adjustUnsetAttrsAboveMorphs(cond, this.embeddingLeft.get(indx), lc2);
                            this.addNAC(lc2);
                        }
                    }
                    ++i;
                }
                shift.clear();
                continue;
            }
            if (cond.getSize() != 0 || (lc = this.shiftGlobalRuleCond(r, cond, morph)) == null || lc.getTarget().isEmpty()) continue;
            lc.setName(cond.getName());
            lc.setEnabled(cond.isEnabled());
            lc.getTarget().unsetTransientAttrValues();
            lc.getImage().setAttrContext(this.getLeft().getAttrContext());
            lc.setAttrContext(this.getLeft().getAttrContext());
            BaseFactory.theBaseFactory.declareVariable(cond.getTarget(), (VarTuple)this.getAttrContext().getVariables());
            this.adjustUnsetAttrsAboveMorphs(cond, this.embeddingLeft.get(indx), lc);
            this.addNAC(lc);
        }
        return true;
    }

    private boolean shiftPACsOverEmbMorphOLD(int indx, Rule r, Enumeration<OrdinaryMorphism> conds, OrdinaryMorphism morph, List<Formula> fl) {
        boolean ok = true;
        while (conds.hasMoreElements() && ok) {
            OrdinaryMorphism cond = conds.nextElement();
            ok = this.shiftPACOverEmbMorphOLD(indx, r, cond, morph, fl);
        }
        return ok;
    }

    private boolean shiftPACOverEmbMorphOLD(int indx, Rule r, OrdinaryMorphism cond, OrdinaryMorphism morph, List<Formula> fl) {
        OrdinaryMorphism lc;
        if (cond.getSize() > 0) {
            List<Pair<OrdinaryMorphism, OrdinaryMorphism>> shift = this.shiftCondOverEmbMorph(cond, morph);
            if (shift != null && shift.size() > 0) {
                Vector<OrdinaryMorphism> list = new Vector<OrdinaryMorphism>();
                int i = 0;
                while (i < shift.size()) {
                    Pair<OrdinaryMorphism, OrdinaryMorphism> p = shift.get(i);
                    OrdinaryMorphism lc2 = (OrdinaryMorphism)p.second;
                    if (!BaseFactory.theBaseFactory.isDanglingSatisfied(lc2, this)) {
                        System.out.println(String.valueOf(lc2.getName()) + "   dangling edge condition failed");
                        this.setErrorMsg(String.valueOf(lc2.getName()) + "   dangling edge condition failed");
                        this.disposeMorphs(shift);
                        this.notApplicable = true;
                        return false;
                    }
                    if (!lc2.getTarget().isEmpty()) {
                        lc2.getTarget().unsetTransientAttrValues();
                        int j = 0;
                        while (j < this.embeddingLeft.size()) {
                            this.filterNotNeededObjs(lc2, this.embeddingLeft.get(j));
                            ++j;
                        }
                        if (lc2.getTarget().getSize() >= cond.getTarget().getSize() && !this.isFalseCond(cond, lc2, morph)) {
                            lc2.setEnabled(cond.isEnabled());
                            lc2.setName(String.valueOf(cond.getName()) + "_" + String.valueOf(indx) + String.valueOf(i));
                            lc2.getImage().setAttrContext(this.getLeft().getAttrContext());
                            lc2.setAttrContext(this.getLeft().getAttrContext());
                            BaseFactory.theBaseFactory.declareVariable(lc2.getTarget(), (VarTuple)this.getAttrContext().getVariables());
                            this.adjustUnsetAttrsAboveMorphs(cond, this.embeddingLeft.get(indx), lc2);
                            list.add(lc2);
                        }
                    }
                    ++i;
                }
                if (list.size() > 1) {
                    this.removeIsomorphicMorph(list);
                    Formula f = BaseFactory.theBaseFactory.replacePACsByGACs(list);
                    fl.add(f);
                    int l = 0;
                    while (l < list.size()) {
                        this.addNestedAC((OrdinaryMorphism)list.get(l));
                        ++l;
                    }
                    this.disposeMorphs(shift);
                } else {
                    this.addPAC((OrdinaryMorphism)list.get(0));
                    shift.clear();
                }
                list.clear();
            }
        } else if (cond.getSize() == 0 && (lc = this.shiftGlobalRuleCond(r, cond, morph)) != null) {
            lc.setName(cond.getName());
            lc.setEnabled(cond.isEnabled());
            lc.getTarget().unsetTransientAttrValues();
            lc.getImage().setAttrContext(this.getLeft().getAttrContext());
            lc.setAttrContext(this.getLeft().getAttrContext());
            BaseFactory.theBaseFactory.declareVariable(lc.getTarget(), (VarTuple)this.getAttrContext().getVariables());
            this.adjustUnsetAttrsAboveMorphs(cond, this.embeddingLeft.get(indx), lc);
            this.addPAC(lc);
        }
        return true;
    }

    private List<OrdinaryMorphism> shiftPACOverEmbMorph(int indx, Rule r, OrdinaryMorphism cond, OrdinaryMorphism morph, List<Formula> fl) {
        OrdinaryMorphism lc;
        Vector<OrdinaryMorphism> list = new Vector<OrdinaryMorphism>();
        if (cond.getSize() > 0) {
            List<Pair<OrdinaryMorphism, OrdinaryMorphism>> shift = this.shiftCondOverEmbMorph(cond, morph);
            if (shift != null && shift.size() > 0) {
                int i = 0;
                while (i < shift.size()) {
                    Pair<OrdinaryMorphism, OrdinaryMorphism> p = shift.get(i);
                    OrdinaryMorphism lc2 = (OrdinaryMorphism)p.second;
                    if (!BaseFactory.theBaseFactory.isDanglingSatisfied(lc2, this)) {
                        System.out.println(String.valueOf(lc2.getName()) + "   dangling edge condition failed");
                        this.setErrorMsg(String.valueOf(lc2.getName()) + "   dangling edge condition failed");
                        this.disposeMorphs(shift);
                        this.notApplicable = true;
                        return null;
                    }
                    if (!lc2.getTarget().isEmpty()) {
                        lc2.getTarget().unsetTransientAttrValues();
                        int j = 0;
                        while (j < this.embeddingLeft.size()) {
                            this.filterNotNeededObjs(lc2, this.embeddingLeft.get(j));
                            ++j;
                        }
                        if (!this.isFalseCond(cond, lc2, morph)) {
                            lc2.setEnabled(cond.isEnabled());
                            lc2.setName(String.valueOf(cond.getName()) + "_" + String.valueOf(indx) + String.valueOf(i));
                            lc2.getImage().setAttrContext(this.getLeft().getAttrContext());
                            lc2.setAttrContext(this.getLeft().getAttrContext());
                            BaseFactory.theBaseFactory.declareVariable(lc2.getTarget(), (VarTuple)this.getAttrContext().getVariables());
                            this.adjustUnsetAttrsAboveMorphs(cond, this.embeddingLeft.get(indx), lc2);
                            list.add(lc2);
                        }
                    }
                    ++i;
                }
            }
        } else if (cond.getSize() == 0 && (lc = this.shiftGlobalRuleCond(r, cond, morph)) != null) {
            lc.setName(cond.getName());
            lc.setEnabled(cond.isEnabled());
            lc.getTarget().unsetTransientAttrValues();
            lc.getImage().setAttrContext(this.getLeft().getAttrContext());
            lc.setAttrContext(this.getLeft().getAttrContext());
            BaseFactory.theBaseFactory.declareVariable(lc.getTarget(), (VarTuple)this.getAttrContext().getVariables());
            this.adjustUnsetAttrsAboveMorphs(cond, this.embeddingLeft.get(indx), lc);
            list.add(lc);
        }
        return list;
    }

    private List<NestedApplCond> shiftGACOverEmbMorph(int indx, Rule r, NestedApplCond cond, OrdinaryMorphism morph, Hashtable<String, List<NestedApplCond>> cond2shift) {
        List<Pair<OrdinaryMorphism, OrdinaryMorphism>> shift = this.shiftCondOverEmbMorph(cond, morph);
        if (shift != null && shift.size() > 0) {
            Vector<NestedApplCond> left = new Vector<NestedApplCond>(shift.size());
            int i = 0;
            while (i < shift.size()) {
                Pair<OrdinaryMorphism, OrdinaryMorphism> p = shift.get(i);
                OrdinaryMorphism c = (OrdinaryMorphism)p.second;
                int j = 0;
                while (j < this.embeddingLeft.size()) {
                    this.filterNotNeededObjs(c, this.embeddingLeft.get(j));
                    this.filterCondL(cond, c, this.embeddingLeft.get(j));
                    ++j;
                }
                if (cond.getSize() > 0 && c.getSize() == 0) {
                    c.dispose();
                    shift.remove(i);
                    --i;
                } else {
                    if (!BaseFactory.theBaseFactory.isDanglingSatisfied(c, this)) {
                        System.out.println(String.valueOf(c.getName()) + "   dangling edge condition failed");
                        this.setErrorMsg(String.valueOf(c.getName()) + "   dangling edge condition failed");
                        this.disposeMorphs(shift);
                        shift.clear();
                        shift = null;
                        return null;
                    }
                    if (c.getTarget().getSize() >= cond.getTarget().getSize() && !this.isFalseCond(cond, c, morph)) {
                        NestedApplCond lc = BaseFactory.theBaseFactory.createGeneralMorphism(c.getSource(), c.getTarget());
                        lc.getDomainObjects().addAll(c.getDomainObjects());
                        lc.getCodomainObjects().addAll(c.getCodomainObjects());
                        BaseFactory.theBaseFactory.unsetAllTransientAttrValues(lc);
                        lc.setEnabled(c.isEnabled());
                        lc.setName(String.valueOf(cond.getName()) + "_" + String.valueOf(indx) + String.valueOf(i));
                        this.adjustUnsetAttrsAboveMorphs(cond, this.embeddingLeft.get(indx), lc);
                        left.add(lc);
                        if (!cond.getNestedACs().isEmpty()) {
                            this.shiftNestedCondOverMorph(cond, (OrdinaryMorphism)p.first, lc);
                        }
                    }
                    c.dispose();
                }
                ++i;
            }
            shift.clear();
            shift = null;
            String key = String.valueOf(cond.hashCode() + indx);
            if (cond2shift.get(key) == null) {
                cond2shift.put(key, left);
            } else {
                cond2shift.get(key).addAll(left);
            }
            left.trimToSize();
            return left;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private List<NestedApplCond> shiftGACOverMorphAndLeft(int indx, Rule r, NestedApplCond cond, OrdinaryMorphism morph, OrdinaryMorphism left, OrdinaryMorphism embMorph, Hashtable<String, List<NestedApplCond>> cond2shift) {
        block6: {
            shift = this.shiftCondOverMorph(r, cond, morph);
            if (shift == null || shift.size() <= 0) break block6;
            list = new Vector<NestedApplCond>(shift.size());
            i = 0;
            while (i < shift.size()) {
                block8: {
                    block9: {
                        block7: {
                            p = shift.get(i);
                            c = (OrdinaryMorphism)p.second;
                            if (cond.getSize() <= 0 || c.getSize() != 0) break block7;
                            c.dispose();
                            shift.remove(i);
                            --i;
                            break block8;
                        }
                        lc = BaseFactory.theBaseFactory.shiftApplCondLeft(c, left);
                        if (lc == null) ** GOTO lbl51
                        if ((cond.getSize() <= 0 || lc.getSize() != 0) && lc.getTarget().getSize() >= cond.getTarget().getSize()) break block9;
                        c.dispose();
                        lc.dispose();
                        shift.remove(i);
                        --i;
                        break block8;
                    }
                    this.filterNotNeededObjs(lc, embMorph);
                    this.filterCondL(c, lc, embMorph);
                    lnc = BaseFactory.theBaseFactory.createGeneralMorphism(lc.getSource(), lc.getTarget());
                    lnc.getDomainObjects().addAll(lc.getDomainObjects());
                    lnc.getCodomainObjects().addAll(lc.getCodomainObjects());
                    lnc.getTarget().unsetTransientAttrValues();
                    this.filterNotNeededObjs(lnc, morph);
                    if (this.isFalseCond(cond, lnc, embMorph)) ** GOTO lbl51
                    lnc.setEnabled(c.isEnabled());
                    lnc.setName(String.valueOf(cond.getName()) + "_" + String.valueOf(indx) + String.valueOf(i) + "_");
                    this.adjustUnsetAttrsAboveMorphs(cond, embMorph, lc);
                    ok = cond.getNestedACs().isEmpty();
                    if (!cond.getNestedACs().isEmpty()) {
                        ok = this.shiftNestedCondOverMorph(cond, (OrdinaryMorphism)p.first, lnc);
                    }
                    if (!ok) {
                        c.dispose();
                        lc.dispose();
                        lnc.dispose();
                        shift.remove(i);
                        --i;
                    } else {
                        list.add(lnc);
lbl51:
                        // 3 sources

                        c.dispose();
                        lc.dispose();
                    }
                }
                ++i;
            }
            shift.clear();
            shift = null;
            list.trimToSize();
            key = String.valueOf(cond.hashCode() + indx);
            if (cond2shift.get(key) == null) {
                cond2shift.put(key, list);
            } else {
                cond2shift.get(key).addAll(list);
            }
            return list;
        }
        return null;
    }

    private boolean shiftNestedCondOverMorph(NestedApplCond cond, OrdinaryMorphism mo1, NestedApplCond lshiftCond) {
        List<Evaluable> evals = cond.getEnabledGeneralACsAsEvaluable();
        Formula f = new Formula(evals, cond.getFormulaStr());
        int i = 0;
        while (i < cond.getNestedACs().size()) {
            NestedApplCond nc = cond.getNestedACs().get(i);
            List<Pair<OrdinaryMorphism, OrdinaryMorphism>> shift = this.shiftCondOverEmbMorph(nc, mo1);
            if (shift != null && shift.size() > 0) {
                Vector<NestedApplCond> l = new Vector<NestedApplCond>(shift.size());
                int j = 0;
                while (j < shift.size()) {
                    Pair<OrdinaryMorphism, OrdinaryMorphism> p = shift.get(j);
                    OrdinaryMorphism sc = (OrdinaryMorphism)p.second;
                    this.filterCondL(nc, sc, mo1);
                    if (nc.getSize() > 0 && sc.getSize() == 0 || sc.getTarget().getSize() < nc.getTarget().getSize() || this.isFalseCond(nc, sc, mo1)) {
                        sc.dispose();
                        shift.remove(j);
                        --j;
                    } else {
                        OrdinaryMorphism mo2;
                        BaseFactory.theBaseFactory.unsetAllTransientAttrValues(sc);
                        NestedApplCond nsc = BaseFactory.theBaseFactory.createGeneralMorphism(sc.getSource(), sc.getTarget());
                        nsc.getDomainObjects().addAll(sc.getDomainObjects());
                        nsc.getCodomainObjects().addAll(sc.getCodomainObjects());
                        BaseFactory.theBaseFactory.declareVariable(nsc.getTarget(), (VarTuple)nsc.getAttrContext().getVariables());
                        BaseFactory.theBaseFactory.adjustAttributeValueAlongMorphismMapping(nsc);
                        nsc.setName(String.valueOf(nc.getName()) + "_" + String.valueOf(j));
                        lshiftCond.addNestedAC(nsc);
                        l.add(nsc);
                        if (!nc.getNestedACs().isEmpty() && (mo2 = BaseFactory.theBaseFactory.createMorphism(nc.getTarget(), nsc.getTarget())).completeDiagram(nc, mo1, nsc)) {
                            this.shiftNestedCondOverMorph(nc, mo2, nsc);
                        }
                    }
                    ++j;
                }
                Vector<Evaluable> shiftEvals = new Vector<Evaluable>(l.size());
                int k = 0;
                while (k < l.size()) {
                    shiftEvals.add((Evaluable)l.get(k));
                    ++k;
                }
                f.patchInEvaluableAsDisjunction(nc, shiftEvals);
            }
            ++i;
        }
        if (cond.getNestedACs().size() > 0 && lshiftCond.getNestedACs().size() == 0) {
            return false;
        }
        if (f.isValid()) {
            lshiftCond.setFormula(f);
        }
        return true;
    }

    private void filterNotNeededObjs(OrdinaryMorphism cond, OrdinaryMorphism iL) {
        Vector<GraphObject> delete = new Vector<GraphObject>();
        for (Arc arc : cond.getTarget().getArcsSet()) {
            GraphObject lgo;
            Enumeration<GraphObject> inv = cond.getInverseImage(arc);
            if (!inv.hasMoreElements() || iL.getInverseImage(lgo = inv.nextElement()).hasMoreElements() || !this.similarAttribute(lgo, arc)) continue;
            delete.add(arc);
        }
        int i = 0;
        while (i < delete.size()) {
            Arc arc = (Arc)delete.get(i);
            try {
                cond.removeMapping(arc);
                try {
                    cond.getTarget().destroyArc(arc, false, false);
                }
                catch (TypeException lgo) {}
            }
            catch (BadMappingException lgo) {
                // empty catch block
            }
            ++i;
        }
        delete.clear();
        for (Node node : cond.getTarget().getNodesSet()) {
            GraphObject lgo;
            Enumeration<GraphObject> inv;
            if (node.getOutgoingArcs().hasNext() || node.getIncomingArcs().hasNext() || !(inv = cond.getInverseImage(node)).hasMoreElements() || iL.getInverseImage(lgo = inv.nextElement()).hasMoreElements() || !this.similarAttribute(lgo, node)) continue;
            delete.add(node);
        }
        int i2 = 0;
        while (i2 < delete.size()) {
            Node node = (Node)delete.get(i2);
            try {
                cond.removeMapping(node);
                try {
                    cond.getTarget().destroyNode(node, false, false);
                }
                catch (TypeException typeException) {}
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
            ++i2;
        }
        delete.clear();
        delete = null;
    }

    /*
     * WARNING - void declaration
     */
    private void filterCondL(OrdinaryMorphism cond, OrdinaryMorphism condL, OrdinaryMorphism leftEmbMorph) {
        void var7_12;
        Vector<GraphObject> del = new Vector<GraphObject>();
        for (GraphObject graphObject : cond.getSource().getArcsSet()) {
            GraphObject graphObject2 = leftEmbMorph.getImage(graphObject);
            GraphObject go2 = condL.getImage(graphObject2);
            if (cond.getImage(graphObject) != null || go2 == null || !this.similarAttribute(go2, graphObject2)) continue;
            del.add(go2);
        }
        for (GraphObject graphObject : cond.getSource().getNodesSet()) {
            GraphObject go1 = leftEmbMorph.getImage(graphObject);
            GraphObject go2 = condL.getImage(go1);
            if (cond.getImage(graphObject) != null || go2 == null || !this.similarAttribute(go2, go1)) continue;
            del.add(go2);
        }
        boolean bl = false;
        while (var7_12 < del.size()) {
            GraphObject go = (GraphObject)del.get((int)var7_12);
            if (go.isArc()) {
                try {
                    condL.removeMapping(go);
                    try {
                        condL.getTarget().destroyArc((Arc)go, false, false);
                    }
                    catch (TypeException typeException) {
                    }
                }
                catch (BadMappingException badMappingException) {}
            } else {
                try {
                    condL.removeMapping(go);
                    try {
                        condL.getTarget().destroyNode((Node)go, false, false);
                    }
                    catch (TypeException typeException) {}
                }
                catch (BadMappingException badMappingException) {
                    // empty catch block
                }
            }
            ++var7_12;
        }
        del.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean similarAttribute(GraphObject go1, GraphObject go2) {
        if (go1.getAttribute() == null || go2.getAttribute() == null) return true;
        ValueTuple val1 = (ValueTuple)go1.getAttribute();
        ValueTuple val2 = (ValueTuple)go2.getAttribute();
        int i = 0;
        while (i < val2.getNumberOfEntries()) {
            ValueMember vm2 = val2.getValueMemberAt(i);
            ValueMember vm1 = val1.getValueMemberAt(vm2.getName());
            if (vm2.isSet()) {
                if (vm1 == null || !vm1.isSet()) return false;
                if (!vm2.getExprAsText().equals(vm1.getExprAsText())) {
                    return false;
                }
            } else if (vm1.isSet()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void setInputParameterIfNeeded(Rule r) {
        VarTuple vars = (VarTuple)r.getAttrContext().getVariables();
        Vector<String> varNamesRHS = r.getTarget().getVariableNamesOfAttributes();
        Vector<String> varNamesLHS = r.getSource().getVariableNamesOfAttributes();
        int i = 0;
        while (i < vars.getNumberOfEntries()) {
            VarMember var = vars.getVarMemberAt(i);
            if (varNamesRHS.contains(var.getName()) && !varNamesLHS.contains(var.getName())) {
                var.setInputParameter(true);
            }
            ++i;
        }
    }

    private void disposeMorphs(List<Pair<OrdinaryMorphism, OrdinaryMorphism>> list) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                Pair<OrdinaryMorphism, OrdinaryMorphism> p = list.get(i);
                ((OrdinaryMorphism)p.first).dispose();
                ((OrdinaryMorphism)p.second).dispose();
                ++i;
            }
            list.clear();
        }
    }

    private void disposeMorphs2(List<NestedApplCond> list) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                list.get(i).dispose();
                ++i;
            }
            list.clear();
        }
    }

    private void adjustUnsetAttrsAboveMorph(OrdinaryMorphism morph) {
        Enumeration<GraphObject> dom = morph.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject from = dom.nextElement();
            GraphObject to = morph.getImage(from);
            if (from.getAttribute() == null || to.getAttribute() == null) continue;
            ValueTuple vt_from = (ValueTuple)from.getAttribute();
            ValueTuple vt_to = (ValueTuple)to.getAttribute();
            int i = 0;
            while (i < vt_from.getNumberOfEntries()) {
                ValueMember vm_to;
                ValueMember vm_from = vt_from.getValueMemberAt(i);
                if (!vm_from.isSet() && (vm_to = vt_to.getValueMemberAt(vm_from.getName())) != null && vm_to.isSet()) {
                    vm_to.setExpr(null);
                    vm_to.setTransient(false);
                }
                ++i;
            }
        }
    }

    private void adjustUnsetAttrsAboveMorphs(OrdinaryMorphism cond, OrdinaryMorphism morph, OrdinaryMorphism shifted) {
        Enumeration<GraphObject> dom = morph.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj = dom.nextElement();
            GraphObject img = morph.getImage(obj);
            GraphObject from = cond.getImage(obj);
            GraphObject to = shifted.getImage(img);
            if (from == null || to == null || from.getAttribute() == null || to.getAttribute() == null) continue;
            ValueTuple vt_from = (ValueTuple)from.getAttribute();
            ValueTuple vt_to = (ValueTuple)to.getAttribute();
            int i = 0;
            while (i < vt_from.getNumberOfEntries()) {
                ValueMember vm_to;
                ValueMember vm_from = vt_from.getValueMemberAt(i);
                if (!vm_from.isSet() && (vm_to = vt_to.getValueMemberAt(vm_from.getName())) != null && vm_to.isSet()) {
                    vm_to.setExpr(null);
                    vm_to.setTransient(false);
                }
                ++i;
            }
        }
    }
}

