/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrException;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.VarMember;
import agg.cons.Formula;
import agg.util.Pair;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.GraGra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.GraTraEventListener;
import agg.xt_basis.GraTraOptions;
import agg.xt_basis.Graph;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Morphism;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.StaticStep;
import agg.xt_basis.TypeException;
import agg.xt_basis.agt.RuleScheme;
import agg.xt_basis.csp.CompletionPropertyBits;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class GraTra {
    protected String name;
    protected GraGra grammar;
    protected Graph hostgraph;
    protected Rule currentRule;
    protected Vector<Rule> currentRuleSet = new Vector();
    protected Match currentMatch;
    protected boolean colimitBasedPushout;
    protected boolean updateTypeObjectsMapAfterStep = true;
    protected MorphCompletionStrategy strategy;
    protected final Vector<GraTraEventListener> graTraListeners = new Vector();
    protected boolean stopping = false;
    protected boolean stoppingRule = false;
    protected boolean pauseRule = false;
    protected boolean waitAfterStep = false;
    protected boolean consistentGraph = true;
    protected boolean writeLogFile = false;
    protected GraTraOptions options;
    protected String errorMsg = "";
    protected boolean wait;

    public void dispose() {
        this.graTraListeners.clear();
        if (this.grammar != null) {
            this.grammar.destroyAllMatches();
        }
        this.currentRuleSet.clear();
        this.grammar = null;
        this.hostgraph = null;
        this.currentRule = null;
        this.currentMatch = null;
    }

    public void setName(String n) {
        if (n != null) {
            this.name = n;
        }
    }

    public String getName() {
        if (this.name == null) {
            return "unnamed";
        }
        return this.name;
    }

    public boolean setGraGra(GraGra gg) {
        if (gg == null) {
            this.grammar = null;
            this.hostgraph = null;
            return false;
        }
        this.grammar = gg;
        this.setRuleSet();
        this.hostgraph = this.grammar.getGraph();
        this.strategy = this.grammar.getMorphismCompletionStrategy();
        this.getGraTraOptions();
        return true;
    }

    private void resetTargetOfRuleMatches() {
        int i = 0;
        while (i < this.currentRuleSet.size()) {
            Rule r = this.currentRuleSet.get(i);
            Match m = r.getMatch();
            if (m != null) {
                if (m.getTarget() != this.hostgraph) {
                    m.resetTarget(this.hostgraph);
                    m.setTypeObjectsMapChanged(true);
                } else {
                    return;
                }
            }
            ++i;
        }
    }

    public GraGra getGraGra() {
        return this.grammar;
    }

    public Rule getCurrentRule() {
        return this.currentRule;
    }

    public Match getCurrentMatch() {
        return this.currentMatch;
    }

    public boolean setHostGraph(Graph g) {
        if (this.hostgraph == null) {
            this.hostgraph = g;
            this.hostgraph.updateTypeObjectsMap();
            this.resetExistingMatchesOfRules(g);
            this.resetTargetOfRuleMatches();
            return true;
        }
        this.hostgraph = g;
        this.hostgraph.updateTypeObjectsMap();
        this.resetExistingMatchesOfRules(g);
        this.resetTargetOfRuleMatches();
        return false;
    }

    public Graph getHostGraph() {
        return this.hostgraph;
    }

    private void resetExistingMatchesOfRules(Graph g) {
        int i = 0;
        while (i < this.grammar.getListOfRules().size()) {
            Rule r = this.grammar.getListOfRules().get(i);
            r.setMatch(this.grammar.getMatch(r, g));
            ++i;
        }
    }

    public GraTraOptions getGraTraOptions() {
        if (this.options == null) {
            this.options = new GraTraOptions();
        }
        if (this.strategy != null) {
            this.options.addOption(CompletionStrategySelector.getName(this.strategy));
            BitSet activebits = this.strategy.getProperties();
            int i = 0;
            while (i < CompletionPropertyBits.BITNAME.length) {
                if (activebits.get(i)) {
                    String bitName = CompletionPropertyBits.BITNAME[i];
                    this.options.addOption(bitName);
                }
                ++i;
            }
            if (!this.strategy.isRandomisedDomain()) {
                this.options.addOption("determinedCSPDomain");
            }
        }
        return this.options;
    }

    public void setGraTraOptions(GraTraOptions newOptions) {
        this.options = newOptions;
        this.options.updateMorphismCompletionStrategy();
        this.setCompletionStrategy(this.options.getCompletionStrategy());
    }

    public void setGraTraOptions(Vector<String> newOptions) {
        GraTraOptions nOptions = new GraTraOptions();
        int i = 0;
        while (i < newOptions.size()) {
            String opt = newOptions.elementAt(i);
            nOptions.addOption(opt);
            ++i;
        }
        this.options = nOptions;
        this.options.updateMorphismCompletionStrategy();
        this.setCompletionStrategy(this.options.getCompletionStrategy());
    }

    public void setCompletionStrategy(MorphCompletionStrategy strat) {
        this.strategy = strat;
    }

    public MorphCompletionStrategy getCompletionStrategy() {
        return this.strategy;
    }

    public Enumeration<Match> getMatches(Rule r) {
        Iterator<Rule> rules = this.grammar.getListOfRules().iterator();
        boolean indicator = false;
        while (rules.hasNext()) {
            if (r != rules.next()) continue;
            indicator = true;
            break;
        }
        if (!indicator) {
            return null;
        }
        return this.grammar.getMatches(r);
    }

    public Match createMatch(Rule r) {
        Iterator<Rule> rules = this.grammar.getListOfRules().iterator();
        boolean indicator = false;
        while (rules.hasNext()) {
            if (r != rules.next()) continue;
            indicator = true;
            break;
        }
        if (!indicator) {
            return null;
        }
        return this.grammar.createMatch(r);
    }

    public void destroyMatch(Match m) {
        this.fireGraTra(new GraTraEvent((Object)this, 17, m));
        this.grammar.destroyMatch(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Morphism apply(Match m) {
        var2_2 = m;
        synchronized (var2_2) {
            block25: {
                block24: {
                    block23: {
                        block22: {
                            this.errorMsg = "";
                            co_match = null;
                            this.consistentGraph = true;
                            if (this.options == null) {
                                this.options = this.getGraTraOptions();
                            }
                            if (!this.options.hasOption("consistencyCheckAfterGraphTrafo")) break block22;
                            try {
                                co_match = StaticStep.execute(m);
                                ** GOTO lbl73
                            }
                            catch (TypeException e) {
                                this.errorMsg = e.getMessage();
                                this.fireGraTra(new GraTraEvent(this, 4, m, this.errorMsg));
                                return null;
                            }
                        }
                        if (this.options.hasOption("consistency")) break block23;
                        try {
                            co_match = StaticStep.execute(m);
                            if (co_match != null && !this.checkGraphConsistency(m.getRule(), m.getTarget())) {
                                this.consistentGraph = false;
                            }
                            ** GOTO lbl73
                        }
                        catch (TypeException e) {
                            this.errorMsg = e.getMessage();
                            this.fireGraTra(new GraTraEvent(this, 4, m, this.errorMsg));
                            return null;
                        }
                    }
                    validStep = false;
                    try {
                        co_match = this.makeTestStep(m);
                        validStep = true;
                        this.consistentGraph = this.checkGraphConsistencyForComatch(m, (OrdinaryMorphism)co_match);
                        co_match.dispose();
                        co_match = null;
                    }
                    catch (TypeException ex) {
                        this.errorMsg = ex.getLocalizedMessage();
                    }
                    while (!(validStep && this.consistentGraph || !m.nextCompletion())) {
                        if (!m.isValid()) continue;
                        try {
                            co_match = this.makeTestStep(m);
                            validStep = true;
                            this.consistentGraph = this.checkGraphConsistencyForComatch(m, (OrdinaryMorphism)co_match);
                            co_match.dispose();
                            co_match = null;
                            if (!this.consistentGraph) continue;
                            break;
                        }
                        catch (TypeException ex) {
                            this.errorMsg = ex.getLocalizedMessage();
                        }
                    }
                    if (validStep) break block24;
                    this.fireGraTra(new GraTraEvent(this, 4, m, this.errorMsg));
                    return null;
                }
                if (!this.consistentGraph) break block25;
                this.fireGraTra(new GraTraEvent((Object)this, 8, m));
                try {
                    co_match = StaticStep.execute(m);
                    ** GOTO lbl73
                }
                catch (TypeException e) {
                    this.errorMsg = e.getMessage();
                    this.fireGraTra(new GraTraEvent(this, 4, m, this.errorMsg));
                    return null;
                }
            }
            this.errorMsg = "Graph inconsistency after transformation.";
lbl73:
            // 4 sources

            if (co_match != null) {
                this.fireGraTra(new GraTraEvent((Object)this, 2, m));
            }
            if (!this.consistentGraph) {
                this.fireGraTra(new GraTraEvent((Object)this, 11, m));
            }
            return co_match;
        }
    }

    public boolean step(Match m) {
        return m != null && this.apply(m) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean apply(Rule r) {
        Rule rule = r;
        synchronized (rule) {
            this.stoppingRule = false;
            boolean result = false;
            boolean valid = false;
            this.currentMatch = r.getMatch();
            if (this.currentMatch == null) {
                this.currentMatch = this.grammar.createMatch(r);
                this.currentMatch.setCompletionStrategy((MorphCompletionStrategy)this.strategy.clone(), true);
            } else if (this.updateTypeObjectsMapAfterStep) {
                this.currentMatch.setTypeObjectsMapChanged(true);
            }
            boolean parallelApply = true;
            boolean is_applied = false;
            while (parallelApply) {
                if (!this.isInputParameterSet(r.getLeft(), true, this.currentMatch)) {
                    this.fireGraTra(new GraTraEvent((Object)this, 1, this.currentMatch));
                }
                if (this.stopping || this.stoppingRule) {
                    this.currentMatch.clear();
                    return false;
                }
                if (this.pauseRule) {
                    return false;
                }
                valid = false;
                while (!valid) {
                    if (this.currentMatch.nextCompletion()) {
                        if (this.currentMatch.isValid()) {
                            valid = true;
                            if (!r.isParallelApplyEnabled() || !this.currentMatch.typeObjectsMapChanged) continue;
                            this.currentMatch.typeObjectsMapChanged = false;
                            this.updateTypeObjectsMapAfterStep = false;
                            continue;
                        }
                        this.errorMsg = this.currentMatch.getErrorMsg();
                        this.currentMatch.clear();
                        continue;
                    }
                    this.errorMsg = this.currentMatch.getErrorMsg();
                    break;
                }
                if (valid) {
                    this.fireGraTra(new GraTraEvent((Object)this, 8, this.currentMatch));
                    if (!this.isInputParameterSet(r.getRight(), false, this.currentMatch)) {
                        this.fireGraTra(new GraTraEvent((Object)this, 1, this.currentMatch));
                    }
                    try {
                        boolean checkVarsOnly = true;
                        this.currentMatch.getAttrContext().getVariables().getAttrManager().checkIfReadyToTransform(this.currentMatch.getAttrContext(), checkVarsOnly);
                    }
                    catch (AttrException ex) {
                        this.fireGraTra(new GraTraEvent((Object)this, 6, r.getName()));
                        return false;
                    }
                    Morphism coMatch = this.apply(this.currentMatch);
                    if (coMatch != null) {
                        this.errorMsg = "";
                        is_applied = true;
                        this.currentMatch.clear();
                        coMatch = null;
                        result = true;
                    } else {
                        valid = false;
                        this.fireGraTra(new GraTraEvent(this, 3, this.currentMatch, this.errorMsg));
                        this.currentMatch.clear();
                        result = false;
                    }
                } else {
                    this.fireGraTra(new GraTraEvent(this, 3, this.currentMatch, this.currentMatch.getErrorMsg()));
                    this.currentMatch.clear();
                    result = false;
                }
                if (r.isParallelApplyEnabled()) {
                    if (!valid) {
                        parallelApply = false;
                        this.currentMatch.typeObjectsMapChanged = true;
                        this.updateTypeObjectsMapAfterStep = true;
                    }
                    if (!is_applied) continue;
                    result = true;
                    continue;
                }
                parallelApply = false;
                break;
            }
            return result;
        }
    }

    public void enableWriteLogFile(boolean b) {
        this.writeLogFile = b;
    }

    public abstract boolean apply();

    public abstract Pair<Morphism, Morphism> derivation(Match var1);

    public abstract void transform(List<Rule> var1);

    public abstract void transform();

    public abstract boolean transformationDone();

    public boolean isGraphConsistent() {
        return this.consistentGraph;
    }

    public void stop() {
        this.stopping = true;
        this.pauseRule = false;
    }

    public void unsetStop() {
        this.stopping = false;
        this.stoppingRule = false;
        this.pauseRule = false;
    }

    public void stopRule() {
        this.stoppingRule = true;
        this.pauseRule = false;
    }

    public void pauseRule(boolean pause) {
        this.pauseRule = pause;
    }

    public void pauseRule() {
        this.pauseRule = true;
    }

    public boolean isPaused() {
        return this.pauseRule;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void doUpdateTypeObjectsMapAfterStep(boolean b) {
        this.updateTypeObjectsMapAfterStep = b;
    }

    public synchronized void removeGraTraListener(GraTraEventListener l) {
        if (this.graTraListeners.contains(l)) {
            this.graTraListeners.removeElement(l);
        }
    }

    public synchronized void addGraTraListener(GraTraEventListener l) {
        if (!this.graTraListeners.contains(l)) {
            this.graTraListeners.addElement(l);
        }
    }

    public synchronized boolean containsGraTraListener(GraTraEventListener l) {
        return this.graTraListeners.contains(l);
    }

    protected void fireGraTra(GraTraEvent e) {
        int count = this.graTraListeners.size();
        int i = 0;
        while (i < count) {
            this.graTraListeners.elementAt(i).graTraEventOccurred(e);
            ++i;
        }
    }

    protected void setRuleSet() {
        if (this.grammar != null) {
            this.currentRuleSet.addAll(this.grammar.getListOfRules());
        }
    }

    protected boolean isInputParameterSet(Graph g, boolean left, Match match) {
        if (match == null || match.getAttrContext().getVariables().getNumberOfEntries() == 0) {
            return true;
        }
        AttrConditionTuple act = match.getAttrContext().getConditions();
        AttrVariableTuple avt = match.getAttrContext().getVariables();
        int i = 0;
        while (i < avt.getNumberOfEntries()) {
            VarMember v = avt.getVarMemberAt(i);
            if (v.isInputParameter() && !v.isSet()) {
                if (g.isUsingVariable(v)) {
                    return false;
                }
                if (left && v.getMark() != 1) {
                    if (v.getMark() == 0) {
                        return false;
                    }
                    return !match.getRule().nacIsUsingVariable(v, act) && !match.getRule().pacIsUsingVariable(v, act);
                }
            }
            ++i;
        }
        return true;
    }

    protected boolean checkGraphConsistency(Rule r, Graph g) {
        if (this.grammar.isLayered()) {
            List<Formula> constraints = this.grammar.getConstraintsForLayer(-1);
            if (this.grammar.checkGraphConsistency(g, constraints)) {
                constraints = this.grammar.getConstraintsForLayer(r.getLayer());
                return this.grammar.checkGraphConsistency(g, constraints);
            }
            return false;
        }
        if (this.grammar.trafoByPriority()) {
            Vector<Formula> constraints = this.grammar.getConstraintsForPriority(-1);
            if (this.grammar.checkGraphConsistency(g, constraints)) {
                constraints = this.grammar.getConstraintsForPriority(r.getPriority());
                return this.grammar.checkGraphConsistency(g, constraints);
            }
            return false;
        }
        return this.grammar.checkGraphConsistency(g);
    }

    protected OrdinaryMorphism makeTestStep(Match m) throws TypeException {
        BaseFactory bf = BaseFactory.theFactory();
        OrdinaryMorphism copy = m.getImage().isomorphicCopy();
        if (copy == null) {
            throw new TypeException("Undefined error occurred during construction of test step.");
        }
        copy.getImage().setCompleteGraph(true);
        OrdinaryMorphism com = m.compose(copy);
        Match m2 = bf.makeMatch(m.getRule(), com);
        if (m2 != null) {
            m2.adaptAttrContextValues(m.getAttrContext());
            try {
                OrdinaryMorphism co_match = (OrdinaryMorphism)StaticStep.execute(m2);
                return co_match;
            }
            catch (TypeException ex) {
                System.out.println(ex.getLocalizedMessage());
                m2.dispose();
                com.dispose();
                copy.dispose();
                throw ex;
            }
        }
        com.dispose();
        copy.dispose();
        throw new TypeException("Undefined error occurred during construction of test step.");
    }

    protected boolean checkGraphConsistencyForComatch(Match m, OrdinaryMorphism co_match) {
        if (co_match != null) {
            boolean result = false;
            if (this.grammar.isLayered()) {
                List<Formula> constraints = this.grammar.getConstraintsForLayer(-1);
                if (this.grammar.checkGraphConsistency(co_match.getImage(), constraints)) {
                    constraints = this.grammar.getConstraintsForLayer(m.getRule().getLayer());
                    result = this.grammar.checkGraphConsistency(co_match.getImage(), constraints);
                } else {
                    result = false;
                }
                co_match.dispose();
                return result;
            }
            if (this.grammar.trafoByPriority()) {
                Vector<Formula> constraints = this.grammar.getConstraintsForPriority(-1);
                if (this.grammar.checkGraphConsistency(co_match.getImage(), constraints)) {
                    constraints = this.grammar.getConstraintsForPriority(m.getRule().getPriority());
                    result = this.grammar.checkGraphConsistency(co_match.getImage(), constraints);
                } else {
                    result = false;
                }
                co_match.dispose();
                return result;
            }
            result = this.grammar.checkGraphConsistency(co_match.getImage());
            co_match.dispose();
            return result;
        }
        return false;
    }

    protected boolean checkGraphConsistency(Match m) {
        BaseFactory bf = BaseFactory.theFactory();
        OrdinaryMorphism copy = m.getImage().isomorphicCopy();
        if (copy == null) {
            return false;
        }
        copy.getImage().setCompleteGraph(true);
        OrdinaryMorphism com = m.compose(copy);
        Match m2 = bf.makeMatch(m.getRule(), com);
        if (m2 != null) {
            m2.adaptAttrContextValues(m.getAttrContext());
            try {
                OrdinaryMorphism co_match = (OrdinaryMorphism)StaticStep.execute(m2);
                if (co_match != null) {
                    boolean result = false;
                    if (this.grammar.isLayered()) {
                        List<Formula> constraints = this.grammar.getConstraintsForLayer(-1);
                        if (this.grammar.checkGraphConsistency(co_match.getImage(), constraints)) {
                            constraints = this.grammar.getConstraintsForLayer(m.getRule().getLayer());
                            result = this.grammar.checkGraphConsistency(co_match.getImage(), constraints);
                        } else {
                            result = false;
                        }
                        co_match.dispose();
                        m2.dispose();
                        com.dispose();
                        copy.dispose();
                        return result;
                    }
                    if (this.grammar.trafoByPriority()) {
                        Vector<Formula> constraints = this.grammar.getConstraintsForPriority(-1);
                        if (this.grammar.checkGraphConsistency(co_match.getImage(), constraints)) {
                            constraints = this.grammar.getConstraintsForPriority(m.getRule().getPriority());
                            result = this.grammar.checkGraphConsistency(co_match.getImage(), constraints);
                        } else {
                            result = false;
                        }
                        co_match.dispose();
                        m2.dispose();
                        com.dispose();
                        copy.dispose();
                        return result;
                    }
                    result = this.grammar.checkGraphConsistency(co_match.getImage());
                    co_match.dispose();
                    m2.dispose();
                    com.dispose();
                    copy.dispose();
                    return result;
                }
                m2.dispose();
                com.dispose();
                copy.dispose();
                return false;
            }
            catch (TypeException e) {
                System.out.println(e.getLocalizedMessage());
                m2.dispose();
                com.dispose();
                copy.dispose();
                return false;
            }
        }
        com.dispose();
        copy.dispose();
        return false;
    }

    protected boolean checkGraphConsistency() {
        if (this.grammar == null) {
            return true;
        }
        List<Formula> constraints = null;
        constraints = this.grammar.isLayered() ? this.grammar.getConstraintsForLayer(-1) : (this.grammar.trafoByPriority() ? this.grammar.getConstraintsForPriority(-1) : this.grammar.getGlobalConstraints());
        if (this.grammar.checkGraphConsistency(this.grammar.getGraph(), constraints)) {
            return true;
        }
        String msgstr = " Constraint:" + this.grammar.getConsistencyErrorMsg() + "- failed.";
        this.fireGraTra(new GraTraEvent((Object)this, 11, msgstr));
        return false;
    }

    protected boolean checkGraphConsistencyForLayer(int layer) {
        if (this.grammar == null) {
            return true;
        }
        List<Formula> constraints = this.grammar.getConstraintsForLayer(layer);
        if (this.grammar.checkGraphConsistency(this.grammar.getGraph(), constraints)) {
            return true;
        }
        String msgstr = " Layer: " + layer + "  Constraint:" + this.grammar.getConsistencyErrorMsg() + "- failed.";
        this.fireGraTra(new GraTraEvent((Object)this, 11, msgstr));
        return false;
    }

    protected boolean checkGraphConsistencyForPriority(int priority) {
        if (this.grammar == null) {
            return true;
        }
        Vector<Formula> constraints = this.grammar.getConstraintsForPriority(priority);
        if (this.grammar.checkGraphConsistency(this.grammar.getGraph(), constraints)) {
            return true;
        }
        String msgstr = " Priority: " + priority + "  Constraint:" + this.grammar.getConsistencyErrorMsg() + "- failed.";
        this.fireGraTra(new GraTraEvent((Object)this, 11, msgstr));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean apply(RuleScheme rs) {
        GraTra graTra = this;
        synchronized (graTra) {
            boolean result;
            block15: {
                block14: {
                    block13: {
                        this.stoppingRule = false;
                        result = false;
                        this.currentMatch = rs.getMatch();
                        if (this.currentMatch == null) {
                            if (!rs.isInputParameterSet(true)) {
                                this.fireGraTra(new GraTraEvent((Object)this, 1, rs));
                            }
                            this.currentMatch = rs.getMatch(this.hostgraph, this.strategy);
                        }
                        if (this.currentMatch != null) break block13;
                        this.fireGraTra(new GraTraEvent((Object)this, 21, "Amalgamated match failed.\n" + rs.getErrorMsg()));
                        return false;
                    }
                    this.fireGraTra(new GraTraEvent((Object)this, 8, this.currentMatch));
                    if (!this.stopping && !this.stoppingRule) break block14;
                    rs.disposeAmalgamatedRule();
                    return false;
                }
                if (!this.pauseRule) break block15;
                return false;
            }
            try {
                boolean checkVarsOnly = true;
                this.currentMatch.getAttrContext().getVariables().getAttrManager().checkIfReadyToTransform(this.currentMatch.getAttrContext(), checkVarsOnly);
            }
            catch (AttrException ex) {
                this.fireGraTra(new GraTraEvent((Object)this, 6, rs.getName()));
                rs.disposeAmalgamatedRule();
                return false;
            }
            Morphism coMatch = this.apply(this.currentMatch);
            if (coMatch != null) {
                this.errorMsg = "";
                rs.disposeAmalgamatedRule();
                coMatch = null;
                result = true;
            } else {
                this.fireGraTra(new GraTraEvent((Object)this, 21, this.errorMsg));
                rs.disposeAmalgamatedRule();
                result = false;
            }
            return result;
        }
    }

    protected boolean isInputParameterSet(RuleScheme rs, boolean left) {
        return rs.isInputParameterSet(left);
    }
}

