/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.cons.AtomConstraint;
import agg.util.Pair;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.Match;
import agg.xt_basis.Morphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.Version;
import agg.xt_basis.agt.RuleScheme;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class DefaultGraTraImpl
extends GraTra {
    private int doneSteps;
    private int counterMax;
    Random ran = new Random();
    private boolean appliedOnce;
    private boolean applyContinue = false;
    private boolean allRulesEnabled = false;
    File f;
    FileOutputStream os;
    String protocolFileName = "";
    private boolean grammarChecked;

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public Pair<Morphism, Morphism> derivation(Match m) {
        return null;
    }

    @Override
    public boolean apply() {
        if (!this.allRulesEnabled) {
            int j = 0;
            while (j < this.currentRuleSet.size()) {
                if (!((Rule)this.currentRuleSet.elementAt(j)).isEnabled()) {
                    this.currentRuleSet.removeElementAt(j);
                    --j;
                }
                ++j;
            }
            this.allRulesEnabled = true;
        }
        boolean applied = false;
        while (!this.stopping && this.currentRuleSet.size() > 0 && !applied) {
            this.pauseRule = false;
            this.stoppingRule = false;
            if (!this.applyContinue) {
                int i = this.ran.nextInt(this.currentRuleSet.size());
                this.currentRule = (Rule)this.currentRuleSet.elementAt(i);
            } else {
                this.applyContinue = false;
            }
            if (!this.stoppingRule) {
                applied = this.currentRule instanceof RuleScheme ? this.apply((RuleScheme)this.currentRule) : this.currentRule.canMatch(this.hostgraph, this.strategy) && this.apply(this.currentRule);
            } else {
                this.stoppingRule = false;
            }
            if (this.pauseRule) {
                return false;
            }
            if (this.os != null) {
                this.writeTransformProtocol(String.valueOf(this.currentRule.getName()) + " \t applied:  " + applied);
            }
            if (!applied) {
                if (this.os != null) {
                    this.writeTransformProtocol(this.getErrorMsg());
                }
                this.currentRuleSet.remove(this.currentRule);
                if (this.os == null) continue;
                this.writeTransformProtocol(this.getRuleNames(this.currentRuleSet));
                continue;
            }
            System.out.println(String.valueOf(this.currentRule.getName()) + " \t applied");
            ++this.doneSteps;
            this.appliedOnce = true;
            if (this.isGraphConsistent()) continue;
            this.stopping = true;
        }
        return applied;
    }

    @Override
    public void transform(List<Rule> ruleSet) {
        this.allRulesEnabled = true;
        boolean applicable = true;
        while (!this.stopping && applicable) {
            if (this.os != null) {
                String ss = this.getRuleNames(ruleSet);
                this.writeTransformProtocol(ss);
            }
            this.currentRuleSet = new Vector<Rule>(ruleSet);
            applicable = this.apply();
            if (this.pauseRule) {
                return;
            }
            if (!this.waitAfterStep) continue;
            return;
        }
    }

    public void setMaxOfCounter(int nb) {
        this.counterMax = nb;
    }

    public void transformByCounter(List<Rule> ruleSet) {
        this.allRulesEnabled = true;
        boolean applicable = true;
        int i = 1;
        while (i <= this.counterMax && applicable) {
            if (this.os != null) {
                String ss = this.getRuleNames(ruleSet);
                this.writeTransformProtocol(ss);
            }
            this.currentRuleSet = new Vector<Rule>(ruleSet);
            long t0 = System.currentTimeMillis();
            applicable = this.apply();
            System.out.println(String.valueOf(i) + ")  Time: " + (System.currentTimeMillis() - t0) + "ms   " + Runtime.getRuntime().freeMemory() + "b" + "  nodes  (" + this.hostgraph.getNodesCount() + ")" + "  edges  (" + this.hostgraph.getArcsCount() + ")");
            ++i;
        }
    }

    public void transformContinue() {
        this.applyContinue = true;
        this.pauseRule = false;
        this.transform(this.currentRuleSet);
    }

    public void transformContinueWithNextStep() {
        this.pauseRule = false;
        this.transform(this.currentRuleSet);
    }

    @Override
    public void transform() {
        this.stopping = false;
        if (!this.grammar.getListOfRules().isEmpty() && this.currentRuleSet.isEmpty()) {
            this.setRuleSet();
        }
        if (this.writeLogFile) {
            String dirName = this.grammar.getDirName();
            String fileName = this.grammar.getFileName();
            if (fileName == null || fileName.equals("")) {
                fileName = this.grammar.getName();
            }
            this.openTransformProtocol(dirName, fileName);
            String version = "Version:  AGG " + Version.getID() + "\n";
            this.writeTransformProtocol(version);
            String s0 = "Graph transformation of : " + this.grammar.getName();
            String s1 = "on graph : " + this.grammar.getGraph().getName();
            String s2 = this.getRuleNames(this.currentRuleSet);
            this.writeTransformProtocol(s0);
            this.writeTransformProtocol(s1);
            this.writeTransformProtocol(s2);
            this.writeTransformProtocol("\n");
        }
        if (!this.grammarChecked) {
            Pair<Object, String> pair = this.grammar.isReadyToTransform(true);
            if (pair != null) {
                Object test = pair.first;
                if (test != null) {
                    String s0 = String.valueOf((String)pair.second) + "\nTransformation is stopped.";
                    if (test instanceof Type) {
                        this.fireGraTra(new GraTraEvent((Object)this, 15, s0));
                    } else if (test instanceof Rule) {
                        this.fireGraTra(new GraTraEvent((Object)this, 9, s0));
                    } else if (test instanceof AtomConstraint) {
                        this.fireGraTra(new GraTraEvent((Object)this, 14, s0));
                    }
                    this.transformFailed(s0);
                    return;
                }
            } else {
                if (!this.grammar.isGraphReadyForTransform()) {
                    String s0 = "Graph of the grammar isn't fine.\nPlease check attribute settings of the objects. \nTransformation is stopped.";
                    this.fireGraTra(new GraTraEvent((Object)this, 10, s0));
                    this.transformFailed(s0);
                    return;
                }
                if (!this.checkGraphConsistency()) {
                    String s = "Graph consistency failed.\nPlease check the host graph against the graph constraints.\nTransformation is stopped.";
                    this.fireGraTra(new GraTraEvent((Object)this, 10, s));
                    this.transformFailed(s);
                    return;
                }
            }
            this.grammarChecked = true;
        }
        Vector<Rule> ruleSet = this.getEnabledRules(this.currentRuleSet);
        long startTime = System.currentTimeMillis();
        if (this.counterMax == 0) {
            this.transform(ruleSet);
        } else {
            this.transformByCounter(ruleSet);
        }
        System.out.println("Used time for graph transformation: " + (System.currentTimeMillis() - startTime) + "ms");
        if (this.options.hasOption("consistencyCheckAfterGraphTrafo")) {
            this.checkGraphConsistency();
        }
        if (this.writeLogFile) {
            this.writeTransformProtocol("\nUsed time for graph transformation: " + (System.currentTimeMillis() - startTime) + "ms");
            this.writeTransformProtocol("\nGraph transformation finished");
            this.closeTransformProtocol();
        }
        this.fireGraTra(new GraTraEvent((Object)this, 5, this.errorMsg));
    }

    private Vector<Rule> getEnabledRules(Vector<Rule> ruleSet) {
        Vector<Rule> vec = new Vector<Rule>(ruleSet.size());
        int j = 0;
        while (j < ruleSet.size()) {
            if (ruleSet.elementAt(j).isEnabled()) {
                vec.add(ruleSet.elementAt(j));
            }
            ++j;
        }
        return vec;
    }

    private void transformFailed(String text) {
        System.out.println(text);
        this.writeTransformProtocol(text);
        this.writeTransformProtocol("\nGraph transformation failed");
        this.fireGraTra(new GraTraEvent((Object)this, 5, this.errorMsg));
        this.closeTransformProtocol();
    }

    @Override
    public boolean transformationDone() {
        return this.appliedOnce;
    }

    public String getProtocolName() {
        return this.protocolFileName;
    }

    private String getRuleNames(List<Rule> rules) {
        String names = "[ ";
        int j = 0;
        while (j < rules.size()) {
            Rule r = rules.get(j);
            names = String.valueOf(names) + r.getName() + " ";
            ++j;
        }
        names = String.valueOf(names) + "]";
        return names;
    }

    private void openTransformProtocol(String dirName, String fileName) {
        String dName = dirName;
        String fName = "DefaultGraTra.log";
        if (fileName != null && !fileName.equals("")) {
            fName = fileName.endsWith(".ggx") ? String.valueOf(fileName.substring(0, fileName.length() - 4)) + "_GraTra.log" : String.valueOf(fileName) + "_GraTra.log";
        }
        if (dName != null && !dName.equals("")) {
            this.f = new File(dName);
            dName = this.f.exists() ? (this.f.isFile() ? (this.f.getParent() != null ? String.valueOf(this.f.getParent()) + File.separator : "." + File.separator) : (this.f.isDirectory() ? String.valueOf(this.f.getPath()) + File.separator : "." + File.separator)) : "." + File.separator;
            this.f = new File(String.valueOf(dirName) + fName);
        } else {
            this.f = new File(fName);
        }
        try {
            this.os = new FileOutputStream(this.f);
            this.protocolFileName = this.f.getName();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        this.writeTransformProtocol(new Date().toString());
    }

    private void writeTransformProtocol(String s) {
        if (this.os == null) {
            return;
        }
        try {
            if (!s.equals("\n")) {
                this.os.write(s.getBytes());
            }
            this.os.write(10);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void closeTransformProtocol() {
        if (this.os == null) {
            return;
        }
        try {
            this.os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

