/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.CriticalPairEvent;
import agg.parser.ExcludePair;
import agg.parser.ExcludePairContainer;
import agg.parser.InvalidAlgorithmException;
import agg.parser.PriorityExcludePair;
import agg.parser.PrioritySimpleExcludePair;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;

public class PriorityExcludePairContainer
extends ExcludePairContainer {
    public PriorityExcludePairContainer(GraGra gragra) {
        super(gragra);
    }

    @Override
    protected synchronized void computeCritical(Rule r1, Rule r2) {
        if (!r1.isEnabled() || !r2.isEnabled()) {
            this.getEntry((Rule)r1, (Rule)r2).state = 5;
            this.addEntry(r1, r2, false, null);
            this.addQuadruple(this.excludeContainer, r1, r2, false, null);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, false, null);
            this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  should not be computed."));
            return;
        }
        if (r1.getPriority() != r2.getPriority()) {
            this.getEntry((Rule)r1, (Rule)r2).state = 4;
            this.addEntry(r1, r2, false, null);
            this.addQuadruple(this.excludeContainer, r1, r2, false, null);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, false, null);
            this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, ""));
            return;
        }
        if (this.getEntry((Rule)r1, (Rule)r2).state == 1 || this.getEntry((Rule)r1, (Rule)r2).state == 0) {
            ExcludePair pair;
            this.getEntry(r1, r2).setState(2);
            this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "Computing critical rule pair  [  " + r1.getName() + "  ,  " + r2.getName() + "  ]"));
            if (!this.complete) {
                pair = new PrioritySimpleExcludePair();
                this.excludePair = pair;
            } else {
                pair = new PriorityExcludePair();
                this.excludePair = pair;
            }
            this.setOptionsOfExcludePair();
            Object overlapping = null;
            try {
                if (this.excludePair != null) {
                    overlapping = this.excludePair.isCritical(0, r1, r2);
                }
            }
            catch (InvalidAlgorithmException invalidAlgorithmException) {
                // empty catch block
            }
            if (this.excludePair != null) {
                this.excludePair.dispose();
            }
            this.excludePair = null;
            boolean critic = overlapping != null;
            this.addEntry(r1, r2, critic, (Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>)overlapping);
            this.addQuadruple(this.excludeContainer, r1, r2, critic, (Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>)overlapping);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, !critic, null);
            if (overlapping != null) {
                this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have critical pairs"));
            } else {
                this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have no critical pairs"));
            }
        }
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        Boolean b;
        Pair p;
        Rule r2;
        Enumeration k2;
        Hashtable secondPart;
        Rule r1;
        h.openNewElem("CriticalPairs", this);
        h.addObject("GraGra", this.getGrammar(), true);
        h.openSubTag("conflictContainer");
        h.addAttr("kind", "exclude");
        Enumeration keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            r1 = (Rule)keys.nextElement();
            h.openSubTag("Rule");
            h.addObject("R1", r1, false);
            secondPart = (Hashtable)this.excludeContainer.get(r1);
            k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = (Rule)k2.nextElement();
                h.openSubTag("Rule");
                h.addObject("R2", r2, false);
                p = (Pair)secondPart.get(r2);
                b = (Boolean)p.first;
                h.addAttr("bool", b.toString());
                if (b.booleanValue()) {
                    Vector v = (Vector)p.second;
                    int i = 0;
                    while (i < v.size()) {
                        Pair p2i = (Pair)v.elementAt(i);
                        Pair p2 = (Pair)p2i.first;
                        h.openSubTag("Overlapping_Pair");
                        OrdinaryMorphism first = (OrdinaryMorphism)p2.first;
                        Graph overlapping = first.getImage();
                        h.addObject("", overlapping, true);
                        for (GraphObject graphObject : overlapping.getNodesSet()) {
                            if (!graphObject.isCritical()) continue;
                            h.openSubTag("Critical");
                            h.addObject("object", graphObject, false);
                            h.close();
                        }
                        for (GraphObject graphObject : overlapping.getArcsSet()) {
                            if (!graphObject.isCritical()) continue;
                            h.openSubTag("Critical");
                            h.addObject("object", graphObject, false);
                            h.close();
                        }
                        this.writeOverlapMorphisms(h, r1, r2, p2i);
                        h.close();
                        ++i;
                    }
                }
                h.close();
            }
            h.close();
        }
        h.close();
        h.openSubTag("conflictFreeContainer");
        keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            r1 = (Rule)keys.nextElement();
            h.openSubTag("Rule");
            h.addObject("R1", r1, false);
            secondPart = (Hashtable)this.conflictFreeContainer.get(r1);
            k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = (Rule)k2.nextElement();
                h.openSubTag("Rule");
                h.addObject("R2", r2, false);
                p = (Pair)secondPart.get(r2);
                b = (Boolean)p.first;
                h.addAttr("bool", b.toString());
                h.close();
            }
            h.close();
        }
        h.close();
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("CriticalPairs", this)) {
            String bool;
            Enumeration<Element> r2s;
            Enumeration<Element> r1s;
            Rule r1 = null;
            Rule r2 = null;
            boolean b = false;
            Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> allOverlappings = null;
            this.grammar = BaseFactory.theFactory().createGraGra();
            h.getObject("", this.grammar, true);
            if (h.readSubTag("conflictContainer")) {
                this.conflictKind = 0;
            }
            if (this.conflictKind == 0) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        allOverlappings = null;
                        b = false;
                        if (bool.equals("true")) {
                            b = true;
                            allOverlappings = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
                            Enumeration<Element> overlappings = h.getEnumeration("", null, true, "Overlapping_Pair");
                            while (overlappings.hasMoreElements()) {
                                h.peekElement(overlappings.nextElement());
                                Graph g = (Graph)h.getObject("", new Graph(), true);
                                while (h.readSubTag("Critical")) {
                                    GraphObject o = (GraphObject)h.getObject("object", null, false);
                                    if (o != null) {
                                        o.setCritical(true);
                                    }
                                    h.close();
                                }
                                Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p = this.readOverlappingMorphisms(h, r1, r2, g);
                                allOverlappings.addElement(p);
                                h.close();
                            }
                        }
                        this.addQuadruple(this.excludeContainer, r1, r2, b, allOverlappings);
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
            if (h.readSubTag("conflictFreeContainer")) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        b = false;
                        if (bool.equals("true")) {
                            b = true;
                        }
                        this.addQuadruple(this.conflictFreeContainer, r1, r2, b, null);
                        if (!r1.isEnabled()) {
                            this.getEntry((Rule)r1, (Rule)r2).state = 5;
                        } else if (r1.getPriority() != r2.getPriority()) {
                            this.getEntry((Rule)r1, (Rule)r2).state = 4;
                        }
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
        }
        h.close();
    }
}

