/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.ExcludePairHelper;
import agg.util.Pair;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CriticalPairData {
    public static final int DELETE_USE_CONFLICT = 0;
    public static final int DELETE_NEED_CONFLICT = 1;
    public static final int PRODUCE_FORBID_CONFLICT = 2;
    public static final int PRODUCE_EDGE_DELTE_NODE_CONFLICT = 3;
    public static final int CHANGE_ATTR_CONFLICT = 40;
    public static final int CHANGE_USE_ATTR_CONFLICT = 4;
    public static final int CHANGE_NEED_ATTR_CONFLICT = 5;
    public static final int CHANGE_FORBID_ATTR_CONFLICT = 6;
    public static final int DELETE_FORBID_DEPENDENCY = 7;
    public static final int PRODUCE_USE_DEPENDENCY = 8;
    public static final int PRODUCE_NEED_DEPENDENCY = 9;
    public static final int CHANGE_USE_ATTR_DEPENDENCY = 10;
    public static final int CHANGE_NEED_ATTR_DEPENDENCY = 11;
    public static final int CHANGE_FORBID_ATTR_DEPENDENCY = 12;
    public static final int PRODUCE_DELETE_DEPENDENCY = 13;
    public static final int READ_DELETE_DEPENDENCY = 131;
    public static final int CREATE_DELETE_DEPENDENCY = 132;
    public static final int FORBID_PRODUCE_DEPENDENCY = 14;
    public static final int PRODUCE_CHANGE_DEPENDENCY = 15;
    public static final String DELETE_USE_C_TXT = "delete-use-conflict";
    public static final String DELETE_NEED_C_TXT = "delete-need-conflict";
    public static final String PRODUCE_FORBID_C_TXT = "produce-forbid-conflict";
    public static final String PRODUCE_EDGE_DELETE_NODE_C_TXT = "produceEdge-deleteNode-conflict";
    public static final String CHANGE_USE_ATTR_C_TXT = "change-use-attr-conflict";
    public static final String CHANGE_NEED_ATTR_C_TXT = "change-need-attr-conflict";
    public static final String CHANGE_FORBID_ATTR_C_TXT = "change-forbid-attr-conflict";
    public static final String PRODUCE_USE_D_TXT = "produce-use-dependency";
    public static final String PRODUCE_NEED_D_TXT = "produce-need-dependency";
    public static final String DELETE_FORBID_D_TXT = "delete-forbid-dependency";
    public static final String CHANGE_USE_ATTR_D_TXT = "change-use-attr-dependency";
    public static final String CHANGE_NEED_ATTR_D_TXT = "change-need-attr-dependency";
    public static final String CHANGE_FORBID_ATTR_D_TXT = "change-forbid-attr-dependency";
    public static final String PRODUCE_DELETE_D_TXT = "deliver-delete-dependency";
    public static final String FORBID_PRODUCE_D_TXT = "forbid-produce-dependency";
    public static final String PRODUCE_CHANGE_D_TXT = "deliver-change-dependency";
    public static final String DELETE_SWITCH_D_TXT = "delete-switch-dependency";
    public static final String FORBID_SWITCH_D_TXT = "forbid-switch-dependency";
    public static final String CHANGE_SWITCH_D_TXT = "change-switch-dependency";
    private Rule r1;
    private Rule r2;
    private List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlaps;
    private Iterator<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> iterator;
    private Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> pair;
    private HashMap<Integer, List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> map;
    private HashMap<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>, Integer> map2;
    int size = 0;

    public CriticalPairData(Rule rule1, Rule rule2, List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlappings) {
        this.r1 = rule1;
        this.r2 = rule2;
        this.overlaps = overlappings;
        this.iterator = this.overlaps.iterator();
        this.size = overlappings.size();
        this.map = new HashMap();
        this.map2 = new HashMap();
        this.fillMap(overlappings);
    }

    public void resetIterator() {
        this.iterator = this.overlaps.iterator();
    }

    public Rule getRule1() {
        return this.r1;
    }

    public Rule getRule2() {
        return this.r2;
    }

    public int getKindOfCurrentCritical() {
        Integer k;
        if (this.pair != null && (k = this.map2.get(this.pair)) != null) {
            return k;
        }
        return -1;
    }

    public boolean hasCriticalsOfKind(int kind) {
        return this.map.get(kind) != null;
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getCriticalsOfKind(int kind) {
        if (kind == -1 && !this.map.isEmpty()) {
            return this.map.values().iterator().next();
        }
        return this.map.get(kind);
    }

    public CriticalPairData getCriticalDataOfKind(int kind) {
        Integer key = kind;
        List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> l = this.map.get(key);
        if (l != null) {
            return new CriticalPairData(this.r1, this.r2, l);
        }
        return null;
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeOf(int kind) {
        List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> list = this.map.get(kind);
        return list != null ? list.size() : 0;
    }

    public boolean hasCriticals() {
        return this.iterator.hasNext();
    }

    public boolean next() {
        if (this.iterator.hasNext()) {
            this.pair = this.iterator.next();
            return true;
        }
        return false;
    }

    public OrdinaryMorphism getMorph1() {
        if (this.pair == null && this.iterator.hasNext()) {
            this.pair = this.iterator.next();
        }
        if (this.pair != null) {
            return (OrdinaryMorphism)((Pair)this.pair.first).first;
        }
        return null;
    }

    public OrdinaryMorphism getMorph2() {
        if (this.pair == null && this.iterator.hasNext()) {
            this.pair = this.iterator.next();
        }
        if (this.pair != null) {
            return (OrdinaryMorphism)((Pair)this.pair.first).second;
        }
        return null;
    }

    public OrdinaryMorphism getMorph(Rule r) {
        if (r == this.r1) {
            return this.getMorph1();
        }
        if (r == this.r2) {
            return this.getMorph2();
        }
        return null;
    }

    public OrdinaryMorphism getMorph1DueToLHS() {
        if (this.pair == null && this.iterator.hasNext()) {
            this.pair = this.iterator.next();
        }
        if (this.pair != null) {
            if (this.pair.second == null) {
                return (OrdinaryMorphism)((Pair)this.pair.first).first;
            }
            return this.adjustMorph1((OrdinaryMorphism)((Pair)this.pair.first).first);
        }
        return null;
    }

    public OrdinaryMorphism getMorph2DueToLHS() {
        if (this.pair == null && this.iterator.hasNext()) {
            this.pair = this.iterator.next();
        }
        if (this.pair != null) {
            if (this.pair.second == null) {
                return (OrdinaryMorphism)((Pair)this.pair.first).second;
            }
            if (this.r2.getLeft() == ((OrdinaryMorphism)((Pair)this.pair.second).first).getSource() && ((OrdinaryMorphism)((Pair)this.pair.first).second).getSource() == ((OrdinaryMorphism)((Pair)this.pair.second).first).getTarget()) {
                return this.adjustMorph2((OrdinaryMorphism)((Pair)this.pair.first).second, (OrdinaryMorphism)((Pair)this.pair.second).first);
            }
            if (this.r2.getLeft() == ((OrdinaryMorphism)((Pair)this.pair.first).second).getSource() && ((Pair)this.pair.second).second != null && ((OrdinaryMorphism)((Pair)this.pair.second).first).getTarget() == ((OrdinaryMorphism)((Pair)this.pair.second).second).getSource()) {
                return (OrdinaryMorphism)((Pair)this.pair.first).second;
            }
        }
        return null;
    }

    public OrdinaryMorphism getMorph2DueToNAC() {
        if (this.pair == null && this.iterator.hasNext()) {
            this.pair = this.iterator.next();
        }
        if (this.pair != null) {
            if (this.pair.second == null) {
                return null;
            }
            if (this.r2.getLeft() == ((OrdinaryMorphism)((Pair)this.pair.second).first).getSource() && ((OrdinaryMorphism)((Pair)this.pair.first).second).getSource() == ((OrdinaryMorphism)((Pair)this.pair.second).second).getTarget()) {
                return this.adjustMorph2NAC((OrdinaryMorphism)((Pair)this.pair.first).second, (OrdinaryMorphism)((Pair)this.pair.second).second);
            }
        }
        return null;
    }

    public OrdinaryMorphism getMorph2DueToPAC() {
        if (this.pair == null && this.iterator.hasNext()) {
            this.pair = this.iterator.next();
        }
        if (this.pair != null) {
            if (this.pair.second == null) {
                return null;
            }
            if (this.r2.getLeft() == ((OrdinaryMorphism)((Pair)this.pair.first).second).getSource() && ((OrdinaryMorphism)((Pair)this.pair.second).first).getTarget() == ((OrdinaryMorphism)((Pair)this.pair.second).second).getSource()) {
                return this.adjustMorph2PAC((OrdinaryMorphism)((Pair)this.pair.first).second, (OrdinaryMorphism)((Pair)this.pair.second).first, (OrdinaryMorphism)((Pair)this.pair.second).second);
            }
        }
        return null;
    }

    public Graph getCriticalGraph() {
        if (this.pair == null && this.iterator.hasNext()) {
            this.pair = this.iterator.next();
        }
        if (this.pair != null) {
            return ((OrdinaryMorphism)((Pair)this.pair.first).first).getTarget();
        }
        return null;
    }

    public List<GraphObject> getOverlapGraphObjects() {
        if (this.pair == null && this.iterator.hasNext()) {
            this.pair = this.iterator.next();
        }
        if (this.pair != null) {
            Vector<GraphObject> list = new Vector<GraphObject>();
            Graph g = ((OrdinaryMorphism)((Pair)this.pair.first).first).getTarget();
            for (GraphObject graphObject : g.getNodesCollection()) {
                if (!((OrdinaryMorphism)((Pair)this.pair.first).first).getInverseImage(graphObject).hasMoreElements() || !((OrdinaryMorphism)((Pair)this.pair.first).second).getInverseImage(graphObject).hasMoreElements()) continue;
                list.add(graphObject);
            }
            for (GraphObject graphObject : g.getArcsCollection()) {
                if (!((OrdinaryMorphism)((Pair)this.pair.first).first).getInverseImage(graphObject).hasMoreElements() || !((OrdinaryMorphism)((Pair)this.pair.first).second).getInverseImage(graphObject).hasMoreElements()) continue;
                list.add(graphObject);
            }
            return list;
        }
        return null;
    }

    public List<GraphObject> getCriticalGraphObjects() {
        if (this.pair == null && this.iterator.hasNext()) {
            this.pair = this.iterator.next();
        }
        if (this.pair != null) {
            Vector<GraphObject> list = new Vector<GraphObject>();
            Graph g = ((OrdinaryMorphism)((Pair)this.pair.first).first).getTarget();
            for (GraphObject graphObject : g.getNodesCollection()) {
                if (!((OrdinaryMorphism)((Pair)this.pair.first).first).getInverseImage(graphObject).hasMoreElements() || !((OrdinaryMorphism)((Pair)this.pair.first).second).getInverseImage(graphObject).hasMoreElements() || !graphObject.isCritical()) continue;
                list.add(graphObject);
            }
            for (GraphObject graphObject : g.getArcsCollection()) {
                if (!((OrdinaryMorphism)((Pair)this.pair.first).first).getInverseImage(graphObject).hasMoreElements() || !((OrdinaryMorphism)((Pair)this.pair.first).second).getInverseImage(graphObject).hasMoreElements() || !graphObject.isCritical()) continue;
                list.add(graphObject);
            }
            return list;
        }
        return null;
    }

    private OrdinaryMorphism adjustMorph1(OrdinaryMorphism m1) {
        if (m1.getSource() == this.r1.getRight()) {
            OrdinaryMorphism om = BaseFactory.theFactory().createMorphism(this.r1.getLeft(), m1.getTarget());
            Enumeration<GraphObject> dom = m1.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go = dom.nextElement();
                Enumeration<GraphObject> inverse = this.r1.getInverseImage(go);
                if (!inverse.hasMoreElements()) continue;
                GraphObject goL = inverse.nextElement();
                try {
                    om.addMapping(goL, m1.getImage(go));
                }
                catch (BadMappingException ex) {
                    return null;
                }
            }
            return om;
        }
        return m1;
    }

    private OrdinaryMorphism adjustMorph1(OrdinaryMorphism m1, OrdinaryMorphism help1) {
        if (m1.getSource() == this.r1.getRight()) {
            OrdinaryMorphism om = BaseFactory.theFactory().createMorphism(this.r1.getLeft(), m1.getTarget());
            Enumeration<GraphObject> dom = m1.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go = dom.nextElement();
                Enumeration<GraphObject> inverse = this.r1.getInverseImage(go);
                if (!inverse.hasMoreElements()) continue;
                GraphObject goL = inverse.nextElement();
                try {
                    om.addMapping(goL, m1.getImage(go));
                }
                catch (BadMappingException ex) {
                    return null;
                }
            }
            return om;
        }
        return m1;
    }

    private OrdinaryMorphism adjustMorph2(OrdinaryMorphism m2, OrdinaryMorphism help2) {
        if (m2.getSource() != this.r2.getLeft() && m2.getSource() == help2.getTarget() && this.r2.getLeft() == help2.getSource()) {
            OrdinaryMorphism om = BaseFactory.theFactory().createMorphism(this.r2.getLeft(), m2.getTarget());
            Enumeration<GraphObject> dom = m2.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go = dom.nextElement();
                Enumeration<GraphObject> inverse = help2.getInverseImage(go);
                if (!inverse.hasMoreElements()) continue;
                GraphObject goL = inverse.nextElement();
                try {
                    om.addMapping(goL, m2.getImage(go));
                }
                catch (BadMappingException ex) {
                    return null;
                }
            }
            return om;
        }
        return m2;
    }

    private OrdinaryMorphism adjustMorph2NAC(OrdinaryMorphism m2, OrdinaryMorphism help2) {
        if (m2.getSource() == help2.getTarget() && this.r2.hasNAC(help2.getSource())) {
            OrdinaryMorphism om = BaseFactory.theFactory().createMorphism(help2.getSource(), m2.getTarget());
            Enumeration<GraphObject> dom = m2.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go = dom.nextElement();
                Enumeration<GraphObject> inverse = help2.getInverseImage(go);
                if (!inverse.hasMoreElements()) continue;
                GraphObject goN = inverse.nextElement();
                try {
                    om.addMapping(goN, m2.getImage(go));
                }
                catch (BadMappingException ex) {
                    return null;
                }
            }
            return om;
        }
        return m2;
    }

    private OrdinaryMorphism adjustMorph2PAC(OrdinaryMorphism m2, OrdinaryMorphism help1, OrdinaryMorphism help2) {
        if (help1.getTarget() == help2.getSource() && this.r2.hasPAC(help1.getSource())) {
            OrdinaryMorphism om = BaseFactory.theFactory().createMorphism(help1.getSource(), m2.getTarget());
            Enumeration<GraphObject> dom = help1.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go = dom.nextElement();
                GraphObject img = help2.getImage(help1.getImage(go));
                if (img == null) continue;
                try {
                    om.addMapping(go, img);
                }
                catch (BadMappingException ex) {
                    return null;
                }
            }
            return om;
        }
        return null;
    }

    private OrdinaryMorphism makeLeftACFromCriticalGraph(Rule r) {
        if (this.pair == null && this.iterator.hasNext()) {
            this.pair = this.iterator.next();
        }
        if (this.pair != null) {
            if (r == this.r1) {
                return ExcludePairHelper.makeLeftACFromGraph(this.pair, r, true, false);
            }
            if (r == this.r2) {
                return ExcludePairHelper.makeLeftACFromGraph(this.pair, r, false, false);
            }
        }
        return null;
    }

    private void fillMap(List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> list) {
        int i = 0;
        while (i < list.size()) {
            String gname;
            Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p = list.get(i);
            if (!(this.addToList(p, gname = ((OrdinaryMorphism)((Pair)p.first).first).getTarget().getName(), DELETE_USE_C_TXT, 0) || this.addToList(p, gname, DELETE_NEED_C_TXT, 1) || this.addToList(p, gname, PRODUCE_FORBID_C_TXT, 2) || this.addToList(p, gname, PRODUCE_EDGE_DELETE_NODE_C_TXT, 3) || this.addToList(p, gname, CHANGE_USE_ATTR_C_TXT, 4) || this.addToList(p, gname, CHANGE_NEED_ATTR_C_TXT, 5) || this.addToList(p, gname, CHANGE_FORBID_ATTR_C_TXT, 6) || this.addToList(p, gname, DELETE_FORBID_D_TXT, 7) || this.addToList(p, gname, PRODUCE_USE_D_TXT, 8) || this.addToList(p, gname, PRODUCE_NEED_D_TXT, 9) || this.addToList(p, gname, CHANGE_USE_ATTR_D_TXT, 10) || this.addToList(p, gname, CHANGE_FORBID_ATTR_D_TXT, 12) || this.addToList(p, gname, CHANGE_NEED_ATTR_D_TXT, 11))) {
                if (this.addToList(p, gname, PRODUCE_DELETE_D_TXT, 13)) {
                    this.addToList_(p, gname, PRODUCE_DELETE_D_TXT, 131);
                    this.addToList_(p, gname, PRODUCE_DELETE_D_TXT, 132);
                } else if (this.addToList(p, gname, FORBID_PRODUCE_D_TXT, 14) || this.addToList(p, gname, PRODUCE_CHANGE_D_TXT, 15) || this.addToList(p, gname, DELETE_SWITCH_D_TXT, 13) || this.addToList(p, gname, FORBID_SWITCH_D_TXT, 14) || this.addToList(p, gname, CHANGE_SWITCH_D_TXT, 15)) {
                    // empty if block
                }
            }
            ++i;
        }
    }

    private boolean addToList(Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p, String graphName, String searchTxt, int kind) {
        if (graphName.indexOf(searchTxt) != -1) {
            Integer key = kind;
            this.map2.put(p, key);
            List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> l = this.map.get(key);
            if (l == null) {
                l = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
                this.map.put(key, l);
            }
            l.add(p);
            return true;
        }
        return false;
    }

    private boolean addToList_(Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p, String graphName, String searchTxt, int kind) {
        if (graphName.indexOf(searchTxt) != -1) {
            if (kind == 131) {
                Integer key = kind;
                List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> l1 = null;
                OrdinaryMorphism m1 = (OrdinaryMorphism)((Pair)p.first).second;
                OrdinaryMorphism m2 = (OrdinaryMorphism)((Pair)p.first).first;
                Enumeration<GraphObject> dom1 = m1.getDomain();
                while (dom1.hasMoreElements()) {
                    GraphObject o1 = dom1.nextElement();
                    GraphObject o = m1.getImage(o1);
                    if (!m2.getInverseImage(o).hasMoreElements() || !o.isCritical() || !this.r1.getInverseImage(o1).hasMoreElements()) continue;
                    this.map2.put(p, key);
                    l1 = this.map.get(key);
                    if (l1 == null) {
                        l1 = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
                        this.map.put(key, l1);
                    }
                    l1.add(p);
                }
                if (l1 != null) {
                    return true;
                }
            } else if (kind == 132) {
                Integer key = kind;
                List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> l1 = null;
                OrdinaryMorphism m1 = (OrdinaryMorphism)((Pair)p.first).second;
                OrdinaryMorphism m2 = (OrdinaryMorphism)((Pair)p.first).first;
                Enumeration<GraphObject> dom1 = m1.getDomain();
                while (dom1.hasMoreElements()) {
                    GraphObject o1 = dom1.nextElement();
                    GraphObject o = m1.getImage(o1);
                    if (!m2.getInverseImage(o).hasMoreElements() || !o.isCritical() || this.r1.getInverseImage(o1).hasMoreElements()) continue;
                    this.map2.put(p, key);
                    l1 = this.map.get(key);
                    if (l1 == null) {
                        l1 = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
                        this.map.put(key, l1);
                    }
                    l1.add(p);
                }
                if (l1 != null) {
                    return true;
                }
            }
        }
        return false;
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getDeleteUseConflicts() {
        return this.map.get(0);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getDeleteNeedConflicts() {
        return this.map.get(1);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getProduceForbidConflicts() {
        return this.map.get(2);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getChangeUseAttributeConflicts() {
        return this.map.get(4);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getChangeNeedAttributeConflicts() {
        return this.map.get(5);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getChangeForbidAttributeConflicts() {
        return this.map.get(6);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getProduceEdgeDeleteNodeConflicts() {
        return this.map.get(3);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getProduceUseDependencies() {
        return this.map.get(8);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getProduceNeedDependencies() {
        return this.map.get(9);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getDeleteForbidDependencies() {
        return this.map.get(7);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getChangeUseDependencies() {
        return this.map.get(10);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getChangeForbidDependencies() {
        return this.map.get(12);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getChangeNeedDependencies() {
        return this.map.get(11);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getDeliverDeleteDependencies() {
        return this.map.get(13);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getForbidProduceDependencies() {
        return this.map.get(14);
    }

    public List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getChangeChangeDependencies() {
        return this.map.get(15);
    }

    public static boolean isSwitchDependency(String str) {
        return str.indexOf(PRODUCE_DELETE_D_TXT) >= 0 || str.indexOf(FORBID_PRODUCE_D_TXT) >= 0 || str.indexOf(PRODUCE_CHANGE_D_TXT) >= 0;
    }
}

