/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.dialog;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdRule;
import agg.gui.help.HtmlBrowser;
import agg.gui.treeview.dialog.ObjectFlowDesktop;
import agg.ruleappl.RuleSequence;
import agg.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class RuleSequenceDialog
extends JDialog
implements TableModelListener,
ListSelectionListener {
    protected final JFrame applFrame;
    protected EdGraGra gragra;
    protected List<EdRule> rules;
    protected JTable ruleList;
    protected JTable groupList;
    protected JTable groupRuleList;
    protected JScrollPane scrollRuleList;
    protected JScrollPane scrollGroupList;
    protected JScrollPane scrollGroupRuleList;
    protected List<Pair<List<Pair<String, String>>, String>> groups;
    protected List<Pair<String, String>> group;
    protected JList ruleSequenceTextList;
    protected JScrollPane scrollpaneSequenceText;
    protected final List<String> ruleNames = new Vector<String>();
    protected final List<String> groupNames = new Vector<String>();
    protected JButton addGroup;
    protected JButton deleteGroup;
    protected JButton addRule;
    protected JButton deleteRule;
    protected JButton close;
    protected JButton cancel;
    protected JButton help;
    protected JButton objectFlow;
    boolean enabled;
    public boolean showWarning;
    protected Integer groupCount = 0;
    protected MouseListener ml;
    protected ListSelectionListener lsl;
    protected int fromIndx;
    protected int toIndx;
    protected int selGroupIndx = -1;
    protected int selRuleIndx = -1;
    protected final List<String> groupListColumnNames;
    protected final List<String> groupRuleListColumnNames;
    protected JDialog dialog;
    protected HtmlBrowser helpBrowser;
    protected final String title = "Transformation by Rule Sequence";
    protected final Hashtable<RuleSequence, ObjectFlowDesktop> objFlowDesktopList = new Hashtable();
    protected ObjectFlowDesktop objFlowDesktop;

    public RuleSequenceDialog(JFrame frame, Point location) {
        this.applFrame = frame;
        this.dialog = this;
        this.showWarning = true;
        this.setModal(false);
        this.setTitle("Transformation by Rule Sequence");
        this.groups = new Vector<Pair<List<Pair<String, String>>, String>>();
        this.group = new Vector<Pair<String, String>>();
        this.groupListColumnNames = new Vector<String>(2);
        this.groupListColumnNames.add("Subsequence");
        this.groupListColumnNames.add("Iterations");
        this.groupRuleListColumnNames = new Vector<String>(2);
        this.groupRuleListColumnNames.add("Rule");
        this.groupRuleListColumnNames.add("Iterations");
        JPanel content = this.initContentPane();
        JScrollPane scroll = new JScrollPane(content);
        scroll.setPreferredSize(new Dimension(550, 750));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scroll, "Center");
        this.validate();
        this.setLocation(location);
        this.pack();
    }

    public void extendTitle(String name) {
        String str = " ".concat(name).concat(" - ");
        super.setTitle(str.concat("Transformation by Rule Sequence"));
    }

    public void refresh(List<EdRule> edrules, List<Pair<List<Pair<String, String>>, String>> subsequences) {
        int i = 0;
        while (i < this.ruleNames.size()) {
            String rname = this.ruleNames.get(i);
            if (this.gragra.getRule(rname) == null) {
                this.ruleNames.remove(i);
                --i;
            }
            ++i;
        }
        this.updateRuleSequences(subsequences);
    }

    public void updateRules(List<EdRule> edrules) {
        if (this.rules != edrules) {
            this.groups = null;
            this.group = null;
            this.clearGroups();
        }
        this.rules = edrules;
        if (this.ruleList != null) {
            this.scrollRuleList.getViewport().remove(this.ruleList);
            if (this.rules != null && !this.rules.isEmpty()) {
                this.ruleNames.clear();
                int i = 0;
                while (i < edrules.size()) {
                    EdRule r = edrules.get(i);
                    this.ruleNames.add(r.getBasisRule().getName());
                    ++i;
                }
                this.ruleList = new JTable(this.ruleNames.size(), 1);
                this.ruleList.getModel().addTableModelListener(this);
                i = 0;
                while (i < this.ruleNames.size()) {
                    this.ruleList.getModel().setValueAt(this.ruleNames.get(i), i, 0);
                    ((DefaultCellEditor)this.ruleList.getCellEditor(i, 0)).getComponent().setEnabled(false);
                    ++i;
                }
                this.scrollRuleList.getViewport().setView(this.ruleList);
            } else {
                this.ruleList = new JTable(0, 1);
                this.scrollRuleList.getViewport().setView(this.ruleList);
            }
            this.ruleList.getSelectionModel().clearSelection();
            this.updateObjectFlow();
        }
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
    }

    public void updateRuleSequencesList() {
        this.updateRuleSequencesTextList(this.getRuleSequencesText(this.groups));
    }

    public void updateRuleSequences(List<Pair<List<Pair<String, String>>, String>> sequences) {
        this.clearGroups();
        if (sequences != null) {
            this.groups.addAll(sequences);
            this.updateGroupList();
            this.updateRuleSequencesTextList(this.getRuleSequencesText(this.groups));
        } else {
            this.setVisible(false);
        }
    }

    public List<Pair<List<Pair<String, String>>, String>> getRuleSequences() {
        return this.groups;
    }

    public void enableGUI(boolean b) {
        this.enabled = b;
        this.ruleList.setEnabled(b);
        this.groupList.setEnabled(b);
        this.groupRuleList.setEnabled(b);
        this.addGroup.setEnabled(b);
        this.deleteGroup.setEnabled(b);
        this.addRule.setEnabled(b);
        this.deleteRule.setEnabled(b);
        this.close.setEnabled(b);
        this.cancel.setEnabled(b);
        this.help.setEnabled(b);
        this.ruleSequenceTextList.setEnabled(b);
    }

    public boolean isGUIEnabled() {
        return this.enabled;
    }

    private JPanel initContentPane() {
        TitledBorder border = new TitledBorder("");
        this.ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    RuleSequenceDialog.this.dialog.setCursor(new Cursor(13));
                }
                if (e.getSource() == RuleSequenceDialog.this.groupList) {
                    RuleSequenceDialog.this.fromIndx = RuleSequenceDialog.this.groupList.rowAtPoint(new Point(e.getX(), e.getY()));
                    if (RuleSequenceDialog.this.groupList.columnAtPoint(new Point(e.getX(), e.getY())) == 0) {
                        ((DefaultCellEditor)RuleSequenceDialog.this.groupList.getCellEditor(RuleSequenceDialog.this.fromIndx, 0)).getComponent().setEnabled(false);
                    } else {
                        ((DefaultCellEditor)RuleSequenceDialog.this.groupList.getCellEditor(RuleSequenceDialog.this.fromIndx, 1)).getComponent().setEnabled(true);
                    }
                } else if (e.getSource() == RuleSequenceDialog.this.groupRuleList) {
                    RuleSequenceDialog.this.fromIndx = RuleSequenceDialog.this.groupRuleList.rowAtPoint(new Point(e.getX(), e.getY()));
                    if (RuleSequenceDialog.this.groupRuleList.columnAtPoint(new Point(e.getX(), e.getY())) == 0) {
                        ((DefaultCellEditor)RuleSequenceDialog.this.groupRuleList.getCellEditor(RuleSequenceDialog.this.fromIndx, 0)).getComponent().setEnabled(false);
                    } else {
                        ((DefaultCellEditor)RuleSequenceDialog.this.groupRuleList.getCellEditor(RuleSequenceDialog.this.fromIndx, 1)).getComponent().setEnabled(true);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getSource() == RuleSequenceDialog.this.groupList) {
                    RuleSequenceDialog.this.toIndx = RuleSequenceDialog.this.groupList.rowAtPoint(new Point(e.getX(), e.getY()));
                    if (RuleSequenceDialog.this.toIndx >= 0) {
                        RuleSequenceDialog.this.selGroupIndx = RuleSequenceDialog.this.toIndx;
                        if (SwingUtilities.isMiddleMouseButton(e)) {
                            Pair<List<Pair<String, String>>, String> v = RuleSequenceDialog.this.groups.get(RuleSequenceDialog.this.fromIndx);
                            RuleSequenceDialog.this.groups.remove(v);
                            RuleSequenceDialog.this.groups.add(RuleSequenceDialog.this.toIndx, v);
                            ((DefaultTableModel)RuleSequenceDialog.this.groupList.getModel()).moveRow(RuleSequenceDialog.this.fromIndx, RuleSequenceDialog.this.fromIndx, RuleSequenceDialog.this.toIndx);
                            RuleSequenceDialog.this.updateGroups();
                            RuleSequenceDialog.this.updateRuleSequencesTextList(RuleSequenceDialog.this.getRuleSequencesText(RuleSequenceDialog.this.groups));
                            RuleSequenceDialog.this.groupList.changeSelection(RuleSequenceDialog.this.selGroupIndx, 0, false, false);
                        }
                    }
                } else if (e.getSource() == RuleSequenceDialog.this.groupRuleList) {
                    RuleSequenceDialog.this.toIndx = RuleSequenceDialog.this.groupRuleList.rowAtPoint(new Point(e.getX(), e.getY()));
                    if (RuleSequenceDialog.this.toIndx >= 0) {
                        RuleSequenceDialog.this.selRuleIndx = RuleSequenceDialog.this.toIndx;
                        if (SwingUtilities.isMiddleMouseButton(e)) {
                            Pair<String, String> v = RuleSequenceDialog.this.group.get(RuleSequenceDialog.this.fromIndx);
                            RuleSequenceDialog.this.group.remove(v);
                            RuleSequenceDialog.this.group.add(RuleSequenceDialog.this.toIndx, v);
                            ((DefaultTableModel)RuleSequenceDialog.this.groupRuleList.getModel()).moveRow(RuleSequenceDialog.this.fromIndx, RuleSequenceDialog.this.fromIndx, RuleSequenceDialog.this.toIndx);
                            RuleSequenceDialog.this.updateRuleSequencesTextList(RuleSequenceDialog.this.getRuleSequencesText(RuleSequenceDialog.this.groups));
                            RuleSequenceDialog.this.groupRuleList.changeSelection(RuleSequenceDialog.this.selRuleIndx, 0, false, false);
                            RuleSequenceDialog.this.ruleSequenceTextList.setSelectedIndex(RuleSequenceDialog.this.selGroupIndx);
                        }
                    }
                }
                RuleSequenceDialog.this.dialog.setCursor(new Cursor(0));
            }
        };
        JPanel p = new JPanel(new BorderLayout());
        JPanel p0 = new JPanel(new GridLayout(0, 1));
        p0.setLayout(new GridBagLayout());
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.setBorder(border);
        JPanel p11 = new JPanel(new BorderLayout());
        JPanel p12 = new JPanel(new BorderLayout());
        JLabel l = new JLabel(" Add a new rule subsequence by clicking ");
        this.addGroup = new JButton("New Subsequence");
        this.addGroup.setEnabled(false);
        this.addGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RuleSequenceDialog.this.ruleList.getRowCount() != 0) {
                    RuleSequenceDialog.this.groupCount = RuleSequenceDialog.this.groups.size();
                    Vector seqvec = new Vector();
                    Pair seqvecpair = new Pair(seqvec, "1");
                    RuleSequenceDialog.this.groups.add(seqvecpair);
                    RuleSequenceDialog.this.group = (List)RuleSequenceDialog.this.groups.get((int)RuleSequenceDialog.this.groupCount.intValue()).first;
                    RuleSequenceDialog.this.groupCount = RuleSequenceDialog.this.groupCount + 1;
                    RuleSequenceDialog.this.updateGroupList();
                    int indx = RuleSequenceDialog.this.groupCount - 1;
                    RuleSequenceDialog.this.groupList.changeSelection(indx, 0, false, false);
                    RuleSequenceDialog.this.selGroupIndx = indx;
                    RuleSequenceDialog.this.groupRuleList.removeAll();
                }
            }
        });
        p11.add((Component)l, "Center");
        p11.add((Component)this.addGroup, "East");
        p11.add((Component)new JLabel("       "), "South");
        l = new JLabel(" Select a rule   &  add to the currently selected subsequence ");
        this.ruleList = new JTable(0, 1);
        this.scrollRuleList = new JScrollPane(this.ruleList);
        this.scrollRuleList.setPreferredSize(new Dimension(300, 100));
        this.addRule = new JButton("Add");
        JPanel addRuleP = this.makeAddRuleButtonPanel(this.addRule);
        this.addRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RuleSequenceDialog.this.group != null) {
                    int[] selValues = RuleSequenceDialog.this.ruleList.getSelectedRows();
                    int i = 0;
                    while (i < selValues.length) {
                        String rulename = (String)RuleSequenceDialog.this.ruleList.getValueAt(selValues[i], 0);
                        Pair<String, String> rulepair = new Pair<String, String>(rulename, "1");
                        RuleSequenceDialog.this.group.add(rulepair);
                        ++i;
                    }
                    RuleSequenceDialog.this.updateGroupRuleList();
                    RuleSequenceDialog.this.updateRuleSequencesTextList(RuleSequenceDialog.this.getRuleSequencesText(RuleSequenceDialog.this.groups));
                    RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence().refresh();
                }
            }
        });
        p12.add((Component)l, "North");
        p12.add((Component)this.scrollRuleList, "Center");
        p12.add((Component)addRuleP, "East");
        this.constrainBuild(p1, p11, 0, 0, 1, 1, 0, 11, 0.0, 0.0, 10, 5, 5, 5);
        this.constrainBuild(p1, p12, -1, 1, 1, 1, 1, 11, 1.0, 1.0, 5, 5, 10, 5);
        JPanel p2 = new JPanel(new GridBagLayout());
        p2.setBorder(border);
        JPanel p21 = new JPanel(new BorderLayout());
        JPanel p22 = new JPanel(new BorderLayout());
        l = new JLabel(" Select a subsequence    &   set the max count of iterations  ");
        this.groupNames.clear();
        this.scrollGroupList = new JScrollPane();
        this.scrollGroupList.setPreferredSize(new Dimension(300, 100));
        this.groupList = this.createGroupList(this.groupNames);
        this.deleteGroup = new JButton("Delete Subsequence");
        this.deleteGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RuleSequenceDialog.this.selGroupIndx == -1) {
                    return;
                }
                RuleSequenceDialog.this.groups.remove(RuleSequenceDialog.this.selGroupIndx);
                RuleSequenceDialog.this.groupCount = RuleSequenceDialog.this.groupCount - 1;
                RuleSequenceDialog.this.updateGroupList();
                if (!RuleSequenceDialog.this.groups.isEmpty()) {
                    RuleSequenceDialog.this.group = (List)RuleSequenceDialog.this.groups.get((int)(RuleSequenceDialog.this.groups.size() - 1)).first;
                    --RuleSequenceDialog.this.selGroupIndx;
                    if (RuleSequenceDialog.this.selGroupIndx == -1 && !RuleSequenceDialog.this.groups.isEmpty()) {
                        RuleSequenceDialog.this.selGroupIndx = 0;
                    }
                    RuleSequenceDialog.this.groupList.changeSelection(RuleSequenceDialog.this.selGroupIndx, 0, false, false);
                    RuleSequenceDialog.this.selRuleIndx = -1;
                } else {
                    RuleSequenceDialog.this.group.clear();
                    RuleSequenceDialog.this.updateGroupRuleList();
                    RuleSequenceDialog.this.selGroupIndx = -1;
                    RuleSequenceDialog.this.selRuleIndx = -1;
                    RuleSequenceDialog.this.groupCount = 0;
                }
                RuleSequenceDialog.this.updateRuleSequencesTextList(RuleSequenceDialog.this.getRuleSequencesText(RuleSequenceDialog.this.groups));
                RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence().refresh();
            }
        });
        JPanel deleteGroupPanel = this.makeButtonPanel(this.deleteGroup);
        p21.add((Component)l, "North");
        p21.add((Component)this.scrollGroupList, "Center");
        p21.add((Component)deleteGroupPanel, "South");
        l = new JLabel(" Select a rule    &    set the max count of iterations ");
        this.scrollGroupRuleList = new JScrollPane();
        this.scrollGroupRuleList.setPreferredSize(new Dimension(300, 100));
        this.groupRuleList = this.createGroupRuleList(this.group);
        this.deleteRule = new JButton("Delete Rule");
        this.deleteRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RuleSequenceDialog.this.selRuleIndx == -1) {
                    return;
                }
                RuleSequenceDialog.this.group.remove(RuleSequenceDialog.this.selRuleIndx);
                RuleSequenceDialog.this.updateGroupRuleList();
                --RuleSequenceDialog.this.selRuleIndx;
                if (RuleSequenceDialog.this.selRuleIndx == -1 && !RuleSequenceDialog.this.group.isEmpty()) {
                    RuleSequenceDialog.this.selRuleIndx = 0;
                }
                RuleSequenceDialog.this.groupRuleList.getSelectionModel().setLeadSelectionIndex(RuleSequenceDialog.this.selRuleIndx);
                RuleSequenceDialog.this.updateRuleSequencesTextList(RuleSequenceDialog.this.getRuleSequencesText(RuleSequenceDialog.this.groups));
                RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence().refresh();
            }
        });
        JPanel deleteRulePanel = this.makeButtonPanel(this.deleteRule);
        p22.add((Component)l, "North");
        p22.add((Component)this.scrollGroupRuleList, "Center");
        p22.add((Component)deleteRulePanel, "South");
        this.constrainBuild(p2, p21, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(p2, p22, -1, 1, 1, 1, 1, 11, 1.0, 1.0, 5, 5, 5, 5);
        JPanel p3 = new JPanel(new BorderLayout());
        p3.setBorder(border);
        p3.add((Component)new JLabel(" Transformation rule sequence defined "), "North");
        this.ruleSequenceTextList = new JList();
        this.scrollpaneSequenceText = new JScrollPane(this.ruleSequenceTextList);
        this.scrollpaneSequenceText.setPreferredSize(new Dimension(250, 100));
        p3.add((Component)this.scrollpaneSequenceText, "Center");
        JPanel p4 = new JPanel(new GridBagLayout());
        this.close = new JButton("Close");
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSequenceDialog.this.closeObjectFlowDeskTop();
                RuleSequenceDialog.this.setVisible(false);
            }
        });
        this.objectFlow = this.makeObjectFlowButton();
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSequenceDialog.this.clearGroups();
                RuleSequenceDialog.this.updateRuleSequencesTextList(RuleSequenceDialog.this.getRuleSequencesText(RuleSequenceDialog.this.groups));
                RuleSequenceDialog.this.setVisible(false);
            }
        });
        this.help = new JButton("Help");
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RuleSequenceDialog.this.helpBrowser != null) {
                    RuleSequenceDialog.this.helpBrowser.dispose();
                    RuleSequenceDialog.this.helpBrowser = null;
                }
                if (RuleSequenceDialog.this.helpBrowser == null) {
                    RuleSequenceDialog.this.helpBrowser = new HtmlBrowser("RuleSequencesHelp.html");
                    RuleSequenceDialog.this.helpBrowser.setSize(500, 600);
                    RuleSequenceDialog.this.helpBrowser.setLocation(20, 20);
                    RuleSequenceDialog.this.helpBrowser.setVisible(true);
                }
            }
        });
        this.constrainBuild(p4, this.close, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 25, 5, 25);
        this.constrainBuild(p4, this.objectFlow, 1, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 25, 5, 25);
        this.constrainBuild(p4, this.cancel, 2, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 25, 5, 25);
        this.constrainBuild(p4, this.help, 3, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 25, 5, 25);
        this.constrainBuild(p0, p1, -1, -1, 1, 1, 1, 10, 1.0, 1.0, 5, 5, 5, 5);
        this.constrainBuild(p0, p2, -1, 1, 1, 1, 1, 10, 1.0, 1.0, 5, 5, 5, 5);
        this.constrainBuild(p0, p3, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        p.add((Component)p0, "Center");
        p.add((Component)p4, "South");
        return p;
    }

    void closeObjectFlowDeskTop() {
        Iterator<ObjectFlowDesktop> elems = this.objFlowDesktopList.values().iterator();
        while (elems.hasNext()) {
            elems.next().setVisible(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int indx;
        if (e.getSource() instanceof DefaultListSelectionModel) {
            int indx2 = ((DefaultListSelectionModel)e.getSource()).getLeadSelectionIndex();
            if (indx2 != -1 && !this.groups.isEmpty()) {
                this.group = (List)this.groups.get((int)indx2).first;
                this.updateGroupRuleList();
                if (indx2 != this.ruleSequenceTextList.getSelectedIndex()) {
                    this.ruleSequenceTextList.setSelectedIndex(indx2);
                }
            }
        } else if (e.getSource() instanceof JList && (indx = ((JList)e.getSource()).getSelectionModel().getLeadSelectionIndex()) != -1 && !this.groups.isEmpty() && indx != this.selGroupIndx) {
            this.groupList.changeSelection(indx, 0, false, false);
        }
    }

    private JTable createGroupList(List<String> names) {
        this.updateGroupList();
        return this.groupList;
    }

    private JTable createGroupRuleList(List<Pair<String, String>> names) {
        this.updateGroupRuleList();
        return this.groupRuleList;
    }

    private JPanel makeButtonPanel(JButton b) {
        JPanel p = new JPanel(new GridLayout(1, 0));
        p.add(b);
        p.add(new JLabel("    "));
        p.add(new JLabel("    "));
        return p;
    }

    private JPanel makeAddRuleButtonPanel(JButton b) {
        JPanel p = new JPanel(new GridLayout(0, 1));
        p.add(new JLabel("       "));
        p.add(new JLabel("       "));
        p.add(b);
        p.add(new JLabel("       "));
        p.add(new JLabel("       "));
        return p;
    }

    private JButton makeObjectFlowButton() {
        JButton b = new JButton("Object Flow");
        b.setToolTipText("Click here to open | refresh Object Flow dialog");
        b.setEnabled(true);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence().containsRuleLoop() && RuleSequenceDialog.this.objFlowDesktop != null && RuleSequenceDialog.this.objFlowDesktop.getGraGra() != RuleSequenceDialog.this.gragra) {
                    RuleSequenceDialog.this.showWarning = true;
                }
                RuleSequenceDialog.this.objFlowDesktop = RuleSequenceDialog.this.objFlowDesktopList.get(RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence());
                if (RuleSequenceDialog.this.objFlowDesktop == null) {
                    RuleSequenceDialog.this.objFlowDesktop = new ObjectFlowDesktop(RuleSequenceDialog.this.applFrame, RuleSequenceDialog.this.gragra, RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence(), new Point(RuleSequenceDialog.this.dialog.getLocation().x + 100, RuleSequenceDialog.this.dialog.getLocation().y + 50));
                    RuleSequenceDialog.this.objFlowDesktopList.put(RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence(), RuleSequenceDialog.this.objFlowDesktop);
                    if (RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence().containsRuleLoop()) {
                        RuleSequenceDialog.this.showWarning = RuleSequenceDialog.this.showWarnDialog() == 0;
                    }
                } else {
                    if (RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence().doesCheckAtGraph() && RuleSequenceDialog.this.gragra.getBasisGraGra().getGraph() != RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence().getGraph()) {
                        int answer = 0;
                        Object[] options = new Object[]{"OK", "Cancel"};
                        if (RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence().isObjFlowActive() || RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence().isChecked()) {
                            answer = JOptionPane.showOptionDialog(RuleSequenceDialog.this.dialog, "<html><body>Currently selected sequence contains an object flow \nor is already checked at the graph  \"" + RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence().getGraph().getName() + "\" \n" + "The object flow resp. results are not more valid after graph reset.", "Reset Graph", -1, 3, null, options, options[0]);
                        }
                        if (answer == 0) {
                            RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence().setGraph(RuleSequenceDialog.this.gragra.getBasisGraGra().getGraph());
                        }
                    }
                    RuleSequenceDialog.this.objFlowDesktop.refresh();
                    if (RuleSequenceDialog.this.showWarning && RuleSequenceDialog.this.gragra.getBasisGraGra().getCurrentRuleSequence().containsRuleLoop()) {
                        RuleSequenceDialog.this.showWarning = RuleSequenceDialog.this.showWarnDialog() == 0;
                    }
                }
                RuleSequenceDialog.this.objFlowDesktop.setVisible(true);
            }
        });
        return b;
    }

    public void closeObjectFlow() {
        if (!this.objFlowDesktopList.isEmpty()) {
            for (ObjectFlowDesktop ofd : this.objFlowDesktopList.values()) {
                ofd.setVisible(false);
            }
        }
    }

    protected int showWarnDialog() {
        Object[] options = new Object[]{"OK", "Do not warn again"};
        int answer = JOptionPane.showOptionDialog(this.dialog, "Please note:\nThe ( * ) iterations of a rule will be converted to 2 times.\n\n", "Warning", -1, 2, null, options, options[1]);
        return answer;
    }

    protected void updateObjectFlow() {
        if (!this.objFlowDesktopList.isEmpty()) {
            for (ObjectFlowDesktop ofd : this.objFlowDesktopList.values()) {
                if (!ofd.isVisible()) continue;
                ofd.refresh();
            }
        }
    }

    protected List<String> getRuleSequencesText(List<Pair<List<Pair<String, String>>, String>> sequences) {
        Vector<String> v = new Vector<String>(sequences.size());
        int i = 0;
        while (i < sequences.size()) {
            Pair<List<Pair<String, String>>, String> g = sequences.get(i);
            String grpStr = "";
            List grpRules = (List)g.first;
            long grpIters = -1L;
            String grpItersStr = (String)g.second;
            if (grpItersStr.equals("*")) {
                grpStr = String.valueOf(grpStr) + "( ";
            } else {
                try {
                    grpIters = new Long((String)g.second);
                    if (grpRules.size() > 1 || grpIters > 1L) {
                        grpStr = String.valueOf(grpStr) + "( ";
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int j = 0;
            while (j < grpRules.size()) {
                Pair p = (Pair)grpRules.get(j);
                String rulename = (String)p.first;
                grpStr = String.valueOf(grpStr) + rulename;
                long ruleIters = -1L;
                String ruleItersStr = (String)p.second;
                if (ruleItersStr.equals("*")) {
                    grpStr = String.valueOf(grpStr) + "{" + ruleItersStr + "}";
                } else {
                    ruleIters = new Long((String)p.second);
                    if (ruleIters > 1L) {
                        grpStr = String.valueOf(grpStr) + "{" + ruleIters + "}";
                    }
                }
                grpStr = String.valueOf(grpStr) + " ";
                ++j;
            }
            if (grpItersStr.equals("*")) {
                grpStr = String.valueOf(grpStr) + ")";
            } else if (grpRules.size() > 1 || grpIters > 1L) {
                grpStr = String.valueOf(grpStr) + ")";
            }
            if (grpRules.size() > 0) {
                if (grpItersStr.equals("*")) {
                    grpStr = String.valueOf(grpStr) + "{" + grpItersStr + "}";
                } else if (grpIters > 1L) {
                    grpStr = String.valueOf(grpStr) + "{" + grpIters + "}";
                }
            }
            if (grpStr.length() > 0) {
                grpStr = String.valueOf(grpStr) + "\n";
            }
            v.add(grpStr);
            ++i;
        }
        return v;
    }

    protected void updateRuleSequencesTextList(List<String> sequenceText) {
        this.scrollpaneSequenceText.getViewport().remove(this.ruleSequenceTextList);
        this.ruleSequenceTextList.removeAll();
        if (sequenceText != null) {
            this.ruleSequenceTextList = new JList((Vector)sequenceText);
            this.ruleSequenceTextList.addListSelectionListener(this);
            this.ruleSequenceTextList.getSelectionModel().setSelectionMode(0);
        } else {
            this.ruleSequenceTextList = new JList();
        }
        this.scrollpaneSequenceText.setViewportView(this.ruleSequenceTextList);
    }

    protected String updateRuleSequencesText(List<Pair<List<Pair<String, String>>, String>> sequences) {
        String s = "";
        int i = 0;
        while (i < sequences.size()) {
            Pair<List<Pair<String, String>>, String> g = sequences.get(i);
            String grpStr = "";
            List grpRules = (List)g.first;
            long grpIters = -1L;
            String grpItersStr = (String)g.second;
            if (grpItersStr.equals("*")) {
                grpStr = grpStr.concat("( ");
            } else {
                grpIters = new Long((String)g.second);
                if (grpRules.size() > 1 || grpIters > 1L) {
                    grpStr = grpStr.concat("( ");
                }
            }
            int j = 0;
            while (j < grpRules.size()) {
                Pair p = (Pair)grpRules.get(j);
                String rulename = (String)p.first;
                grpStr = grpStr.concat(rulename);
                long ruleIters = -1L;
                String ruleItersStr = (String)p.second;
                if (ruleItersStr.equals("*")) {
                    grpStr = grpStr.concat("{");
                    grpStr = grpStr.concat(ruleItersStr);
                    grpStr = grpStr.concat("}");
                } else {
                    ruleIters = new Long((String)p.second);
                    if (ruleIters > 1L) {
                        grpStr = grpStr.concat("{");
                        grpStr = grpStr.concat(String.valueOf(ruleIters));
                        grpStr = grpStr.concat("}");
                    }
                }
                grpStr = grpStr.concat(" ");
                ++j;
            }
            if (grpItersStr.equals("*")) {
                grpStr = grpStr.concat(")");
            } else if (grpRules.size() > 1 || grpIters > 1L) {
                grpStr = grpStr.concat(")");
            }
            if (grpRules.size() > 0) {
                if (grpItersStr.equals("*")) {
                    grpStr = grpStr.concat("{");
                    grpStr = grpStr.concat(grpItersStr);
                    grpStr = grpStr.concat("}");
                } else if (grpIters > 1L) {
                    grpStr = String.valueOf(grpStr) + "{" + grpIters + "}";
                }
            } else {
                grpStr = "()";
            }
            grpStr = grpStr.concat("\n");
            s = s.concat(grpStr);
            ++i;
        }
        return s;
    }

    public String getRuleSequencesText() {
        return this.updateRuleSequencesText(this.groups);
    }

    public boolean isEmpty() {
        return this.rules == null || this.rules.isEmpty();
    }

    protected void clear() {
        this.updateRules(null);
        this.clearGroups();
    }

    protected void clearGroups() {
        this.groups = new Vector<Pair<List<Pair<String, String>>, String>>();
        this.group = new Vector<Pair<String, String>>();
        this.groupCount = 0;
        this.updateGroupList();
        this.updateGroupRuleList();
        this.updateRuleSequencesTextList(null);
    }

    protected void updateGroups() {
        int i = 0;
        while (i < this.groupList.getRowCount()) {
            this.groupList.getModel().setValueAt(String.valueOf(i + 1), i, 0);
            ++i;
        }
    }

    protected void updateGroupList() {
        Vector data = new Vector(this.groups.size());
        int i = 0;
        while (i < this.groups.size()) {
            Vector<String> rd = new Vector<String>(2);
            rd.add(String.valueOf(i + 1));
            rd.add((String)this.groups.get((int)i).second);
            data.add(rd);
            ++i;
        }
        if (this.groupList != null) {
            this.scrollGroupList.getViewport().remove(this.groupList);
        }
        this.groupList = new JTable(data, (Vector)this.groupListColumnNames);
        this.groupList.getModel().addTableModelListener(this);
        this.groupList.addMouseListener(this.ml);
        this.scrollGroupList.getViewport().setView(this.groupList);
        this.groupList.getSelectionModel().setSelectionMode(0);
        this.groupList.getSelectionModel().addListSelectionListener(this);
    }

    protected void updateGroupRuleList() {
        Vector data = new Vector(this.group.size());
        int i = 0;
        while (i < this.group.size()) {
            Pair<String, String> p = this.group.get(i);
            Vector<String> rd = new Vector<String>(2);
            rd.add((String)p.first);
            rd.add((String)p.second);
            data.add(rd);
            ++i;
        }
        if (this.groupRuleList != null) {
            this.scrollGroupRuleList.getViewport().remove(this.groupRuleList);
        }
        this.groupRuleList = new JTable(data, (Vector)this.groupRuleListColumnNames);
        this.groupRuleList.getModel().addTableModelListener(this);
        this.groupRuleList.addMouseListener(this.ml);
        this.scrollGroupRuleList.getViewport().setView(this.groupRuleList);
        this.groupRuleList.getSelectionModel().setSelectionMode(0);
    }

    protected void updateGroupRuleList(List<Pair<String, String>> aGroup) {
        Vector data = new Vector(aGroup.size());
        int i = 0;
        while (i < aGroup.size()) {
            Pair<String, String> p = aGroup.get(i);
            Vector<String> rd = new Vector<String>(2);
            rd.add((String)p.first);
            rd.add((String)p.second);
            data.add(rd);
            ++i;
        }
        if (this.groupRuleList != null) {
            this.scrollGroupRuleList.getViewport().remove(this.groupRuleList);
        }
        this.groupRuleList = new JTable(data, (Vector)this.groupRuleListColumnNames);
        this.groupRuleList.getModel().addTableModelListener(this);
        this.groupRuleList.addMouseListener(this.ml);
        this.scrollGroupRuleList.getViewport().setView(this.groupRuleList);
        this.groupRuleList.getSelectionModel().setSelectionMode(0);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row;
        if (e.getSource() == this.groupList.getModel()) {
            int indx = this.groupList.getSelectedRow();
            if (indx != -1) {
                boolean ok = false;
                String iters = (String)this.groupList.getModel().getValueAt(indx, 1);
                if (iters.equals("*")) {
                    ok = true;
                } else {
                    try {
                        new Long((String)this.groupList.getModel().getValueAt(indx, 1));
                        ok = true;
                    }
                    catch (NumberFormatException ex) {
                        this.groupList.getModel().setValueAt("1", indx, 1);
                        iters = "1";
                        ok = true;
                    }
                }
                if (ok) {
                    this.groups.get((int)indx).second = iters;
                    this.updateRuleSequencesTextList(this.getRuleSequencesText(this.groups));
                    this.gragra.getBasisGraGra().getCurrentRuleSequence().refresh();
                }
            }
        } else if (e.getSource() == this.groupRuleList.getModel() && this.group != null && !this.group.isEmpty() && (row = this.groupRuleList.getSelectedRow()) != -1) {
            boolean ok = false;
            String iters = (String)this.groupRuleList.getModel().getValueAt(row, 1);
            if (iters.equals("*")) {
                ok = true;
            } else {
                try {
                    new Long((String)this.groupRuleList.getModel().getValueAt(row, 1));
                    ok = true;
                }
                catch (NumberFormatException ex) {
                    this.groupRuleList.getModel().setValueAt("1", row, 1);
                    iters = "1";
                    ok = true;
                }
            }
            if (ok) {
                int i = this.groupList.getSelectedRow();
                Pair p = (Pair)((List)this.groups.get((int)i).first).get(row);
                p.second = iters;
                this.group.get((int)row).second = iters;
                this.updateRuleSequencesTextList(this.getRuleSequencesText(this.groups));
                this.gragra.getBasisGraGra().getCurrentRuleSequence().refresh();
            }
        }
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }
}

