/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.options;

import agg.gui.parser.event.OptionEvent;
import agg.gui.parser.event.OptionListener;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class AbstractOptionGUI
extends JPanel {
    protected HashSet<OptionListener> listener = new HashSet();

    public AbstractOptionGUI() {
        super(true);
    }

    public void addOptionListener(OptionListener ol) {
        this.listener.add(ol);
    }

    public void removeOptionListener(OptionListener ol) {
        this.listener.remove(ol);
    }

    public void fireOptionEvent(OptionEvent oe) {
        for (OptionListener ol : this.listener) {
            ol.optionEventOccurred(oe);
        }
    }

    public Icon getIcon() {
        return null;
    }

    public abstract String getTabTitle();

    public abstract String getTabTip();

    public abstract void update();

    public abstract void executeOnClose();

    protected JPanel makeInitialOptionPanel(String title) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        return this.makeInitialOptionPanel(true, title, c);
    }

    protected JPanel makeInitialOptionPanel(boolean border, String title, GridBagConstraints c) {
        JPanel optionPanel = new JPanel();
        if (border) {
            Border etched = BorderFactory.createEtchedBorder();
            optionPanel.setBorder(etched);
        }
        GridBagLayout gridbag = new GridBagLayout();
        optionPanel.setLayout(gridbag);
        if (!"".equals(title)) {
            JLabel titleText = new JLabel(title);
            gridbag.setConstraints(titleText, c);
            optionPanel.add(titleText);
        }
        return optionPanel;
    }
}

