/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.icons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;

public class StepIcon
implements Icon {
    boolean isEnabled;
    Color color;

    public StepIcon(Color aColor) {
        this.color = aColor;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.isEnabled) {
            g.setColor(this.color);
        } else {
            g.setColor(Color.gray.darker());
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.5f));
        g2.drawLine(x + 2, y + 6, x + this.getIconWidth() - 4, y + 6);
        g2.drawLine(x + 2, y + this.getIconHeight() - 6, x + this.getIconWidth() - 4, y + this.getIconHeight() - 6);
        g2.drawLine(x + 12, y + 4, x + this.getIconWidth(), 10);
        g2.drawLine(x + 12, y + this.getIconHeight() - 4, x + this.getIconWidth(), 10);
    }

    @Override
    public int getIconWidth() {
        return 16;
    }

    @Override
    public int getIconHeight() {
        return 16;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }
}

