/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.editor;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraphObject;
import agg.gui.AGGAppl;
import agg.gui.editor.GraphEditor;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class GraphEditorMouseAdapter
extends MouseAdapter {
    private GraphEditor editor;

    public GraphEditorMouseAdapter(GraphEditor grapheditor) {
        this.editor = grapheditor;
        this.editor.addMouseListener(this);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Object source = e.getSource();
        if (source == this.editor.getGraphPanel().getCanvas()) {
            AGGAppl.getInstance().setCursor(this.editor.getGraphPanel().getEditCursor());
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        AGGAppl.getInstance().setCursor(new Cursor(0));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.editor.getGraph() == null) {
            return;
        }
        Object source = e.getSource();
        int x = e.getX();
        int y = e.getY();
        if ((e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) && this.editor.getGraph().isEditable()) {
            if (this.editor.getGraphPanel().getCanvas().isLeftPressed()) {
                this.editor.allowToShowPopupMenu(false);
            }
        } else if (SwingUtilities.isMiddleMouseButton(e)) {
            if (this.editor.getGraphPanel().getCanvas().getPickedObject(e.getX(), e.getY(), this.editor.getGraphics().getFontMetrics()) != null) {
                AGGAppl.getInstance().setCursor(new Cursor(13));
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.editor.getGraphPanel().getCanvas().isRightPressed()) {
                this.editor.allowToShowPopupMenu(false);
            }
            switch (this.editor.getGraphPanel().getEditMode()) {
                case 11: {
                    break;
                }
                case 13: {
                    EdGraphObject ego;
                    if (source != this.editor.getGraphPanel().getCanvas() || this.editor.getGraphPanel() == null || (ego = this.editor.getGraph().getPicked(x, y)) == null || !ego.isArc()) break;
                    EdArc ea = (EdArc)ego;
                    if (ea.getAnchorID() == 1) {
                        AGGAppl.getInstance().setCursor(new Cursor(6));
                        break;
                    }
                    if (ea.getAnchorID() == 2) {
                        AGGAppl.getInstance().setCursor(new Cursor(7));
                        break;
                    }
                    if (ea.getAnchorID() == 3) {
                        AGGAppl.getInstance().setCursor(new Cursor(5));
                        break;
                    }
                    if (ea.getAnchorID() == 4) {
                        AGGAppl.getInstance().setCursor(new Cursor(4));
                        break;
                    }
                    if (ea.getAnchorID() != 0) break;
                    AGGAppl.getInstance().setCursor(new Cursor(13));
                    break;
                }
                case 1201: {
                    break;
                }
                case 1202: {
                    break;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.editor.getGraph() == null) {
            return;
        }
        if ((SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) && this.editor.getGraph().isEditable()) {
            if (this.editor.isPopupMenuAllowed()) {
                this.editor.showPopupMenu(e);
            }
            this.editor.allowToShowPopupMenu(true);
            this.editor.getGraphPanel().getCanvas().unsetLeftAndRightPressed();
        } else if (e.getSource() == this.editor.getGraphPanel().getCanvas()) {
            if (!this.editor.getGraphPanel().getCanvas().isRightPressed()) {
                this.editor.getGraphPanel().getCanvas().setLeftPressed(false);
            }
            switch (this.editor.getGraphPanel().getEditMode()) {
                case 113: {
                    this.editor.setMsg("You have just picked the source of an edge. Click on a node to get the target.");
                    break;
                }
                case 11: {
                    this.editor.drawModeProc();
                    AGGAppl.getInstance().setCursor(new Cursor(0));
                    if (this.editor.getGraGraEditor() == null) break;
                    this.editor.getGraGraEditor().setMsg(this.editor.getMsg());
                    break;
                }
                case 13: {
                    AGGAppl.getInstance().setCursor(new Cursor(13));
                    break;
                }
                case 151: {
                    AGGAppl.getInstance().setCursor(new Cursor(1));
                    break;
                }
                case 15: {
                    break;
                }
                default: {
                    AGGAppl.getInstance().setCursor(this.editor.getGraphPanel().getEditCursor());
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

