/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.cpa;

import agg.attribute.AttrType;
import agg.attribute.facade.InformationFacade;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.handler.AttrHandler;
import agg.attribute.impl.ValueTuple;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.gui.cpa.CriticalPairPanel;
import agg.gui.cpa.GraphDesktop;
import agg.gui.parser.PairIOGUI;
import agg.gui.parser.event.CPAEventData;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.gui.saveload.GraphicsExportJPEG;
import agg.parser.CriticalPairEvent;
import agg.parser.ExcludePairContainer;
import agg.parser.PairContainer;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;

public class ConflictsDependenciesGraph
implements ActionListener,
ParserEventListener,
ParserGUIListener {
    PairIOGUI pairIOGUI;
    GraphDesktop graphDesktop;
    ExcludePairContainer conflictCont;
    ExcludePairContainer dependCont;
    GraGra grammar;
    Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> conflicts;
    Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> dependencies;
    Graph cpaGraph;
    EdGraph cpaLayout;
    boolean conflictAction = true;
    boolean hiddenGraphObject = false;
    GraphicsExportJPEG graphJPG;
    final Vector<Arc> visArcs = new Vector();

    public ConflictsDependenciesGraph(ExcludePairContainer conflictsContainer, ExcludePairContainer dependenciesContainer) {
        this.init(conflictsContainer, dependenciesContainer);
    }

    public ConflictsDependenciesGraph(ExcludePairContainer conflictsContainer, ExcludePairContainer dependenciesContainer, EdGraph cpaGraph, boolean loaded) {
        if (cpaGraph == null) {
            this.init(conflictsContainer, dependenciesContainer);
        } else {
            this.reinit(conflictsContainer, dependenciesContainer, cpaGraph, loaded);
        }
    }

    private void init(ExcludePairContainer conflictsContainer, ExcludePairContainer dependenciesContainer) {
        this.conflictCont = conflictsContainer;
        this.dependCont = dependenciesContainer;
        this.initTables();
        this.createGraphs();
        if (this.cpaGraph != null) {
            this.storeVisArcs(this.cpaGraph);
            this.cpaLayout = new EdGraph(this.cpaGraph);
            this.cpaLayout.setCPAgraph(true);
            this.cpaLayout.makeInitialUpdateOfNodes();
            this.layoutGraph(this.cpaLayout);
            if (this.conflictCont != null) {
                this.conflictCont.addPairEventListener(this);
            }
            if (this.dependCont != null) {
                this.dependCont.addPairEventListener(this);
            }
        }
    }

    private void reinit(ExcludePairContainer conflictsContainer, ExcludePairContainer dependenciesContainer, EdGraph cpagraph, boolean loaded) {
        this.conflictCont = conflictsContainer;
        this.dependCont = dependenciesContainer;
        this.cpaLayout = cpagraph;
        this.initTables();
        if (this.cpaLayout != null) {
            if (!loaded) {
                this.updateGraphAlongPairContainer();
            } else {
                this.updatePairsContainerAlongCPAgraph();
            }
            this.cpaLayout.makeInitialUpdateOfNodes();
            this.layoutGraph(this.cpaLayout);
            if (this.conflictCont != null) {
                this.conflictCont.addPairEventListener(this);
            }
            if (this.dependCont != null) {
                this.dependCont.addPairEventListener(this);
            }
        }
    }

    public void dispose() {
        if (this.cpaLayout != null) {
            this.cpaLayout.dispose();
            this.cpaLayout = null;
        }
        if (this.cpaGraph != null) {
            this.cpaGraph.dispose();
            this.cpaGraph = null;
        }
        this.grammar = null;
        this.conflictCont = null;
        this.dependCont = null;
        this.conflicts = null;
        this.dependencies = null;
        this.visArcs.clear();
    }

    public void setGraphDesktop(GraphDesktop desktop) {
        this.graphDesktop = desktop;
    }

    public void setGraphExportJPG(GraphicsExportJPEG jpg) {
        this.graphJPG = jpg;
    }

    public void setConflictPairContainer(PairContainer pc) {
        this.conflictCont = (ExcludePairContainer)pc;
        this.conflicts = this.conflictCont.getExcludeContainer();
        if (this.grammar == null) {
            this.grammar = this.conflictCont.getGrammar();
        }
    }

    public void setDependencyPairContainer(PairContainer pc) {
        this.dependCont = (ExcludePairContainer)pc;
        this.dependencies = this.dependCont.getExcludeContainer();
        if (this.grammar == null) {
            this.grammar = this.dependCont.getGrammar();
        }
    }

    @Override
    public void parserEventOccured(ParserEvent p) {
        if (p instanceof CriticalPairEvent && p.getSource() instanceof ExcludePairContainer) {
            if (((ExcludePairContainer)p.getSource()).isAlive() || this.cpaLayout == null) {
                return;
            }
            Rule r1 = ((CriticalPairEvent)p).getFirstRule();
            Rule r2 = ((CriticalPairEvent)p).getSecondRule();
            if (((ExcludePairContainer)p.getSource()).getKindOfConflict() == 0) {
                if (this.conflictCont != p.getSource()) {
                    return;
                }
                if (((CriticalPairEvent)p).getKey() == 71) {
                    this.updateGraphAlongPairContainer();
                    if (this.graphDesktop != null) {
                        this.graphDesktop.refreshCPAGraph();
                    }
                    return;
                }
                ExcludePairContainer.Entry entry = ((ExcludePairContainer)p.getSource()).getEntry(r1, r2);
                if (entry.getState() == 3 || entry.getState() == 31 || entry.getState() == 32) {
                    Node n2;
                    Node n1 = this.getNode(this.cpaLayout.getBasisGraph(), r1);
                    if (n1 == null) {
                        this.createLayoutNode(this.cpaLayout, "Rule", r1);
                    }
                    if ((n2 = this.getNode(this.cpaLayout.getBasisGraph(), r2)) == null) {
                        this.createLayoutNode(this.cpaLayout, "Rule", r2);
                    }
                    if (entry.isCritical()) {
                        this.createLayoutEdge(this.cpaLayout, "c", r1, r2);
                    }
                    this.cpaLayout.update();
                    this.cpaLayout.setTransformChangeEnabled(false);
                    if (this.graphDesktop != null) {
                        this.graphDesktop.refreshCPAGraph();
                    }
                }
                if (((CriticalPairEvent)p).getKey() == 3) {
                    this.showEdge(this.cpaLayout.getBasisGraph(), "c", r1, r2);
                    if (this.cpaLayout != null) {
                        this.cpaLayout.update();
                        if (this.graphDesktop != null) {
                            this.graphDesktop.refreshCPAGraph();
                        }
                    }
                }
            } else {
                if (this.dependCont != p.getSource()) {
                    return;
                }
                if (((CriticalPairEvent)p).getKey() == 71) {
                    this.updateGraphAlongPairContainer();
                    if (this.graphDesktop != null) {
                        this.graphDesktop.refreshCPAGraph();
                    }
                    return;
                }
                ExcludePairContainer.Entry entry = ((ExcludePairContainer)p.getSource()).getEntry(r1, r2);
                if (entry.getState() == 3 || entry.getState() == 31 || entry.getState() == 32) {
                    Node n2;
                    Node n1 = this.getNode(this.cpaLayout.getBasisGraph(), r1);
                    if (n1 == null) {
                        this.createLayoutNode(this.cpaLayout, "Rule", r1);
                    }
                    if ((n2 = this.getNode(this.cpaLayout.getBasisGraph(), r2)) == null) {
                        this.createLayoutNode(this.cpaLayout, "Rule", r2);
                    }
                    if (entry.isCritical()) {
                        this.createLayoutEdge(this.cpaLayout, "d", r1, r2);
                    }
                    this.cpaLayout.update();
                    this.cpaLayout.setTransformChangeEnabled(false);
                    if (this.graphDesktop != null) {
                        this.graphDesktop.refreshCPAGraph();
                    }
                }
                if (((CriticalPairEvent)p).getKey() == 3) {
                    this.showEdge(this.cpaLayout.getBasisGraph(), "d", r1, r2);
                    if (this.cpaLayout != null) {
                        this.cpaLayout.update();
                        if (this.graphDesktop != null) {
                            this.graphDesktop.refreshCPAGraph();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void occured(ParserGUIEvent e) {
        if (e.getSource() instanceof CriticalPairPanel) {
            if (e.getData() instanceof CPAEventData) {
                if (((CriticalPairPanel)e.getSource()).getKindOfPairContainer() == 0) {
                    this.conflictAction = true;
                } else if (((CriticalPairPanel)e.getSource()).getKindOfPairContainer() == 1 || ((CriticalPairPanel)e.getSource()).getKindOfPairContainer() == 2) {
                    this.conflictAction = false;
                }
                CPAEventData d = (CPAEventData)e.getData();
                int kind = d.kind;
                Rule r1 = d.r1;
                Rule r2 = null;
                String t = "";
                boolean vis = d.visible;
                if (kind == CPAEventData.SHOW_RULE) {
                    t = "Rule";
                }
                if (kind == CPAEventData.SHOW_RELATION || kind == CPAEventData.HIDE_RELATION) {
                    r2 = d.r2;
                    t = d.type;
                }
                if (this.cpaLayout != null) {
                    if (!vis) {
                        if (kind == CPAEventData.SHOW_RULE) {
                            this.hideNode(this.cpaLayout.getBasisGraph(), r1, false);
                        } else if (kind == CPAEventData.SHOW_RELATION && t.equals("C")) {
                            this.hideEdge(this.cpaLayout.getBasisGraph(), "c", r1, r2);
                        } else if (kind == CPAEventData.SHOW_RELATION && t.equals("D")) {
                            this.hideEdge(this.cpaLayout.getBasisGraph(), "d", r1, r2);
                        }
                        this.cpaLayout.update();
                        if (this.graphDesktop != null) {
                            this.graphDesktop.refresh();
                        }
                    } else {
                        if (kind == CPAEventData.SHOW_RULE) {
                            this.showNode(this.cpaLayout.getBasisGraph(), t, r1, false);
                        } else if (kind == CPAEventData.SHOW_RELATION && t.equals("C")) {
                            this.showEdge(this.cpaLayout.getBasisGraph(), "c", r1, r2);
                        } else if (kind == CPAEventData.SHOW_RELATION && t.equals("D")) {
                            this.showEdge(this.cpaLayout.getBasisGraph(), "d", r1, r2);
                        }
                        this.cpaLayout.update();
                        if (this.graphDesktop != null) {
                            this.graphDesktop.refresh();
                        }
                    }
                    if (kind == CPAEventData.HIDE_RELATION) {
                        this.cpaLayout.enableStaticNodePosition();
                        try {
                            this.cpaLayout.deleteObj(this.cpaLayout.findArc(this.getEdge(this.cpaLayout.getBasisGraph(), t.toLowerCase(), r1, r2)), true);
                        }
                        catch (TypeException ex) {
                            System.out.println(ex.getLocalizedMessage());
                        }
                        this.cpaLayout.disableStaticNodePosition();
                    }
                }
            } else if (e.getData() instanceof CriticalPairEvent) {
                Rule r1 = ((CriticalPairEvent)e.getData()).getFirstRule();
                Rule r2 = ((CriticalPairEvent)e.getData()).getSecondRule();
                if (((CriticalPairPanel)e.getSource()).getKindOfPairContainer() == 0) {
                    if (((CriticalPairEvent)e.getData()).getKey() == 6) {
                        this.removeLayoutEdge(this.cpaLayout, "c", r1, r2);
                    }
                } else if (((CriticalPairEvent)e.getData()).getKey() == 6) {
                    this.removeLayoutEdge(this.cpaLayout, "d", r1, r2);
                }
            }
        }
    }

    public void updatePairsContainerAlongCPAgraph() {
        if (this.cpaLayout == null) {
            return;
        }
        if (this.conflictCont != null) {
            this.updatePairsContainerAlongCPAgraph(this.conflictCont);
        }
        if (this.dependCont != null) {
            this.updatePairsContainerAlongCPAgraph(this.dependCont);
        }
    }

    private void updatePairsContainerAlongCPAgraph(PairContainer pc) {
        if (this.cpaLayout == null || pc == null) {
            return;
        }
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> container = ((ExcludePairContainer)pc).getExcludeContainer();
        Enumeration<Rule> keys = container.keys();
        while (keys.hasMoreElements()) {
            Rule r1 = keys.nextElement();
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = container.get(r1);
            Enumeration<Rule> k2 = secondPart.keys();
            block1: while (k2.hasMoreElements()) {
                Object val;
                Node n;
                Vector<EdNode> elems;
                Rule r2 = k2.nextElement();
                ExcludePairContainer.Entry entry = ((ExcludePairContainer)pc).getEntry(r1, r2);
                if (entry.isCritical()) {
                    Arc a;
                    if (r1 == r2) {
                        elems = this.cpaLayout.getNodes();
                        int i = 0;
                        while (i < elems.size()) {
                            n = elems.get(i).getBasisNode();
                            val = n.getAttribute().getValueAt("name");
                            if (val != null && ((String)val).equals(r1.getQualifiedName())) {
                                ((ExcludePairContainer)pc).setEntryRuleVisible(r1, r2, n.isVisible(), true, false);
                                break;
                            }
                            ++i;
                        }
                    }
                    String tn = "c";
                    if (pc.getKindOfConflict() == 1 || pc.getKindOfConflict() == 2) {
                        tn = "d";
                    }
                    if ((a = this.getArc(this.cpaLayout, tn, r1, r2)) == null) continue;
                    if (r1 == r2) {
                        ((ExcludePairContainer)pc).setEntryRelationVisible(r1, r2, a.isVisible(), true);
                        continue;
                    }
                    ExcludePairContainer.Entry entry2 = ((ExcludePairContainer)pc).getEntry(r2, r1);
                    if (entry2.isCritical()) {
                        Arc a2 = this.getArc(this.cpaLayout, tn, r2, r1);
                        if (a2 == null) continue;
                        if (!a.isVisible() && !a2.isVisible()) {
                            ((ExcludePairContainer)pc).setEntryRelationVisible(r1, r2, false, true);
                            ((ExcludePairContainer)pc).setEntryRelationVisible(r2, r1, false, true);
                            continue;
                        }
                        if (!a2.isDirected() && !a2.isVisible() && a.isDirected() && a.isVisible()) {
                            ((ExcludePairContainer)pc).setEntryRelationVisible(r2, r1, false, true);
                            continue;
                        }
                        if (!a.isDirected() && !a.isVisible() && a2.isDirected() && a2.isVisible()) {
                            ((ExcludePairContainer)pc).setEntryRelationVisible(r1, r2, false, true);
                            continue;
                        }
                        if (a2.isDirected() && !a2.isVisible() && !a.isDirected() && a.isVisible()) {
                            if (this.visArcs.contains(a2)) continue;
                            this.visArcs.add(a2);
                            continue;
                        }
                        if (!a.isDirected() || a.isVisible() || a2.isDirected() || !a2.isVisible() || this.visArcs.contains(a)) continue;
                        this.visArcs.add(a);
                        continue;
                    }
                    ((ExcludePairContainer)pc).setEntryRelationVisible(r1, r2, a.isVisible(), true);
                    continue;
                }
                if (r1 != r2) continue;
                elems = this.cpaLayout.getNodes();
                int i = 0;
                while (i < elems.size()) {
                    n = elems.get(i).getBasisNode();
                    val = n.getAttribute().getValueAt("name");
                    if (val != null && ((String)val).equals(r1.getQualifiedName())) {
                        ((ExcludePairContainer)pc).setEntryRuleVisible(r1, r2, n.isVisible(), true, false);
                        continue block1;
                    }
                    ++i;
                }
            }
        }
    }

    private void updatePairsContainerAllVisibile(PairContainer pc) {
        if (this.cpaLayout == null || pc == null) {
            return;
        }
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> container = ((ExcludePairContainer)pc).getExcludeContainer();
        Enumeration<Rule> keys = container.keys();
        while (keys.hasMoreElements()) {
            Rule r1 = keys.nextElement();
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = container.get(r1);
            Enumeration<Rule> k2 = secondPart.keys();
            block1: while (k2.hasMoreElements()) {
                Object val;
                Node n;
                Vector<EdNode> elems;
                Rule r2 = k2.nextElement();
                ExcludePairContainer.Entry entry = ((ExcludePairContainer)pc).getEntry(r1, r2);
                if (entry.isCritical()) {
                    Arc a;
                    elems = this.cpaLayout.getNodes();
                    int i = 0;
                    while (i < elems.size()) {
                        n = elems.get(i).getBasisNode();
                        val = n.getAttribute().getValueAt("name");
                        if (val != null && ((String)val).equals(r1.getQualifiedName())) {
                            n.setVisible(true);
                            ((ExcludePairContainer)pc).setEntryRuleVisible(r1, r2, true, true, false);
                            break;
                        }
                        ++i;
                    }
                    String tn = "c";
                    if (pc.getKindOfConflict() == 1 || pc.getKindOfConflict() == 2) {
                        tn = "d";
                    }
                    if ((a = this.getArc(this.cpaLayout, tn, r1, r2)) == null) continue;
                    if (!a.isVisible() && !this.visArcs.contains(a)) {
                        a.setVisible(true);
                    }
                    ((ExcludePairContainer)pc).setEntryRelationVisible(r1, r2, true, true);
                    continue;
                }
                if (r1 != r2) continue;
                elems = this.cpaLayout.getNodes();
                int i = 0;
                while (i < elems.size()) {
                    n = elems.get(i).getBasisNode();
                    val = n.getAttribute().getValueAt("name");
                    if (val != null && ((String)val).equals(r1.getQualifiedName())) {
                        n.setVisible(true);
                        ((ExcludePairContainer)pc).setEntryRuleVisible(r1, r2, true, true, false);
                        continue block1;
                    }
                    ++i;
                }
            }
        }
    }

    private Arc getArc(EdGraph g, String tn, Rule r1, Rule r2) {
        Vector<EdArc> elems = g.getArcs();
        Arc a = null;
        int i = 0;
        while (i < elems.size()) {
            a = elems.get(i).getBasisArc();
            if (a.getType().getName().equals(tn)) {
                Object src = a.getSource().getAttribute().getValueAt("name");
                Object tar = a.getTarget().getAttribute().getValueAt("name");
                if (src != null && ((String)src).equals(r1.getQualifiedName()) && tar != null && ((String)tar).equals(r2.getQualifiedName())) {
                    return a;
                }
            }
            ++i;
        }
        return null;
    }

    public void updateGraphAlongPairContainer() {
        if (this.conflictCont != null && this.dependCont != null && this.conflictCont.isEmpty() && this.dependCont.isEmpty()) {
            this.visArcs.clear();
            try {
                this.cpaLayout.deleteAll();
            }
            catch (TypeException typeException) {}
        } else {
            if (this.conflictCont != null) {
                this.updateGraphAlongPairContainer(this.cpaLayout, this.conflictCont, this.conflicts, "c");
            }
            if (this.dependCont != null) {
                this.updateGraphAlongPairContainer(this.cpaLayout, this.dependCont, this.dependencies, "d");
            }
        }
    }

    private void updateGraphAlongPairContainer(EdGraph g, PairContainer pc, Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> table1, String tn) {
        Arc a;
        Iterator<Arc> e;
        if (g == null || pc == null || table1 == null) {
            return;
        }
        if (table1.isEmpty()) {
            e = g.getBasisGraph().getArcsSet().iterator();
            while (e.hasNext()) {
                a = e.next();
                if (!a.getType().getName().equals(tn)) continue;
                try {
                    this.visArcs.remove(a);
                    g.delArc(a);
                    e = g.getBasisGraph().getArcsSet().iterator();
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
        } else {
            e = g.getBasisGraph().getArcsSet().iterator();
            while (e.hasNext()) {
                ExcludePairContainer.Entry entry;
                a = e.next();
                if (!a.getType().getName().equals(tn)) continue;
                Rule r1 = this.getRule((Node)a.getSource());
                Rule r2 = this.getRule((Node)a.getTarget());
                if (r1 == null || r2 == null || (entry = ((ExcludePairContainer)pc).getEntry(r1, r2)) != null && entry.getState() != 0) continue;
                try {
                    this.visArcs.remove(a);
                    g.delArc(a);
                    e = g.getBasisGraph().getArcsSet().iterator();
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
        }
        Enumeration<Rule> keys1 = table1.keys();
        while (keys1.hasMoreElements()) {
            Rule r1 = keys1.nextElement();
            Node n1 = this.getNode(g.getBasisGraph(), r1);
            if (n1 == null) {
                n1 = this.createNode(g.getBasisGraph(), "Rule", r1);
            }
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> table2 = table1.get(r1);
            Enumeration<Rule> keys2 = table2.keys();
            while (keys2.hasMoreElements()) {
                Rule r2 = keys2.nextElement();
                Node n2 = this.getNode(g.getBasisGraph(), r2);
                if (n2 == null) {
                    n2 = this.createNode(g.getBasisGraph(), "Rule", r2);
                }
                ExcludePairContainer.Entry entry = ((ExcludePairContainer)pc).getEntry(r1, r2);
                if (r1 == r2) {
                    n1.setVisible(entry.isRuleVisible());
                }
                if (!entry.isCritical()) continue;
                Arc a2 = this.getArc(g, tn, r1, r2);
                if (a2 != null) {
                    if (r1 == r2) {
                        a2.setVisible(entry.isRelationVisible() && a2.isVisible() && !this.visArcs.contains(a2));
                        continue;
                    }
                    ExcludePairContainer.Entry entry2 = ((ExcludePairContainer)pc).getEntry(r2, r1);
                    if (!entry2.isCritical()) continue;
                    Arc a22 = this.getArc(g, tn, r2, r1);
                    if (a22 != null) {
                        if (entry.isRelationVisible() && entry2.isRelationVisible()) continue;
                        if (!entry.isRelationVisible() && !entry2.isRelationVisible()) {
                            a2.setVisible(false);
                            a22.setVisible(false);
                            continue;
                        }
                        if (entry.isRelationVisible()) {
                            a2.setDirected(true);
                            a22.setVisible(false);
                            if (!a22.isDirected()) continue;
                            a22.setDirected(false);
                            continue;
                        }
                        if (!entry2.isRelationVisible()) continue;
                        a22.setDirected(true);
                        a2.setVisible(false);
                        if (!a2.isDirected()) continue;
                        a2.setDirected(false);
                        continue;
                    }
                    a22 = this.createEdge(this.cpaLayout.getBasisGraph(), tn, r2, r1);
                    continue;
                }
                a2 = this.createEdge(g.getBasisGraph(), tn, r1, r2);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JMenuItem) {
            if (((JMenuItem)source).getText().equals("Show Conflicts")) {
                if (this.conflictCont != null) {
                    this.updatePairsContainerAllVisibile(this.conflictCont);
                }
                this.setEdgeVisible(this.cpaLayout.getBasisGraph(), "c", true);
                this.setEdgeVisible(this.cpaLayout.getBasisGraph(), "d", false);
                if (this.graphDesktop != null) {
                    this.graphDesktop.doClickShowAllConflicts();
                    this.graphDesktop.doClickShowAllDepends();
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Show Dependencies")) {
                if (this.dependCont != null) {
                    this.updatePairsContainerAllVisibile(this.dependCont);
                }
                this.setEdgeVisible(this.cpaLayout.getBasisGraph(), "d", true);
                this.setEdgeVisible(this.cpaLayout.getBasisGraph(), "c", false);
                if (this.graphDesktop != null) {
                    this.graphDesktop.doClickShowAllConflicts();
                    this.graphDesktop.doClickShowAllDepends();
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Show All")) {
                if (this.conflictCont != null) {
                    this.updatePairsContainerAllVisibile(this.conflictCont);
                }
                if (this.dependCont != null) {
                    this.updatePairsContainerAllVisibile(this.dependCont);
                }
                if (this.hiddenGraphObject) {
                    this.setAllVisible(this.cpaLayout.getBasisGraph());
                    this.hiddenGraphObject = false;
                } else {
                    this.setEdgeVisible(this.cpaLayout.getBasisGraph(), "c", true);
                    this.setEdgeVisible(this.cpaLayout.getBasisGraph(), "d", true);
                }
                if (this.graphDesktop != null) {
                    this.graphDesktop.doClickShowAllConflicts();
                    this.graphDesktop.doClickShowAllDepends();
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Refresh")) {
                if (this.conflictCont != null) {
                    this.updatePairsContainerAllVisibile(this.conflictCont);
                }
                if (this.dependCont != null) {
                    this.updatePairsContainerAllVisibile(this.dependCont);
                }
                this.setAllVisible(this.cpaGraph);
                this.updateGraphAlongPairContainer();
                this.cpaLayout.makeGraphObjectsOfNewBasisObjects(false);
                this.cpaLayout.setTransformChangeEnabled(true);
                this.cpaLayout.updateGraph();
                this.cpaLayout.setTransformChangeEnabled(false);
                if (this.graphDesktop != null) {
                    this.graphDesktop.doClickShowAllConflicts();
                    this.graphDesktop.doClickShowAllDepends();
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Hide Node/Edge")) {
                this.hideGraphObject(this.cpaLayout.getPicked());
                if (this.graphDesktop != null) {
                    this.graphDesktop.doClickShowAllConflicts();
                    this.graphDesktop.doClickShowAllDepends();
                    this.updatePairsContainerAlongCPAgraph();
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Straight Edges")) {
                this.straightEdges(this.cpaLayout);
                if (this.graphDesktop != null) {
                    this.graphDesktop.doClickShowAllConflicts();
                    this.graphDesktop.doClickShowAllDepends();
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Solid Line")) {
                if (((JMenuItem)source).getActionCommand().indexOf("Conflict") != -1) {
                    this.changeStyleOfEdges(this.cpaLayout, "c", 61);
                } else if (((JMenuItem)source).getActionCommand().indexOf("Dependency") != -1) {
                    this.changeStyleOfEdges(this.cpaLayout, "d", 61);
                }
                if (this.graphDesktop != null) {
                    this.graphDesktop.doClickShowAllConflicts();
                    this.graphDesktop.doClickShowAllDepends();
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Dot Line")) {
                if (((JMenuItem)source).getActionCommand().indexOf("Conflict") != -1) {
                    this.changeStyleOfEdges(this.cpaLayout, "c", 63);
                } else if (((JMenuItem)source).getActionCommand().indexOf("Dependency") != -1) {
                    this.changeStyleOfEdges(this.cpaLayout, "d", 63);
                }
                if (this.graphDesktop != null) {
                    this.graphDesktop.doClickShowAllConflicts();
                    this.graphDesktop.doClickShowAllDepends();
                    this.graphDesktop.refresh();
                }
            } else if (((JMenuItem)source).getText().equals("Dash Line")) {
                if (((JMenuItem)source).getActionCommand().indexOf("Conflict") != -1) {
                    this.changeStyleOfEdges(this.cpaLayout, "c", 62);
                } else if (((JMenuItem)source).getActionCommand().indexOf("Dependency") != -1) {
                    this.changeStyleOfEdges(this.cpaLayout, "d", 62);
                }
                if (this.graphDesktop != null) {
                    this.graphDesktop.doClickShowAllConflicts();
                    this.graphDesktop.doClickShowAllDepends();
                    this.graphDesktop.refresh();
                }
            } else if (!((JMenuItem)source).getText().equals("Export JPEG") && ((JMenuItem)source).getText().equals("Layout Graph")) {
                if (this.graphDesktop != null) {
                    this.makeLayout(this.cpaLayout, this.graphDesktop.getInternalCPAGraphFrame().getSize());
                    this.graphDesktop.doClickShowAllConflicts();
                    this.graphDesktop.doClickShowAllDepends();
                    this.graphDesktop.refresh();
                } else {
                    this.makeLayout(this.cpaLayout);
                }
            }
        }
    }

    public EdGraph getGraph() {
        if (this.cpaLayout != null) {
            return this.cpaLayout;
        }
        return null;
    }

    public ExcludePairContainer getConflictsContainer() {
        return this.conflictCont;
    }

    public ExcludePairContainer getDependenciesContainer() {
        return this.dependCont;
    }

    private void setEdgeVisible(Graph g, String tn, boolean vis) {
        Type t = g.getTypeSet().getTypeByName(tn);
        if (t == null) {
            return;
        }
        for (Arc a : g.getArcsSet()) {
            if (!a.getSource().isVisible() || !a.getTarget().isVisible() || !a.getType().getName().equals(t.getName())) continue;
            if (a.getSource() == a.getTarget()) {
                a.setVisible(vis);
                continue;
            }
            if (vis) {
                a.setVisible(vis);
                Arc a1 = this.getEdge(g, t, (Node)a.getTarget(), (Node)a.getSource());
                if (a1 == null) continue;
                if (a1.isDirected()) {
                    a1.setVisible(false);
                    continue;
                }
                a1.setVisible(true);
                a.setVisible(false);
                continue;
            }
            a.setVisible(vis);
        }
    }

    private void setNodeVisible(Graph g) {
        for (GraphObject graphObject : g.getNodesSet()) {
            graphObject.setVisible(true);
        }
    }

    private void setAllVisible(Graph g) {
        this.cpaLayout.deselectAll();
        this.setNodeVisible(g);
        this.setEdgeVisible(g, "c", true);
        this.setEdgeVisible(g, "d", true);
    }

    private void initTables() {
        if (this.conflictCont != null) {
            this.conflicts = this.conflictCont.getExcludeContainer();
            this.grammar = this.conflictCont.getGrammar();
        }
        if (this.dependCont != null) {
            this.dependencies = this.dependCont.getExcludeContainer();
            if (this.grammar == null) {
                this.grammar = this.dependCont.getGrammar();
            }
        }
    }

    private void createGraphs() {
        if (this.conflicts == null && this.dependencies == null) {
            return;
        }
        Hashtable<String, Node> local = new Hashtable<String, Node>();
        TypeSet types = null;
        if (this.conflicts != null || this.dependencies != null) {
            this.cpaGraph = new Graph();
            this.cpaGraph.setName("CPA_RuleGraph:Conflicts_(red)-Dependencies_(blue)");
            types = this.cpaGraph.getTypeSet();
        }
        if (types != null) {
            boolean rel;
            Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p;
            Node nr2;
            Node nr1;
            ExcludePairContainer.Entry entry;
            Rule r2;
            Enumeration<Rule> keys2;
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> table;
            Rule r1;
            Enumeration<Rule> keys1;
            Type nodeType = types.createNodeType(true);
            Type arcTypeConflict = types.createArcType(false);
            Type arcTypeDepend = types.createArcType(false);
            nodeType.setStringRepr("Rule");
            nodeType.setAdditionalRepr("[NODE]");
            arcTypeConflict.setStringRepr("c");
            arcTypeConflict.setAdditionalRepr(":SOLID_LINE:java.awt.Color[r=255,g=0,b=0]::[EDGE]:");
            arcTypeDepend.setStringRepr("d");
            arcTypeDepend.setAdditionalRepr(":DOT_LINE:java.awt.Color[r=0,g=0,b=255]::[EDGE]:");
            InformationFacade info = DefaultInformationFacade.self();
            AttrHandler javaHandler = info.getJavaHandler();
            AttrType attrType = nodeType.getAttrType();
            attrType.addMember(javaHandler, "String", "name");
            if (this.conflicts != null) {
                keys1 = this.conflicts.keys();
                while (keys1.hasMoreElements()) {
                    r1 = keys1.nextElement();
                    if (!r1.isEnabled()) continue;
                    table = this.conflicts.get(r1);
                    keys2 = table.keys();
                    while (keys2.hasMoreElements()) {
                        r2 = keys2.nextElement();
                        if (!r2.isEnabled()) continue;
                        entry = this.conflictCont.getEntry(r1, r2);
                        nr1 = (Node)local.get(r1.getQualifiedName());
                        if (nr1 == null) {
                            nr1 = this.createNode(this.cpaGraph, nodeType, r1);
                            local.put(r1.getQualifiedName(), nr1);
                            if (r1 == r2) {
                                nr1.setVisible(entry.isRuleVisible());
                            }
                        }
                        if ((nr2 = (Node)local.get(r2.getQualifiedName())) == null) {
                            nr2 = this.createNode(this.cpaGraph, nodeType, r2);
                            local.put(r2.getQualifiedName(), nr2);
                        }
                        p = table.get(r2);
                        rel = (Boolean)p.first;
                        if (!rel) continue;
                        this.createEdge(this.cpaGraph, arcTypeConflict, nr1, nr2);
                    }
                }
            }
            if (this.dependencies != null) {
                local.clear();
                keys1 = this.dependencies.keys();
                while (keys1.hasMoreElements()) {
                    r1 = keys1.nextElement();
                    if (!r1.isEnabled()) continue;
                    table = this.dependencies.get(r1);
                    keys2 = table.keys();
                    while (keys2.hasMoreElements()) {
                        r2 = keys2.nextElement();
                        if (!r2.isEnabled()) continue;
                        entry = this.dependCont.getEntry(r1, r2);
                        nr1 = (Node)local.get(r1.getQualifiedName());
                        if (nr1 == null) {
                            nr1 = this.createNode(this.cpaGraph, nodeType, r1);
                            local.put(r1.getQualifiedName(), nr1);
                            if (r1 == r2) {
                                nr1.setVisible(entry.isRuleVisible());
                            }
                        }
                        if ((nr2 = (Node)local.get(r2.getQualifiedName())) == null) {
                            nr2 = this.createNode(this.cpaGraph, nodeType, r2);
                            local.put(r2.getQualifiedName(), nr2);
                        }
                        p = table.get(r2);
                        rel = (Boolean)p.first;
                        if (!rel) continue;
                        this.createEdge(this.cpaGraph, arcTypeDepend, nr1, nr2);
                    }
                }
            }
            local.clear();
            local = null;
        }
    }

    private void replaceBidirectedEdgesByUndirectedEdge(EdGraph eg) {
        Enumeration<EdArc> e = eg.getArcs().elements();
        block0: while (e.hasMoreElements()) {
            EdArc a = e.nextElement();
            if (a.getSource() == a.getTarget() || !a.getBasisArc().isDirected()) continue;
            Enumeration<EdArc> e1 = eg.getArcs().elements();
            while (e1.hasMoreElements()) {
                EdArc a1 = e1.nextElement();
                if (a1.getSource() == a1.getTarget() || !a1.getBasisArc().isDirected() || a == a1 || !a.getType().getName().equals(a1.getType().getName()) || a.getSource() != a1.getTarget() || a.getTarget() != a1.getSource()) continue;
                a.getBasisArc().setVisible(false);
                a1.getBasisArc().setDirected(false);
                continue block0;
            }
        }
    }

    private void layoutGraph(EdGraph eg) {
        this.replaceBidirectedEdgesByUndirectedEdge(eg);
        if (!eg.hasDefaultLayout()) {
            this.makeLayout(eg);
        }
    }

    private void storeVisArcs(Graph g) {
        this.visArcs.clear();
        for (Arc a : g.getArcsSet()) {
            Arc a1;
            if (a.isDirected() || !a.isVisible() || (a1 = this.getEdge(g, a.getType(), (Node)a.getTarget(), (Node)a.getSource())) == null || this.visArcs.contains(a1)) continue;
            this.visArcs.add(a1);
        }
    }

    private Node showNode(Graph g, String tn, Rule r, boolean changePairContainer) {
        Type t = g.getTypeSet().getTypeByName(tn);
        if (t == null) {
            return null;
        }
        return this.showNode(g, t, r, changePairContainer);
    }

    private Node showNode(Graph g, Type t, Rule r, boolean changePairContainer) {
        Node n = this.getNode(g, r);
        if (n != null && !n.isVisible()) {
            n.setVisible(true);
        }
        return n;
    }

    private Node createNode(Graph g, Type t, Rule r) {
        Node n = this.getNode(g, r);
        if (n == null) {
            try {
                n = g.createNode(t);
                ValueTuple vt = (ValueTuple)n.getAttribute();
                String rname = r.getQualifiedName();
                vt.getValueMemberAt("name").setExprAsObject(rname);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return n;
    }

    private Node createNode(Graph g, String tn, Rule r) {
        Type t = g.getTypeSet().getTypeByName(tn);
        return this.createNode(g, t, r);
    }

    private void createLayoutNode(EdGraph g, String tn, Rule r) {
        Type t = g.getBasisGraph().getTypeSet().getTypeByName(tn);
        Node n = this.createNode(g.getBasisGraph(), t, r);
        EdType et = g.getTypeSet().getNodeType(t);
        if (n != null && g.findNode(n) == null) {
            g.addNode(n, et);
        }
    }

    private Node getNode(Graph g, Rule r) {
        for (Node n : g.getNodesSet()) {
            if (!((String)n.getAttribute().getValueAt("name")).equals(r.getQualifiedName())) continue;
            return n;
        }
        return null;
    }

    private void hideNode(Graph g, Rule r, boolean changePairContainer) {
        Node n;
        if (this.conflictCont != null && this.dependCont != null) {
            ExcludePairContainer.Entry entryCC = this.conflictCont.getEntry(r, r);
            ExcludePairContainer.Entry entryDC = this.dependCont.getEntry(r, r);
            if (this.conflictAction ? (entryDC.getState() == 3 || entryDC.getState() == 31 || entryDC.getState() == 32) && entryDC.isRuleVisible() : entryCC.getState() == 3 && entryCC.isRuleVisible()) {
                return;
            }
        }
        if ((n = this.getNode(g, r)) != null && n.isVisible()) {
            n.setVisible(false);
        }
    }

    private Arc showEdge(Graph g, String tn, Rule r1, Rule r2) {
        Type t = g.getTypeSet().getTypeByName(tn);
        if (t == null) {
            return null;
        }
        Node n1 = this.getNode(g, r1);
        Node n2 = this.getNode(g, r2);
        return this.showEdge(g, t, n1, n2);
    }

    private Arc showEdge(Graph g, Type t, Node n1, Node n2) {
        if (t == null || n1 == null || n2 == null) {
            return null;
        }
        Arc a = this.getEdge(g, t, n1, n2);
        if (a != null) {
            a.setVisible(true);
            a.setDirected(true);
            if (a.getSource() == a.getTarget()) {
                return a;
            }
            Arc a1 = this.getEdge(g, t, n2, n1);
            if (a1 != null) {
                if (a1.isVisible()) {
                    a1.setVisible(false);
                    if (!this.visArcs.contains(a1)) {
                        this.visArcs.add(a1);
                    }
                    a.setDirected(false);
                } else if (this.visArcs.contains(a1)) {
                    a.setDirected(false);
                } else if (this.visArcs.contains(a)) {
                    this.visArcs.remove(a);
                }
            }
        }
        return a;
    }

    private Arc createEdge(Graph g, Type t, Node n1, Node n2) {
        if (t == null || n1 == null || n2 == null) {
            return null;
        }
        Arc a = this.getEdge(g, t, n1, n2);
        if (a == null) {
            try {
                Arc a1;
                a = g.createArc(t, n1, n2);
                if (n1 != n2 && (a1 = this.getEdge(g, t, n2, n1)) != null) {
                    a.setDirected(false);
                    a1.setVisible(false);
                    if (!this.visArcs.contains(a1)) {
                        this.visArcs.add(a1);
                    }
                }
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return a;
    }

    private Arc createEdge(Graph g, Type t, Rule r1, Rule r2) {
        if (t == null || r1 == null || r2 == null) {
            return null;
        }
        Node n1 = this.getNode(g, r1);
        Node n2 = this.getNode(g, r2);
        return this.createEdge(g, t, n1, n2);
    }

    private Arc createEdge(Graph g, String tn, Rule r1, Rule r2) {
        Type t = g.getTypeSet().getTypeByName(tn);
        return this.createEdge(g, t, r1, r2);
    }

    private void createLayoutEdge(EdGraph g, String tn, Rule r1, Rule r2) {
        Type t = g.getBasisGraph().getTypeSet().getTypeByName(tn);
        Arc a = this.createEdge(g.getBasisGraph(), t, r1, r2);
        EdType et = g.getTypeSet().getArcType(t);
        if (a != null && g.findArc(a) == null) {
            try {
                g.addArc(a, et);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
    }

    private Arc getEdge(Graph g, String tn, Rule r1, Rule r2) {
        Type t = g.getTypeSet().getTypeByName(tn);
        Node n1 = this.getNode(g, r1);
        Node n2 = this.getNode(g, r2);
        return this.getEdge(g, t, n1, n2);
    }

    private void removeEdge(Graph g, String tn, Rule r1, Rule r2) {
        Type t = g.getTypeSet().getTypeByName(tn);
        Arc a = this.getEdge(g, t, r1, r2);
        if (this.visArcs.contains(a)) {
            this.visArcs.remove(a);
        }
        if (a != null) {
            try {
                g.destroyArc(a, true, false);
                Arc a1 = this.getEdge(g, t, r2, r1);
                if (a1 != null && !a1.isVisible()) {
                    a1.setVisible(true);
                    a1.setDirected(true);
                    this.visArcs.add(a1);
                }
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
    }

    private void removeLayoutEdge(EdGraph g, String tn, Rule r1, Rule r2) {
        Type t = g.getBasisGraph().getTypeSet().getTypeByName(tn);
        Arc a = this.getEdge(g.getBasisGraph(), t, r1, r2);
        if (a != null) {
            if (this.visArcs.contains(a)) {
                this.visArcs.remove(a);
            }
            try {
                g.delArc(a);
                Arc a1 = this.getEdge(g.getBasisGraph(), t, r2, r1);
                if (a1 != null) {
                    if (!a1.isVisible()) {
                        a1.setVisible(true);
                        a1.setDirected(true);
                        this.visArcs.remove(a1);
                        EdType et = g.getTypeSet().getArcType(t);
                        if (g.findArc(a1) == null) {
                            g.addArc(a1, et);
                        }
                    } else {
                        a1.setDirected(true);
                        EdType et = g.getTypeSet().getArcType(t);
                        if (g.findArc(a1) == null) {
                            g.addArc(a1, et);
                        }
                    }
                }
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
    }

    private Arc getEdge(Graph g, Type t, Rule r1, Rule r2) {
        Node n1 = this.getNode(g, r1);
        Node n2 = this.getNode(g, r2);
        return this.getEdge(g, t, n1, n2);
    }

    private Arc getEdge(Graph g, Type t, Node n1, Node n2) {
        if (t == null || n1 == null || n2 == null) {
            return null;
        }
        for (Arc a : g.getArcsSet()) {
            if (!a.getType().getName().equals(t.getName())) continue;
            Object src = a.getSource().getAttribute().getValueAt("name");
            Object tar = a.getTarget().getAttribute().getValueAt("name");
            Object name1 = n1.getAttribute().getValueAt("name");
            Object name2 = n2.getAttribute().getValueAt("name");
            if (src == null || !((String)src).equals(name1) || tar == null || !((String)tar).equals(name2)) continue;
            return a;
        }
        return null;
    }

    private boolean hideEdge(Graph g, String tn, Rule r1, Rule r2) {
        Type t = g.getTypeSet().getTypeByName(tn);
        if (t == null) {
            return false;
        }
        Node n1 = this.getNode(g, r1);
        Node n2 = this.getNode(g, r2);
        return this.hideEdge(g, t, n1, n2);
    }

    private boolean hideEdge(Graph g, Type t, Node n1, Node n2) {
        if (t == null || n1 == null || n2 == null) {
            return false;
        }
        Arc a = this.getEdge(g, t, n1, n2);
        if (a != null) {
            Arc a1;
            a.setVisible(false);
            if (a.getSource() == a.getTarget()) {
                return true;
            }
            if (this.visArcs.contains(a)) {
                this.visArcs.remove(a);
            }
            if ((a1 = this.getEdge(g, t, n2, n1)) != null) {
                if (a1.isVisible()) {
                    a1.setDirected(true);
                } else if (this.visArcs.contains(a1)) {
                    this.visArcs.remove(a1);
                    a1.setDirected(true);
                    a1.setVisible(true);
                }
            }
        }
        return false;
    }

    private void hideGraphObject(EdGraphObject go) {
        if (go != null) {
            this.hiddenGraphObject = true;
            go.getBasisObject().setVisible(false);
            if (go.isNode()) {
                Iterator<Arc> e = ((Node)go.getBasisObject()).getOutgoingArcsSet().iterator();
                while (e.hasNext()) {
                    e.next().setVisible(false);
                }
                e = ((Node)go.getBasisObject()).getIncomingArcsSet().iterator();
                while (e.hasNext()) {
                    e.next().setVisible(false);
                }
            }
        }
    }

    private Rule getRule(Node n) {
        ValueTuple vt = (ValueTuple)n.getAttribute();
        String rname = (String)vt.getValueMemberAt("name").getExprAsObject();
        return this.grammar.getRule(rname);
    }

    private void straightEdges(EdGraph g) {
        Enumeration<EdArc> e = g.getArcs().elements();
        while (e.hasMoreElements()) {
            EdArc ea = e.nextElement();
            g.straightArc(ea);
        }
        g.update();
    }

    private void changeStyleOfEdges(EdGraph g, String edgeTypeName, int style) {
        Vector<EdType> arctypes = g.getTypeSet().getArcTypes();
        int i = 0;
        while (i < arctypes.size()) {
            EdType et = arctypes.get(i);
            if (et.getBasisType().getName().equals(edgeTypeName)) {
                et.setShape(style);
                et.setAdditionalReprOfBasisType();
            }
            ++i;
        }
    }

    private void makeLayout(EdGraph g) {
        g.forceVisibilityUpdate();
        List<EdNode> visiblenodes = g.getVisibleNodes();
        g.setCurrentLayoutToDefault(false);
        g.getDefaultGraphLayouter().setEnabled(true);
        Dimension dim = g.getDefaultGraphLayouter().getNeededPanelSize(visiblenodes);
        if (dim.width < 550) {
            dim.width = 550;
        }
        if (dim.height < 450) {
            dim.height = 450;
        }
        g.getDefaultGraphLayouter().setPanelSize(dim);
        g.doDefaultEvolutionaryGraphLayout(g.getDefaultGraphLayouter(), 100, 10);
    }

    private void makeLayout(EdGraph g, Dimension dim) {
        g.forceVisibilityUpdate();
        g.setCurrentLayoutToDefault(false);
        g.getDefaultGraphLayouter().setEnabled(true);
        if (dim.width < 550) {
            dim.width = 550;
        }
        if (dim.height < 450) {
            dim.height = 450;
        }
        g.getDefaultGraphLayouter().setPanelSize(dim);
        g.doDefaultEvolutionaryGraphLayout(g.getDefaultGraphLayouter(), 100, 10);
    }
}

