/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.AttrContext;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.cons.AtomConstraint;
import agg.cons.Evaluable;
import agg.cons.Formula;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdConstraint;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleScheme;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.editor.impl.EditUndoManager;
import agg.layout.evolutionary.LayoutPattern;
import agg.ruleappl.RuleSequence;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.ConcurrentRule;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.ParallelRule;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeGraph;
import agg.xt_basis.agt.AmalgamatedRule;
import agg.xt_basis.agt.RuleScheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoManager;
import org.w3c.dom.Element;

public class EdGraGra
implements XMLObject {
    private String name;
    private GraGra bGraGra;
    private EdTypeSet typeSet;
    private EdGraph eGraph;
    private transient EdGraph startGraph;
    private Vector<EdGraph> eGraphs = new Vector();
    private Vector<EdRule> eRules = new Vector();
    private Vector<EdAtomic> eAtomics = new Vector();
    private Vector<EdConstraint> eConstraints = new Vector();
    private String dirName = "";
    private String fileName = "";
    private boolean isChanged = false;
    private Hashtable<Type, Vector<LayoutPattern>> layoutPatterns = new Hashtable();
    private EditUndoManager undoManager;
    private boolean undoEnabled = true;
    protected boolean animated;

    public EdGraGra(String name) {
        this.name = name;
        this.dirName = "";
        this.fileName = "";
        this.bGraGra = BaseFactory.theFactory().createGraGra();
        this.bGraGra.setName(name);
        this.typeSet = new EdTypeSet(this.bGraGra.getTypeSet());
        this.eGraph = new EdGraph(this.bGraGra.getGraph(), this.typeSet);
        this.eGraph.setGraGra(this);
        this.eGraphs.add(this.eGraph);
        this.startGraph = null;
        this.createRule("Rule");
    }

    public EdGraGra(String name, boolean directedGraphs, boolean parallelArcs) {
        this.name = name;
        this.dirName = "";
        this.fileName = "";
        this.bGraGra = BaseFactory.theFactory().createGraGra(true, directedGraphs, parallelArcs);
        this.bGraGra.setName(name);
        this.typeSet = new EdTypeSet(this.bGraGra.getTypeSet());
        this.eGraph = new EdGraph(this.bGraGra.getGraph(), this.typeSet);
        this.eGraph.setGraGra(this);
        this.eGraphs.add(this.eGraph);
        this.startGraph = null;
        this.createRule("Rule");
    }

    public EdGraGra(GraGra basis) {
        this.bGraGra = basis;
        this.name = basis.getName();
        this.dirName = "";
        this.fileName = "";
        this.typeSet = new EdTypeSet(this.bGraGra.getTypeSet());
        if (this.getTypeGraph() != null) {
            this.getTypeGraph().setGraGra(this);
        }
        if (!this.bGraGra.getListOfGraphs().isEmpty()) {
            this.createGraphs(this.bGraGra.getListOfGraphs());
            this.eGraph = this.eGraphs.firstElement();
        }
        this.startGraph = null;
        this.createRules(this.bGraGra.getListOfRules());
        this.createAtomics(this.bGraGra.getListOfAtomics());
        this.createConstraints(this.bGraGra.getListOfConstraints());
    }

    public void dispose() {
        if (this.undoManager != null) {
            this.undoManager.discardAllEdits();
        }
        while (!this.eRules.isEmpty()) {
            this.eRules.remove(0).dispose();
        }
        while (!this.eConstraints.isEmpty()) {
            this.eConstraints.remove(0).dispose();
        }
        while (!this.eAtomics.isEmpty()) {
            this.eAtomics.remove(0).dispose();
        }
        while (!this.eGraphs.isEmpty()) {
            this.eGraphs.remove(0).dispose();
        }
        if (this.startGraph != null) {
            this.startGraph.dispose();
        }
        Iterator<Vector<LayoutPattern>> lpIter = this.layoutPatterns.values().iterator();
        while (lpIter.hasNext()) {
            Iterator<LayoutPattern> iter = lpIter.next().iterator();
            while (iter.hasNext()) {
                iter.next().dispose();
            }
        }
        this.layoutPatterns.clear();
        this.typeSet.dispose();
        this.eGraph = null;
        this.startGraph = null;
        this.typeSet = null;
        this.undoManager = null;
        BaseFactory.theFactory().destroyGraGra(this.bGraGra);
        this.bGraGra = null;
    }

    public void finalize() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String str) {
        this.name = str;
        this.bGraGra.setName(str);
    }

    public void setAnimated(boolean b) {
        this.animated = b;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void resetAnimated(boolean updateAnimatedOfRule) {
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule r = this.eRules.get(i);
            if (r.getBasisRule().isEnabled() && r.isAnimated()) {
                this.animated = true;
                if (!updateAnimatedOfRule) break;
                r.setAnimated(true);
            }
            ++i;
        }
    }

    public void enableUndoManager(boolean b) {
        this.undoEnabled = b;
        if (this.undoManager != null) {
            this.undoManager.enabled = this.undoEnabled;
        }
    }

    public boolean isUndoManagerEnabled() {
        return this.undoManager != null && this.undoEnabled;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(EditUndoManager anUndoManager) {
        this.undoManager = anUndoManager;
        if (this.typeSet.getTypeGraph() != null) {
            this.typeSet.getTypeGraph().setUndoManager(this.undoManager);
        }
        int i = 0;
        while (i < this.eGraphs.size()) {
            EdGraph g = this.eGraphs.elementAt(i);
            g.setUndoManager(this.undoManager);
            ++i;
        }
        i = 0;
        while (i < this.eRules.size()) {
            EdRule r = this.eRules.elementAt(i);
            if (r != null) {
                r.setUndoManager(this.undoManager);
            }
            ++i;
        }
        i = 0;
        while (i < this.eAtomics.size()) {
            EdAtomic a = this.eAtomics.elementAt(i);
            a.setUndoManager(this.undoManager);
            ++i;
        }
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String str) {
        this.dirName = str;
        this.bGraGra.setDirName(str);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String str) {
        this.fileName = str;
        this.bGraGra.setFileName(str);
    }

    public GraGra getBasisGraGra() {
        return this.bGraGra;
    }

    public void setBasisGraGra(GraGra gra) {
        this.bGraGra = gra;
    }

    public EdGraph getGraph() {
        return this.eGraph;
    }

    public EdGraph getGraph(String graphname) {
        int i = 0;
        while (i < this.eGraphs.size()) {
            EdGraph g = this.eGraphs.get(i);
            if (g.getName().equals(graphname)) {
                return g;
            }
            ++i;
        }
        return null;
    }

    public EdGraph getGraph(int index) {
        return index >= 0 && index < this.eGraphs.size() ? this.eGraphs.get(index) : null;
    }

    public int getIndexOfGraph() {
        return this.eGraphs.indexOf(this.eGraph);
    }

    public int getIndexOfGraph(EdGraph g) {
        return this.eGraphs.indexOf(g);
    }

    public Vector<EdGraph> getGraphs() {
        return this.eGraphs;
    }

    public EdGraph getTypeGraph() {
        return this.typeSet.getTypeGraph();
    }

    public Vector<EdRule> getRules() {
        return this.eRules;
    }

    public Vector<EdRule> getEnabledRules() {
        Vector<EdRule> v = new Vector<EdRule>();
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule er = this.eRules.get(i);
            if (er.getBasisRule().isEnabled()) {
                v.add(er);
            }
            ++i;
        }
        return v;
    }

    public Vector<EdRule> getRulesForLayer(int l) {
        Vector<EdRule> v = new Vector<EdRule>(5);
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule r = this.eRules.get(i);
            if (r.getBasisRule().getLayer() == l) {
                v.add(r);
            }
            ++i;
        }
        return v;
    }

    public List<Pair<List<Pair<String, String>>, String>> getRuleSequenceList() {
        return this.bGraGra.getRuleSequenceList();
    }

    public Vector<EdAtomic> getAtomics() {
        return this.eAtomics;
    }

    public Vector<String> getAtomicNames() {
        Vector<String> ret = new Vector<String>();
        int i = 0;
        while (i < this.eAtomics.size()) {
            ret.add(this.eAtomics.get(i).getBasisAtomic().getAtomicName());
            ++i;
        }
        return ret;
    }

    public Vector<Evaluable> getAtomicsAsEvaluable() {
        Vector<Evaluable> ret = new Vector<Evaluable>();
        int i = 0;
        while (i < this.eAtomics.size()) {
            ret.add(this.eAtomics.get(i).getBasisAtomic());
            ++i;
        }
        return ret;
    }

    public Vector<EdConstraint> getConstraints() {
        return this.eConstraints;
    }

    public List<EdConstraint> getEnabledConstraints() {
        Vector<EdConstraint> list = new Vector<EdConstraint>();
        int i = 0;
        while (i < this.eConstraints.size()) {
            EdConstraint c = this.eConstraints.get(i);
            if (c.getBasisConstraint().isEnabled()) {
                list.add(c);
            }
            ++i;
        }
        return list;
    }

    public boolean hasEnabledConstraints() {
        int i = 0;
        while (i < this.eConstraints.size()) {
            EdConstraint c = this.eConstraints.get(i);
            if (c.getBasisConstraint().isEnabled()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector<EdConstraint> getConstraintsForLayer(int l) {
        Vector<EdConstraint> v = new Vector<EdConstraint>(5);
        int i = 0;
        while (i < this.eConstraints.size()) {
            EdConstraint c = this.eConstraints.get(i);
            Vector<Integer> layer = c.getBasisConstraint().getLayer();
            int j = 0;
            while (j < layer.size()) {
                if (layer.get(j) == l) {
                    v.add(c);
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    public Vector<String> getGraTraOptions() {
        return this.bGraGra.getGraTraOptions();
    }

    public boolean addGraph(EdGraph g) {
        if (g.getTypeSet().getBasisTypeSet().compareTo(this.typeSet.getBasisTypeSet())) {
            if (this.bGraGra.addGraph(g.getBasisGraph())) {
                Vector<Type> v = g.getBasisGraph().getUsedTypes();
                this.bGraGra.getTypeSet().adaptTypes(v.elements(), false);
                this.typeSet.refreshTypes();
                g.update();
                g.setGraGra(this);
                this.eGraphs.add(g);
                g.setUndoManager(this.undoManager);
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeGraph(EdGraph g) {
        if (this.bGraGra == null) {
            return false;
        }
        if (g == null || g.getBasisGraph() == null || !this.bGraGra.removeGraph(g.getBasisGraph())) return false;
        if (this.eGraph == g) {
            this.eGraphs.removeElement(this.eGraph);
            if (this.eGraphs.size() > 0) {
                if (!this.bGraGra.resetGraph(this.eGraphs.firstElement().getBasisGraph())) return false;
                this.eGraph = this.eGraphs.firstElement();
            }
        } else {
            this.eGraphs.removeElement(g);
        }
        this.isChanged = true;
        return true;
    }

    public synchronized boolean importTypeGraph(EdGraph g, boolean rewrite) {
        if (!g.isTypeGraph()) {
            return false;
        }
        boolean result = false;
        if (this.typeSet.getTypeGraph() == null) {
            this.typeSet.createTypeGraph();
        }
        this.typeSet.getTypeGraph().setUndoManager(this.undoManager);
        if (this.bGraGra.importTypeGraph(g.getBasisGraph(), rewrite)) {
            this.typeSet.refreshTypes();
            this.typeSet.getTypeGraph().deselectAll();
            this.typeSet.getTypeGraph().synchronizeWithBasis(true);
            this.typeSet.getTypeGraph().setLayoutByType(g);
            this.update(true);
            result = true;
        }
        return result;
    }

    public synchronized boolean importGraph(EdGraph g) {
        if (this.bGraGra.importGraph(g.getBasisGraph())) {
            this.typeSet.refreshTypes();
            int indx = this.eGraphs.indexOf(this.eGraph);
            if (indx != -1) {
                this.eGraphs.remove(this.eGraph);
                this.eGraph.dispose();
            }
            EdGraph impG = new EdGraph(this.bGraGra.getGraph(), this.typeSet, true);
            impG.setGraGra(this);
            impG.setUndoManager(this.undoManager);
            impG.setLayoutByIndex(g, false);
            if (indx != -1) {
                this.eGraphs.add(indx, impG);
            } else {
                this.eGraphs.add(impG);
            }
            this.eGraph = impG;
            return true;
        }
        return false;
    }

    public synchronized boolean addImportGraph(EdGraph g) {
        if (this.bGraGra.addImportGraph(g.getBasisGraph())) {
            this.typeSet.refreshTypes();
            EdGraph impG = new EdGraph(this.bGraGra.getListOfGraphs().get(this.bGraGra.getCountOfGraphs() - 1), this.typeSet, true);
            impG.setGraGra(this);
            impG.setLayoutByIndex(g, false);
            this.eGraphs.add(impG);
            impG.setUndoManager(this.undoManager);
            return true;
        }
        return false;
    }

    public synchronized boolean importGraph(EdGraph g, boolean adapt) {
        if (this.bGraGra.importGraph(g.getBasisGraph(), adapt)) {
            this.typeSet.refreshTypes(true);
            int indx = this.eGraphs.indexOf(this.eGraph);
            if (indx != -1) {
                this.eGraphs.remove(this.eGraph);
            }
            EdGraph impG = new EdGraph(this.bGraGra.getGraph(), this.typeSet, true);
            impG.setGraGra(this);
            impG.setLayoutByIndex(g, false);
            impG.setUndoManager(this.undoManager);
            if (indx != -1) {
                this.eGraphs.add(indx, impG);
            } else {
                this.eGraphs.add(impG);
            }
            this.eGraph = impG;
            return true;
        }
        return false;
    }

    public synchronized boolean addImportGraph(EdGraph g, boolean adapt) {
        if (this.bGraGra.addImportGraph(g.getBasisGraph(), adapt)) {
            this.typeSet.refreshTypes(true);
            EdGraph impG = new EdGraph(this.bGraGra.getListOfGraphs().get(this.bGraGra.getCountOfGraphs() - 1), this.typeSet, true);
            impG.setGraGra(this);
            impG.setLayoutByIndex(g, false);
            this.eGraphs.add(impG);
            impG.setUndoManager(this.undoManager);
            return true;
        }
        return false;
    }

    public void refreshAttrInstances() {
        this.typeSet.refreshAttrInstances();
        this.bGraGra.refreshAttributed();
    }

    public synchronized boolean resetGraph() {
        if (this.startGraph == null || this.startGraph == this.eGraph || this.typeSet == null || this.startGraph.getTypeSet() == null || !this.typeSet.equals(this.startGraph.getTypeSet())) {
            return false;
        }
        EdGraph eg = this.startGraph.copy();
        eg.setGraGra(this);
        String origGraphName = this.eGraph.getName();
        if (this.bGraGra.resetGraph(eg.getBasisGraph())) {
            int indx = this.eGraphs.indexOf(this.eGraph);
            this.eGraphs.remove(this.eGraph);
            this.eGraph.dispose();
            this.eGraph = eg;
            this.eGraph.setCurrentLayoutToDefault(true);
            this.eGraph.setUndoManager(this.undoManager);
            if (indx == -1) {
                this.eGraphs.add(this.eGraph);
            } else {
                this.eGraphs.add(indx, this.eGraph);
            }
            this.eGraph.getBasisGraph().setName(origGraphName);
            this.isChanged = true;
            return true;
        }
        return false;
    }

    public synchronized boolean resetGraph(int atIndex) {
        if (this.startGraph == null || this.startGraph == this.eGraph || this.typeSet == null || this.startGraph.getTypeSet() == null || !this.typeSet.equals(this.startGraph.getTypeSet()) || atIndex < 0 || atIndex >= this.eGraphs.size()) {
            return false;
        }
        EdGraph eg = this.startGraph.copy();
        eg.setGraGra(this);
        String origGraphName = this.eGraphs.get(atIndex).getName();
        if (this.bGraGra.resetGraph(atIndex, eg.getBasisGraph())) {
            this.eGraphs.remove(atIndex);
            eg.setCurrentLayoutToDefault(true);
            eg.setUndoManager(this.undoManager);
            this.eGraphs.add(atIndex, eg);
            this.eGraphs.get(atIndex).getBasisGraph().setName(origGraphName);
            this.isChanged = true;
            return true;
        }
        return false;
    }

    public synchronized boolean resetGraph(EdGraph g) {
        if (g.getGraGra() == this) {
            if (this.bGraGra.resetGraph(g.getBasisGraph())) {
                int indxOther = this.eGraphs.indexOf(g);
                int indx = this.eGraphs.indexOf(this.eGraph);
                if (indxOther == -1 && indx != -1) {
                    this.eGraphs.remove(this.eGraph);
                }
                this.eGraph = g;
                this.eGraph.setCurrentLayoutToDefault(true);
                this.eGraph.setGraGra(this);
                this.eGraph.setUndoManager(this.undoManager);
                if (!this.eGraphs.contains(this.eGraph)) {
                    if (indx != -1) {
                        this.eGraphs.add(indx, this.eGraph);
                    } else {
                        this.eGraphs.add(this.eGraph);
                    }
                }
                this.isChanged = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized boolean resetGraphWithoutGuarantee(EdGraph g) {
        if (g != null) {
            if (this.bGraGra.resetGraphWithoutGuarantee(g.getBasisGraph())) {
                int indx = this.eGraphs.indexOf(this.eGraph);
                this.eGraphs.remove(this.eGraph);
                this.eGraph = new EdGraph(this.bGraGra.getGraph());
                this.eGraph.setUndoManager(this.undoManager);
                this.eGraph.setLayoutByIndex(g, false);
                this.eGraph.setCurrentLayoutToDefault(true);
                this.eGraph.setGraGra(this);
                if (indx != -1) {
                    this.eGraphs.add(indx, this.eGraph);
                } else {
                    this.eGraphs.add(this.eGraph);
                }
                this.isChanged = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public EdGraph getStartGraph() {
        return this.startGraph;
    }

    public void destroyStartGraph() {
        if (this.startGraph != null) {
            this.startGraph.dispose();
        }
        this.startGraph = null;
    }

    public Collection<TypeError> setLevelOfTypeGraphCheck(int level) {
        Collection<TypeError> baseResult = this.getBasisGraGra().setLevelOfTypeGraphCheck(level);
        WeakHashMap<GraphObject, EdGraphObject> base2ed = new WeakHashMap<GraphObject, EdGraphObject>();
        this.putAllGraphObjectsInMap(base2ed, this.typeSet.getTypeGraph());
        int i = 0;
        while (i < this.eGraphs.size()) {
            EdGraph eg = this.eGraphs.get(i);
            this.putAllGraphObjectsInMap(base2ed, eg);
            ++i;
        }
        i = 0;
        while (i < this.eRules.size()) {
            EdRule er = this.eRules.get(0);
            if (er instanceof EdRuleScheme) {
                this.putAllGraphObjectsOfRuleSchemeInMap(base2ed, (EdRuleScheme)er);
            } else {
                this.putAllGraphObjectsOfRuleInMap(base2ed, er);
            }
            ++i;
        }
        i = 0;
        while (i < this.eAtomics.size()) {
            EdAtomic eAtomic = this.eAtomics.get(i);
            this.putAllGraphObjectsInMap(base2ed, eAtomic.getLeft());
            Iterator<EdAtomic> subIter = eAtomic.getConclusions().iterator();
            while (subIter.hasNext()) {
                EdGraph ec = subIter.next().getRight();
                this.putAllGraphObjectsInMap(base2ed, ec);
            }
            ++i;
        }
        if (baseResult.isEmpty()) {
            return baseResult;
        }
        for (TypeError baseError : baseResult) {
            EdGraphObject edObject;
            GraphObject baseObject = baseError.getGraphObject();
            if (baseObject == null || (edObject = base2ed.get(baseObject)) == null) continue;
            edObject.setErrorMode(true);
        }
        this.update();
        return baseResult;
    }

    private void putAllGraphObjectsOfRuleSchemeInMap(WeakHashMap<GraphObject, EdGraphObject> base2ed, EdRuleScheme rs) {
        this.putAllGraphObjectsOfRuleInMap(base2ed, rs.getKernelRule());
        int i = 0;
        while (i < rs.getMultiRules().size()) {
            this.putAllGraphObjectsOfRuleInMap(base2ed, rs.getMultiRules().get(i));
            ++i;
        }
    }

    private void putAllGraphObjectsOfRuleInMap(WeakHashMap<GraphObject, EdGraphObject> base2ed, EdRule r) {
        this.putAllGraphObjectsInMap(base2ed, r.getLeft());
        this.putAllGraphObjectsInMap(base2ed, r.getRight());
        for (EdNAC eNAC : r.getNACs()) {
            this.putAllGraphObjectsInMap(base2ed, eNAC);
        }
        for (EdPAC ePAC : r.getPACs()) {
            this.putAllGraphObjectsInMap(base2ed, ePAC);
        }
    }

    public void disableTypeGraphCheck() {
        this.typeSet.getBasisTypeSet().setLevelOfTypeGraphCheck(0);
    }

    public int getLevelOfTypeGraphCheck() {
        return this.typeSet.getBasisTypeSet().getLevelOfTypeGraphCheck();
    }

    private void putAllGraphObjectsInMap(Map<GraphObject, EdGraphObject> map, EdGraph graph) {
        for (EdArc actArc : graph.getArcs()) {
            map.put(actArc.getBasisArc(), actArc);
            actArc.setErrorMode(false);
        }
        for (EdNode actNode : graph.getNodes()) {
            map.put(actNode.getBasisNode(), actNode);
            actNode.setErrorMode(false);
        }
    }

    public EdRuleScheme createRuleScheme(String ruleSchemeName) {
        if (ruleSchemeName != null) {
            EdRuleScheme eRuleScheme = new EdRuleScheme(this.bGraGra.createRuleScheme(), this.typeSet);
            eRuleScheme.setUndoManager(this.undoManager);
            eRuleScheme.getBasisRule().setName(ruleSchemeName);
            eRuleScheme.setGraGra(this);
            this.eRules.addElement(eRuleScheme);
            this.isChanged = true;
            return eRuleScheme;
        }
        return null;
    }

    public EdRuleScheme createRuleScheme(EdRule rule) {
        RuleScheme rs;
        if (rule != null && (rs = this.bGraGra.createRuleScheme(rule.getBasisRule())) != null) {
            EdRuleScheme eRS = new EdRuleScheme(rs, this.typeSet);
            eRS.getKernelRule().setLayoutByIndexFrom(rule, true);
            eRS.setUndoManager(this.undoManager);
            eRS.setGraGra(this);
            int indx = this.eRules.indexOf(rule);
            if (indx >= 0) {
                this.eRules.add(indx + 1, eRS);
            } else {
                this.eRules.add(eRS);
            }
            this.isChanged = true;
            return eRS;
        }
        return null;
    }

    public EdRule createRule(String ruleName) {
        if (ruleName != null) {
            EdRule eRule = new EdRule(this.bGraGra.createRule(), this.typeSet);
            eRule.setUndoManager(this.undoManager);
            eRule.getBasisRule().setName(ruleName);
            eRule.setGraGra(this);
            eRule.setEditable(true);
            this.eRules.addElement(eRule);
            this.isChanged = true;
            return eRule;
        }
        return null;
    }

    public boolean addRule(EdRule r) {
        if (r != null && !this.eRules.contains(r) && r.getTypeSet().getBasisTypeSet().compareTo(this.typeSet.getBasisTypeSet())) {
            if (this.bGraGra.getRule(r.getBasisRule().getName()) != null) {
                r.getBasisRule().setName(String.valueOf(r.getName()) + "_" + this.eRules.size());
            }
            if (this.bGraGra.addRule(r.getBasisRule())) {
                Vector<Type> v = r.getBasisRule().getUsedTypes();
                this.bGraGra.getTypeSet().adaptTypes(v.elements(), false);
                this.typeSet.refreshTypes();
                this.eRules.add(r);
                r.update();
                r.setUndoManager(this.undoManager);
                r.setGraGra(this);
                return true;
            }
        }
        return false;
    }

    public EdGraph cloneGraph() {
        return this.cloneGraph(true);
    }

    public EdGraph cloneGraph(boolean insertToGraGra) {
        this.eGraph.setContextUsageOfGraphObjToBasisHashCode();
        Graph graph = this.bGraGra.cloneGraph();
        if (graph == null) {
            return null;
        }
        graph.setName(String.valueOf(this.eGraph.getBasisGraph().getName()) + "_clone");
        EdGraph clone = new EdGraph(graph, this.typeSet);
        clone.setGraGra(this);
        clone.setLayoutByContextUsage(this.eGraph, true);
        this.eGraph.unsetContextUsageOfGraphObj();
        clone.unsetContextUsageOfGraphObj();
        clone.setUndoManager(this.undoManager);
        if (insertToGraGra) {
            this.bGraGra.addGraph(graph);
            this.eGraphs.add(clone);
            this.eGraph.setUndoManager(this.undoManager);
            this.isChanged = true;
        }
        return clone;
    }

    public EdRule reverseRule(EdRule r, boolean doInsert) {
        Pair<Pair<Rule, Boolean>, Pair<OrdinaryMorphism, OrdinaryMorphism>> inverseRulePair = BaseFactory.theFactory().reverseRule(r.getBasisRule());
        if (inverseRulePair != null) {
            EdRule invR = new EdRule((Rule)((Pair)inverseRulePair.first).first);
            invR.setLayoutByIndexFrom(r, true);
            if (doInsert) {
                int indx = this.eRules.indexOf(r) + 1;
                if (indx >= 0) {
                    this.bGraGra.addRuleAt(indx, invR.getBasisRule());
                    this.eRules.add(indx, invR);
                } else {
                    this.bGraGra.addRule(invR.getBasisRule());
                    this.eRules.add(invR);
                }
                invR.setUndoManager(this.undoManager);
                invR.setGraGra(this);
            }
            return invR;
        }
        return null;
    }

    public EdRuleScheme reverseRuleScheme(EdRuleScheme rs, boolean doInsert) {
        RuleScheme inv = BaseFactory.theFactory().reverseRuleScheme(rs.getBasisRuleScheme());
        if (inv != null) {
            EdRuleScheme invRS = new EdRuleScheme(inv, this.typeSet);
            invRS.setLayoutByIndexFrom(rs, true);
            if (doInsert) {
                int indx = this.eRules.indexOf(rs) + 1;
                if (indx >= 0) {
                    this.bGraGra.addRuleAt(indx, invRS.getBasisRule());
                    this.eRules.add(indx, invRS);
                } else {
                    this.bGraGra.addRule(invRS.getBasisRule());
                    this.eRules.add(invRS);
                }
                invRS.setUndoManager(this.undoManager);
                invRS.setGraGra(this);
            }
            return invRS;
        }
        return null;
    }

    public EdRule makeConcurrentRule(EdRule r1, EdRule r2, boolean disjoint, boolean doInsert) {
        ConcurrentRule concurrentRule = new ConcurrentRule(r1.getBasisRule(), r2.getBasisRule());
        if (concurrentRule.getRule() != null) {
            EdRule rule = new EdRule(concurrentRule.getRule());
            this.takeLayoutFromRuleToRule(r1, rule, concurrentRule.getFirstLeftEmbedding(), concurrentRule.getFirstRightEmbedding(), false);
            this.takeLayoutFromRuleToRule(r2, rule, concurrentRule.getSecondLeftEmbedding(), concurrentRule.getSecondRightEmbedding(), false);
            if (doInsert) {
                this.addRule(rule);
            }
            return rule;
        }
        return null;
    }

    public EdRule makeConcurrentRuleOfRuleSeq(RuleSequence seq, boolean byObjectFlow, boolean addToRuleList) {
        if (seq != null) {
            long t0 = System.currentTimeMillis();
            seq.enableCompleteObjFlowOfNodes(false);
            ConcurrentRule concurrentRule = BaseFactory.theFactory().makeConcurrentRuleOfRuleSeqBackwards(seq, byObjectFlow);
            if (concurrentRule != null && concurrentRule.getRule() != null) {
                System.out.println(">>> Concurrent rule creation time : " + (System.currentTimeMillis() - t0) + "ms   ");
                System.out.println(">>> Concurrent rule creation - Used memory: " + concurrentRule.usedM / 1024L + "k");
                EdRule rule = new EdRule(concurrentRule.getRule());
                int i = 0;
                while (i < seq.getRules().size()) {
                    Rule r = seq.getRules().get(i);
                    EdRule er = this.getRule(r.getName());
                    this.takeLayoutFromRuleToRule(er, rule, concurrentRule.getFirstLeftEmbedding(), concurrentRule.getFirstRightEmbedding(), false);
                    this.takeLayoutFromRuleToRule(er, rule, concurrentRule.getSecondLeftEmbedding(), concurrentRule.getSecondRightEmbedding(), false);
                    ++i;
                }
                if (addToRuleList) {
                    this.addRule(rule);
                    if (rule.getBasisRule().getMatch() != null) {
                        this.bGraGra.addMatch(rule.getBasisRule().getMatch());
                    }
                }
                return rule;
            }
        }
        return null;
    }

    public List<EdRule> makeConcurrentRuleOfRuleSeqForward(RuleSequence seq, boolean completeConcurrency, boolean addToRuleList) {
        if (seq != null) {
            long t0 = System.currentTimeMillis();
            long freem0 = Runtime.getRuntime().freeMemory();
            List<ConcurrentRule> crs = BaseFactory.theFactory().makeConcurrentRuleOfRuleSeqForward(seq, this.bGraGra, completeConcurrency);
            long usedm = freem0 - Runtime.getRuntime().freeMemory();
            if (crs != null && !crs.isEmpty()) {
                System.out.println(">>> Concurrent rule creation time : " + (System.currentTimeMillis() - t0) + "ms   ");
                System.out.println(">>> Concurrent rule creation - Used memory: " + usedm / 1024L + "k");
                Vector<EdRule> rs = new Vector<EdRule>(crs.size());
                int j = 0;
                while (j < crs.size()) {
                    ConcurrentRule cr = crs.get(j);
                    if (cr.getRule() != null) {
                        EdRule rule = new EdRule(cr.getRule());
                        int i = seq.getRules().size() - 1;
                        Rule r = seq.getRules().get(i);
                        EdRule er = this.getRule(r.getName());
                        this.takeLayoutFromRuleToRule(er, rule, cr.getFirstLeftEmbedding(), cr.getFirstRightEmbedding(), false);
                        this.takeLayoutFromRuleToRule(er, rule, cr.getSecondLeftEmbedding(), cr.getSecondRightEmbedding(), false);
                        if (addToRuleList) {
                            this.addRule(rule);
                            if (rule.getBasisRule().getMatch() != null) {
                                this.bGraGra.addMatch(rule.getBasisRule().getMatch());
                            }
                        }
                        rs.add(rule);
                    }
                    ++j;
                }
                return rs;
            }
        }
        return null;
    }

    public EdRule makeParallelRuleOfRules(List<Rule> rules, boolean addToRuleList) {
        if (!rules.isEmpty()) {
            long t0 = System.currentTimeMillis();
            long freem0 = Runtime.getRuntime().freeMemory();
            ParallelRule parallelRule = new ParallelRule(this.typeSet.getBasisTypeSet(), rules);
            System.out.println(">>> Parallel rule creation time : " + (System.currentTimeMillis() - t0) + "ms   ");
            long usedm = freem0 - Runtime.getRuntime().freeMemory();
            System.out.println(">>> Concurrent rule creation - Used memory: " + usedm / 1024L + "k");
            if (parallelRule.isValid() && parallelRule.isApplicable()) {
                EdRule rule = new EdRule(parallelRule);
                String namestr = "";
                int i = 0;
                while (i < rules.size()) {
                    Rule r = rules.get(i);
                    EdRule er = this.getRule(r);
                    namestr = String.valueOf(namestr) + r.getName() + "+";
                    this.takeLayoutFromRuleToRule(er, rule, parallelRule.getLeftEmbedding().get(i), parallelRule.getRightEmbedding().get(i), false);
                    ++i;
                }
                rule.getBasisRule().setName(namestr.substring(0, namestr.length() - 1));
                if (addToRuleList) {
                    this.addRule(rule);
                }
                return rule;
            }
        }
        return null;
    }

    public EdRule makeParallelRuleOfTwoRules(Rule r1, Rule r2, boolean addToRuleList) {
        ParallelRule parallelRule = new ParallelRule(this.typeSet.getBasisTypeSet(), r1, r2);
        if (parallelRule.isValid() && parallelRule.isApplicable()) {
            EdRule rule = new EdRule(parallelRule);
            EdRule er1 = this.getRule(r1.getName());
            this.takeLayoutFromRuleToRule(er1, rule, parallelRule.getLeftEmbedding().get(0), parallelRule.getRightEmbedding().get(0), false);
            EdRule er2 = this.getRule(r2.getName());
            this.takeLayoutFromRuleToRule(er2, rule, parallelRule.getLeftEmbedding().get(1), parallelRule.getRightEmbedding().get(1), false);
            if (addToRuleList) {
                this.addRule(rule);
            }
            return rule;
        }
        return null;
    }

    private void takeLayoutFromRuleToRule(EdRule fromRule, EdRule toRule, OrdinaryMorphism leftFrom2leftTo, OrdinaryMorphism rightFrom2rightTo, boolean inverse) {
        EdNode inv;
        EdNode n;
        EdGraph lg = inverse ? toRule.getRight() : toRule.getLeft();
        EdGraph rg = inverse ? toRule.getLeft() : toRule.getRight();
        Vector<EdNode> nodes = fromRule.getLeft().getNodes();
        int i = 0;
        while (i < nodes.size()) {
            n = nodes.get(i);
            inv = lg.findNode(leftFrom2leftTo.getImage(n.getBasisObject()));
            if (inv != null) {
                inv.setXY(n.getX(), n.getY());
            }
            ++i;
        }
        nodes = fromRule.getRight().getNodes();
        i = 0;
        while (i < nodes.size()) {
            n = nodes.get(i);
            inv = rg.findNode(rightFrom2rightTo.getImage(n.getBasisObject()));
            if (inv != null) {
                inv.setXY(n.getX(), n.getY());
            }
            ++i;
        }
        Vector<EdPAC> gacs = toRule.getNestedACs();
        int j = 0;
        while (j < gacs.size()) {
            EdPAC ac = gacs.get(j);
            EdPAC acOrig = fromRule.getNestedAC(ac.getName());
            if (acOrig != null) {
                ac.setLayoutByIndex(acOrig, true);
            }
            ++j;
        }
        Vector<EdNAC> nacs = toRule.getNACs();
        int j2 = 0;
        while (j2 < nacs.size()) {
            EdNAC ac = nacs.get(j2);
            EdNAC acOrig = fromRule.getNAC(ac.getName());
            if (acOrig != null) {
                ac.setLayoutByIndex(acOrig, true);
            }
            ++j2;
        }
        Vector<EdPAC> pacs = toRule.getPACs();
        int j3 = 0;
        while (j3 < pacs.size()) {
            EdPAC ac = pacs.get(j3);
            EdPAC acOrig = fromRule.getPAC(ac.getName());
            if (acOrig != null) {
                ac.setLayoutByIndex(acOrig, true);
            }
            ++j3;
        }
    }

    public EdRule cloneRule(EdRule rule) {
        return this.cloneRule(rule, false);
    }

    public EdRule cloneRule(EdRule rule, boolean doInsert) {
        Rule r = BaseFactory.theFactory().cloneRule(rule.getBasisRule(), this.getTypeSet().getBasisTypeSet(), true);
        r.setName(String.valueOf(rule.getBasisRule().getName()) + "_clone");
        EdRule clone = new EdRule(r, this.getTypeSet());
        clone.setGraGra(this);
        clone.setLayoutByIndexFrom(rule, false);
        if (doInsert) {
            int indx = this.eRules.indexOf(rule) + 1;
            this.bGraGra.addRuleAt(indx, r);
            this.eRules.add(indx, clone);
        } else {
            this.bGraGra.addRule(r);
            this.eRules.add(clone);
        }
        this.isChanged = true;
        return clone;
    }

    public EdRule cloneAmalgamatedRule(EdRule rule, EdRuleScheme rs, boolean doInsert) {
        Rule r = BaseFactory.theFactory().cloneRule(rule.getBasisRule(), this.getTypeSet().getBasisTypeSet(), true);
        r.setName(String.valueOf(rule.getBasisRule().getName()) + "_clone");
        EdRule clone = new EdRule(r, this.getTypeSet());
        clone.setGraGra(this);
        clone.setLayoutByIndexFrom(rule, false);
        if (doInsert && rs != null) {
            int indx = this.eRules.indexOf(rs) + 1;
            this.bGraGra.addRuleAt(indx, r);
            this.eRules.add(indx, clone);
        } else {
            this.bGraGra.addRule(r);
            this.eRules.add(clone);
        }
        this.isChanged = true;
        return clone;
    }

    public EdRule makeMinimalRule(EdRule rule, boolean doInsert) {
        Rule r = BaseFactory.theFactory().cloneRule(rule.getBasisRule(), this.getTypeSet().getBasisTypeSet(), false);
        r.setName(String.valueOf(rule.getBasisRule().getName()) + "_Minimal");
        EdRule clone = new EdRule(r, this.getTypeSet());
        clone.setGraGra(this);
        clone.setLayoutByIndexFrom(rule, false);
        clone.getLeft().setTransformChangeEnabled(true);
        clone.getRight().setTransformChangeEnabled(true);
        if (!BaseFactory.theFactory().removePreservedUnchangedObjs(r)) {
            clone.getBasisRule().setErrorMsg("The minimal rule is identical to the given rule.");
        } else {
            clone.updateRule();
        }
        clone.getLeft().setTransformChangeEnabled(false);
        clone.getRight().setTransformChangeEnabled(false);
        if (doInsert) {
            int indx = this.eRules.indexOf(rule) + 1;
            this.bGraGra.addRuleAt(indx, r);
            this.eRules.add(indx, clone);
        } else {
            this.bGraGra.addRule(r);
            this.eRules.add(clone);
        }
        this.isChanged = true;
        return clone;
    }

    public EdRuleScheme cloneRuleScheme(EdRuleScheme rs, boolean doInsert) {
        RuleScheme brs = BaseFactory.theFactory().cloneRuleScheme(rs.getBasisRuleScheme(), this.getTypeSet().getBasisTypeSet());
        brs.setName(String.valueOf(rs.getBasisRuleScheme().getName()) + "_clone");
        EdRuleScheme clone = new EdRuleScheme(brs, this.getTypeSet());
        clone.setGraGra(this);
        clone.setLayoutByIndexFrom(rs);
        if (doInsert) {
            int indx = this.eRules.indexOf(rs) + 1;
            this.bGraGra.addRuleAt(indx, brs);
            this.eRules.add(indx, clone);
        } else {
            this.bGraGra.addRule(brs);
            this.eRules.add(clone);
        }
        this.isChanged = true;
        return clone;
    }

    private EdRule cloneRuleOLD(EdRule r, boolean doInsert) {
        Rule rule = this.bGraGra.createRule();
        if (rule == null) {
            return null;
        }
        rule.setName(String.valueOf(r.getBasisRule().getName()) + "_clone");
        rule.setLayer(r.getBasisRule().getLayer());
        EdRule ruleClone = new EdRule(rule, this.typeSet);
        if (doInsert) {
            this.bGraGra.getListOfRules().remove(rule);
            this.bGraGra.getListOfRules().add(this.bGraGra.getListOfRules().indexOf(r.getBasisRule()) + 1, rule);
            this.eRules.insertElementAt(ruleClone, this.eRules.indexOf(r) + 1);
        } else {
            this.eRules.add(ruleClone);
        }
        this.isChanged = true;
        AttrContext ac = ruleClone.getBasisRule().getAttrContext();
        VarTuple avt = (VarTuple)ac.getVariables();
        AttrContext acOther = r.getBasisRule().getAttrContext();
        VarTuple avtOther = (VarTuple)acOther.getVariables();
        int i = 0;
        while (i < avtOther.getSize()) {
            VarMember varOther = avtOther.getVarMemberAt(i);
            VarMember var = avt.getVarMemberAt(varOther.getName());
            if (var != null) {
                var.setMark(varOther.getMark());
                var.setInputParameter(varOther.isInputParameter());
            } else {
                avt.declare(varOther.getHandler(), varOther.getDeclaration().getTypeName(), varOther.getName());
                var = avt.getVarMemberAt(varOther.getName());
                if (var != null) {
                    var.setMark(varOther.getMark());
                    var.setInputParameter(varOther.isInputParameter());
                }
            }
            ++i;
        }
        Hashtable<GraphObject, GraphObject> table = new Hashtable<GraphObject, GraphObject>();
        this.copyGraph(r.getLeft(), ruleClone.getLeft(), table);
        this.copyGraph(r.getRight(), ruleClone.getRight(), table);
        this.copyMorph(r.getBasisRule(), ruleClone.getBasisRule(), table);
        Enumeration<EdNAC> nacs = r.getNACs().elements();
        while (nacs.hasMoreElements()) {
            EdNAC cond = nacs.nextElement();
            EdNAC condClone = ruleClone.createNAC(cond.getBasisGraph().getName(), false);
            condClone.setUndoManager(this.undoManager);
            this.copyGraph(cond, condClone, table);
            this.copyMorph(cond.getMorphism(), condClone.getMorphism(), table);
        }
        Enumeration<EdPAC> pacs = r.getPACs().elements();
        while (pacs.hasMoreElements()) {
            EdPAC cond = pacs.nextElement();
            EdPAC condClone = ruleClone.createPAC(cond.getBasisGraph().getName(), false);
            condClone.setUndoManager(this.undoManager);
            this.copyGraph(cond, condClone, table);
            this.copyMorph(cond.getMorphism(), condClone.getMorphism(), table);
        }
        Enumeration<EdPAC> gacs = r.getNestedACs().elements();
        while (gacs.hasMoreElements()) {
            EdPAC cond = gacs.nextElement();
            EdNestedApplCond condClone = ruleClone.createNestedAC(cond.getBasisGraph().getName(), false);
            ((EdGraph)condClone).setUndoManager(this.undoManager);
            this.copyGraph(cond, condClone, table);
            this.copyMorph(cond.getMorphism(), condClone.getMorphism(), table);
        }
        CondTuple act = (CondTuple)ac.getConditions();
        CondTuple actOther = (CondTuple)acOther.getConditions();
        int i2 = 0;
        while (i2 < actOther.getSize()) {
            CondMember condOther = actOther.getCondMemberAt(i2);
            CondMember cond = (CondMember)act.addCondition(condOther.getExprAsText());
            cond.setMark(condOther.getMark());
            ++i2;
        }
        ruleClone.setGraGra(this);
        ruleClone.update();
        ruleClone.setUndoManager(this.undoManager);
        return ruleClone;
    }

    private void copyGraph(EdGraph from, EdGraph to, Hashtable<GraphObject, GraphObject> table) {
        for (Node bn1 : from.getBasisGraph().getNodesSet()) {
            Node bn2 = null;
            try {
                bn2 = to.getBasisGraph().copyNode(bn1);
                table.put(bn1, bn2);
                EdNode n1 = from.findNode(bn1);
                EdNode n2 = to.addNode(bn2, n1.getType());
                n2.setXY(n1.getX(), n1.getY());
                n2.getLNode().setFrozenByDefault(true);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        for (Arc ba1 : from.getBasisGraph().getArcsSet()) {
            Node src = (Node)table.get(ba1.getSource());
            Node tar = (Node)table.get(ba1.getTarget());
            Arc ba2 = null;
            try {
                ba2 = to.getBasisGraph().copyArc(ba1, src, tar);
                table.put(ba1, ba2);
                EdArc a1 = from.findArc(ba1);
                EdArc a2 = to.addArc(ba2, a1.getType());
                if (a2 == null) continue;
                if (a1.isLine()) {
                    if (a1.hasAnchor()) {
                        a2.setAnchor(new Point(a1.getAnchor()));
                    }
                } else if (a1.hasAnchor()) {
                    a2.setAnchor(1, new Point(a1.getX(), a1.getY()));
                    a2.setWidth(a1.getWidth());
                    a2.setHeight(a1.getHeight());
                }
                a2.setTextOffset(a1.getTextOffset().x, a1.getTextOffset().y);
                a2.getLArc().setFrozenByDefault(true);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
    }

    private void copyMorph(OrdinaryMorphism from, OrdinaryMorphism to, Hashtable<GraphObject, GraphObject> table) {
        for (GraphObject lgo : from.getDomainObjects()) {
            GraphObject rgo = from.getImage(lgo);
            GraphObject lgo1 = table.get(lgo);
            GraphObject rgo1 = table.get(rgo);
            try {
                to.addMapping(lgo1, rgo1);
            }
            catch (BadMappingException e) {
                e.printStackTrace();
            }
        }
    }

    public void sortRulesByPriority() {
        Vector<EdRule> v = new Vector<EdRule>(this.eRules.size());
        v.addAll(this.eRules);
        this.eRules.removeAllElements();
        this.bGraGra.sortRulesByPriority();
        List<Rule> rules = this.bGraGra.getListOfRules();
        int i = 0;
        while (i < rules.size()) {
            Rule r = rules.get(i);
            int j = 0;
            while (j < v.size()) {
                EdRule er = (EdRule)v.elementAt(j);
                if (er.getBasisRule().equals(r)) {
                    this.eRules.addElement(er);
                    break;
                }
                ++j;
            }
            ++i;
        }
        v.removeAllElements();
    }

    public void sortRulesByLayer() {
        Vector<EdRule> v = new Vector<EdRule>(this.eRules.size());
        v.addAll(this.eRules);
        this.eRules.removeAllElements();
        this.bGraGra.sortRulesByLayer();
        List<Rule> rules = this.bGraGra.getListOfRules();
        int i = 0;
        while (i < rules.size()) {
            Rule r = rules.get(i);
            int j = 0;
            while (j < v.size()) {
                EdRule er = (EdRule)v.elementAt(j);
                if (er.getBasisRule().equals(r)) {
                    this.eRules.addElement(er);
                    break;
                }
                ++j;
            }
            ++i;
        }
        v.removeAllElements();
    }

    public void sortConstraintsByLayer() {
        Vector<EdConstraint> v = new Vector<EdConstraint>(this.eConstraints.size());
        v.addAll(this.eConstraints);
        this.eConstraints.removeAllElements();
        this.bGraGra.sortConstraintsByLayer();
        Vector<Formula> constraints = this.bGraGra.getConstraintsVec();
        int i = 0;
        while (i < constraints.size()) {
            Formula f = constraints.elementAt(i);
            int j = 0;
            while (j < v.size()) {
                EdConstraint c = (EdConstraint)v.elementAt(j);
                if (c.getBasisConstraint().equals(f)) {
                    this.eConstraints.addElement(c);
                    break;
                }
                ++j;
            }
            ++i;
        }
        v.removeAllElements();
    }

    public void sortConstraintsByPriority() {
        Vector<EdConstraint> v = new Vector<EdConstraint>(this.eConstraints.size());
        v.addAll(this.eConstraints);
        this.eConstraints.removeAllElements();
        this.bGraGra.sortConstraintsByPriority();
        Vector<Formula> constraints = this.bGraGra.getConstraintsVec();
        int i = 0;
        while (i < constraints.size()) {
            Formula f = constraints.elementAt(i);
            int j = 0;
            while (j < v.size()) {
                EdConstraint c = (EdConstraint)v.elementAt(j);
                if (c.getBasisConstraint().equals(f)) {
                    this.eConstraints.addElement(c);
                    break;
                }
                ++j;
            }
            ++i;
        }
        v.removeAllElements();
    }

    public EdAtomic createAtomic(String atomicName) {
        if (atomicName != null) {
            EdAtomic a = new EdAtomic(this.bGraGra.createAtomic(atomicName), this.typeSet, atomicName);
            this.eAtomics.addElement(a);
            a.getLeft().setEditable(this.eGraph.isEditable());
            a.getRight().setEditable(this.eGraph.isEditable());
            a.setGraGra(this);
            a.setUndoManager(this.undoManager);
            this.isChanged = true;
            return a;
        }
        return null;
    }

    public boolean addAtomic(EdAtomic c) {
        if (c.getTypeSet().getBasisTypeSet().compareTo(this.typeSet.getBasisTypeSet())) {
            if (this.bGraGra.addAtomic(c.getBasisAtomic())) {
                Vector<Type> v = c.getBasisAtomic().getUsedTypes();
                this.bGraGra.getTypeSet().adaptTypes(v.elements(), false);
                this.typeSet.refreshTypes();
                c.update();
                c.setGraGra(this);
                c.setUndoManager(this.undoManager);
                c.getLeft().setEditable(this.eGraph.isEditable());
                c.getRight().setEditable(this.eGraph.isEditable());
                this.eAtomics.addElement(c);
                this.isChanged = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public EdConstraint createConstraint(String constrName) {
        EdConstraint e = null;
        if (constrName != null) {
            e = new EdConstraint(this.bGraGra.createConstraint(constrName), constrName);
            e.setVarSet(this.getAtomicsAsEvaluable(), this.getAtomicNames());
            e.setGraGra(this);
            this.eConstraints.addElement(e);
            this.isChanged = true;
        }
        return e;
    }

    public boolean addConstraint(EdConstraint c) {
        if (this.bGraGra.addConstraint(c.getBasisConstraint())) {
            c.setVarSet(this.getAtomicsAsEvaluable(), this.getAtomicNames());
            c.setGraGra(this);
            this.eConstraints.addElement(c);
            this.isChanged = true;
            return true;
        }
        return false;
    }

    public EdGraph createTypeGraph() {
        this.bGraGra.createTypeGraph();
        EdGraph tg = this.typeSet.createTypeGraph();
        tg.setGraGra(this);
        tg.setUndoManager(this.undoManager);
        return tg;
    }

    public void setTypeGraph(EdGraph tg) {
        this.typeSet.setTypeGraph(tg);
        tg.setGraGra(this);
        tg.setUndoManager(this.undoManager);
    }

    public boolean createTypeGraphFrom(EdGraph g) {
        this.bGraGra.createTypeGraph();
        this.getTypeSet().createTypeGraph();
        if (((TypeGraph)this.getTypeSet().getTypeGraph().getBasisGraph()).makeFromPlainGraph(g.getBasisGraph())) {
            this.bGraGra.getTypeSet().setLevelOfTypeGraph(10);
            this.getTypeGraph().doDefaultEvolutionaryGraphLayout(20);
            return true;
        }
        return false;
    }

    public Vector<EdGraph> createGraphs(Enumeration<Graph> basisGraphs) {
        while (basisGraphs.hasMoreElements()) {
            EdGraph g = new EdGraph(basisGraphs.nextElement(), this.typeSet);
            g.setGraGra(this);
            this.eGraphs.add(g);
        }
        return this.eGraphs;
    }

    public Vector<EdGraph> createGraphs(List<Graph> basisGraphs) {
        Iterator<Graph> graphIt = basisGraphs.iterator();
        while (graphIt.hasNext()) {
            EdGraph g = new EdGraph(graphIt.next(), this.typeSet);
            g.setGraGra(this);
            this.eGraphs.add(g);
        }
        return this.eGraphs;
    }

    public Vector<EdRule> createRules(List<Rule> basisRules) {
        int i = 0;
        while (i < basisRules.size()) {
            Rule basisRule = basisRules.get(i);
            EdRule r = null;
            r = basisRule instanceof RuleScheme ? new EdRuleScheme((RuleScheme)basisRule, this.typeSet) : new EdRule(basisRules.get(i), this.typeSet);
            r.setGraGra(this);
            r.getLeft().setEditable(this.eGraph.isEditable());
            r.getRight().setEditable(this.eGraph.isEditable());
            r.setEditable(true);
            this.eRules.addElement(r);
            ++i;
        }
        return this.eRules;
    }

    public Vector<EdAtomic> createAtomics(Enumeration<AtomConstraint> basisAtomics) {
        while (basisAtomics.hasMoreElements()) {
            EdAtomic a = new EdAtomic(basisAtomics.nextElement(), this.typeSet, "");
            a.setGraGra(this);
            a.getLeft().setEditable(this.eGraph.isEditable());
            a.getRight().setEditable(this.eGraph.isEditable());
            this.eAtomics.addElement(a);
        }
        return this.eAtomics;
    }

    public List<EdAtomic> createAtomics(List<AtomConstraint> basisAtomics) {
        Iterator<AtomConstraint> basisAtomicsIter = basisAtomics.iterator();
        while (basisAtomicsIter.hasNext()) {
            EdAtomic a = new EdAtomic(basisAtomicsIter.next(), this.typeSet, "");
            a.setGraGra(this);
            a.getLeft().setEditable(this.eGraph.isEditable());
            a.getRight().setEditable(this.eGraph.isEditable());
            this.eAtomics.addElement(a);
        }
        return this.eAtomics;
    }

    public Vector<EdConstraint> createConstraints(Enumeration<Formula> formulae) {
        while (formulae.hasMoreElements()) {
            Formula f = formulae.nextElement();
            EdConstraint c = new EdConstraint(f, f.getName());
            c.setGraGra(this);
            this.eConstraints.addElement(c);
        }
        return this.eConstraints;
    }

    public List<EdConstraint> createConstraints(List<Formula> formulae) {
        for (Formula f : formulae) {
            EdConstraint c = new EdConstraint(f, f.getName());
            c.setGraGra(this);
            this.eConstraints.addElement(c);
        }
        return this.eConstraints;
    }

    public int getIndexOfRule(EdRule r) {
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule er = this.eRules.get(i);
            if (er == r) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public EdRule getRule(int i) {
        return this.eRules.elementAt(i);
    }

    public EdRule getRule(String rname) {
        int i = 0;
        while (i < this.eRules.size()) {
            Rule r;
            EdRule er = this.eRules.get(i);
            if (er.getBasisRule().getRuleScheme() == null ? er.getBasisRule().getName().equals(rname) : (r = er.getBasisRule().getRuleScheme().getRule(rname)) != null && (er = this.getRuleScheme(er.getBasisRule().getRuleScheme()).getRule(rname)) != null) {
                return er;
            }
            ++i;
        }
        return null;
    }

    public EdRule getRule(Rule r) {
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule er = this.eRules.get(i);
            if (er.getBasisRule() == r) {
                return er;
            }
            ++i;
        }
        return null;
    }

    public EdRule getRule(Graph g) {
        int i = 0;
        while (i < this.eRules.size()) {
            EdRuleScheme rs;
            EdRule r;
            EdRule er = this.eRules.get(i);
            if (er.getBasisRule().getLeft() == g || er.getBasisRule().getRight() == g) {
                return er;
            }
            if (er.getBasisRule() instanceof RuleScheme && (r = (rs = (EdRuleScheme)this.getRule(er.getBasisRule())).getRule(g)) != null) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public EdRuleScheme getRuleScheme(Graph g) {
        int i = 0;
        while (i < this.eRules.size()) {
            EdRuleScheme rs;
            EdRule er = this.eRules.get(i);
            if (er.getBasisRule() instanceof RuleScheme && (rs = (EdRuleScheme)this.getRule(er.getBasisRule())).getRule(g) != null) {
                return rs;
            }
            ++i;
        }
        return null;
    }

    public EdRuleScheme getRuleScheme(Rule r) {
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule er = this.eRules.get(i);
            if (er instanceof EdRuleScheme && r.getRuleScheme() != null && er.getBasisRule().getRuleScheme() == r.getRuleScheme()) {
                return (EdRuleScheme)er;
            }
            ++i;
        }
        return null;
    }

    public boolean isRuleAnimated(Rule r) {
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule er = this.eRules.get(i);
            if (r instanceof AmalgamatedRule) {
                return false;
            }
            if (er.getBasisRule().equals(r) && er.isAnimated()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public EdAtomic getAtomic(int i) {
        return this.eAtomics.elementAt(i);
    }

    public EdAtomic getAtomic(String name) {
        int i = 0;
        while (i < this.eAtomics.size()) {
            EdAtomic ac = this.eAtomics.get(i);
            if (ac.getBasisAtomic().getAtomicName().equals(name)) {
                return ac;
            }
            ++i;
        }
        return null;
    }

    public EdConstraint getConstraint(int i) {
        return this.eConstraints.elementAt(i);
    }

    public void removeTypeGraph() {
        if (this.bGraGra == null) {
            return;
        }
        if (this.typeSet.getTypeGraph() == null) {
            return;
        }
        this.typeSet.removeTypeGraph();
        this.bGraGra.removeTypeGraph();
    }

    public void destroyTypeGraph() {
        if (this.bGraGra == null) {
            return;
        }
        if (this.typeSet.getTypeGraph() == null) {
            return;
        }
        this.bGraGra.destroyTypeGraph();
    }

    public EdGraph getGraphOf(Graph basisGraph) {
        int i = 0;
        while (i < this.eGraphs.size()) {
            EdGraph eg = this.eGraphs.get(i);
            if (eg.getBasisGraph() == basisGraph) {
                return eg;
            }
            ++i;
        }
        return null;
    }

    public EdGraph getGraphOf(EdGraphObject go) {
        int i = 0;
        while (i < this.eGraphs.size()) {
            EdGraph g = this.eGraphs.get(i);
            if (g.getBasisGraph() == go.getBasisObject().getContext()) {
                return g;
            }
            ++i;
        }
        Enumeration<EdRule> rules = this.eRules.elements();
        while (rules.hasMoreElements()) {
            EdRule r = rules.nextElement();
            if (r.getLeft().getBasisGraph() == go.getBasisObject().getContext()) {
                return r.getLeft();
            }
            if (r.getRight().getBasisGraph() == go.getBasisObject().getContext()) {
                return r.getRight();
            }
            if (r.getNACs().isEmpty()) continue;
            int j = 0;
            while (j < r.getNACs().size()) {
                EdNAC nac = r.getNACs().get(j);
                if (nac.getBasisGraph() == go.getBasisObject().getContext()) {
                    return nac;
                }
                ++j;
            }
        }
        Enumeration<EdAtomic> atomics = this.eAtomics.elements();
        while (atomics.hasMoreElements()) {
            EdAtomic a = atomics.nextElement();
            Vector<EdAtomic> conclusions = a.getConclusions();
            if (conclusions.isEmpty()) continue;
            EdAtomic c = conclusions.elementAt(0);
            if (c.getLeft().getBasisGraph() == go.getBasisObject().getContext()) {
                return c.getLeft();
            }
            int j = 0;
            while (j < conclusions.size()) {
                c = conclusions.elementAt(j);
                if (c.getRight().getBasisGraph() == go.getBasisObject().getContext()) {
                    return c.getRight();
                }
                ++j;
            }
        }
        if (this.startGraph != null && this.startGraph.getBasisGraph() == go.getBasisObject().getContext()) {
            return this.startGraph;
        }
        if (this.typeSet.getTypeGraph() != null && this.typeSet.getTypeGraph().getBasisGraph() == go.getBasisObject().getContext()) {
            return this.typeSet.getTypeGraph();
        }
        return null;
    }

    private boolean containsGraph(EdGraph g) {
        if (g.getBasisGraph() == null) {
            return false;
        }
        if (this.bGraGra.isElement(g.getBasisGraph())) {
            return true;
        }
        if (this.bGraGra.getTypeGraph() == g.getBasisGraph()) {
            return true;
        }
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule r = this.eRules.get(i);
            if (r.getBasisRule().getRuleScheme() == null ? r.getBasisRule().isElement(g.getBasisGraph()) : r.getBasisRule().getRuleScheme().isElement(g.getBasisGraph())) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.eAtomics.size()) {
            EdAtomic a = this.eAtomics.get(i);
            if (a.getBasisAtomic().isElement(g.getBasisGraph())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector<EdGraphObject> getGraphObjectsOfType(EdType t, boolean fromTypeGraph) {
        Vector<EdGraphObject> vec = new Vector<EdGraphObject>();
        List<EdGraphObject> users = this.typeSet.getTypeUsers(t);
        int i = 0;
        while (i < users.size()) {
            EdGraphObject go = users.get(i);
            EdGraph g = go.getContext();
            if (g != null) {
                if (g.isTypeGraph() && fromTypeGraph && g == this.getTypeGraph()) {
                    vec.add(go);
                } else if (this.containsGraph(g)) {
                    vec.add(go);
                } else if (this.startGraph == g) {
                    vec.add(go);
                }
            }
            ++i;
        }
        return vec;
    }

    public Vector<String> deleteGraphObjectsOfTypeFromRule(EdType t, EdRule r, boolean addToUndo) {
        Vector<String> failed = new Vector<String>(5);
        if (r.getBasisRule().getRuleScheme() == null) {
            if (!r.deleteGraphObjectsOfType(t, addToUndo) && failed.isEmpty()) {
                failed.add(r.getName());
            }
        } else if (!((EdRuleScheme)r).deleteGraphObjectsOfType(t, addToUndo) && failed.isEmpty()) {
            failed.add(r.getName());
        }
        return failed;
    }

    public Vector<String> deleteGraphObjectsOfTypeFromRule(EdGraphObject tgo, EdRule r, boolean addToUndo) {
        Vector<String> failed = new Vector<String>(5);
        if (r.getBasisRule().getRuleScheme() == null) {
            if (!r.deleteGraphObjectsOfType(tgo, addToUndo) && failed.isEmpty()) {
                failed.add(r.getName());
            }
        } else if (!((EdRuleScheme)r).deleteGraphObjectsOfType(tgo, addToUndo) && failed.isEmpty()) {
            failed.add(r.getName());
        }
        return failed;
    }

    public Vector<String> deleteGraphObjectsOfTypeFromAtomicGraphConstraint(EdType t, EdAtomic a, boolean addToUndo) {
        Vector<String> failed = new Vector<String>(5);
        Vector<EdAtomic> conclusions = a.getConclusions();
        int i = 0;
        while (i < conclusions.size()) {
            EdAtomic c = (EdAtomic)conclusions.get(i);
            List<EdGraphObject> list = c.getLeft().getGraphObjectsOfType(t);
            int j = 0;
            while (j < list.size()) {
                EdGraphObject imggo;
                EdGraphObject go = list.get(j);
                GraphObject img = c.getMorphism().getImage(go.getBasisObject());
                if (img != null && (imggo = c.getRight().findGraphObject(img)) != null) {
                    c.addDeletedMappingToUndo(go, imggo);
                }
                ++j;
            }
            if (!c.getRight().deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
                failed.add(c.getName());
            }
            ++i;
        }
        if (!a.getLeft().deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
            failed.add(a.getBasisAtomic().getAtomicName());
        }
        return failed;
    }

    public Vector<String> deleteGraphObjectsOfTypeFromAtomicGraphConstraint(EdGraphObject tgo, EdAtomic a, boolean addToUndo) {
        Vector<String> failed = new Vector<String>(5);
        Vector<EdAtomic> conclusions = a.getConclusions();
        int i = 0;
        while (i < conclusions.size()) {
            EdAtomic c = (EdAtomic)conclusions.get(i);
            List<EdGraphObject> list = c.getLeft().getGraphObjectsOfType(tgo);
            int j = 0;
            while (j < list.size()) {
                EdGraphObject imggo;
                EdGraphObject go = list.get(j);
                GraphObject img = c.getMorphism().getImage(go.getBasisObject());
                if (img != null && (imggo = c.getRight().findGraphObject(img)) != null) {
                    c.addDeletedMappingToUndo(go, imggo);
                }
                ++j;
            }
            if (!c.getRight().deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
                failed.add(c.getName());
            }
            ++i;
        }
        if (!a.getLeft().deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
            failed.add(a.getBasisAtomic().getAtomicName());
        }
        return failed;
    }

    public boolean deleteGraphObjectsOfTypeFromHostGraph(EdGraphObject tgo, boolean addToUndo) {
        return this.getGraph().deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo);
    }

    public String kernelRuleContainsObjsOfType(EdGraphObject tgo) {
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule kernRule;
            EdRule r = this.eRules.get(i);
            if (r instanceof EdRuleScheme && ((kernRule = ((EdRuleScheme)r).getKernelRule()).getLeft().getGraphObjectsOfType(tgo).size() > 0 || kernRule.getRight().getGraphObjectsOfType(tgo).size() > 0)) {
                String failed = String.valueOf(((EdRuleScheme)r).getName()) + "." + kernRule.getName();
                return failed;
            }
            ++i;
        }
        return null;
    }

    public String kernelRuleContainsObjsOfType(EdType t) {
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule kernRule;
            EdRule r = this.eRules.get(i);
            if (r instanceof EdRuleScheme && ((kernRule = ((EdRuleScheme)r).getKernelRule()).getLeft().getGraphObjectsOfType(t).size() > 0 || kernRule.getRight().getGraphObjectsOfType(t).size() > 0)) {
                String failed = String.valueOf(((EdRuleScheme)r).getName()) + "." + kernRule.getName();
                return failed;
            }
            ++i;
        }
        return null;
    }

    public List<String> deleteGraphObjectsOfType(EdGraphObject tgo, boolean fromTypeGraph, boolean addToUndo) {
        Vector<String> failed = new Vector<String>(5);
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule r = this.eRules.get(i);
            failed.addAll(this.deleteGraphObjectsOfTypeFromRule(tgo, r, addToUndo));
            ++i;
        }
        i = 0;
        while (i < this.eGraphs.size()) {
            EdGraph g = this.eGraphs.get(i);
            if (!g.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
                failed.add(g.getName());
            }
            ++i;
        }
        if (this.startGraph != null && !this.startGraph.deleteGraphObjectsOfTypeFromGraph(tgo, false)) {
            failed.add(String.valueOf(this.startGraph.getName()) + "(StartG)");
        }
        i = 0;
        while (i < this.eAtomics.size()) {
            EdAtomic a = this.eAtomics.get(i);
            failed.addAll(this.deleteGraphObjectsOfTypeFromAtomicGraphConstraint(tgo, a, addToUndo));
            ++i;
        }
        if (this.typeSet.getTypeGraph() != null && fromTypeGraph && !this.typeSet.getTypeGraph().deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
            failed.add(this.typeSet.getTypeGraph().getName());
        }
        return failed;
    }

    public List<String> deleteGraphObjectsOfType(EdType t, boolean fromTypeGraph, boolean addToUndo) {
        Vector<String> failed = new Vector<String>(5);
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule r = this.eRules.get(i);
            failed.addAll(this.deleteGraphObjectsOfTypeFromRule(t, r, addToUndo));
            ++i;
        }
        i = 0;
        while (i < this.eGraphs.size()) {
            EdGraph g = this.eGraphs.get(i);
            if (!g.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
                failed.add(g.getName());
            }
            ++i;
        }
        if (this.startGraph != null && !this.startGraph.deleteGraphObjectsOfTypeFromGraph(t, false)) {
            failed.add(String.valueOf(this.startGraph.getName()) + "(StartG)");
        }
        i = 0;
        while (i < this.eAtomics.size()) {
            EdAtomic a = this.eAtomics.get(i);
            failed.addAll(this.deleteGraphObjectsOfTypeFromAtomicGraphConstraint(t, a, addToUndo));
            ++i;
        }
        if (this.typeSet.getTypeGraph() != null && fromTypeGraph && !this.typeSet.getTypeGraph().deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
            failed.add(this.typeSet.getTypeGraph().getName());
        }
        return failed;
    }

    public void destroyAllMatches() {
        this.bGraGra.destroyAllMatches();
    }

    public void removeRule(EdRule er) {
        this.removeRule(er, false);
    }

    public boolean removeRule(EdRule er, boolean dispose) {
        if (this.bGraGra == null) {
            return false;
        }
        if (er != null && er.getBasisRule() != null && this.bGraGra.removeRule(er.getBasisRule())) {
            this.eRules.removeElement(er);
            if (dispose) {
                er.dispose();
                this.bGraGra.destroyRule(er.getBasisRule());
                er.unsetBasisRule();
            }
            this.isChanged = true;
            return true;
        }
        return false;
    }

    public void destroyRule(EdRule er) {
        if (this.bGraGra == null) {
            return;
        }
        if (er != null && er.getBasisRule() != null) {
            this.eRules.removeElement(er);
            this.bGraGra.removeRule(er.getBasisRule());
            er.dispose();
            this.bGraGra.destroyRule(er.getBasisRule());
            er.unsetBasisRule();
            this.isChanged = true;
        }
    }

    public void removeRules() {
        while (this.eRules.size() != 0) {
            this.removeRule(this.eRules.elementAt(0));
        }
    }

    public boolean removeAtomic(EdAtomic atom) {
        if (this.bGraGra == null) {
            return false;
        }
        if (atom == null) {
            return false;
        }
        if (atom.getMorphism() != null) {
            this.bGraGra.removeAtomic(atom.getBasisAtomic());
            this.eAtomics.removeElement(atom);
            this.isChanged = true;
            return true;
        }
        return false;
    }

    public void destroyAtomic(EdAtomic atom) {
        if (this.bGraGra == null) {
            return;
        }
        if (atom == null) {
            return;
        }
        if (atom.getMorphism() != null) {
            if (this.eAtomics.contains(atom)) {
                this.eAtomics.removeElement(atom);
            }
            this.bGraGra.destroyAtomic(atom.getBasisAtomic());
            this.isChanged = true;
        }
    }

    public void removeAtomics() {
        while (this.eAtomics.size() != 0) {
            this.removeAtomic(this.eAtomics.elementAt(0));
        }
    }

    public void destroyConstraint(EdConstraint constr) {
        if (this.bGraGra == null) {
            return;
        }
        if (constr == null) {
            return;
        }
        if (constr.getBasisConstraint() != null) {
            this.eConstraints.removeElement(constr);
            this.bGraGra.destroyConstraint(constr.getBasisConstraint());
            this.isChanged = true;
        }
    }

    public boolean removeConstraint(EdConstraint constr) {
        if (this.bGraGra == null) {
            return false;
        }
        if (constr == null) {
            return false;
        }
        if (constr.getBasisConstraint() != null) {
            this.bGraGra.destroyConstraint(constr.getBasisConstraint());
            this.eConstraints.removeElement(constr);
            this.isChanged = true;
            return true;
        }
        return false;
    }

    public void removeConstraints() {
        while (this.eConstraints.size() != 0) {
            this.removeConstraint(this.eConstraints.elementAt(0));
        }
    }

    public void clear() {
        if (this.typeSet.getTypeGraph() != null) {
            this.typeSet.getTypeGraph().clearSelected();
        }
        int i = 0;
        while (i < this.eGraphs.size()) {
            EdGraph g = this.eGraphs.elementAt(i);
            g.clearSelected();
            ++i;
        }
        i = 0;
        while (i < this.eRules.size()) {
            EdRule r = this.eRules.elementAt(i);
            if (r != null) {
                r.destroyMatch();
                r.update();
                r.getLeft().clearSelected();
                r.getRight().clearSelected();
                int j = 0;
                while (j < r.getNACs().size()) {
                    r.getNACs().elementAt(j).clearSelected();
                    ++j;
                }
            }
            ++i;
        }
        this.bGraGra.destroyAllMatches();
        i = 0;
        while (i < this.eAtomics.size()) {
            EdAtomic a = this.eAtomics.elementAt(i);
            a.getLeft().clearSelected();
            a.getRight().clearSelected();
            ++i;
        }
    }

    public void setVisibilityOfGraphObjectsOfType(EdType type, boolean vis) {
        if (this.getTypeGraph() != null) {
            EdArc a;
            int j;
            int i;
            int oldhidden = this.getTypeGraph().hidden;
            if (type.isNodeType()) {
                Vector<EdNode> list = new Vector<EdNode>();
                i = 0;
                while (i < this.getTypeGraph().nodes.size()) {
                    EdNode n = this.getTypeGraph().nodes.get(i);
                    if (type.getBasisType().isParentOf(n.getType().getBasisType())) {
                        n.getType().getBasisType().setVisibilityOfObjectsOfTypeGraphNode(vis);
                        this.getTypeGraph().hidden = vis ? this.getTypeGraph().hidden - 1 : this.getTypeGraph().hidden + 1;
                        list.add(n);
                    }
                    ++i;
                }
                j = 0;
                while (j < this.getTypeGraph().arcs.size()) {
                    a = this.getTypeGraph().arcs.get(j);
                    if (list.contains(a.getSource()) || list.contains(a.getTarget())) {
                        a.getType().getBasisType().setVisibityOfObjectsOfTypeGraphArc(a.getSource().getType().getBasisType(), a.getTarget().getType().getBasisType(), vis);
                        this.getTypeGraph().hidden = vis ? this.getTypeGraph().hidden - 1 : this.getTypeGraph().hidden + 1;
                    }
                    ++j;
                }
            } else {
                Vector<EdArc> edges = this.getTypeGraph().getArcs(type);
                j = 0;
                while (j < edges.size()) {
                    a = edges.get(j);
                    type.getBasisType().setVisibityOfObjectsOfTypeGraphArc(a.getSource().getType().getBasisType(), a.getTarget().getType().getBasisType(), vis);
                    this.getTypeGraph().hidden = vis ? this.getTypeGraph().hidden - 1 : this.getTypeGraph().hidden + 1;
                    ++j;
                }
            }
            Vector<EdGraph> graphs = this.getGraphs();
            i = 0;
            while (i < graphs.size()) {
                ((EdGraph)graphs.get((int)i)).visibilityChecked = oldhidden == this.getTypeGraph().hidden;
                ++i;
            }
        }
    }

    public synchronized void update() {
        if (this.typeSet.getTypeGraph() != null) {
            this.typeSet.getTypeGraph().setGraGra(this);
            this.typeSet.getTypeGraph().markTypeGraph(true);
            this.typeSet.getTypeGraph().updateGraph();
        }
        int i = 0;
        while (i < this.eGraphs.size()) {
            EdGraph g = this.eGraphs.get(i);
            g.setTypeSet(this.typeSet);
            g.updateGraph();
            ++i;
        }
        this.updateRules();
        this.updateConstraints();
    }

    public synchronized void update(boolean attrsVisible) {
        if (this.typeSet.getTypeGraph() == null && this.typeSet.getBasisTypeSet().getTypeGraph() != null) {
            this.typeSet.createTypeGraph();
        }
        if (this.typeSet.getTypeGraph() != null) {
            this.typeSet.getTypeGraph().setGraGra(this);
            this.typeSet.getTypeGraph().markTypeGraph(true);
            this.typeSet.getTypeGraph().updateGraph(true, true);
        }
        int i = 0;
        while (i < this.eGraphs.size()) {
            EdGraph g = this.eGraphs.get(i);
            g.setTypeSet(this.typeSet);
            g.updateGraph(attrsVisible);
            ++i;
        }
        this.updateRules();
        this.updateConstraints();
    }

    public synchronized void updateRules() {
        int i = 0;
        while (i < this.eRules.size()) {
            if (this.eRules.elementAt(i) != null) {
                EdRule er = this.eRules.elementAt(i);
                er.setTypeSet(this.typeSet);
                int j = 0;
                while (j < er.getNACs().size()) {
                    EdNAC nac = er.getNACs().elementAt(j);
                    nac.setTypeSet(this.typeSet);
                    ++j;
                }
                er.update();
            }
            ++i;
        }
    }

    public synchronized void updateConstraints() {
        int i = 0;
        while (i < this.eAtomics.size()) {
            EdAtomic a = this.getAtomic(i);
            if (a != null) {
                a.setTypeSet(this.typeSet);
                a.update();
            }
            ++i;
        }
        i = 0;
        while (i < this.eConstraints.size()) {
            EdConstraint c = this.getConstraint(i);
            if (c != null) {
                c.update();
            }
            ++i;
        }
    }

    public void makeLayoutOfBasisGraphs() {
        int j;
        Vector<StateEditable> list;
        if (this.typeSet.getTypeGraph() != null) {
            this.typeSet.getTypeGraph().layoutBasisGraph(new Dimension(800, 600));
        }
        int i = 0;
        while (i < this.eGraphs.size()) {
            EdGraph g = this.eGraphs.get(i);
            g.layoutBasisGraph(new Dimension(800, 600));
            ++i;
        }
        i = 0;
        while (i < this.eRules.size()) {
            EdRule er = this.eRules.elementAt(i);
            er.getLeft().layoutBasisGraph(new Dimension(400, 300));
            er.getRight().layoutBasisGraph(new Dimension(400, 300));
            list = er.getNACs();
            j = 0;
            while (j < list.size()) {
                ((EdNAC)list.get(j)).layoutBasisGraph(new Dimension(400, 300));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.eAtomics.size()) {
            EdAtomic a = this.getAtomic(i);
            a.getLeft().layoutBasisGraph(new Dimension(400, 300));
            list = a.getConclusions();
            j = 0;
            while (j < list.size()) {
                ((EdAtomic)list.get(j)).getRight().layoutBasisGraph(new Dimension(400, 300));
                ++j;
            }
            ++i;
        }
    }

    public EdTypeSet getTypeSet() {
        return this.typeSet;
    }

    void setTypeSet(EdTypeSet types) {
        this.typeSet = types;
    }

    public Vector<EdType> getNodeTypes() {
        return this.typeSet.getNodeTypes();
    }

    public void setNodeTypes(Vector<EdType> nTypes) {
        this.typeSet.setNodeTypes(nTypes);
    }

    public Vector<EdType> getArcTypes() {
        return this.typeSet.getArcTypes();
    }

    public void setArcTypes(Vector<EdType> aTypes) {
        this.typeSet.setArcTypes(aTypes);
    }

    public EdType getSelectedNodeType() {
        return this.typeSet.getSelectedNodeType();
    }

    public void setSelectedNodeType(EdType et) {
        this.typeSet.setSelectedNodeType(et);
    }

    public EdType getSelectedArcType() {
        return this.typeSet.getSelectedArcType();
    }

    public void setSelectedArcType(EdType et) {
        this.typeSet.setSelectedArcType(et);
    }

    public EdType newNodeType(String tname, int shape, Color color, boolean filledShape, String iconFileName) {
        return this.typeSet.createNodeType(tname, shape, color, filledShape, iconFileName);
    }

    public EdType newNodeType(Type baseType, String tname, int shape, Color color, boolean filledShape, String iconFileName) {
        return this.typeSet.createNodeType(baseType, tname, shape, color, filledShape, iconFileName);
    }

    public EdType createDefaultNodeType(Type baseType) {
        return this.typeSet.createDefaultNodeType(baseType);
    }

    public EdType newArcType(String tname, int shape, Color color, boolean bold) {
        return this.typeSet.createArcType(tname, shape, color, bold);
    }

    public EdType newArcType(Type baseType, String tname, int shape, Color color, boolean bold) {
        return this.typeSet.createArcType(baseType, tname, shape, color, bold);
    }

    public EdType createDefaultArcType(Type baseType) {
        return this.typeSet.createDefaultArcType(baseType);
    }

    public void removeLayout() {
        this.typeSet.getNodeTypes().removeAllElements();
        this.typeSet.getArcTypes().removeAllElements();
        this.eGraph.getArcs().removeAllElements();
        this.eGraph.getNodes().removeAllElements();
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule r = this.eRules.elementAt(i);
            if (r != null) {
                r.getLeft().getArcs().removeAllElements();
                r.getLeft().getNodes().removeAllElements();
                r.getRight().getArcs().removeAllElements();
                r.getRight().getNodes().removeAllElements();
                int j = 0;
                while (j < r.getNACs().size()) {
                    EdNAC nac = r.getNACs().elementAt(j);
                    nac.getArcs().removeAllElements();
                    nac.getNodes().removeAllElements();
                    ++j;
                }
            }
            ++i;
        }
    }

    public boolean compareTo(EdGraGra gra) {
        if (this.bGraGra == null || gra.getBasisGraGra() == null) {
            return false;
        }
        return this.bGraGra.compareTo(gra.getBasisGraGra());
    }

    public boolean compareTo(EdGraGra gra, boolean transOption) {
        if (this.bGraGra == null || gra.getBasisGraGra() == null) {
            return false;
        }
        return this.bGraGra.compareTo(gra.getBasisGraGra(), transOption);
    }

    public void setEditable(boolean b) {
        if (this.typeSet.getTypeGraph() != null) {
            this.typeSet.getTypeGraph().setEditable(b);
        }
        this.eGraph.setEditable(b);
        int i = 0;
        while (i < this.eRules.size()) {
            EdRule r = this.eRules.elementAt(i);
            r.setEditable(b);
            ++i;
        }
        i = 0;
        while (i < this.eAtomics.size()) {
            EdAtomic a = this.eAtomics.elementAt(i);
            a.setEditable(b);
            ++i;
        }
    }

    public boolean isEditable() {
        return this.eGraph.isEditable();
    }

    public void setChanged(boolean b) {
        this.isChanged = b;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public Vector<Rule> getApplicableRules(MorphCompletionStrategy strategy) {
        boolean changed = this.isChanged;
        Vector<Rule> applicableRules = null;
        applicableRules = this.bGraGra.getApplicableRules(strategy);
        this.isChanged = changed;
        return applicableRules;
    }

    public void dismissRuleApplicability() {
        this.bGraGra.dismissRuleApplicability();
    }

    public String checkNodeTypeMultiplicity(EdNode typeNode) {
        return this.bGraGra.checkNodeTypeMultiplicity(typeNode.getBasisNode());
    }

    public String checkEdgeTypeMultiplicity(EdArc typeArc) {
        return this.bGraGra.checkEdgeTypeMultiplicity(typeArc.getBasisArc());
    }

    public void trimToSize() {
        this.bGraGra.trimToSize();
        this.typeSet.trimToSize();
        this.eGraphs.trimToSize();
        int i = 0;
        while (i < this.eGraphs.size()) {
            this.eGraphs.get(i).trimToSize();
            ++i;
        }
        this.eRules.trimToSize();
        i = 0;
        while (i < this.eRules.size()) {
            this.eRules.get(i).trimToSize();
            ++i;
        }
        this.eAtomics.trimToSize();
        i = 0;
        while (i < this.eAtomics.size()) {
            this.eAtomics.get(i).trimToSize();
            ++i;
        }
        this.eConstraints.trimToSize();
        if (this.startGraph != null) {
            this.startGraph.trimToSize();
        }
    }

    public boolean save() {
        if (this.dirName.equals("")) {
            this.dirName = System.getProperty("user.dir");
        }
        if (this.fileName.equals("")) {
            return false;
        }
        return this.saveToXML(this.fileName);
    }

    public boolean save(String fname) {
        if (fname.equals("")) {
            return this.save();
        }
        if (this.dirName.equals("")) {
            this.dirName = System.getProperty("user.dir");
        }
        return this.saveToXML(fname);
    }

    private boolean saveToXML(String fname) {
        this.trimToSize();
        XMLHelper xmlh = new XMLHelper();
        xmlh.addTopObject(this);
        if (xmlh.save_to_xml(String.valueOf(this.dirName) + File.separator + fname)) {
            this.isChanged = false;
            return true;
        }
        return false;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        this.typeSet.enrichAdditionalReprOfNodeType();
        h.addTopObject(this.bGraGra);
        h.openObject(this.bGraGra, this);
        int i = 0;
        while (i < this.typeSet.getNodeTypes().size()) {
            h.addObject("", this.typeSet.getNodeTypes().get(i), true);
            ++i;
        }
        Enumeration<Type> types = this.layoutPatterns.keys();
        while (types.hasMoreElements()) {
            Type t = types.nextElement();
            Vector<LayoutPattern> lpatternsVec = this.layoutPatterns.get(t);
            if (lpatternsVec == null || lpatternsVec.isEmpty()) continue;
            h.openSubTag("Layout");
            h.addObject("type", t, false);
            h.addEnumeration("", lpatternsVec.elements(), true);
            h.close();
        }
        h.close();
        int j = 0;
        while (j < this.eGraphs.size()) {
            h.addObject("", this.eGraphs.elementAt(j), true);
            ++j;
        }
        j = 0;
        while (j < this.eRules.size()) {
            h.addObject("", this.eRules.elementAt(j), true);
            ++j;
        }
        j = 0;
        while (j < this.getAtomics().size()) {
            h.addObject("", this.getAtomic(j), true);
            ++j;
        }
        j = 0;
        while (j < this.getConstraints().size()) {
            h.addObject("", this.getConstraint(j), true);
            ++j;
        }
        if (this.typeSet.getTypeGraph() != null) {
            h.addObject("", this.typeSet.getTypeGraph(), true);
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        h.peekObject(this.bGraGra, this);
        int i = 0;
        while (i < this.typeSet.getNodeTypes().size()) {
            EdType et = this.typeSet.getNodeTypes().get(i);
            h.enrichObject(et);
            ++i;
        }
        if (h.readSubTag("Layout")) {
            boolean firstsubtag = true;
            while (firstsubtag || h.readSubTag("Layout")) {
                firstsubtag = false;
                Type t = (Type)h.getObject("type", null, false);
                if (t != null) {
                    Enumeration<Element> en = h.getEnumeration("", null, true, "LayoutPattern");
                    while (en.hasMoreElements()) {
                        h.peekElement(en.nextElement());
                        LayoutPattern lp = new LayoutPattern(t);
                        h.loadObject(lp);
                        this.addLayoutPattern(t, lp);
                        h.close();
                    }
                }
                h.close();
            }
            Vector<Arc> inheritArcs = this.typeSet.getBasisTypeSet().getInheritanceArcs();
            this.createInheritancePattern(inheritArcs);
            h.close();
        }
        if (this.typeSet.getTypeGraph() != null) {
            h.enrichObject(this.typeSet.getTypeGraph());
            this.typeSet.getTypeGraph().setGraGra(this);
        }
        int j = 0;
        while (j < this.eGraphs.size()) {
            EdGraph g = this.eGraphs.elementAt(j);
            h.enrichObject(g);
            ++j;
        }
        j = 0;
        while (j < this.eAtomics.size()) {
            EdAtomic a = this.eAtomics.get(j);
            h.enrichObject(a);
            ++j;
        }
        j = 0;
        while (j < this.getConstraints().size()) {
            EdConstraint c = this.getConstraint(j);
            h.enrichObject(c);
            Vector<Evaluable> atomics = new Vector<Evaluable>();
            atomics.addAll(this.bGraGra.getListOfAtomics());
            c.setVarSet(atomics, this.getAtomicNames());
            ++j;
        }
        j = 0;
        while (j < this.eRules.size()) {
            EdRule r = this.eRules.elementAt(j);
            h.enrichObject(r);
            ++j;
        }
        this.startGraph = this.eGraph != null ? this.makeStartGraphFrom(this.eGraph) : new EdGraph(this.getTypeSet());
        this.isChanged = false;
        this.trimToSize();
    }

    private EdGraph makeStartGraphFrom(EdGraph g) {
        EdGraph sg = g.copy();
        sg.setCurrentLayoutToDefault(true);
        sg.getBasisGraph().setName(sg.getBasisGraph().getName());
        sg.setGraGra(this);
        this.getBasisGraGra().setStartGraph(sg.getBasisGraph());
        return sg;
    }

    public void createInheritancePattern(Vector<Arc> inheritanceArcs) {
        int i = 0;
        while (i < inheritanceArcs.size()) {
            Arc inharc = inheritanceArcs.get(i);
            Vector<LayoutPattern> v = this.getLayoutPatternsForType(inharc.getType());
            v.clear();
            this.createLayoutPattern("ver_tree", "edge", inharc.getType(), 'y', -1);
            this.createLayoutPattern("edge_length", "edge", inharc.getType(), 150);
            ++i;
        }
    }

    public void createLayoutPattern(String pname, String pType, Type type, char offsetType, int offset) {
        LayoutPattern lp = new LayoutPattern(pname, pType, type, offsetType, offset);
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        int i = 0;
        while (i < v.size()) {
            if (v.get(i).isSimilarTo(lp)) {
                v.remove(i);
                --i;
            }
            ++i;
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void createLayoutPattern(String pname, String pType, Type type, int length) {
        LayoutPattern lp = new LayoutPattern(pname, pType, type, length);
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        int i = 0;
        while (i < v.size()) {
            if (v.get(i).isSimilarTo(lp)) {
                v.remove(i);
                --i;
            }
            ++i;
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void createLayoutPattern(String pName, String pType, Type type, boolean frozen) {
        LayoutPattern lp = new LayoutPattern(pName, pType, type, frozen);
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        int i = 0;
        while (i < v.size()) {
            if (v.get(i).isSimilarTo(lp)) {
                v.remove(i);
                --i;
            }
            ++i;
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void addLayoutPattern(Type type, LayoutPattern lp) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        int i = 0;
        while (i < v.size()) {
            if (v.get(i).isSimilarTo(lp)) {
                v.remove(i);
                --i;
            }
            ++i;
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void removeLayoutPattern(Type type) {
        this.layoutPatterns.remove(type);
    }

    public void removeLayoutPattern(Type type, String patternName) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null || v.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < v.size()) {
            LayoutPattern lp = v.get(i);
            if (lp.getName().equals(patternName)) {
                v.remove(lp);
                --i;
            }
            ++i;
        }
        this.layoutPatterns.put(type, v);
    }

    public void removeAllLayoutPattern() {
        this.layoutPatterns.clear();
    }

    public Hashtable<Type, Vector<LayoutPattern>> getLayoutPatterns() {
        return this.layoutPatterns;
    }

    public void clearLayoutPatterns() {
        this.layoutPatterns.clear();
    }

    public Vector<LayoutPattern> getLayoutPatternsForType(Type type) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
            this.layoutPatterns.put(type, v);
        }
        return v;
    }

    public LayoutPattern getLayoutPatternForType(Type type, String patternName) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            return null;
        }
        int i = 0;
        while (i < v.size()) {
            LayoutPattern lp = v.get(i);
            if (lp.getName().equals(patternName)) {
                return lp;
            }
            ++i;
        }
        return null;
    }

    public void setLayoutPatterns(Hashtable<Type, Vector<LayoutPattern>> table) {
        this.layoutPatterns.clear();
        Enumeration<Type> keys = table.keys();
        while (keys.hasMoreElements()) {
            Type key = keys.nextElement();
            this.layoutPatterns.put(key, table.get(key));
        }
    }
}

