/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.editor.impl.TypeReprData;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.undo.StateEditable;

public class ArcReprData
implements StateEditable {
    protected int typeHashCode;
    protected boolean elemOfTG;
    protected TypeReprData typeRepresentation;
    protected Hashtable<String, Pair<String, String>> attributes = new Hashtable();
    protected Point textOffset = new Point(0, 0);
    protected boolean hasAnchor;
    protected Point location;
    protected int loopW;
    protected int loopH;
    protected String arcHC;
    protected String fromHC;
    protected String toHC;
    protected int key = this.hashCode();
    protected int arcHashCode;
    protected boolean frozen;
    protected boolean frozenAsDefault;
    protected boolean restoreDone;

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        state.put(this.key, this);
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        ArcReprData data = (ArcReprData)state.get(this.key);
        state.remove(this.key);
        this.restoreDone = false;
        if (data != null) {
            this.typeHashCode = data.typeHashCode;
            this.typeRepresentation = data.typeRepresentation;
            this.elemOfTG = data.elemOfTG;
            this.attributes = data.attributes;
            this.textOffset = data.textOffset;
            this.loopW = data.loopW;
            this.loopH = data.loopH;
            this.hasAnchor = data.hasAnchor;
            this.location = data.location;
            this.arcHC = data.arcHC;
            this.fromHC = data.fromHC;
            this.toHC = data.toHC;
            this.frozen = data.frozen;
            this.frozenAsDefault = data.frozenAsDefault;
            this.restoreDone = true;
        }
    }

    public boolean hasRestored() {
        return this.restoreDone;
    }

    protected ArcReprData(EdArc a) {
        EdGraphObject kernObj;
        if (a.getBasisArc() == null) {
            return;
        }
        this.key = this.hashCode();
        this.arcHashCode = a.hashCode();
        this.typeHashCode = a.getType().hashCode();
        this.elemOfTG = a.isElementOfTypeGraph();
        this.typeRepresentation = a.isElementOfTypeGraph() ? new TypeReprData(a) : new TypeReprData(a.getType());
        this.arcHC = a.getContextUsage();
        if (a.getContextUsage().indexOf(String.valueOf(a.hashCode())) == -1) {
            this.arcHC = String.valueOf(String.valueOf(a.hashCode())) + ":" + a.getContextUsage();
        }
        this.fromHC = String.valueOf(a.getSource().hashCode());
        if (a.getContext() != null && a.getContext().isTargetObjOfGraphEmbedding(a.getSource()) && (kernObj = a.getContext().getSourceObjOfGraphEmbedding(a.getSource())) != null) {
            this.fromHC = String.valueOf(kernObj.hashCode());
        }
        this.toHC = String.valueOf(a.getTarget().hashCode());
        if (a.getContext() != null && a.getContext().isTargetObjOfGraphEmbedding(a.getTarget()) && (kernObj = a.getContext().getSourceObjOfGraphEmbedding(a.getTarget())) != null) {
            this.toHC = String.valueOf(kernObj.hashCode());
        }
        this.attributes = new Hashtable();
        if (a.getBasisObject().getAttribute() != null) {
            ValueTuple vt = (ValueTuple)a.getBasisObject().getAttribute();
            int i = 0;
            while (i < vt.getNumberOfEntries()) {
                ValueMember vm = vt.getValueMemberAt(i);
                if (vm.getName() != null) {
                    Pair<String, String> valPair = new Pair<String, String>(vm.getDeclaration().getTypeName(), "NULL");
                    if (vm.getExpr() != null) {
                        valPair.second = vm.getExprAsText();
                    }
                    this.attributes.put(vm.getName(), valPair);
                }
                ++i;
            }
        }
        this.hasAnchor = a.hasAnchor();
        this.location = a.hasAnchor() ? new Point(a.getAnchor()) : new Point(a.getX(), a.getY());
        this.textOffset = new Point(a.getTextOffset().x, a.getTextOffset().y);
        if (!a.isLine()) {
            this.loopW = a.getWidthOfLoop();
            this.loopH = a.getHeightOfLoop();
        }
        this.frozen = a.getLArc().isFrozen();
        this.frozenAsDefault = a.getLArc().isFrozenByDefault();
    }

    protected TypeReprData getArcTypeReprData() {
        return this.typeRepresentation;
    }

    protected void restoreArcFromArcRepr(EdArc a) {
        if (this.elemOfTG != a.isElementOfTypeGraph()) {
            return;
        }
        this.typeRepresentation.restoreTypeFromTypeRepr(a.getType());
        a.addContextUsage(this.arcHC);
        if (a.isElementOfTypeGraph()) {
            this.restoreMultiplicity(a, this.typeRepresentation);
        }
        if (!this.attributes.isEmpty() && a.getBasisObject().getAttribute() != null) {
            Hashtable<String, Pair<String, String>> attrs = new Hashtable<String, Pair<String, String>>();
            attrs.putAll(this.attributes);
            this.restoreAttributes(attrs, a);
        }
        a.setX(this.location.x);
        a.setY(this.location.y);
        if (this.hasAnchor) {
            a.setAnchor(new Point(this.location.x, this.location.y));
        } else {
            a.setAnchor(null);
        }
        a.setTextOffset(this.textOffset.x, this.textOffset.y);
        if (!a.isLine()) {
            a.setWidth(this.loopW);
            a.setHeight(this.loopH);
        }
        a.getLArc().setFrozen(this.frozen);
        a.getLArc().setFrozenByDefault(this.frozenAsDefault);
    }

    private EdType findArcType(EdGraph g, EdType t) {
        Vector<EdType> arcTypes = g.getTypeSet().getArcTypes();
        int i = 0;
        while (i < arcTypes.size()) {
            EdType ti = arcTypes.get(i);
            if (ti == t || ti.getContextUsage().indexOf(String.valueOf(this.typeRepresentation.getTypeHashCode())) >= 0) {
                return ti;
            }
            ++i;
        }
        return null;
    }

    private EdType findArcType(EdGraph g, int typeHC) {
        Vector<EdType> arcTypes = g.getTypeSet().getArcTypes();
        int i = 0;
        while (i < arcTypes.size()) {
            EdType t = arcTypes.get(i);
            if (t.hashCode() == typeHC) {
                return t;
            }
            if (t.getContextUsage().indexOf(String.valueOf(this.typeRepresentation.getTypeHashCode())) >= 0) {
                return t;
            }
            ++i;
        }
        return null;
    }

    protected EdArc createArcFromArcRepr(EdGraph g, Vector<EdNode> restoredNodes) {
        EdArc a;
        block19: {
            EdNode to;
            EdNode from;
            EdType type = this.findArcType(g, this.typeRepresentation.getTypeHashCode());
            if (type == null) {
                type = this.typeRepresentation.createTypeFromTypeRepr();
                if ((type = this.findArcType(g, type)) == null) {
                    return null;
                }
            }
            if ((from = this.getNode(g, Integer.valueOf(this.fromHC))) == null) {
                from = (EdNode)g.findRestoredNode(this.fromHC);
            }
            if ((to = this.getNode(g, Integer.valueOf(this.toHC))) == null) {
                to = (EdNode)g.findRestoredNode(this.toHC);
            }
            if (from == null || to == null) {
                EdNode n;
                int i = 0;
                while (i < restoredNodes.size()) {
                    n = restoredNodes.get(i);
                    if (n.getContextUsage().contains(this.fromHC)) {
                        from = n;
                    }
                    if (n.getContextUsage().contains(this.toHC)) {
                        to = n;
                    }
                    ++i;
                }
                if (from == null || to == null) {
                    i = 0;
                    while (i < g.getNodes().size()) {
                        n = g.getNodes().get(i);
                        if (from == null && n.getContextUsage().contains(this.fromHC)) {
                            from = n;
                        }
                        if (to == null && n.getContextUsage().contains(this.toHC)) {
                            to = n;
                        }
                        ++i;
                    }
                }
                if (from == null || to == null) {
                    return null;
                }
            }
            a = null;
            Arc basis = g.getBasisGraph().createArc(type.getBasisType(), from.getBasisNode(), to.getBasisNode());
            a = g.addArc(basis, type);
            if (a != null) break block19;
            return null;
        }
        try {
            a.addContextUsage(this.arcHC);
            if (a.isElementOfTypeGraph()) {
                this.restoreMultiplicity(a, this.typeRepresentation);
            }
            this.refreshAttributes(a);
            a.setX(this.location.x);
            a.setY(this.location.y);
            if (this.hasAnchor) {
                a.setAnchor(new Point(this.location.x, this.location.y));
            }
            a.setTextOffset(this.textOffset.x, this.textOffset.y);
            if (!a.isLine()) {
                a.setWidth(this.loopW);
                a.setHeight(this.loopH);
            }
            a.getLArc().setFrozen(this.frozen);
            a.getLArc().setFrozenByDefault(this.frozenAsDefault);
        }
        catch (TypeException typeException) {
            // empty catch block
        }
        return a;
    }

    private void refreshAttributes(EdArc a) {
        if (!this.attributes.isEmpty()) {
            if (a.getBasisObject().getAttribute() == null) {
                a.getBasisObject().createAttributeInstance();
            }
            Hashtable<String, Pair<String, String>> attrs = new Hashtable<String, Pair<String, String>>();
            attrs.putAll(this.attributes);
            this.restoreAttributes(attrs, a);
        }
    }

    private EdNode getNode(EdGraph g, int hashCode) {
        Vector<EdNode> nodes = g.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            EdNode n = nodes.get(i);
            if (n.hashCode() == hashCode) {
                return n;
            }
            ++i;
        }
        return null;
    }

    private void restoreMultiplicity(EdArc a, TypeReprData typedata) {
        Type t = a.getType().getBasisType();
        Type srct = a.getBasisArc().getSource().getType();
        Type tart = a.getBasisArc().getTarget().getType();
        t.setSourceMin(srct, tart, typedata.srcMinMultiplicity);
        t.setSourceMax(srct, tart, typedata.srcMaxMultiplicity);
        t.setTargetMin(srct, tart, typedata.tarMinMultiplicity);
        t.setTargetMax(srct, tart, typedata.tarMaxMultiplicity);
    }

    private void restoreAttributes(Hashtable<String, Pair<String, String>> attrs, EdArc a) {
        ValueTuple vt = (ValueTuple)a.getBasisObject().getAttribute();
        int i = 0;
        while (i < vt.getNumberOfEntries()) {
            ValueMember vm = vt.getValueMemberAt(i);
            Pair<String, String> valPair = attrs.get(vm.getName());
            if (valPair != null && !valPair.isEmpty()) {
                String expr = (String)valPair.second;
                if (!a.isElementOfTypeGraph() && expr != null) {
                    if (vm.getExpr() == null) {
                        if (!expr.equals("NULL")) {
                            vm.setExprAsText(expr);
                            vm.checkValidity();
                        }
                    } else if (expr.equals("NULL")) {
                        vm.setExpr(null);
                    } else if (!vm.getExprAsText().equals(expr)) {
                        vm.setExprAsText(expr);
                        vm.checkValidity();
                    }
                }
                attrs.remove(vm.getName());
            }
            ++i;
        }
    }
}

