/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrTuple;
import agg.attribute.AttrTypeMember;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerType;
import agg.attribute.impl.AttrMsgCode;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.Member;
import agg.util.XMLHelper;

public class DeclMember
extends Member
implements AttrMsgCode,
AttrTypeMember {
    static final long serialVersionUID = -1967468240702798334L;
    protected DeclTuple tuple;
    protected HandlerType type;
    protected String typeName;
    protected String name;
    protected AttrHandler handler;
    protected boolean isNameValid = false;
    protected String handlerMessage;
    protected boolean visible;

    public DeclMember(DeclTuple tuple) {
        this.tuple = tuple;
        this.visible = true;
    }

    public DeclMember(DeclTuple tuple, AttrHandler handler, String typeString, String name) {
        this(tuple);
        this.setName(name);
        this.retype(handler, typeString);
    }

    protected void retype(AttrHandler attrhandler, String typename) {
        this.handler = attrhandler;
        this.typeName = typename.replaceAll(" ", "");
        this.type = null;
        this.handlerMessage = null;
        if (attrhandler == null) {
            return;
        }
        try {
            this.type = attrhandler.newHandlerType(this.typeName);
        }
        catch (AttrHandlerException ex) {
            this.typeName = null;
            this.handlerMessage = ex.getMessage();
        }
        this.fireChanged(60);
    }

    @Override
    public void delete() {
        this.getTuple().deleteMemberAt(this.getTuple().getIndexForMember(this));
    }

    public void setNameValid(boolean b) {
        this.isNameValid = b;
    }

    @Override
    public boolean isValid() {
        return this.isNameValid && this.type != null;
    }

    public boolean isDefined() {
        return this.typeName != null && this.name != null && !"".equals(this.typeName) && !"".equals(this.name);
    }

    @Override
    public String getValidityReport() {
        if (this.isValid()) {
            return null;
        }
        String report = "-------- DECLARATION : --------\n";
        if (this.handler == null) {
            report = String.valueOf(report) + "No attribute handler.\n";
        }
        if (this.typeName == null) {
            report = String.valueOf(report) + "No type.\n";
        }
        if (this.handlerMessage != null) {
            report = String.valueOf(report) + this.handlerMessage + "\n";
        }
        if (this.name == null) {
            report = String.valueOf(report) + "No name.\n";
        } else if (!this.isNameValid) {
            report = String.valueOf(report) + "Name is not unique or a Java data class name.\n";
        }
        return report;
    }

    @Override
    public AttrHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(AttrHandler h) {
        this.handler = h;
        if (this.typeName != null) {
            this.retype(h, this.typeName);
        }
    }

    @Override
    public HandlerType getType() {
        return this.type;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public void setType(String typeName) {
        if (this.handler != null) {
            this.retype(this.handler, typeName);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.getTuple() == null) {
            return;
        }
        String prevName = this.name;
        this.name = name.replaceAll(" ", "");
        this.getTuple().checkNameValidity(this.name);
        if (!this.isNameValid) {
            this.name = prevName;
        }
        this.fireChanged(50);
    }

    public void setVisible(boolean vis) {
        this.visible = vis;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public AttrTuple getHoldingTuple() {
        return this.getTuple();
    }

    protected DeclTuple getTuple() {
        return this.tuple;
    }

    protected AttrTupleManager getManager() {
        return this.getTuple().getManager();
    }

    @Override
    public boolean compareTo(AttrTypeMember mem) {
        return mem != null && this.isValid() && mem.isValid() && this.getHandler().getName().equals(mem.getHandler().getName()) && this.getTypeName().equals(mem.getTypeName()) && this.getName().equals(mem.getName());
    }

    public boolean weakcompareTo(AttrTypeMember mem) {
        return mem != null && this.isDefined() && this.getHandler().getName().equals(mem.getHandler().getName());
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.openNewElem("AttrType", this);
        h.addAttr("typename", this.getTypeName());
        h.addAttr("attrname", this.getName());
        if (this.visible) {
            h.addAttr("visible", "true");
        } else {
            h.addAttr("visible", "false");
        }
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("AttrType", this)) {
            this.typeName = h.readAttr("typename");
            this.name = h.readAttr("attrname");
            this.name = XMLHelper.checkNameDueToSpecialCharacters(this.name);
            String visiblestr = h.readAttr("visible");
            if ("true".equals(visiblestr)) {
                this.visible = true;
            } else if ("false".equals(visiblestr)) {
                this.visible = false;
            }
            h.close();
        }
    }
}

