/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.gui.impl;

import agg.attribute.AttrContext;
import agg.attribute.AttrManager;
import agg.attribute.gui.AttrContextEditor;
import agg.attribute.gui.AttrEditorManager;
import agg.attribute.gui.impl.AbstractEditor;
import agg.attribute.gui.impl.ConditionTupleEditor;
import agg.attribute.gui.impl.VariableTupleEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.BevelBorder;

public class ContextEditor
extends AbstractEditor
implements AttrContextEditor,
ScrollPaneConstants {
    protected AttrContext attrContext;
    protected JPanel condPanel;
    protected JPanel varPanel;
    protected JSplitPane varAndCondSplitPane;
    protected JTextArea outputTextArea;
    protected JScrollPane outputScrollPane;
    protected ConditionTupleEditor conditionEditor;
    protected VariableTupleEditor variableEditor;

    public ContextEditor(AttrManager m, AttrEditorManager em) {
        super(m, em);
    }

    @Override
    protected void genericCreateAllViews() {
        this.variableEditor = new VariableTupleEditor(this.getAttrManager(), this.getEditorManager());
        this.varPanel = new JPanel(new BorderLayout());
        this.varPanel.setBackground(new Color(205, 230, 205));
        this.varPanel.add(this.variableEditor.getComponent(), "Center");
        this.variableEditor.getComponent().setBackground(new Color(205, 230, 205));
        this.varPanel.setBorder(BorderFactory.createTitledBorder(new BevelBorder(0), "Parameters and Variables", 2, 2));
        this.conditionEditor = new ConditionTupleEditor(this.getAttrManager(), this.getEditorManager());
        this.condPanel = new JPanel(new BorderLayout());
        this.condPanel.setBackground(new Color(205, 230, 205));
        this.condPanel.add(this.conditionEditor.getComponent(), "Center");
        this.conditionEditor.getComponent().setBackground(new Color(205, 230, 205));
        this.condPanel.setBorder(BorderFactory.createTitledBorder(new BevelBorder(0), "Conditions", 2, 2));
        this.createOutputTextArea();
    }

    @Override
    protected void arrangeMainPanel() {
    }

    @Override
    protected void genericCustomizeMainLayout() {
        this.varAndCondSplitPane = new JSplitPane(1, this.varPanel, this.condPanel);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.varAndCondSplitPane, "Center");
        this.mainPanel.setPreferredSize(new Dimension(500, 400));
        this.mainPanel.addComponentListener(this);
        this.resize();
    }

    protected void createOutputTextArea() {
        this.outputTextArea = new JTextArea(5, 10);
        this.outputTextArea.setEditable(false);
        this.outputTextArea.setLineWrap(false);
        this.outputScrollPane = new JScrollPane(this.outputTextArea, 20, 30);
        this.outputScrollPane.setPreferredSize(new Dimension(300, 50));
    }

    protected void resize() {
        this.varAndCondSplitPane.setDividerLocation(0.67);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.resize();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.resize();
    }

    @Override
    public void setContext(AttrContext anAttrContext) {
        this.attrContext = anAttrContext;
        this.conditionEditor.setTuple(this.attrContext.getConditions());
        this.variableEditor.setTuple(this.attrContext.getVariables());
    }

    @Override
    public AttrContext getContext() {
        return this.attrContext;
    }

    public ConditionTupleEditor getConditionEditor() {
        return this.conditionEditor;
    }

    public VariableTupleEditor getVariableEditor() {
        return this.variableEditor;
    }

    public void resetVariableEditorComponent() {
        this.varPanel.add(this.variableEditor.getComponent(), "Center");
    }

    @Override
    public void setAttrManager(AttrManager m) {
        super.setAttrManager(m);
        this.conditionEditor.setAttrManager(m);
        this.variableEditor.setAttrManager(m);
    }

    @Override
    public void setEditorManager(AttrEditorManager m) {
        super.setEditorManager(m);
        this.conditionEditor.setEditorManager(m);
        this.variableEditor.setEditorManager(m);
    }
}

