/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.henshin.HenshinModelExporter;
import org.eclipse.emf.henshin.HenshinModelImporter;
import org.eclipse.emf.henshin.HenshinModelPluginInitializer;

public class HenshinModelPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.henshin.model";
    public static final HenshinModelPlugin INSTANCE = new HenshinModelPlugin();
    private static Implementation plugin;
    private Map<String, HenshinModelImporter> importers = new LinkedHashMap<String, HenshinModelImporter>();
    private Map<String, HenshinModelExporter> exporters = new LinkedHashMap<String, HenshinModelExporter>();
    private boolean adaptersLoaded = false;

    public HenshinModelPlugin() {
        super(new ResourceLocator[0]);
    }

    public HenshinModelPlugin(ResourceLocator[] delegateResourceLocators) {
        super(delegateResourceLocators);
    }

    private void loadAdapters() {
        if (!this.adaptersLoaded) {
            this.adaptersLoaded = true;
            try {
                HenshinModelPluginInitializer.loadAdapters();
            }
            catch (Throwable throwable) {}
        }
    }

    public Map<String, HenshinModelImporter> getImporters() {
        this.loadAdapters();
        return this.importers;
    }

    public Map<String, HenshinModelExporter> getExporters() {
        this.loadAdapters();
        return this.exporters;
    }

    public void logInfo(String message) {
        this.log(1, message, null);
    }

    public void logWarning(String message, Throwable t) {
        this.log(2, message, t);
    }

    public void logError(String message, Throwable t) {
        this.log(4, message, null);
    }

    private void log(int code, String message, Throwable t) {
        if (plugin != null && plugin.getLog() != null) {
            plugin.getLog().log((IStatus)new Status(code, PLUGIN_ID, 0, message, t));
        } else {
            if (code == 4) {
                System.err.print("ERROR: " + message);
            } else if (code == 2) {
                System.out.print("WARNING: " + message);
            } else if (code == 1) {
                System.out.print("INFO: " + message);
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }
    }
}

