/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.EGraph;

public class EGraphImpl
extends LinkedHashSet<EObject>
implements EGraph {
    private static final long serialVersionUID = -1917534761444871093L;
    protected final Set<EPackage> packages = new LinkedHashSet<EPackage>();
    protected final Map<EClass, List<EObject>> domainMap = new LinkedHashMap<EClass, List<EObject>>();
    protected final Map<EClass, Set<EClass>> inheritanceMap = new LinkedHashMap<EClass, Set<EClass>>();
    protected final ECrossReferenceAdapter crossReferenceAdapter = new ECrossReferenceAdapter();

    public EGraphImpl() {
        this(32);
    }

    public EGraphImpl(EObject object) {
        this();
        this.addGraph(object);
    }

    public EGraphImpl(Collection<? extends EObject> collection) {
        this();
        for (EObject eObject : collection) {
            if (this.contains(eObject)) continue;
            this.addGraph(eObject);
        }
    }

    public EGraphImpl(Resource resource) {
        this((Collection<? extends EObject>)resource.getContents());
    }

    public EGraphImpl(int initialSize) {
        super(initialSize);
    }

    @Override
    public boolean add(EObject object) {
        boolean added = super.add(object);
        if (added) {
            object.eAdapters().add((Object)this.crossReferenceAdapter);
            EClass type = object.eClass();
            EPackage ePackage = type.getEPackage();
            List<EObject> domain = this.domainMap.get(type);
            if (domain == null) {
                domain = new ArrayList<EObject>();
                this.domainMap.put(type, domain);
            }
            domain.add(object);
            this.addEPackage(ePackage);
        }
        return added;
    }

    @Override
    public boolean remove(Object object) {
        boolean removed = super.remove(object);
        if (removed && object instanceof EObject) {
            this.domainMap.get(((EObject)object).eClass()).remove(object);
            ((EObject)object).eAdapters().remove((Object)this.crossReferenceAdapter);
        }
        return removed;
    }

    @Override
    public boolean addTree(EObject root) {
        boolean changed = this.add(root);
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            if (!this.add((EObject)it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeTree(EObject root) {
        boolean changed = this.remove(root);
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            if (!this.remove(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addGraph(EObject object) {
        LinkedHashSet<EObject> closure = new LinkedHashSet<EObject>();
        this.computeTransitiveClosure(object, closure);
        return this.addAll((Collection<? extends EObject>)closure);
    }

    @Override
    public boolean removeGraph(EObject object) {
        LinkedHashSet<EObject> closure = new LinkedHashSet<EObject>();
        this.computeTransitiveClosure(object, closure);
        return this.removeAll(closure);
    }

    private boolean computeTransitiveClosure(EObject object, Set<EObject> closure) {
        if (closure.contains(object)) {
            return false;
        }
        closure.add(object);
        for (EReference ref : object.eClass().getEAllReferences()) {
            if (ref.isMany()) {
                EList targets = (EList)object.eGet((EStructuralFeature)ref);
                for (EObject target : targets) {
                    this.computeTransitiveClosure(target, closure);
                }
                continue;
            }
            EObject target = (EObject)object.eGet((EStructuralFeature)ref);
            if (target == null) continue;
            this.computeTransitiveClosure(target, closure);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends EObject> objs) {
        boolean changed = false;
        for (EObject eObject : objs) {
            if (!this.add(eObject)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> objs) {
        boolean changed = false;
        for (Object object : objs) {
            if (!this.remove(object)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        for (EObject object : this) {
            object.eAdapters().remove((Object)this.crossReferenceAdapter);
        }
        super.clear();
        this.packages.clear();
        this.domainMap.clear();
        this.inheritanceMap.clear();
    }

    protected boolean addEPackage(EPackage ePackage) {
        boolean added = this.packages.add(ePackage);
        if (added) {
            for (EClassifier classifier : ePackage.getEClassifiers()) {
                if (!(classifier instanceof EClass)) continue;
                EClass type = (EClass)classifier;
                this.addChildParentRelation(type, type);
                for (EClass parent : type.getEAllSuperTypes()) {
                    this.addChildParentRelation(type, parent);
                }
            }
        }
        return added;
    }

    protected void addChildParentRelation(EClass child, EClass parent) {
        Set<EClass> children = this.inheritanceMap.get(parent);
        if (children == null) {
            children = new LinkedHashSet<EClass>();
            this.inheritanceMap.put(parent, children);
        }
        children.add(child);
    }

    @Override
    public List<EObject> getDomain(EClass type, boolean strict) {
        if (strict) {
            return new ArrayList<EObject>(this.getDomain(type));
        }
        ArrayList<EObject> domain = new ArrayList<EObject>();
        Set<EClass> inhMap = this.inheritanceMap.get(type);
        if (inhMap != null) {
            for (EClass child : inhMap) {
                domain.addAll(this.getDomain(child));
            }
        }
        return domain;
    }

    @Override
    public int getDomainSize(EClass type, boolean strict) {
        if (strict) {
            return this.getDomain(type).size();
        }
        Set<EClass> inhMap = this.inheritanceMap.get(type);
        int size = 0;
        if (inhMap != null) {
            for (EClass child : inhMap) {
                size += this.getDomain(child).size();
            }
        }
        return size;
    }

    protected Collection<EObject> getDomain(EClass type) {
        List<EObject> domain = this.domainMap.get(type);
        if (domain == null) {
            domain = new ArrayList<EObject>();
            this.domainMap.put(type, domain);
        }
        return domain;
    }

    @Override
    public ECrossReferenceAdapter getCrossReferenceAdapter() {
        return this.crossReferenceAdapter;
    }

    @Override
    public EGraph copy(Map<EObject, EObject> copies) {
        if (copies == null) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copier.copyAll(this.getRoots());
            copier.copyReferences();
            copies = copier;
        }
        EGraphImpl copy = new EGraphImpl(this.size());
        for (EObject object : this) {
            copy.add((EObject)copies.get(object));
        }
        return copy;
    }

    @Override
    public List<EObject> getRoots() {
        ArrayList<EObject> roots = new ArrayList<EObject>();
        for (EObject object : this) {
            while (object.eContainer() != null) {
                object = object.eContainer();
            }
            if (roots.contains(object)) continue;
            roots.add(object);
        }
        return roots;
    }
}

