/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.commands.dnd;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DragAndDropFeedback;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;

public class DelegatingWrapperFeatureDragAndDropCommand
extends AbstractCommand
implements DragAndDropFeedback {
    protected EditingDomain domain;
    protected Object owner;
    protected float location;
    protected Command dragCommand;
    protected Command dropCommand;
    protected Collection<?> collection;
    protected int feedback;

    public DelegatingWrapperFeatureDragAndDropCommand(EditingDomain domain, Object owner, float location, Collection<?> collection) {
        this.domain = domain;
        this.owner = owner;
        this.location = location;
        this.collection = collection;
        this.dragCommand = UnexecutableCommand.INSTANCE;
        this.dropCommand = UnexecutableCommand.INSTANCE;
    }

    protected boolean prepare() {
        this.dragCommand = IdentityCommand.INSTANCE;
        this.dropCommand = UnexecutableCommand.INSTANCE;
        if (this.checkValidInstanceVariables() && this.checkNoSelfInsertion()) {
            int index;
            IWrapperItemProvider wrapper = (IWrapperItemProvider)this.owner;
            EReference feature_ = (EReference)wrapper.getFeature();
            EObject owner_ = (EObject)wrapper.getOwner();
            int targetIndex = index = wrapper.getIndex();
            if ((double)this.location < 0.5) {
                this.feedback = 2;
            } else {
                this.feedback = 4;
                ++targetIndex;
            }
            CompoundCommand dragCompoundCommand = new CompoundCommand();
            CompoundCommand dropCompoundCommand = new CompoundCommand();
            for (Object o : this.collection) {
                if (o instanceof IWrapperItemProvider) {
                    IWrapperItemProvider w = (IWrapperItemProvider)o;
                    if (w.getOwner().equals(owner_) && w.getFeature().equals(feature_)) {
                        if (feature_.isMany()) {
                            int drageeIndex = ((List)owner_.eGet((EStructuralFeature)feature_)).indexOf(w.getValue());
                            drageeIndex = drageeIndex < index ? targetIndex - 1 : targetIndex;
                            dropCompoundCommand.append(MoveCommand.create((EditingDomain)this.domain, (Object)owner_, (Object)w.getFeature(), (Object)w.getValue(), (int)drageeIndex));
                            continue;
                        }
                        dropCompoundCommand.append(MoveCommand.create((EditingDomain)this.domain, (Object)owner_, (Object)w.getFeature(), (Object)w.getValue(), (int)0));
                        continue;
                    }
                    dragCompoundCommand.append(RemoveCommand.create((EditingDomain)this.domain, (Object)w.getOwner(), (Object)w.getFeature(), (Object)w.getValue()));
                    dropCompoundCommand.append(AddCommand.create((EditingDomain)this.domain, (Object)owner_, (Object)feature_, (Object)w.getValue(), (int)targetIndex));
                    continue;
                }
                dropCompoundCommand.append(AddCommand.create((EditingDomain)this.domain, (Object)owner_, (Object)feature_, o, (int)targetIndex));
            }
            this.dragCommand = dragCompoundCommand.isEmpty() ? IdentityCommand.INSTANCE : dragCompoundCommand;
            this.dropCommand = dropCompoundCommand;
        }
        return this.dragCommand.canExecute() && this.dropCommand.canExecute();
    }

    private boolean checkValidInstanceVariables() {
        boolean result = this.domain != null && this.owner != null && this.owner instanceof IWrapperItemProvider && this.collection != null && !this.collection.isEmpty();
        return result;
    }

    private boolean checkNoSelfInsertion() {
        boolean result = true;
        Iterator<?> it = this.collection.iterator();
        while (result && it.hasNext()) {
            boolean bl = result = !it.next().equals(this.owner);
        }
        result = result && ((double)this.location > 0.7 || (double)this.location < 0.3);
        return result;
    }

    protected int calculateIndex() {
        return 0;
    }

    public void execute() {
        this.dragCommand.execute();
        this.dropCommand.execute();
    }

    public void undo() {
        this.dropCommand.undo();
        this.dragCommand.undo();
    }

    public void redo() {
        this.execute();
    }

    public Collection<?> getResult() {
        return this.dropCommand != null ? this.dropCommand.getResult() : super.getResult();
    }

    public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
        return false;
    }

    public int getFeedback() {
        return this.isExecutable ? this.feedback : 0;
    }

    public int getOperation() {
        return this.isExecutable ? 4 : 0;
    }

    public Collection<?> getAffectedObjects() {
        return this.dropCommand != null ? this.dropCommand.getAffectedObjects() : super.getAffectedObjects();
    }

    public void dispose() {
        if (this.dragCommand != null) {
            this.dragCommand.dispose();
        }
        if (this.dropCommand != null) {
            this.dropCommand.dispose();
        }
    }
}

