/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.henshin.diagram.edit.parts.SymbolType;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class SymbolEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 3004;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public SymbolEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("SemanticPolicy");
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        SymbolType symbol = SymbolType.get(this.getNotationView());
        this.primaryShape = symbol == SymbolType.UNIT_BEGIN ? new SymbolCircleFigure(true) : (symbol == SymbolType.UNIT_END ? new SymbolCircleFigure(false) : (symbol == SymbolType.INDEPENDENT_CHOICE ? new IndependentChoiceSymbolFigure() : new InvalidSymbolFigure()));
        return this.primaryShape;
    }

    public Command getCommand(Request request) {
        Object type = request.getType();
        if ("delete".equals(type) && SymbolType.get(this.getNotationView()) != null) {
            return UnexecutableCommand.INSTANCE;
        }
        if ("Reconnection source".equals(type) || "Reconnection target".equals(type)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCommand(request);
    }

    public SymbolCircleFigure getPrimaryShape() {
        return (SymbolCircleFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(20, 20);
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public class IndependentChoiceSymbolFigure
    extends Figure {
        public void paint(Graphics graphics) {
            graphics.setForegroundColor(ColorConstants.black);
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.setLineWidthFloat(1.0f);
            Rectangle r = this.getBounds();
            Point p1 = new Point(r.x, r.y + r.height / 2);
            Point p2 = new Point(r.x + r.width / 2, r.y);
            Point p3 = new Point(r.x + r.width - 1, r.y + r.height / 2);
            Point p4 = new Point(r.x + r.width / 2, r.y + r.height - 1);
            PointList pointList = new PointList();
            pointList.addPoint(p1);
            pointList.addPoint(p2);
            pointList.addPoint(p3);
            pointList.addPoint(p4);
            graphics.fillPolygon(pointList);
            graphics.drawLine(p1, p2);
            graphics.drawLine(p2, p3);
            graphics.drawLine(p3, p4);
            graphics.drawLine(p4, p1);
        }
    }

    public class InvalidSymbolFigure
    extends Ellipse {
        public InvalidSymbolFigure() {
            this.setForegroundColor(ColorConstants.black);
            this.setBackgroundColor(ColorConstants.red);
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.add((IFigure)new Label("  Invalid  "));
        }
    }

    public class SymbolCircleFigure
    extends Ellipse {
        private Ellipse inner;

        public SymbolCircleFigure() {
            this.setForegroundColor(ColorConstants.black);
            this.setBackgroundColor(ColorConstants.white);
        }

        public SymbolCircleFigure(boolean begin) {
            this.setLayoutManager((LayoutManager)new StackLayout());
            if (begin) {
                this.setForegroundColor(ColorConstants.darkGray);
                this.setBackgroundColor(ColorConstants.black);
            } else {
                this.setForegroundColor(ColorConstants.black);
                this.setBackgroundColor(ColorConstants.white);
                final SymbolCircleFigure main = this;
                this.inner = new Ellipse(){

                    public Rectangle getBounds() {
                        Rectangle b = main.getBounds();
                        return new Rectangle(b.x + b.width / 4, b.y + b.height / 4, b.width / 2, b.height / 2);
                    }
                };
                this.inner.setForegroundColor(ColorConstants.black);
                this.inner.setBackgroundColor(ColorConstants.black);
                this.add((IFigure)this.inner);
            }
        }
    }
}

