/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.om.monitor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.net4j.internal.util.om.monitor.Monitor;

public class EclipseMonitor
extends Monitor {
    private IProgressMonitor progressMonitor;

    public EclipseMonitor(IProgressMonitor progressMonitor) {
        super(null, 0);
        if (progressMonitor == null) {
            throw new IllegalArgumentException("progressMonitor == null");
        }
        this.progressMonitor = new DelegatingProgressMonitor(progressMonitor);
    }

    private EclipseMonitor(EclipseMonitor parent, int workFromParent) {
        super(parent, workFromParent);
        this.progressMonitor = new SubProgressMonitor((IProgressMonitor)new SubProgressMonitor(parent.getProgressMonitor(), workFromParent), workFromParent);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setTask(String task) {
        super.setTask(task);
        this.progressMonitor.setTaskName(task);
    }

    public void worked(int work, String msg) {
        super.worked(work, msg);
        this.progressMonitor.worked(work);
        if (msg != null) {
            this.progressMonitor.subTask(msg);
        }
    }

    protected void begin(int totalWork, String task) {
        super.begin(totalWork, task);
        this.progressMonitor.beginTask(task == null ? "" : task, totalWork);
    }

    protected void done() {
        super.done();
        this.progressMonitor.done();
    }

    protected void message(String msg, int level) {
        super.message(msg, level);
        this.progressMonitor.subTask(msg);
    }

    protected EclipseMonitor subMonitor(int workFromParent) {
        return new EclipseMonitor(this, workFromParent);
    }

    private final class DelegatingProgressMonitor
    implements IProgressMonitor {
        private IProgressMonitor delegate;

        public DelegatingProgressMonitor(IProgressMonitor delegate) {
            this.delegate = delegate;
        }

        public IProgressMonitor getDelegate() {
            return this.delegate;
        }

        public void beginTask(String name, int totalWork) {
            this.delegate.beginTask(name, totalWork);
        }

        public void done() {
            this.delegate.done();
        }

        public void internalWorked(double work) {
            this.delegate.internalWorked(work);
        }

        public boolean isCanceled() {
            return this.delegate.isCanceled();
        }

        public void setCanceled(boolean value) {
            EclipseMonitor.this.setCanceled(value);
            this.delegate.setCanceled(value);
        }

        public void setTaskName(String name) {
            this.delegate.setTaskName(name);
        }

        public void subTask(String name) {
            this.delegate.subTask(name);
        }

        public void worked(int work) {
            this.delegate.worked(work);
        }
    }
}

